/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc.types;

import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerType;
import com.intellij.lang.typescript.tsc.TypeScriptCompilerSymbolTypeBuilder;
import com.intellij.lang.typescript.tsc.gen.ImplementationKt;
import com.intellij.lang.typescript.tsc.gen.Symbol;
import com.intellij.lang.typescript.tsc.gen.SymbolFlagsValues;
import com.intellij.lang.typescript.tsc.gen.TypeScriptServerTypeCheckerContextKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\"\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0014J\n\u0010!\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u001fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/intellij/lang/typescript/tsc/types/TypeScriptCompilerSymbolType;", "Lcom/intellij/lang/javascript/psi/types/JSTypeBaseImpl;", "Lcom/intellij/lang/javascript/psi/types/typescript/TypeScriptCompilerType;", "symbol", "Lcom/intellij/lang/typescript/tsc/gen/Symbol;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/lang/typescript/tsc/gen/Symbol;Lcom/intellij/openapi/project/Project;)V", "substituteImpl", "Lcom/intellij/lang/javascript/psi/JSType;", "context", "Lcom/intellij/lang/javascript/psi/JSTypeSubstitutionContext;", "buildTypeTextImpl", "", "format", "Lcom/intellij/lang/javascript/psi/JSType$TypeTextFormat;", "builder", "Lcom/intellij/lang/javascript/psi/JSTypeTextBuilder;", "copyWithNewSource", "source", "Lcom/intellij/lang/javascript/psi/types/JSTypeSource;", "hashCodeImpl", "", "asRecordTypeNoCache", "Lcom/intellij/lang/javascript/psi/JSRecordType;", "isEquivalentTo", "", "other", "isEquivalentToWithSameClass", "type", "Lcom/intellij/util/ProcessingContext;", "allowResolve", "asJSTypeSubstituted", "isDirectlyAssignableTypeImpl", "elementType", "processingContext", "targetOrSelf", "getTargetOrSelf", "()Lcom/intellij/lang/javascript/psi/JSType;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerSymbolType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerSymbolType.kt\ncom/intellij/lang/typescript/tsc/types/TypeScriptCompilerSymbolType\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n31#2,2:100\n31#2,2:102\n31#2,2:108\n1557#3:104\n1628#3,3:105\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerSymbolType.kt\ncom/intellij/lang/typescript/tsc/types/TypeScriptCompilerSymbolType\n*L\n25#1:100,2\n35#1:102,2\n91#1:108,2\n42#1:104\n42#1:105,3\n*E\n"})
public final class TypeScriptCompilerSymbolType
extends JSTypeBaseImpl
implements TypeScriptCompilerType {
    @NotNull
    private final Symbol symbol;
    @NotNull
    private final Project project;

    public TypeScriptCompilerSymbolType(@NotNull Symbol symbol, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(JSTypeSource.EMPTY_TS_EXPLICITLY_DECLARED);
        this.symbol = symbol;
        this.project = project;
    }

    @Override
    @Nullable
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<TypeScriptCompilerSymbolTypeBuilder> serviceClass$iv = TypeScriptCompilerSymbolTypeBuilder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((TypeScriptCompilerSymbolTypeBuilder)object).buildTypeOfSymbol(this.symbol);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        if (format == JSType.TypeTextFormat.SIMPLE) {
            builder2.append("#" + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            return;
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE && !ImplementationKt.intersects(SymbolFlagsValues.INSTANCE.getTransient(), this.symbol.getFlags())) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<TypeScriptCompilerSymbolTypeBuilder> serviceClass$iv = TypeScriptCompilerSymbolTypeBuilder.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            TypeScriptCompilerSymbolTypeBuilder symbolTypeBuilder = (TypeScriptCompilerSymbolTypeBuilder)object;
            JSType typeFromDeclarations = symbolTypeBuilder.buildTypeFromDeclarations(this.symbol, true);
            if (typeFromDeclarations != null) {
                typeFromDeclarations.buildTypeText(format, builder2);
            } else {
                JSTypeDeclaration typeDeclaration;
                List<PsiElement> declarations;
                List<PsiElement> list = declarations = symbolTypeBuilder.findPsiDeclarations(this.symbol);
                if (list != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        PsiElement psiElement = (PsiElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        JSTypeDeclarationOwner jSTypeDeclarationOwner = it instanceof JSTypeDeclarationOwner ? (JSTypeDeclarationOwner)it : null;
                        PsiElement psiElement2 = jSTypeDeclarationOwner != null ? jSTypeDeclarationOwner.getTypeElement() : null;
                        collection.add(psiElement2 instanceof JSTypeDeclaration ? (JSTypeDeclaration)psiElement2 : null);
                    }
                    v3 = (JSTypeDeclaration)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                } else {
                    v3 = typeDeclaration = null;
                }
                if (typeDeclaration != null) {
                    builder2.append(JSFormatUtil.formatTypeDeclaration(typeDeclaration));
                    return;
                }
            }
        }
        this.substitute().buildTypeText(format, builder2);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this;
    }

    @Override
    protected int hashCodeImpl() {
        Object[] objectArray = new Object[]{this.symbol.getId(), TypeScriptServerTypeCheckerContextKt.getIdeTypeCheckerContext(this.symbol).getIdeTypeCheckerId(), this.project};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType jSRecordType;
        JSType jSType = this.substitute();
        Intrinsics.checkNotNullExpressionValue((Object)jSType, (String)"substitute(...)");
        JSType substituted = jSType;
        if (!Intrinsics.areEqual((Object)substituted, (Object)this)) {
            JSRecordType jSRecordType2 = this.substitute().asRecordType();
            jSRecordType = jSRecordType2;
            Intrinsics.checkNotNullExpressionValue((Object)jSRecordType2, (String)"asRecordType(...)");
        } else {
            JSRecordType jSRecordType3 = super.asRecordTypeNoCache();
            jSRecordType = jSRecordType3;
            Intrinsics.checkNotNullExpressionValue((Object)jSRecordType3, (String)"asRecordTypeNoCache(...)");
        }
        return jSRecordType;
    }

    private final boolean isEquivalentTo(Symbol $this$isEquivalentTo, Symbol other) {
        return $this$isEquivalentTo.getId() == other.getId() && TypeScriptServerTypeCheckerContextKt.getIdeTypeCheckerContext($this$isEquivalentTo).getIdeTypeCheckerId() == TypeScriptServerTypeCheckerContextKt.getIdeTypeCheckerContext(other).getIdeTypeCheckerId();
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context2, boolean allowResolve) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.isEquivalentTo(this.symbol, ((TypeScriptCompilerSymbolType)type).symbol) && Intrinsics.areEqual((Object)this.project, (Object)((TypeScriptCompilerSymbolType)type).project);
    }

    private final JSType asJSTypeSubstituted() {
        JSType jSType = this.substitute();
        Intrinsics.checkNotNullExpressionValue((Object)jSType, (String)"substitute(...)");
        JSType substitute = jSType;
        return !Intrinsics.areEqual((Object)substitute, (Object)this) ? substitute : null;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)processingContext, (String)"processingContext");
        JSType jSType = this.asJSTypeSubstituted();
        if (jSType == null) {
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        JSType asJSType = jSType;
        return asJSType.isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    @NotNull
    public JSType getTargetOrSelf() {
        JSType typeFromDeclarations;
        if (!ImplementationKt.intersects(SymbolFlagsValues.INSTANCE.getTransient(), this.symbol.getFlags())) {
            return TypeScriptCompilerType.super.getTargetOrSelf();
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<TypeScriptCompilerSymbolTypeBuilder> serviceClass$iv = TypeScriptCompilerSymbolTypeBuilder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        TypeScriptCompilerSymbolTypeBuilder symbolTypeBuilder = (TypeScriptCompilerSymbolTypeBuilder)object;
        JSType jSType = typeFromDeclarations = symbolTypeBuilder.buildTypeFromDeclarations(this.symbol, true);
        if (jSType != null) {
            return jSType;
        }
        List<PsiElement> psiDeclarations = symbolTypeBuilder.findPsiDeclarations(this.symbol);
        if (psiDeclarations != null && psiDeclarations.size() == 1) {
            return new JSPsiBasedTypeOfType((PsiElement)CollectionsKt.first(psiDeclarations), false);
        }
        JSAnyType jSAnyType = JSAnyType.getSimple();
        Intrinsics.checkNotNullExpressionValue((Object)jSAnyType, (String)"getSimple(...)");
        return jSAnyType;
    }
}

