/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSDocDecoratedType;
import com.intellij.lang.javascript.psi.ecma6.JSDocFunctionType;
import com.intellij.lang.javascript.psi.ecma6.JSDocFunctionTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.jsdoc.JSDocSingleTypeImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptService;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl;", "Lcom/intellij/lang/typescript/resolve/TypeScriptCompilerEvaluationFacade;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "useTypesFromServerStateLogged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isAnyEnabled", "", "getTypeFromService", "Lcom/intellij/lang/javascript/psi/JSType;", "element", "Lcom/intellij/psi/PsiElement;", "getQuickTypeOfElement", "canAcceptElement", "isFromJSDoc", "throwIfUnitTestMode", "", "message", "", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerEvaluationFacadeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerEvaluationFacadeImpl.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,144:1\n808#2,11:145\n1755#2,3:156\n14#3:159\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerEvaluationFacadeImpl.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl\n*L\n62#1:145,11\n62#1:156,3\n41#1:159\n*E\n"})
public final class TypeScriptCompilerEvaluationFacadeImpl
implements TypeScriptCompilerEvaluationFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean useTypesFromServerStateLogged;
    @NotNull
    private static final Logger LOG;

    public TypeScriptCompilerEvaluationFacadeImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.useTypesFromServerStateLogged = new AtomicBoolean(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isAnyEnabled() {
        boolean bl;
        block7: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable name;
            List<JSLanguageService> languageServices = JSLanguageServiceProvider.Companion.getLanguageServices(this.project);
            if (this.useTypesFromServerStateLogged.compareAndSet(false, true)) {
                for (JSLanguageService languageService : languageServices) {
                    if (!(languageService instanceof TypeScriptService) || Reflection.getOrCreateKotlinClass(languageService.getClass()).getSimpleName() == null) continue;
                    if (languageService instanceof TypeScriptServerServiceImpl) {
                        LOG.info("'Use types from server' option for " + (String)((Object)name) + " state: " + ((TypeScriptServerServiceImpl)languageService).isTypeEvaluationEnabled());
                        continue;
                    }
                    if (!((TypeScriptService)languageService).isTypeEvaluationEnabled()) continue;
                    LOG.info("'Use types from server' option for " + (String)((Object)name) + " is enabled");
                }
            }
            Iterable $this$filterIsInstance$iv = languageServices;
            boolean $i$f$filterIsInstance = false;
            name = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof TypeScriptService)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeScriptService it = (TypeScriptService)element$iv;
                    boolean bl2 = false;
                    if (!it.isTypeEvaluationEnabled()) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public JSType getTypeFromService(@NotNull PsiElement element) {
        JSType typeFromService2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.canAcceptElement(element)) {
            return null;
        }
        PsiElement psiElement = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOriginalOrSelf(...)");
        PsiElement adjustedElement = psiElement;
        PsiElement psiElement2 = JSTypeEvaluationLocationProvider.getTypeEvaluationLocation();
        if (psiElement2 == null || (psiElement2 = psiElement2.getOriginalElement()) == null) {
            TypeScriptCompilerEvaluationFacadeImpl $this$getTypeFromService_u24lambda_u241 = this;
            boolean bl = false;
            $this$getTypeFromService_u24lambda_u241.throwIfUnitTestMode("Type evaluation location has not been provided. Use JSTypeEvaluationLocationProvider.withTypeEvaluationLocation to provide information about evaluation location.");
            psiElement2 = adjustedElement;
        }
        PsiElement evaluationLocation = psiElement2;
        TypeScriptService.VirtualFileAndTypeScriptService virtualFileAndTypeScriptService = JSLanguageServiceUtil.nonBlockingReadActionWithTimeout(() -> TypeScriptCompilerEvaluationFacadeImpl.getTypeFromService$lambda$2(adjustedElement, evaluationLocation));
        if (virtualFileAndTypeScriptService == null) {
            return null;
        }
        TypeScriptService.VirtualFileAndTypeScriptService virtualFileAndTypeScriptService2 = virtualFileAndTypeScriptService;
        VirtualFile virtualFile = virtualFileAndTypeScriptService2.component1();
        TypeScriptService service = virtualFileAndTypeScriptService2.component2();
        if (!(service instanceof BaseLspTypeScriptService) && !(service instanceof TypeScriptCompilerService)) {
            return null;
        }
        if (!service.isTypeEvaluationEnabled()) {
            return null;
        }
        if (!service.supportsTypeEvaluation(virtualFile, adjustedElement)) {
            return null;
        }
        String projectFileName = TypeScriptConfigUtil.getProjectFileName(evaluationLocation.getContainingFile());
        JSLanguageServiceUtil.assertServiceRequestAllowed();
        JSType typeInQuickCase = this.getQuickTypeOfElement(adjustedElement);
        boolean shouldCheckTypeInQuickCaseEquivalence = ApplicationManager.getApplication().isUnitTestMode();
        if (typeInQuickCase != null && !shouldCheckTypeInQuickCaseEquivalence) {
            return typeInQuickCase;
        }
        JSType rawTypeFromService = service.getTypeEvaluationSupport().getElementType(adjustedElement, virtualFile, projectFileName);
        JSType jSType = typeFromService2 = element instanceof JSLiteralExpression && rawTypeFromService instanceof JSLiteralType ? (JSType)((JSLiteralType)rawTypeFromService).copyWithAllowWidening(true) : rawTypeFromService;
        if (typeInQuickCase != null) {
            if (_Assertions.ENABLED && !shouldCheckTypeInQuickCaseEquivalence) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (!typeInQuickCase.isEquivalentTo(typeFromService2, null) && !PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)adjustedElement.getContainingFile()))) {
                LOG.error("Types are not equivalent: " + typeInQuickCase + " vs " + typeFromService2);
            }
        }
        if (typeFromService2 == null && Registry.Companion.is("typescript.compiler.evaluation.fallback")) {
            return null;
        }
        JSType jSType2 = typeFromService2;
        if (jSType2 == null) {
            JSAnyType jSAnyType = JSAnyType.get(JSTypeSource.EMPTY_TS);
            Intrinsics.checkNotNullExpressionValue((Object)jSAnyType, (String)"get(...)");
            jSType2 = jSAnyType;
        }
        return jSType2;
    }

    private final JSType getQuickTypeOfElement(PsiElement element) {
        return element instanceof JSLiteralExpression && !(element instanceof JSStringTemplateExpression) && !(element instanceof JSXmlLiteralExpression) && !((JSLiteralExpression)element).isRegExpLiteral() && !(((JSLiteralExpression)element).getParent() instanceof JSReferenceListMember) ? JSTypeEvaluator.getTypeFromConstant((JSExpression)element) : null;
    }

    private final boolean canAcceptElement(PsiElement element) {
        return !this.isFromJSDoc(element);
    }

    private final boolean isFromJSDoc(PsiElement element) {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(JSDocComment.class), Reflection.getOrCreateKotlinClass(JSDocFunctionType.class), Reflection.getOrCreateKotlinClass(JSDocFunctionTypeParameter.class), Reflection.getOrCreateKotlinClass(JSDocSingleTypeImpl.class), Reflection.getOrCreateKotlinClass(JSDocDecoratedType.class)};
        return PsiTreeUtilKt.parentOfTypes$default((PsiElement)element, (KClass[])kClassArray, (boolean)false, (int)2, null) != null;
    }

    private final void throwIfUnitTestMode(String message) {
        IllegalStateException error = new IllegalStateException(message);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw error;
        }
        LOG.warn((Throwable)error);
    }

    private static final TypeScriptService.VirtualFileAndTypeScriptService getTypeFromService$lambda$2(PsiElement $adjustedElement, PsiElement $evaluationLocation) {
        return TypeScriptService.Companion.getForElement($adjustedElement, $evaluationLocation);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TypeScriptCompilerEvaluationFacadeImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerEvaluationFacadeImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

