/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSStubSafeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptAugmentationUtil {
    public static final Key<CachedValue<Map<PsiElement, Collection<PsiElement>>>> KEY = Key.create((String)"module.aug.non.filtered");

    @NotNull
    public static Collection<PsiElement> getModuleAugmentations(@NotNull PsiElement context2, @NotNull PsiElement module) {
        PsiElement scopeElement;
        if (context2 == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(1);
        }
        if ((scopeElement = TypeScriptAugmentationUtil.calculateScopeElement(context2)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        Map value = (Map)CachedValuesManager.getCachedValue((PsiElement)scopeElement, KEY, () -> {
            Map<PsiElement, Collection<PsiElement>> map2 = TypeScriptAugmentationUtil.getModuleAugmentationsImpl(scopeElement);
            return CachedValueProvider.Result.create(map2, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency(), ProjectRootModificationTracker.getInstance((Project)scopeElement.getProject())});
        });
        Collection collection = value.getOrDefault(module, Collections.emptyList());
        if (collection == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    private static PsiElement calculateScopeElement(@NotNull PsiElement context2) {
        PsiFile file;
        PsiFile file2;
        TypeScriptConfig candidate;
        if (context2 == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(4);
        }
        if ((candidate = TypeScriptConfigUtil.getConfigForPsiFile(context2.getContainingFile(), true)) != null && (file2 = context2.getManager().findFile(candidate.getConfigFile())) != null) {
            return file2;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)context2);
        if (virtualFile == null || JSCorePredefinedLibrariesProvider.getReactPredefinedLibraryFiles().contains(virtualFile)) {
            return null;
        }
        if (DialectDetector.isTypeScript(context2) && !JSLibraryUtil.hasDirectoryInPath(virtualFile, "node_modules", null)) {
            return context2.getContainingFile();
        }
        VirtualFile packageJson = TypeScriptUtil.getPackageJsonOutsideNodeModules(virtualFile);
        if (packageJson != null && (file = context2.getManager().findFile(packageJson)) != null) {
            return file;
        }
        return context2.getContainingFile();
    }

    @NotNull
    private static Map<PsiElement, Collection<PsiElement>> getModuleAugmentationsImpl(@NotNull PsiElement scopeElement) {
        Project project;
        Collection<TypeScriptModule> augmentationModules;
        if (scopeElement == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(5);
        }
        if ((augmentationModules = TypeScriptUtil.getAllAugmentationModules(project = scopeElement.getProject(), scopeElement)).isEmpty()) {
            Map<PsiElement, Collection<PsiElement>> map2 = Collections.emptyMap();
            if (map2 == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(6);
            }
            return map2;
        }
        MultiMap result2 = MultiMap.create();
        for (TypeScriptModule augmentation : augmentationModules) {
            ProgressManager.checkCanceled();
            Collection<PsiElement> elements = TypeScriptAugmentationUtil.resolveAugmentation(augmentation);
            for (PsiElement resolvedModule : elements) {
                ProgressManager.checkCanceled();
                result2.putValue((Object)resolvedModule, (Object)augmentation);
            }
        }
        Map map3 = result2.freezeValues();
        if (map3 == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(7);
        }
        return map3;
    }

    @NotNull
    public static List<PsiElement> getAugmentations(@NotNull PsiElement context2, @NotNull Collection<? extends PsiElement> modules) {
        if (context2 == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(8);
        }
        if (modules == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(9);
        }
        if (modules.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptAugmentationUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        List list = ((StreamEx)((StreamEx)StreamEx.of(modules).flatCollection(el -> TypeScriptAugmentationUtil.getModuleAugmentations(context2, el)).distinct()).filter(augmentation -> {
            ProgressManager.checkCanceled();
            return TypeScriptAugmentationUtil.getVirtualFile(augmentation) != null;
        })).toList();
        if (list == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(12);
        }
        PsiFile file = element.getContainingFile();
        PsiFile originalFile = file.getOriginalFile();
        return originalFile.getVirtualFile();
    }

    @NotNull
    public static Collection<PsiElement> resolveAugmentation(@NotNull PsiElement augmentation) {
        if (augmentation == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(13);
        }
        Collection<PsiElement> augmentedModules = JSFileReferencesUtil.resolveModuleReferences(augmentation);
        List augmentedNames = ContainerUtil.mapNotNull(JSStubSafeUtil.getStubSafeChildrenProperty(augmentation), child -> {
            if (!(child instanceof JSNamedElement)) {
                return null;
            }
            JSNamedElement namedElement = (JSNamedElement)child;
            String name = namedElement.getName();
            if (name == null) {
                return null;
            }
            return name;
        });
        HashSet<PsiElement> result2 = new HashSet<PsiElement>(augmentedModules);
        augmentedModules.forEach(module -> TypeScriptAugmentationUtil.processExportDeclarations(augmentedNames, module, result2, new HashSet<PsiElement>()));
        HashSet<PsiElement> hashSet = result2;
        if (hashSet == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private static void processExportDeclarations(@NotNull Collection<String> names, @NotNull PsiElement module, @NotNull Collection<PsiElement> result2, @NotNull Collection<PsiElement> visitedModules) {
        PsiElement[] exportDeclarations;
        if (names == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(15);
        }
        if (module == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(16);
        }
        if (result2 == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(17);
        }
        if (visitedModules == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(18);
        }
        visitedModules.add(module);
        for (PsiElement declaration : exportDeclarations = JSStubBasedPsiTreeUtil.getChildrenByType(module, ES6PsiUtil.DECLARATIONS)) {
            String referenceText;
            ES6FromClause fromClause;
            ES6ExportDeclaration exportDeclaration;
            if (!(declaration instanceof ES6ExportDeclaration) || !(exportDeclaration = (ES6ExportDeclaration)declaration).isExportAll() || (fromClause = exportDeclaration.getFromClause()) == null || (referenceText = fromClause.getReferenceText()) == null) continue;
            Collection<PsiElement> resolvedModules = JSFileReferencesUtil.resolveModuleReferenceWithoutMerge(declaration, referenceText);
            for (PsiElement resolvedModule : resolvedModules) {
                if (visitedModules.contains(resolvedModule)) continue;
                if (ContainerUtil.or(names, name -> JSStubBasedPsiTreeUtil.resolveLocally(name, resolvedModule) != null)) {
                    result2.add(resolvedModule);
                }
                TypeScriptAugmentationUtil.processExportDeclarations(names, resolvedModule, result2, visitedModules);
            }
        }
    }

    public static boolean isExternalModuleAugmentation(@NotNull PsiElement candidate) {
        if (candidate == null) {
            TypeScriptAugmentationUtil.$$$reportNull$$$0(19);
        }
        if (!(candidate instanceof TypeScriptModule)) {
            return false;
        }
        TypeScriptModule module = (TypeScriptModule)candidate;
        if (!TypeScriptPsiUtil.isAmbientModule(module)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope(module);
        if (container instanceof JSFile) {
            return ((JSFile)container).isCommonJSModule();
        }
        if (container instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientModule((TypeScriptModule)container)) {
            JSElement secondLevelParent = ES6PsiUtil.getExportScope((PsiElement)container);
            return secondLevelParent != null && !ES6PsiUtil.isExternalModule((PsiElement)secondLevelParent);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 10, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "augmentation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedModules";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleAugmentations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleAugmentationsImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugmentations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAugmentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleAugmentations";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateScopeElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleAugmentationsImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAugmentations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveAugmentation";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processExportDeclarations";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isExternalModuleAugmentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7, 10, 11, 14 -> new IllegalStateException(string);
        };
    }
}

