/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface TypeScriptLibraryProvider {
    public static final String LIB_D_TS = "lib.d.ts";
    public static final String REACT_D_TS = "react.d.ts";

    @NotNull
    public static TypeScriptLibraryProvider getService(@NotNull Project project) {
        if (project == null) {
            TypeScriptLibraryProvider.$$$reportNull$$$0(0);
        }
        TypeScriptLibraryProvider typeScriptLibraryProvider = (TypeScriptLibraryProvider)project.getService(TypeScriptLibraryProvider.class);
        if (typeScriptLibraryProvider == null) {
            TypeScriptLibraryProvider.$$$reportNull$$$0(1);
        }
        return typeScriptLibraryProvider;
    }

    @NotNull
    public Set<VirtualFile> getPredefinedLibraries(@NotNull VirtualFile var1);

    @NotNull
    public Set<VirtualFile> getAllBundledLibraries();

    @NotNull
    public Set<VirtualFile> getAllCustomLibraries();

    @NotNull
    public IntSet getLibrariesIds(boolean var1);

    @NotNull
    public IntSet getEffectiveLibrariesIds();

    public Collection<VirtualFile> getCurrentLibraries();

    @NotNull
    public GlobalSearchScope getFileTypeRestrictedScope(@NotNull GlobalSearchScope var1, @NotNull VirtualFile var2);

    @NotNull
    public static Set<VirtualFile> getPredefinedLibraries(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TypeScriptLibraryProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TypeScriptLibraryProvider.$$$reportNull$$$0(3);
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(project);
        Set<VirtualFile> set = service.getPredefinedLibraries(file);
        if (set == null) {
            TypeScriptLibraryProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    public static boolean checkLibraryFile(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return false;
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(project);
        return service.isLibraryFile(file);
    }

    @NotNull
    public static String getVersion(@Nullable Project project) {
        if (project == null) {
            return "";
        }
        return "5.4.3";
    }

    public boolean isLibraryFile(@Nullable VirtualFile var1);

    public boolean isLibraryOrBundledLibraryFile(@Nullable VirtualFile var1);

    public boolean isLibraryFileName(@NotNull String var1);

    @Nullable
    public VirtualFile findLibraryByShortName(@NotNull String var1);

    public static boolean isLibraryOrBundledLibraryFile(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null) {
            return false;
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(project);
        return service.isLibraryOrBundledLibraryFile(file);
    }

    @NotNull
    public Set<VirtualFile> getLibsForTarget(@NotNull Project var1, @Nullable TypeScriptConfig.LanguageTarget var2);

    @NotNull
    public static @Unmodifiable Set<VirtualFile> getAllLibraries(@NotNull Project project) {
        if (project == null) {
            TypeScriptLibraryProvider.$$$reportNull$$$0(5);
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(project);
        Set<VirtualFile> customLibraries = service.getAllCustomLibraries();
        Set bundledLibraries = service.getAllBundledLibraries();
        Set set = customLibraries.isEmpty() ? bundledLibraries : ContainerUtil.union(bundledLibraries, customLibraries);
        if (set == null) {
            TypeScriptLibraryProvider.$$$reportNull$$$0(6);
        }
        return set;
    }

    @RequiresReadLock
    @NotNull
    public TypeScriptLibraries getEffectiveLibrary();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/library/TypeScriptLibraryProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/library/TypeScriptLibraryProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraries";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllLibraries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6 -> new IllegalStateException(string);
        };
    }
}

