/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.ide;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.ide.ServiceResultsState;
import com.intellij.lang.typescript.compiler.languageService.ide.TypeScriptServiceCompletionProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J@\u0010\u0014\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!H\u0002J.\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0014\u0010&\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00160\u00152\u0006\u0010'\u001a\u00020!H\u0002J\u001e\u0010(\u001a\u00020)\"\u0004\b\u0000\u0010*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u0002H*\u0018\u00010\u0016H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006,"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/ide/TypeScriptServiceCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "serviceItemsLimit", "", "getServiceItemsLimit", "()I", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "resultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "isRapidContributorCompletionResultPlace", "", "context", "Lcom/intellij/psi/PsiElement;", "unsupportedLocation", "location", "getServiceFuture", "Ljava/util/concurrent/Future;", "", "Lcom/intellij/lang/typescript/compiler/TypeScriptService$CompletionEntry;", "service", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "logExceededThreshold", "threshold", "", "time", "timeToWait", "startProcess", "awaitServiceFuture", "serviceFuture", "toWait", "getStateByDetails", "Lcom/intellij/lang/typescript/compiler/languageService/ide/ServiceResultsState;", "T", "details", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptServiceCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServiceCompletionContributor.kt\ncom/intellij/lang/typescript/compiler/languageService/ide/TypeScriptServiceCompletionContributor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,383:1\n24#2:384\n*S KotlinDebug\n*F\n+ 1 TypeScriptServiceCompletionContributor.kt\ncom/intellij/lang/typescript/compiler/languageService/ide/TypeScriptServiceCompletionContributor\n*L\n151#1:384\n*E\n"})
public class TypeScriptServiceCompletionContributor
extends CompletionContributor {
    protected int getServiceItemsLimit() {
        return Registry.Companion.get("typescript.service.completion.serviceItemsLimit").asInteger();
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                if (parameters.isExtendedCompletion()) break block14;
                PsiElement psiElement = parameters.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
                if (!this.unsupportedLocation(psiElement)) break block15;
            }
            return;
        }
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile psiFile2 = psiFile;
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement context2 = psiElement;
        if (DumbService.Companion.isDumb(project2)) {
            return;
        }
        if (!TypeScriptLanguageServiceUtil.isServiceCompletionEnabled()) {
            return;
        }
        TypeScriptService.VirtualFileAndTypeScriptService virtualFileAndTypeScriptService = TypeScriptService.Companion.getForElement$default(TypeScriptService.Companion, (PsiElement)psiFile2, null, 2, null);
        if (virtualFileAndTypeScriptService == null) {
            return;
        }
        TypeScriptService.VirtualFileAndTypeScriptService virtualFileAndTypeScriptService2 = virtualFileAndTypeScriptService;
        VirtualFile file = virtualFileAndTypeScriptService2.component1();
        TypeScriptService tsService = virtualFileAndTypeScriptService2.component2();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return;
        }
        Document document2 = document;
        int offset = InjectedLanguageManager.getInstance((Project)project2).injectedToHost((PsiElement)psiFile2, parameters.getOffset());
        if (!file.isInLocalFileSystem() || !TypeScriptLanguageServiceUtil.useServiceCompletion(project2)) {
            return;
        }
        TypeScriptService.CompletionMergeStrategy strategy = tsService.getCompletionMergeStrategy(parameters, psiFile2, context2);
        if (strategy == TypeScriptService.CompletionMergeStrategy.NON) {
            return;
        }
        boolean isRapidContributorCompletion = this.isRapidContributorCompletionResultPlace(context2);
        if (Registry.Companion.is("typescript.service.completion.fasterPaint")) {
            CompletionProgressIndicator completionProgressIndicator;
            CompletionProcess completionProcess = parameters.getProcess();
            CompletionProgressIndicator completionProgressIndicator2 = completionProgressIndicator = completionProcess instanceof CompletionProgressIndicator ? (CompletionProgressIndicator)completionProcess : null;
            if (completionProgressIndicator2 != null) {
                completionProgressIndicator2.showLookupAsSoonAsPossible();
            }
        }
        Future<List<TypeScriptService.CompletionEntry>> future = this.getServiceFuture(tsService, file, document2, offset, parameters);
        if (future == null) {
            return;
        }
        Future<List<TypeScriptService.CompletionEntry>> serviceFuture = future;
        Ref.ObjectRef serviceResultsState = new Ref.ObjectRef();
        serviceResultsState.element = ServiceResultsState.NOT_COMPLETED;
        TypeScriptServiceCompletionProcessor processor = new TypeScriptServiceCompletionProcessor(parameters, document2, offset, resultSet, tsService, strategy, isRapidContributorCompletion);
        long startProcessTime = System.currentTimeMillis();
        resultSet.runRemainingContributors(parameters, arg_0 -> TypeScriptServiceCompletionContributor.fillCompletionVariants$lambda$1(arg_0 -> TypeScriptServiceCompletionContributor.fillCompletionVariants$lambda$0(processor, serviceResultsState, serviceFuture, this, startProcessTime, resultSet, arg_0), arg_0));
        if (serviceResultsState.element == ServiceResultsState.NOT_COMPLETED) {
            long toWait = this.timeToWait(startProcessTime);
            List<TypeScriptService.CompletionEntry> completionEntries = this.awaitServiceFuture(serviceFuture, toWait);
            serviceResultsState.element = this.getStateByDetails(completionEntries);
            if (serviceResultsState.element == ServiceResultsState.COMPLETED_ACCEPTED && completionEntries != null) {
                processor.putAllServiceCompletionEntries(completionEntries);
            }
        }
        processor.flushEverythingAfterBothSourcesFinished((ServiceResultsState)((Object)serviceResultsState.element));
    }

    private final boolean isRapidContributorCompletionResultPlace(PsiElement context2) {
        PsiElement parent = context2.getParent();
        return (!(parent instanceof JSReferenceExpression) || !((JSReferenceExpression)parent).hasQualifier()) && Registry.Companion.is("typescript.service.completion.rapidOwnResultsWherePossible");
    }

    private final boolean unsupportedLocation(PsiElement location) {
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)location), (Object)JSDocTokenTypes.DOC_TAG_NAME);
    }

    private final Future<List<TypeScriptService.CompletionEntry>> getServiceFuture(TypeScriptService service, VirtualFile virtualFile, Document document, int offset, CompletionParameters parameters) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        long start = System.currentTimeMillis();
        Future<List<TypeScriptService.CompletionEntry>> future = service.getCompletionItems(virtualFile, document, offset, parameters);
        long time = System.currentTimeMillis() - start;
        if (time > 150L) {
            this.logExceededThreshold(150L, time, service);
        }
        return future;
    }

    private final void logExceededThreshold(long threshold, long time, TypeScriptService service) {
        TypeScriptServiceCompletionContributor $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TypeScriptServiceCompletionContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Exceeded the " + threshold + "ms threshold for getCompletionItems. Is your Future asynchronous? time: " + time + "ms, service: " + service.getClass().getSimpleName());
    }

    private final long timeToWait(long startProcess) {
        long diffAwaited = System.currentTimeMillis() - startProcess;
        return 700L - diffAwaited;
    }

    private final List<TypeScriptService.CompletionEntry> awaitServiceFuture(Future<List<TypeScriptService.CompletionEntry>> serviceFuture, long toWait) {
        return JSLanguageServiceUtil.awaitFuture(serviceFuture, toWait, 5L, null);
    }

    private final <T> ServiceResultsState getStateByDetails(List<? extends T> details) {
        Collection collection = details;
        return !(collection == null || collection.isEmpty()) && details.size() < this.getServiceItemsLimit() ? ServiceResultsState.COMPLETED_ACCEPTED : ServiceResultsState.COMPLETED_DISCARDED;
    }

    private static final Unit fillCompletionVariants$lambda$0(TypeScriptServiceCompletionProcessor $processor, Ref.ObjectRef $serviceResultsState, Future $serviceFuture, TypeScriptServiceCompletionContributor this$0, long $startProcessTime, CompletionResultSet $resultSet, CompletionResult completionResult) {
        Intrinsics.checkNotNull((Object)completionResult);
        if ($processor.acceptPriorityCompletionResult(completionResult)) {
            return Unit.INSTANCE;
        }
        if ($serviceResultsState.element == ServiceResultsState.NOT_COMPLETED) {
            $processor.addElementToRemainingMap(completionResult);
            if (!$serviceFuture.isDone() && this$0.timeToWait($startProcessTime) >= 0L) {
                return Unit.INSTANCE;
            }
            List<TypeScriptService.CompletionEntry> completionEntries = this$0.awaitServiceFuture($serviceFuture, 0L);
            $serviceResultsState.element = this$0.getStateByDetails(completionEntries);
            $processor.flushCollectedContributorResultsAfterServiceFutureIsDone((ServiceResultsState)((Object)$serviceResultsState.element), completionEntries);
        } else if ($serviceResultsState.element == ServiceResultsState.COMPLETED_DISCARDED) {
            $resultSet.passResult(completionResult);
        } else {
            $processor.processRemainingItem(completionResult);
        }
        return Unit.INSTANCE;
    }

    private static final void fillCompletionVariants$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

