/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAnnotationErrorsFilter;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticEventKind;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceProjectErrors;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCache;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerState
implements Disposable {
    private static final int TIME_TO_MERGE_COMPILE_EVENTS_MILLS = 2000;
    private static final int TIME_TO_REMOVE_USELESS_EVENTS = 5000;
    public static final String TYPESCRIPT_PACKAGE = "typescript";
    @NotNull
    private final MergingUpdateQueue myCommandQueue;
    @NotNull
    private final ConcurrentMap<String, CopyOnWriteArraySet<Consumer<JSLanguageServiceAnswer>>> myEventCollector;
    @NotNull
    private final ConcurrentMap<String, JSLanguageServiceAnswer> myConfigDiagnostics;
    @NotNull
    private final MergingUpdateQueue myRemoveVfsEventsQueue;
    @NotNull
    private final Set<VirtualFile> myChangedContentFiles;
    @NotNull
    private final Pair<VirtualFile, Long> myServicePackageJsonInfo;
    @NotNull
    private final TypeScriptLanguageServiceCache myCacheData;
    @NotNull
    private final Set<String> myCompiledProjects;
    @NotNull
    private final Project myProject;
    protected volatile Set<String> myErrorCodeFixes;
    private final TypeScriptServiceProjectErrors myProjectErrors;
    @Nullable
    private volatile LanguageServiceInfo myLanguageServiceInfo;
    @Nullable
    @NlsSafe
    private volatile String myServerVersion;
    @NotNull
    @Nls
    private volatile String myProcessName;
    @Nullable
    private final VirtualFile myDefaultConfig;

    public TypeScriptServerState(@NotNull Project project, @NotNull TypeScriptLanguageServiceCache cacheData, @NotNull JSLanguageServiceProtocol protocol, @NotNull JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter reporter, @NotNull JSAnnotationErrorsFilter filter, @NotNull String servicePath) {
        if (project == null) {
            TypeScriptServerState.$$$reportNull$$$0(0);
        }
        if (cacheData == null) {
            TypeScriptServerState.$$$reportNull$$$0(1);
        }
        if (protocol == null) {
            TypeScriptServerState.$$$reportNull$$$0(2);
        }
        if (reporter == null) {
            TypeScriptServerState.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            TypeScriptServerState.$$$reportNull$$$0(4);
        }
        if (servicePath == null) {
            TypeScriptServerState.$$$reportNull$$$0(5);
        }
        this.myConfigDiagnostics = new ConcurrentHashMap<String, JSLanguageServiceAnswer>();
        this.myCompiledProjects = ContainerUtil.newConcurrentSet();
        this.myErrorCodeFixes = Collections.emptySet();
        this.myProject = project;
        this.myCacheData = cacheData;
        VirtualFile packageJson = TypeScriptServerState.getPackageJsonFromServicePath(servicePath);
        this.myServicePackageJsonInfo = Pair.create((Object)packageJson, (Object)(packageJson == null ? -1L : packageJson.getModificationStamp()));
        this.myEventCollector = new ConcurrentHashMap<String, CopyOnWriteArraySet<Consumer<JSLanguageServiceAnswer>>>();
        this.myCommandQueue = new MergingUpdateQueue("TypeScript service compile queue", 2000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myProjectErrors = new TypeScriptServiceProjectErrors(project, protocol, reporter, filter);
        this.myRemoveVfsEventsQueue = new MergingUpdateQueue("TypeScript service files to reload", 5000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myRemoveVfsEventsQueue.setRestartTimerOnAdd(true);
        this.myChangedContentFiles = ConcurrentCollectionFactory.createConcurrentSet();
        this.registerEventTracker("configFileDiag", el -> {
            JsonObject element = el.getElement();
            JsonObject body2 = element.getAsJsonObject("body");
            JsonElement file = body2.get("configFile");
            if (file != null && file.isJsonPrimitive()) {
                String string = file.getAsString();
                this.myConfigDiagnostics.put(FileUtil.toSystemIndependentName((String)string), (JSLanguageServiceAnswer)el);
                JSLanguageServiceQueue.Holder.LOGGER.debug("Updated config diagnostics: " + el.getElement());
            }
        });
        this.registerEventTracker(DiagnosticEventKind.syntaxDiag.name(), answer2 -> this.myProjectErrors.pushSyntaxErrors(answer2, this.myLanguageServiceInfo));
        this.registerEventTracker(DiagnosticEventKind.semanticDiag.name(), answer2 -> this.myProjectErrors.pushSemanticErrors(answer2, this.myLanguageServiceInfo));
        this.registerEventTracker(DiagnosticEventKind.suggestionDiag.name(), answer2 -> this.myProjectErrors.pushSuggestions(answer2, this.myLanguageServiceInfo));
        this.myProcessName = JavaScriptBundle.message("typescript.compiler.starting", new Object[0]);
        this.myDefaultConfig = TypeScriptLanguageServiceUtil.getDefaultConfig(project);
    }

    public final void registerEventTracker(@NotNull String eventName, @NotNull Consumer<JSLanguageServiceAnswer> tracker) {
        if (eventName == null) {
            TypeScriptServerState.$$$reportNull$$$0(6);
        }
        if (tracker == null) {
            TypeScriptServerState.$$$reportNull$$$0(7);
        }
        this.myEventCollector.computeIfAbsent(eventName, e -> new CopyOnWriteArraySet()).add(tracker);
    }

    void processEvent(@NotNull JSLanguageServiceAnswer el) {
        String type;
        if (el == null) {
            TypeScriptServerState.$$$reportNull$$$0(8);
        }
        if ((type = el.getProperty("event")) == null) {
            return;
        }
        Set consumers = (Set)this.myEventCollector.get(type);
        if (consumers != null) {
            for (Consumer consumer : consumers) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    block2: {
                        try {
                            consumer.accept(el);
                        }
                        catch (Exception e) {
                            if (e instanceof ControlFlowException) break block2;
                            JSLanguageServiceQueue.Holder.LOGGER.error("Exception during TS server event handling", (Throwable)e);
                        }
                    }
                });
            }
        } else {
            JSLanguageServiceQueue.Holder.LOGGER.debug("Unprocessed event: " + el.getElement());
        }
    }

    @Nullable
    JSLanguageServiceAnswer getConfigDiagnostics(@NotNull String config) {
        if (config == null) {
            TypeScriptServerState.$$$reportNull$$$0(9);
        }
        return (JSLanguageServiceAnswer)this.myConfigDiagnostics.get(config);
    }

    void flushQueue() {
        this.myCommandQueue.flush();
    }

    public void addUpdate(@NotNull Update update2) {
        if (update2 == null) {
            TypeScriptServerState.$$$reportNull$$$0(10);
        }
        this.myCommandQueue.queue(update2);
    }

    void addFileToContentChangedQueue(@NotNull TypeScriptCompilerService.UpdateFileInfo update2) {
        if (update2 == null) {
            TypeScriptServerState.$$$reportNull$$$0(11);
        }
        final VirtualFile file = update2.getFile();
        if (update2.isVfsChange()) {
            this.myCacheData.addVfsFile(file);
            this.myRemoveVfsEventsQueue.queue(new Update(file){

                public void run() {
                    TypeScriptServerState.this.myCacheData.removeVfsFile(file);
                }
            });
        } else {
            this.myChangedContentFiles.add(file);
            this.myRemoveVfsEventsQueue.queue(new Update(file){

                public void run() {
                    TypeScriptServerState.this.myChangedContentFiles.remove(file);
                }
            });
        }
    }

    @NotNull
    public Set<VirtualFile> getChangedContentFiles() {
        return new HashSet<VirtualFile>(this.myChangedContentFiles);
    }

    public void dispose() {
        this.myCommandQueue.cancelAllUpdates();
        this.myChangedContentFiles.clear();
        this.myRemoveVfsEventsQueue.cancelAllUpdates();
        this.myEventCollector.clear();
        Disposer.dispose((Disposable)this.myProjectErrors);
    }

    public boolean isProjectCompiled(@NotNull String projectName) {
        if (projectName == null) {
            TypeScriptServerState.$$$reportNull$$$0(12);
        }
        return this.myCompiledProjects.contains(projectName);
    }

    public void setProjectCompiled(@NotNull String projectName) {
        if (projectName == null) {
            TypeScriptServerState.$$$reportNull$$$0(13);
        }
        this.myCompiledProjects.add(projectName);
    }

    public void clearCompiledProject(@NotNull String projectName) {
        if (projectName == null) {
            TypeScriptServerState.$$$reportNull$$$0(14);
        }
        this.myCompiledProjects.remove(projectName);
    }

    public void forceProjectOwner(@Nullable String projectContext, @NotNull List<JSAnnotationError> globalErrors) {
        if (globalErrors == null) {
            TypeScriptServerState.$$$reportNull$$$0(15);
        }
        this.myProjectErrors.setProjectContext(projectContext, globalErrors);
    }

    public void setErrorCodes(@NotNull Set<String> errorCodeFixes) {
        if (errorCodeFixes == null) {
            TypeScriptServerState.$$$reportNull$$$0(16);
        }
        this.myErrorCodeFixes = errorCodeFixes;
    }

    public void setLanguageServiceInfo(@Nullable LanguageServiceInfo languageServiceInfo) {
        this.myLanguageServiceInfo = languageServiceInfo;
    }

    @Nullable
    public LanguageServiceInfo getLanguageServiceInfo() {
        return this.myLanguageServiceInfo;
    }

    public void setProcessName(@Nls @NotNull String processName) {
        if (processName == null) {
            TypeScriptServerState.$$$reportNull$$$0(17);
        }
        this.myProcessName = processName;
    }

    public void setServerVersion(@NlsSafe @Nullable String versionAsString) {
        this.myServerVersion = versionAsString;
    }

    @Nls
    @NotNull
    public String getStatus() {
        Object object = this.myServerVersion != null ? this.myProcessName + " " + this.myServerVersion : this.myProcessName;
        if (object == null) {
            TypeScriptServerState.$$$reportNull$$$0(18);
        }
        return object;
    }

    @Nullable
    public VirtualFile getDefaultConfig() {
        return this.myDefaultConfig;
    }

    public boolean isServiceValid() {
        VirtualFile packageJson = (VirtualFile)this.myServicePackageJsonInfo.first;
        if (packageJson != null && !packageJson.isValid()) {
            return false;
        }
        String path2 = TypeScriptServiceDirectoryWatcher.getService(this.myProject).calcServiceDirectoryAndRefresh();
        VirtualFile currentPackageJson = TypeScriptServerState.getPackageJsonFromServicePath(path2);
        if (!Objects.equals(packageJson, currentPackageJson)) {
            return false;
        }
        return packageJson == null || packageJson.getModificationStamp() == ((Long)this.myServicePackageJsonInfo.second).longValue();
    }

    @Nullable
    public SemVer getServerVersion() {
        return SemVer.parseFromText((String)this.myServerVersion);
    }

    @Nullable
    public static VirtualFile getPackageJsonFromServicePath(@NotNull String servicePath) {
        VirtualFile serviceDirectory;
        if (servicePath == null) {
            TypeScriptServerState.$$$reportNull$$$0(19);
        }
        VirtualFile packageRoot = (serviceDirectory = LocalFileSystem.getInstance().findFileByPath(servicePath)) == null ? null : (serviceDirectory.getName().equals(TYPESCRIPT_PACKAGE) ? serviceDirectory : serviceDirectory.getParent());
        return packageRoot == null ? null : packageRoot.findChild("package.json");
    }

    TypeScriptServiceProjectErrors getProjectErrors() {
        return this.myProjectErrors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servicePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrors";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCodeFixes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerEventTracker";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConfigDiagnostics";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addFileToContentChangedQueue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isProjectCompiled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setProjectCompiled";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clearCompiledProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "forceProjectOwner";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setErrorCodes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setProcessName";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonFromServicePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }
}

