/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSignatureHelpResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSymbolDisplayPart;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptLanguageServiceResponseParser {
    public static final String NO_NAME = "noname";

    public static List<JSFunctionItem> parseFunctions(TypeScriptSignatureHelpResponse response, @NotNull PsiFile contextFile) {
        Object[] items;
        if (contextFile == null) {
            TypeScriptLanguageServiceResponseParser.$$$reportNull$$$0(0);
        }
        if (ArrayUtil.isEmpty((Object[])(items = response.items))) {
            return ContainerUtil.emptyList();
        }
        SmartList result2 = new SmartList();
        for (Object item : items) {
            String functionName = NO_NAME;
            for (TypeScriptSymbolDisplayPart part : ((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpItem)item).prefixDisplayParts) {
                if (!"methodName".equals(part.kind)) continue;
                functionName = part.text;
            }
            JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(functionName, (PsiElement)contextFile);
            builder2.setType(JSImplicitElement.Type.Function);
            Object[] parameters = ((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpItem)item).parameters;
            if (ArrayUtil.isEmpty((Object[])parameters)) {
                result2.add((JSFunctionItem)((Object)builder2.toImplicitElement()));
                continue;
            }
            SmartList parameterStructures = new SmartList();
            for (Object parameter : parameters) {
                int symbolIndex;
                String typeText = null;
                Object[] parameterParts = ((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpParameter)parameter).displayParts;
                if (!ArrayUtil.isEmpty((Object[])parameterParts) && !TypeScriptLanguageServiceResponseParser.isInvalidPlace((TypeScriptSymbolDisplayPart[])parameterParts, symbolIndex = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace((TypeScriptSymbolDisplayPart[])parameterParts, 0, ':'))) {
                    typeText = TypeScriptLanguageServiceResponseParser.readRestText((TypeScriptSymbolDisplayPart[])parameterParts, symbolIndex);
                }
                parameterStructures.add(new JSImplicitParameterStructure(((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpParameter)parameter).name, typeText, ((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpParameter)parameter).isOptional, false, true));
            }
            builder2.setParameters((List<JSImplicitParameterStructure>)parameterStructures);
            result2.add((JSFunctionItem)((Object)builder2.toImplicitElement()));
        }
        return result2;
    }

    @NotNull
    public static String readRestText(TypeScriptSymbolDisplayPart[] parts, int startIndex) {
        StringBuilder result2 = new StringBuilder();
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            TypeScriptLanguageServiceResponseParser.appendText(result2, part);
        }
        String string = result2.toString();
        if (string == null) {
            TypeScriptLanguageServiceResponseParser.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void appendText(StringBuilder result2, TypeScriptSymbolDisplayPart part) {
        if ("space".equals(part.kind)) {
            result2.append(" ");
        } else {
            result2.append(part.text);
        }
    }

    public static int waitSymbolWithoutBrace(TypeScriptSymbolDisplayPart[] parts, int startIndex, char symbol) {
        ArrayDeque<String> toSkipPairs = new ArrayDeque<String>();
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            String text = part.text;
            if ("{".equals(text)) {
                toSkipPairs.addLast("}");
                continue;
            }
            if ("<".equals(text)) {
                toSkipPairs.addLast(">");
                continue;
            }
            if ("[".equals(text)) {
                toSkipPairs.addLast("]");
                continue;
            }
            if (symbol != '(' && "(".equals(text)) {
                toSkipPairs.addLast(")");
                continue;
            }
            if (!toSkipPairs.isEmpty()) {
                if (!text.equals(toSkipPairs.getLast())) continue;
                toSkipPairs.removeLast();
                continue;
            }
            if (!text.equals(String.valueOf(symbol))) continue;
            return i + 1;
        }
        return -1;
    }

    public static boolean isInvalidPlace(TypeScriptSymbolDisplayPart[] parts, int index) {
        return index == -1 || index >= parts.length;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceResponseParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceResponseParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readRestText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctions";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

