/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.TypeScriptFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptImplementMemberUtil {
    private static final TypeScriptFunctionSignatureGenerator TS_SIGNATURE_GENERATOR = new TypeScriptFunctionSignatureGenerator();
    private static final String ourImplementedMethodBodyTemplate = "TypeScript Implemented Method Body.ts";

    public static void implementAllMissingMembersForMemberOwner(@NotNull PsiElement memberOwner, @Nullable JSType expectedType) {
        JSObjectLiteralExpression objectLiteral;
        JSClass jsClass;
        ASTNode anchorNode;
        if (memberOwner == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(0);
        }
        if ((anchorNode = memberOwner.getNode().findChildByType(JSTokenTypes.LBRACE)) == null) {
            return;
        }
        JSClass jSClass = jsClass = memberOwner instanceof JSClass ? (JSClass)memberOwner : null;
        if (jsClass != null) {
            Map<TypeScriptMemberInfo, JSClass> members = TypeScriptUtil.getUnimplementedMembers(jsClass, false);
            TypeScriptImplementMemberUtil.invokeOnMemberList(jsClass, anchorNode, members, false);
            return;
        }
        JSObjectLiteralExpression jSObjectLiteralExpression = objectLiteral = memberOwner instanceof JSObjectLiteralExpression ? (JSObjectLiteralExpression)memberOwner : null;
        if (objectLiteral != null) {
            if (expectedType != null) {
                Map<TypeScriptMemberInfo, JSClass> members = TypeScriptImplementMemberUtil.getUnimplementedMembersForLiteral(objectLiteral, expectedType, false);
                TypeScriptImplementMemberUtil.invokeOnMemberList((PsiElement)objectLiteral, objectLiteral.getFirstChild().getNode(), members, false);
            }
            return;
        }
        throw new NotImplementedError("Please implement me for: " + memberOwner.getClass());
    }

    @Nullable
    public static JSType filterExpectedTypeForImplement(@Nullable JSType expectedType, @Nullable PsiElement location) {
        if (expectedType instanceof JSEvaluableOnlyType && expectedType.isJavaScript()) {
            return null;
        }
        if ((expectedType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(expectedType, location)) instanceof JSUnionType || expectedType instanceof JSContextualUnionType) {
            List<JSType> types = ((JSUnionOrIntersectionType)expectedType).getTypes();
            ArrayList<JSType> filteredTypes = new ArrayList<JSType>(types.size());
            for (JSType typeComponent : types) {
                JSType type = typeComponent instanceof TypeScriptCompilerType ? typeComponent.substitute() : typeComponent;
                if (type instanceof JSArrayType || type instanceof JSTupleType || type instanceof JSPrimitiveType) continue;
                filteredTypes.add(type);
            }
            if (!filteredTypes.isEmpty() && filteredTypes.size() != types.size()) {
                return expectedType.isTypeScript() ? JSCompositeTypeFactory.createContextualUnionType(filteredTypes, expectedType.getSource()) : JSCompositeTypeFactory.createUnionType(expectedType.getSource(), filteredTypes);
            }
        }
        return expectedType;
    }

    @NotNull
    public static Map<TypeScriptMemberInfo, JSClass> getUnimplementedMembersForLiteral(@NotNull JSObjectLiteralExpression objectLiteral, @NotNull JSType expectedType, boolean includeOptional) {
        JSType filteredType;
        if (objectLiteral == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(1);
        }
        if (expectedType == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(2);
        }
        if ((filteredType = TypeScriptImplementMemberUtil.filterExpectedTypeForImplement(expectedType, (PsiElement)objectLiteral)) == null) {
            Map<TypeScriptMemberInfo, JSClass> map2 = Collections.emptyMap();
            if (map2 == null) {
                TypeScriptImplementMemberUtil.$$$reportNull$$$0(3);
            }
            return map2;
        }
        JSRecordType recordType = filteredType.asRecordType();
        HashMap<TypeScriptMemberInfo, JSClass> members = new HashMap<TypeScriptMemberInfo, JSClass>();
        JSType exprType = JSResolveUtil.getExpressionJSType(objectLiteral);
        if (exprType == null) {
            Map<TypeScriptMemberInfo, JSClass> map3 = Collections.emptyMap();
            if (map3 == null) {
                TypeScriptImplementMemberUtil.$$$reportNull$$$0(4);
            }
            return map3;
        }
        Set<String> propNames = exprType.asRecordType().getPropertyNames();
        for (JSRecordType.TypeMember prop : recordType.getTypeMembers()) {
            if (!(prop instanceof JSRecordType.PropertySignature) || propNames.contains(((JSRecordType.PropertySignature)prop).getMemberName())) continue;
            JSRecordType.MemberSource source = prop.getMemberSource();
            if (source.isEmpty()) {
                PsiElement sourceElement = recordType.getSource().getSourceElement();
                if (sourceElement == null) continue;
                members.put(TypeScriptMemberInfo.create(prop, new JSLocalImplicitElementImpl(((JSRecordType.PropertySignature)prop).getMemberName(), ((JSRecordType.PropertySignature)prop).getJSType(), sourceElement, JSImplicitElement.Type.Property)), JSResolveUtil.getClassOfContext(sourceElement));
                continue;
            }
            for (PsiElement singleElement : source.getAllSourceElements()) {
                if (!includeOptional && singleElement instanceof JSOptionalOwner && ((JSOptionalOwner)singleElement).isOptional()) continue;
                if (singleElement instanceof TypeScriptFunction) {
                    for (JSFunctionItem jSFunctionItem : TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)singleElement)) {
                        members.put(TypeScriptMemberInfo.create(prop, jSFunctionItem), JSResolveUtil.getClassOfContext((PsiElement)jSFunctionItem));
                    }
                    continue;
                }
                members.put(TypeScriptMemberInfo.create(prop, (JSElement)singleElement), JSResolveUtil.getClassOfContext(singleElement));
            }
        }
        HashMap<TypeScriptMemberInfo, JSClass> hashMap = members;
        if (hashMap == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    public static void addUnimplementedMemberCandidates(@Nullable PsiElement memberContainer, @NotNull Collection<? super JSChooserElementNode> candidates, @NotNull Predicate<? super JSElement> filter) {
        JSType expectedType;
        Map<TypeScriptMemberInfo, JSClass> members;
        if (candidates == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(7);
        }
        if ((members = memberContainer instanceof JSClass ? TypeScriptUtil.getUnimplementedMembers((JSClass)memberContainer, true) : (memberContainer instanceof JSObjectLiteralExpression ? ((expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)memberContainer, JSExpectedTypeKind.CONTEXTUAL)) == null ? null : TypeScriptImplementMemberUtil.getUnimplementedMembersForLiteral((JSObjectLiteralExpression)memberContainer, expectedType, true)) : null)) == null) {
            return;
        }
        for (Map.Entry<TypeScriptMemberInfo, JSClass> entry : members.entrySet()) {
            JSElement key = entry.getKey().getElement();
            if (!filter.test(key)) continue;
            if (entry.getKey().getMember() != null) {
                Collection<PsiElement> elements = QualifiedItemProcessor.getElementsForTypeMember(entry.getKey().getMember(), (PsiElement)key, true);
                candidates.add(JSChooserElementNode.create((PsiElement)(elements.size() == 1 ? elements.iterator().next() : key)));
                continue;
            }
            candidates.add(JSChooserElementNode.create((PsiElement)key));
        }
    }

    public static void implementMembersForMemberOwner(@NotNull PsiElement memberOwner, @NotNull Set<? extends JSNamedElement> toImplement, @Nullable ASTNode anchorNode, boolean implementAsAbstract) {
        if (memberOwner == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(8);
        }
        if (toImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(9);
        }
        if ((anchorNode = TypeScriptImplementMemberUtil.fixAnchorNode(memberOwner, anchorNode)) == null) {
            return;
        }
        if (memberOwner instanceof JSClass) {
            TypeScriptImplementMemberUtil.doImplementMembers(memberOwner, toImplement, anchorNode, TypeScriptUtil.getUnimplementedMembers((JSClass)memberOwner, false), implementAsAbstract);
        } else if (memberOwner instanceof JSObjectLiteralExpression) {
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)memberOwner, JSExpectedTypeKind.CONTEXTUAL);
            if (expectedType != null) {
                TypeScriptImplementMemberUtil.doImplementMembers(memberOwner, toImplement, anchorNode, TypeScriptImplementMemberUtil.getUnimplementedMembersForLiteral((JSObjectLiteralExpression)memberOwner, expectedType, true), false);
            }
        } else {
            throw new NotImplementedError("Please implement me for " + memberOwner.getClass());
        }
    }

    @Nullable
    private static ASTNode fixAnchorNode(@NotNull PsiElement owner, @Nullable ASTNode anchorNode) {
        if (owner == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(10);
        }
        if (anchorNode == null) {
            anchorNode = owner.getNode().findChildByType(JSTokenTypes.LBRACE);
        } else {
            while (anchorNode != null && TreeUtil.isWhitespaceOrComment((ASTNode)anchorNode)) {
                anchorNode = anchorNode.getTreePrev();
            }
        }
        if (anchorNode == null) {
            return null;
        }
        return anchorNode;
    }

    private static void doImplementMembers(@NotNull PsiElement jsClass, @NotNull Set<? extends JSNamedElement> toImplement, @NotNull ASTNode anchorNode, Map<TypeScriptMemberInfo, JSClass> members, boolean implementAsAbstract) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(11);
        }
        if (toImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(12);
        }
        if (anchorNode == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(13);
        }
        ArrayList<TypeScriptMemberInfo> keySet = new ArrayList<TypeScriptMemberInfo>(members.keySet());
        for (TypeScriptMemberInfo typeScriptMemberInfo : keySet) {
            JSElement jsElement = typeScriptMemberInfo.getElement();
            if (jsElement instanceof JSNamedElement && toImplement.contains(jsElement)) continue;
            members.remove(typeScriptMemberInfo);
        }
        for (JSElement jSElement : toImplement) {
            TypeScriptMemberInfo info = TypeScriptMemberInfo.create(null, jSElement);
            if (members.containsKey(info)) continue;
            members.put(info, JSResolveUtil.getClassOfContext((PsiElement)jSElement));
        }
        TypeScriptImplementMemberUtil.invokeOnMemberList(jsClass, anchorNode, members, implementAsAbstract);
    }

    private static void invokeOnMemberList(@NotNull PsiElement jsClass, @NotNull ASTNode anchorNode, @NotNull Map<TypeScriptMemberInfo, JSClass> members, boolean implementAsAbstract) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(14);
        }
        if (anchorNode == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(15);
        }
        if (members == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(16);
        }
        ContainerUtil.KeyOrderedMultiMap properties = new ContainerUtil.KeyOrderedMultiMap();
        ContainerUtil.KeyOrderedMultiMap functions = new ContainerUtil.KeyOrderedMultiMap();
        ArrayList<TypeScriptMemberInfo> stringIndexers = new ArrayList<TypeScriptMemberInfo>();
        ArrayList<TypeScriptMemberInfo> numericIndexers = new ArrayList<TypeScriptMemberInfo>();
        TypeScriptImplementMemberUtil.collectPropertiesFunctionsAndIndexersForImplementation(members, (MultiMap<String, TypeScriptMemberInfo>)properties, (MultiMap<String, TypeScriptMemberInfo>)functions, stringIndexers, numericIndexers);
        PsiElement anchor = anchorNode.getPsi();
        if (jsClass instanceof JSClass) {
            anchor = TypeScriptImplementMemberUtil.addIndexerToClass(jsClass, anchor, numericIndexers, members, JSRecordType.IndexSignatureKind.NUMERIC);
            anchor = TypeScriptImplementMemberUtil.addIndexerToClass(jsClass, anchor, stringIndexers, members, JSRecordType.IndexSignatureKind.STRING);
        }
        for (Map.Entry entry : properties.entrySet()) {
            anchor = TypeScriptImplementMemberUtil.addPropertyToClass(jsClass, anchor, (String)entry.getKey(), (Collection)entry.getValue(), members, implementAsAbstract);
        }
        for (Map.Entry entry : functions.entrySet()) {
            anchor = TypeScriptImplementMemberUtil.addFunctionToClass(jsClass, (String)entry.getKey(), (Collection)entry.getValue(), members, anchor, implementAsAbstract);
        }
        TypeScriptImplementMemberUtil.fixRedundantTrailingComma(jsClass);
    }

    private static void fixRedundantTrailingComma(@NotNull PsiElement jsClass) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(17);
        }
        if (jsClass instanceof JSObjectLiteralExpression) {
            PsiElement child = jsClass.getLastChild();
            if (child != null) {
                child = child.getPrevSibling();
            }
            while (child != null && TreeUtil.isWhitespaceOrComment((ASTNode)child.getNode())) {
                child = child.getPrevSibling();
            }
            if (child == null || !",".equals(child.getText())) {
                return;
            }
            jsClass.deleteChildRange(child, child);
        }
    }

    private static void collectPropertiesFunctionsAndIndexersForImplementation(@NotNull Map<TypeScriptMemberInfo, JSClass> membersToImplement, @NotNull MultiMap<String, TypeScriptMemberInfo> properties, @NotNull MultiMap<String, TypeScriptMemberInfo> functions, @NotNull List<TypeScriptMemberInfo> stringIndexers, @NotNull List<TypeScriptMemberInfo> numericIndexers) {
        if (membersToImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(18);
        }
        if (properties == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(19);
        }
        if (functions == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(20);
        }
        if (stringIndexers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(21);
        }
        if (numericIndexers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(22);
        }
        for (TypeScriptMemberInfo member : membersToImplement.keySet()) {
            if (TypeScriptUtil.isTypeScriptMethod((PsiElement)member.getElement())) {
                functions.putValue((Object)JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)((Object)member.getElement()), false), (Object)member);
                continue;
            }
            if (TypeScriptUtil.isTypeScriptProperty((PsiElement)member.getElement()) || member.getElement() instanceof JSLocalImplicitElementImpl || member.getElement() instanceof JSProperty) {
                properties.putValue((Object)JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)((Object)member.getElement()), false), (Object)member);
                continue;
            }
            if (!(member.getElement() instanceof TypeScriptIndexSignature)) continue;
            JSType type = ((TypeScriptIndexSignature)member.getElement()).getMemberParameterType();
            if (type instanceof JSStringType) {
                stringIndexers.add(member);
                continue;
            }
            if (!(type instanceof JSNumberType)) continue;
            numericIndexers.add(member);
        }
    }

    private static PsiElement addIndexerToClass(@NotNull PsiElement jsClass, @Nullable PsiElement anchor, @NotNull List<TypeScriptMemberInfo> indexers, @NotNull Map<TypeScriptMemberInfo, JSClass> interfacesForImplement, @NotNull JSRecordType.IndexSignatureKind indexSignatureKind) {
        String text;
        PsiElement parameterNameElement;
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(23);
        }
        if (indexers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(24);
        }
        if (interfacesForImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(25);
        }
        if (indexSignatureKind == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(26);
        }
        if (indexers.size() == 0) {
            return anchor;
        }
        JSType returnType = TypeScriptImplementMemberUtil.getBestTypeAnnotationType(jsClass, indexers.stream().filter(i -> ((TypeScriptIndexSignature)i.getElement()).getType() != null).map(i -> TypeScriptImplementMemberUtil.fixTypeWithBaseTypes(jsClass, interfacesForImplement, i, ((TypeScriptIndexSignature)i.getElement()).getType().getJSType())).collect(Collectors.toList()));
        String paramName = "p";
        if (indexers.size() == 1 && (parameterNameElement = ((TypeScriptIndexSignature)indexers.get(0).getElement()).getParameterNameElement()) != null) {
            paramName = parameterNameElement.getText();
        }
        StringBuilder builder2 = new StringBuilder("[");
        builder2.append(paramName);
        builder2.append(": ");
        builder2.append(indexSignatureKind == JSRecordType.IndexSignatureKind.NUMERIC ? "number" : "string");
        builder2.append("]");
        if (returnType != null && !StringUtil.isEmpty((String)(text = BaseCreateFix.getTypeText(returnType, jsClass)))) {
            builder2.append(": ").append(text);
        }
        builder2.append(JSCodeStyleSettings.getSemicolon(jsClass));
        return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, builder2.toString());
    }

    public static PsiElement addPropertyToClass(@NotNull PsiElement jsClass, @Nullable PsiElement anchor, @Nullable String name, @NotNull Collection<TypeScriptMemberInfo> properties, @NotNull Map<TypeScriptMemberInfo, JSClass> interfacesForImplement, boolean implementAsAbstract) {
        String text;
        boolean shouldCreateGetter;
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(27);
        }
        if (properties == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(28);
        }
        if (interfacesForImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(29);
        }
        if (name == null) {
            return anchor;
        }
        StringBuilder builder2 = new StringBuilder();
        ArrayList<JSType> types = new ArrayList<JSType>();
        String attributes = "";
        boolean hasGetter = false;
        boolean hasNonGetter = false;
        for (TypeScriptMemberInfo propertyInfo : properties) {
            String attributeListText;
            JSType type = null;
            JSElement property = propertyInfo.getElement();
            if (property instanceof JSTypeOwner) {
                type = ((JSTypeOwner)((Object)property)).getJSType();
            }
            if (type != null) {
                type = TypeScriptImplementMemberUtil.fixTypeWithBaseTypes(jsClass, interfacesForImplement, propertyInfo, type);
                types.add(type);
            }
            if (property instanceof JSImplicitElement) {
                property = (JSElement)ObjectUtils.tryCast((Object)property.getContext(), JSElement.class);
            }
            boolean isGetter = property instanceof JSFunction && ((JSFunction)property).isGetProperty();
            hasGetter |= isGetter;
            hasNonGetter |= !isGetter;
            if (!(property instanceof JSAttributeListOwner) || StringUtil.isEmpty((String)(attributeListText = TypeScriptImplementMemberUtil.getAttributeListString(jsClass, (JSAttributeListOwner)property)))) continue;
            attributes = attributeListText;
        }
        if (!StringUtil.isEmpty((String)attributes)) {
            builder2.append(attributes);
            builder2.append(' ');
        }
        if (implementAsAbstract) {
            builder2.append("abstract");
            builder2.append(' ');
        }
        boolean bl = shouldCreateGetter = hasGetter && !hasNonGetter;
        if (shouldCreateGetter) {
            builder2.append("get ");
        }
        builder2.append(name);
        JSType type = TypeScriptImplementMemberUtil.getBestTypeAnnotationType(jsClass, types);
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type, jsClass);
        if (!shouldCreateGetter && expanded instanceof JSFunctionType) {
            TypeScriptImplementMemberUtil.appendFunctionByType(jsClass, name, implementAsAbstract, builder2, (JSFunctionType)expanded);
            return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, builder2.toString());
        }
        if (shouldCreateGetter) {
            builder2.append("()");
            text = TypeScriptImplementMemberUtil.getParameterTypeText(jsClass, type);
            if (!StringUtil.isEmpty((String)text)) {
                builder2.append(": ").append(text);
            }
            TypeScriptImplementMemberUtil.appendFunctionBody(jsClass, type, builder2, implementAsAbstract, name);
            return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, builder2.toString());
        }
        if (type != null) {
            String string = text = jsClass instanceof JSClass ? BaseCreateFix.getTypeText(type, jsClass) : JSRefactoringUtil.defaultValueOfType(expanded);
            if (!StringUtil.isEmpty((String)text)) {
                builder2.append(": ").append(text);
            } else if (jsClass instanceof JSObjectLiteralExpression) {
                builder2.append(": ").append("undefined");
            }
        } else if (jsClass instanceof JSObjectLiteralExpression) {
            builder2.append(": ").append("undefined");
        }
        builder2.append(jsClass instanceof JSClass ? JSCodeStyleSettings.getSemicolon(jsClass) : ",");
        return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, builder2.toString());
    }

    private static void appendFunctionByType(@NotNull PsiElement jsClass, @NotNull String name, boolean implementAsAbstract, StringBuilder builder2, JSFunctionType expanded) {
        int i;
        List<TypeScriptGenericDeclarationTypeImpl> declarations;
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(30);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(31);
        }
        if (expanded instanceof TypeScriptJSFunctionTypeImpl && !(declarations = ((TypeScriptJSFunctionTypeImpl)expanded).getGenericDeclarations()).isEmpty() && DialectDetector.hasFeature(jsClass, JSLanguageFeature.GENERICS)) {
            builder2.append("<");
            for (i = 0; i < declarations.size(); ++i) {
                if (i > 0) {
                    builder2.append(",");
                }
                builder2.append(declarations.get(i).getName());
            }
            builder2.append(">");
        }
        builder2.append("(");
        @NotNull List<JSParameterTypeDecorator> parameters = expanded.getParameters();
        i = -1;
        for (JSParameterTypeDecorator parameter : parameters) {
            JSType iterableType;
            JSType inferredType;
            if (++i > 0) {
                builder2.append(", ");
            }
            if ((inferredType = parameter.getInferredType()) instanceof JSRestTypeImpl && (iterableType = ((JSRestTypeImpl)inferredType).getIterableType()) instanceof JSTupleType) {
                for (JSType jsType : ((JSTupleType)iterableType).getTypes()) {
                    PsiElement sourceElement;
                    if (i > 0) {
                        builder2.append(", ");
                    }
                    PsiElement parent = (sourceElement = jsType.getSourceElement()) == null ? null : sourceElement.getParent();
                    builder2.append((String)ObjectUtils.coalesce((Object)(parent instanceof JSParameter ? ((JSParameter)parent).getName() : null), (Object)("p" + i)));
                    String text = TypeScriptImplementMemberUtil.getParameterTypeText(jsClass, jsType);
                    if (!StringUtil.isEmpty((String)text)) {
                        builder2.append(": ").append(text);
                    }
                    ++i;
                }
                break;
            }
            builder2.append((String)ObjectUtils.coalesce((Object)parameter.getName(), (Object)("p" + i)));
            String text = TypeScriptImplementMemberUtil.getParameterTypeText(jsClass, inferredType);
            if (StringUtil.isEmpty((String)text)) continue;
            builder2.append(": ").append(text);
        }
        builder2.append(")");
        JSType returnType = expanded.getReturnType();
        String text = TypeScriptImplementMemberUtil.getParameterTypeText(jsClass, returnType);
        if (!StringUtil.isEmpty((String)text)) {
            builder2.append(": ").append(text);
        }
        TypeScriptImplementMemberUtil.appendFunctionBody(jsClass, returnType, builder2, implementAsAbstract, name);
    }

    @Nullable
    private static String getParameterTypeText(@NotNull PsiElement jsClass, JSType inferredType) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(32);
        }
        return inferredType == null ? null : BaseCreateFix.getTypeText(inferredType, jsClass);
    }

    @NotNull
    private static String getAttributeListString(@NotNull PsiElement jsClass, @NotNull JSAttributeListOwner attributeListOwner) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(33);
        }
        if (attributeListOwner == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(34);
        }
        if (jsClass instanceof JSObjectLiteralExpression) {
            JSAttributeList list = attributeListOwner.getAttributeList();
            return list != null && list.hasModifier(JSAttributeList.ModifierType.ASYNC) ? "async " : "";
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(attributeListOwner);
        wrapper.overrideModifier(JSAttributeList.ModifierType.ABSTRACT, false);
        String string = wrapper.computeText(attributeListOwner, DialectDetector.dialectOfElement(jsClass), true);
        if (string == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    private static JSType fixTypeWithBaseTypes(@NotNull PsiElement jsClass, @NotNull Map<TypeScriptMemberInfo, JSClass> interfacesForImplement, TypeScriptMemberInfo property, JSType type) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(36);
        }
        if (interfacesForImplement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(37);
        }
        return BaseCreateMembersFix.fixGenericsByOwner(type, jsClass, interfacesForImplement.get(property));
    }

    @Nullable
    private static JSType getBestTypeAnnotationType(@NotNull PsiElement anchor, @NotNull List<JSType> types) {
        if (anchor == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(38);
        }
        if (types == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(39);
        }
        if ((types = TypeScriptImplementMemberUtil.optimizeTypeSet(types, anchor)).size() == 0) {
            return null;
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        return JSCompositeTypeFactory.createIntersectionType(types, JSTypeSourceFactory.createTypeSource(anchor, true));
    }

    @NotNull
    private static List<JSType> optimizeTypeSet(@NotNull List<JSType> types, @NotNull PsiElement contextElement) {
        if (types == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(40);
        }
        if (contextElement == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(41);
        }
        ArrayList<JSType> newTypes = new ArrayList<JSType>(types.size());
        ProcessingContext context2 = JSTypeComparingContextService.createProcessingContextWithCache(contextElement);
        for (JSType currentType : types) {
            if (currentType instanceof JSAnyType) {
                List list = ContainerUtil.createMaybeSingletonList((Object)currentType);
                if (list == null) {
                    TypeScriptImplementMemberUtil.$$$reportNull$$$0(42);
                }
                return list;
            }
            boolean add = true;
            ArrayList<JSType> toRemove = new ArrayList<JSType>();
            for (JSType resultedType : newTypes) {
                if (currentType.isDirectlyAssignableType(resultedType, context2)) {
                    add = false;
                    break;
                }
                if (!resultedType.isDirectlyAssignableType(currentType, context2)) continue;
                toRemove.add(resultedType);
            }
            newTypes.removeAll(toRemove);
            if (!add) continue;
            newTypes.add(currentType);
        }
        ArrayList<JSType> arrayList = newTypes;
        if (arrayList == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement addFunctionToClass(@NotNull PsiElement jsClass, @Nullable String name, @NotNull Collection<TypeScriptMemberInfo> functions, @NotNull Map<TypeScriptMemberInfo, JSClass> allMembers, @Nullable PsiElement anchor, boolean implementAsAbstract) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(44);
        }
        if (functions == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(45);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(46);
        }
        if (name == null) {
            return anchor;
        }
        assert (!functions.isEmpty());
        if (functions.size() == 1) {
            TypeScriptMemberInfo function = (TypeScriptMemberInfo)ContainerUtil.getFirstItem(functions);
            assert (function != null);
            return TypeScriptImplementMemberUtil.addDistinctFunctionToClass(function, name, jsClass, anchor, allMembers, implementAsAbstract);
        }
        if (functions.size() == 2) {
            boolean hasGetter = false;
            boolean hasSetter = false;
            for (TypeScriptMemberInfo function : functions) {
                JSElement element = function.getElement();
                if (!(element instanceof JSFunctionItem)) continue;
                if (((JSFunctionItem)element).isGetProperty()) {
                    hasGetter = true;
                }
                if (!((JSFunctionItem)element).isSetProperty()) continue;
                hasSetter = true;
            }
            if (hasGetter && hasSetter) {
                for (TypeScriptMemberInfo function : functions) {
                    anchor = TypeScriptImplementMemberUtil.addDistinctFunctionToClass(function, name, jsClass, anchor, allMembers, implementAsAbstract);
                }
                return anchor;
            }
        }
        return TypeScriptImplementMemberUtil.doAddFunctions(functions, name, jsClass, anchor, allMembers, implementAsAbstract);
    }

    private static PsiElement doAddFunctions(@NotNull Collection<TypeScriptMemberInfo> functions, @NotNull String name, @NotNull PsiElement jsClass, @Nullable PsiElement anchor, @NotNull Map<TypeScriptMemberInfo, JSClass> allMembers, boolean implementAsAbstract) {
        if (functions == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(47);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(48);
        }
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(49);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(50);
        }
        if (jsClass instanceof JSClass) {
            for (TypeScriptMemberInfo function : functions) {
                StringBuilder result2 = TypeScriptImplementMemberUtil.buildSignatureText(function, jsClass, name, allMembers, implementAsAbstract);
                if (result2 == null) continue;
                TypeScriptImplementMemberUtil.fixSemicolon(jsClass, result2);
                PsiElement element = JSChangeUtil.createClassMemberPsiFromTextWithContext(result2.toString(), jsClass, PsiElement.class);
                if (element == null) continue;
                anchor = jsClass.addAfter(element, anchor);
            }
        }
        if (TypeScriptPsiUtil.isAmbientDeclaration(jsClass) || implementAsAbstract) {
            return anchor;
        }
        Signature signatureInfo = TypeScriptImplementMemberUtil.getParametersAndReturnType(functions, jsClass, allMembers);
        StringBuilder signature = TypeScriptImplementMemberUtil.buildCommonSignature(name, jsClass, signatureInfo);
        TypeScriptImplementMemberUtil.appendFunctionBody(jsClass, signatureInfo.returnType, signature, false, name);
        if (jsClass instanceof JSObjectLiteralExpression) {
            signature.append(',');
        }
        return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, signature.toString());
    }

    public static StringBuilder buildCommonSignature(@NotNull String name, @NotNull PsiElement jsClass, Signature signatureInfo) {
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(51);
        }
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(52);
        }
        JSFunctionSignatureInfo info = new JSFunctionSignatureInfo(name);
        info.setScope(JSFunctionSignatureInfo.Scope.CLASS);
        JSAttributeList.AccessType type = signatureInfo.accessType;
        if (type != null) {
            info.setAccessType(type);
        }
        info.setReturnType(signatureInfo.returnTypeString);
        int count = 1;
        for (ParameterInfo param : signatureInfo.params) {
            Object parameterName = param.name;
            if (parameterName == null) {
                parameterName = "p" + count++;
            }
            if (param.isRest) {
                parameterName = "... " + (String)parameterName;
            } else if (param.isOptional) {
                parameterName = (String)parameterName + "?";
            }
            info.addParameterAndType((String)parameterName, param.type);
        }
        return TypeScriptImplementMemberUtil.buildSignatureText(jsClass, info);
    }

    private static PsiElement createAndAppendMember(PsiElement jsClass, PsiElement anchor, String signatureText) {
        PsiElement element;
        boolean isObjectLiteral = jsClass instanceof JSObjectLiteralExpression;
        PsiElement psiElement = element = isObjectLiteral ? JSChangeUtil.createObjectLiteralPropertyFromText(signatureText, jsClass) : JSChangeUtil.createClassMemberPsiFromTextWithContext(signatureText, jsClass, PsiElement.class);
        assert (element != null);
        PsiElement nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)anchor);
        if (JSRefactoringUtil.isEndRegionComment(nextElement)) {
            anchor = nextElement;
        }
        anchor = jsClass instanceof TypeScriptInterface ? ((TypeScriptInterface)jsClass).getBody().addAfter(element, anchor) : jsClass.addAfter(element, anchor);
        return anchor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Signature getParametersAndReturnType(@NotNull Collection<? extends TypeScriptMemberInfo> functions, @NotNull PsiElement jsResultClass, @NotNull Map<TypeScriptMemberInfo, JSClass> allMembers) {
        void var11_15;
        if (functions == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(53);
        }
        if (jsResultClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(54);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(55);
        }
        Signature result2 = new Signature();
        List<ParameterInfo> infos = result2.params;
        boolean isFirst = true;
        boolean hasTypeParametersList = false;
        int minParameterCount = Integer.MAX_VALUE;
        ArrayList<JSType> returnTypes = new ArrayList<JSType>();
        MultiMap paramTypes = MultiMap.createLinked();
        for (TypeScriptMemberInfo typeScriptMemberInfo : functions) {
            JSParameterListElement[] parameters;
            String newReturnType;
            JSClass surroundClass = allMembers.get(typeScriptMemberInfo);
            JSFunction function = (JSFunction)typeScriptMemberInfo.getElement();
            JSType returnType = function.getReturnType();
            JSType fixedType = TypeScriptImplementMemberUtil.fixTypeWithBaseTypes(jsResultClass, allMembers, typeScriptMemberInfo, returnType);
            if (fixedType != null) {
                returnTypes.add(fixedType);
            }
            if (isFirst) {
                result2.returnTypeString = BaseCreateMembersFix.getProcessedType(returnType, jsResultClass, surroundClass);
                result2.returnType = returnType;
                isFirst = false;
            } else if (result2.returnType != null && !StringUtil.equals((CharSequence)(newReturnType = BaseCreateMembersFix.getProcessedType(returnType, jsResultClass, surroundClass)), (CharSequence)result2.returnTypeString)) {
                result2.returnTypeString = "any";
                result2.returnType = null;
            }
            JSAttributeList.AccessType accessType = function.getAccessType();
            if (result2.accessType != accessType) {
                if (result2.accessType == null) {
                    result2.accessType = accessType;
                } else if (result2.accessType == JSAttributeList.AccessType.PROTECTED) {
                    result2.accessType = JSAttributeList.AccessType.PUBLIC;
                }
            }
            if (!hasTypeParametersList && function instanceof TypeScriptFunction) {
                boolean bl = hasTypeParametersList = ((TypeScriptFunction)function).getTypeParameterList() != null;
            }
            if (minParameterCount > (parameters = function.getParameters()).length) {
                minParameterCount = parameters.length;
            }
            for (int i = 0; i < parameters.length; ++i) {
                String type;
                JSParameterListElement parameter = parameters[i];
                ParameterInfo info = infos.size() > i ? infos.get(i) : null;
                JSType parameterType = TypeScriptImplementMemberUtil.getParameterType(parameter);
                JSType fixedParamType = TypeScriptImplementMemberUtil.fixTypeWithBaseTypes(jsResultClass, allMembers, typeScriptMemberInfo, parameterType);
                if (fixedParamType != null && parameter.isRest()) {
                    fixedParamType = JSTypeUtils.getIterableComponentType(fixedParamType, false, true, true);
                }
                if (fixedParamType != null) {
                    paramTypes.putValue((Object)i, (Object)fixedParamType);
                }
                if (info == null) {
                    info = new ParameterInfo();
                    type = BaseCreateMembersFix.getProcessedType(parameterType, jsResultClass, surroundClass);
                    info.name = parameter.getName();
                    info.type = type;
                    info.isOptional = parameter.isOptional();
                    info.isRest = parameter.isRest();
                    infos.add(info);
                    continue;
                }
                type = BaseCreateMembersFix.getProcessedType(parameterType, jsResultClass, surroundClass);
                if (!StringUtil.equals((CharSequence)type, (CharSequence)info.type)) {
                    info.type = null;
                }
                if (info.isOptional != parameter.isOptional()) {
                    info.isOptional = true;
                }
                if (info.isRest == parameter.isRest()) continue;
                info.isRest = true;
            }
        }
        if (result2.returnType == null && returnTypes.size() > 1 && jsResultClass instanceof JSClass) {
            JSType union = TypeScriptImplementMemberUtil.createCompositeType(jsResultClass, returnTypes);
            boolean bl = JSTypeUtils.hasForeignGenericParameter(union);
            result2.returnTypeString = bl ? "any" : union.getTypeText(JSType.TypeTextFormat.CODE);
            result2.returnType = bl ? null : union;
        }
        int restIndex = -1;
        boolean bl = false;
        while (var11_15 < infos.size()) {
            void parameterNumber = var11_15 + true;
            ParameterInfo info = infos.get((int)var11_15);
            if (paramTypes.containsKey((Object)((int)var11_15))) {
                Collection types = paramTypes.get((Object)((int)var11_15));
                if (hasTypeParametersList && types.stream().anyMatch(t -> JSTypeUtils.hasForeignGenericParameter(t))) {
                    info.type = null;
                } else if (info.type == null) {
                    info.type = TypeScriptImplementMemberUtil.createCompositeTypeText(jsResultClass, (List)types);
                    if (info.isRest) {
                        info.type = TypeScriptImplementMemberUtil.wrapTypeDescAsRest(info.type);
                    }
                }
            }
            if (parameterNumber > minParameterCount) {
                info.isOptional = true;
            }
            if (info.isRest && parameterNumber != infos.size()) {
                info.type = null;
                restIndex = var11_15;
                break;
            }
            ++var11_15;
        }
        if (restIndex != -1) {
            ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>(restIndex);
            for (int i = 0; i < restIndex; ++i) {
                arrayList.add(infos.get(i));
            }
            ArrayList<JSType> allTypesForRest = new ArrayList<JSType>();
            for (int i = restIndex; i < infos.size(); ++i) {
                if (!paramTypes.containsKey((Object)i)) continue;
                allTypesForRest.addAll(paramTypes.get((Object)i));
            }
            ParameterInfo rest = infos.get(restIndex);
            rest.type = TypeScriptImplementMemberUtil.wrapTypeDescAsRest(TypeScriptImplementMemberUtil.createCompositeTypeText(jsResultClass, allTypesForRest));
            arrayList.add(rest);
            result2.params = arrayList;
        }
        Signature signature = result2;
        if (signature == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(56);
        }
        return signature;
    }

    @Nullable
    @Contract(value="null -> null")
    private static String wrapTypeDescAsRest(@Nullable String typeDesc) {
        if (typeDesc == null) {
            return null;
        }
        return "(" + typeDesc + ")[]";
    }

    @NotNull
    private static String createCompositeTypeText(@Nullable PsiElement jsResultClass, @NotNull List<JSType> types) {
        if (types == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(57);
        }
        JSType union = TypeScriptImplementMemberUtil.createCompositeType(jsResultClass, types);
        String string = union.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NotNull
    private static JSType createCompositeType(@Nullable PsiElement jsResultClass, @NotNull List<JSType> types) {
        if (types == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(59);
        }
        JSType union = JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource(jsResultClass, true), types);
        JSType jSType = JSCompositeTypeFactory.optimizeTypeIfComposite(union);
        if (jSType == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(60);
        }
        return jSType;
    }

    @Nullable
    public static PsiElement addDistinctFunctionToClass(@NotNull TypeScriptMemberInfo function, @NotNull String name, @NotNull PsiElement jsClass, @Nullable PsiElement anchor, @NotNull Map<TypeScriptMemberInfo, JSClass> allMembers, boolean implementAsAbstract) {
        StringBuilder result2;
        if (function == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(61);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(62);
        }
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(63);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(64);
        }
        if ((result2 = TypeScriptImplementMemberUtil.buildSignatureText(function, jsClass, name, allMembers, implementAsAbstract)) == null) {
            return anchor;
        }
        TypeScriptImplementMemberUtil.appendFunctionBody(jsClass, ((JSFunction)function.getElement()).getReturnType(), result2, implementAsAbstract, name);
        if (jsClass instanceof JSObjectLiteralExpression) {
            result2.append(',');
        }
        return TypeScriptImplementMemberUtil.createAndAppendMember(jsClass, anchor, result2.toString());
    }

    @Nullable
    public static StringBuilder buildSignatureText(@NotNull TypeScriptMemberInfo function, @NotNull PsiElement jsResultClass, @NotNull String name, @NotNull Map<TypeScriptMemberInfo, JSClass> allMembers, boolean implementAsAbstract) {
        if (function == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(65);
        }
        if (jsResultClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(66);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(67);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(68);
        }
        JSFunctionSignatureInfo info = TypeScriptImplementMemberUtil.buildFunctionInfo(function, jsResultClass, name, allMembers, implementAsAbstract);
        return TypeScriptImplementMemberUtil.buildSignatureText(jsResultClass, info);
    }

    public static StringBuilder buildSignatureText(@NotNull PsiElement jsResultClass, JSFunctionSignatureInfo info) {
        if (jsResultClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(69);
        }
        return TS_SIGNATURE_GENERATOR.getSignature(info, jsResultClass);
    }

    @NotNull
    public static JSFunctionSignatureInfo buildFunctionInfo(@NotNull TypeScriptMemberInfo functionInfo, @NotNull PsiElement jsResultClass, @NotNull String name, @NotNull Map<TypeScriptMemberInfo, JSClass> allMembers, boolean implementAsAbstract) {
        String generics;
        TypeScriptFunction typeScriptFunction;
        TypeScriptTypeParameterList list;
        JSParameterListElement[] parameters;
        if (functionInfo == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(70);
        }
        if (jsResultClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(71);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(72);
        }
        if (allMembers == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(73);
        }
        JSClass interfaceForImplement = allMembers.get(functionInfo);
        JSFunction function = (JSFunction)functionInfo.getElement();
        JSFunctionSignatureInfo info = new JSFunctionSignatureInfo(name);
        if (implementAsAbstract) {
            info.setAbstract(true);
        }
        info.setScope(JSFunctionSignatureInfo.Scope.CLASS);
        info.setAccessType(function.getAccessType());
        info.setIsGetter(function.isGetProperty());
        info.setIsSetter(function.isSetProperty());
        info.setIsGenerator(function.isGenerator());
        info.setAsync(JSPsiImplUtils.hasModifier(function, JSAttributeList.ModifierType.ASYNC));
        for (JSParameterListElement parameter : parameters = function.getParameters()) {
            Object parameterName = parameter.getName();
            if (parameterName == null) continue;
            if (parameter.isRest()) {
                parameterName = "... " + (String)parameterName;
            } else if (parameter.isOptional()) {
                parameterName = (String)parameterName + "?";
            }
            info.addParameterAndType((String)parameterName, BaseCreateMembersFix.getProcessedType(TypeScriptImplementMemberUtil.getParameterType(parameter), jsResultClass, interfaceForImplement));
        }
        if (function instanceof TypeScriptFunction && (list = (typeScriptFunction = (TypeScriptFunction)function).getTypeParameterList()) != null && !StringUtil.isEmpty((String)(generics = TypeScriptUtil.buildParameterTypeListStringWithApplyingGenerics(typeScriptFunction, jsResultClass)))) {
            info.setTypeParameterList(generics);
        }
        JSType returnType = function.getReturnType();
        info.setReturnType(BaseCreateMembersFix.getProcessedType(returnType, jsResultClass, interfaceForImplement));
        JSFunctionSignatureInfo jSFunctionSignatureInfo = info;
        if (jSFunctionSignatureInfo == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(74);
        }
        return jSFunctionSignatureInfo;
    }

    @Nullable
    private static JSType getParameterType(@NotNull JSParameterItem parameter) {
        if (parameter == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(75);
        }
        if (parameter.isRest() && parameter instanceof StubBasedPsiElementBase) {
            return TypeScriptPsiUtil.getTypeFromDeclaration((StubBasedPsiElementBase)parameter);
        }
        return parameter.getSimpleType();
    }

    private static void appendFunctionBody(@NotNull PsiElement jsClass, @Nullable JSType returnType, @NotNull StringBuilder builder2, boolean implementAsAbstract, String name) {
        if (jsClass == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(76);
        }
        if (builder2 == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(77);
        }
        if (TypeScriptPsiUtil.isAmbientDeclaration(jsClass) || implementAsAbstract || jsClass instanceof TypeScriptInterface) {
            TypeScriptImplementMemberUtil.fixSemicolon(jsClass, builder2);
            return;
        }
        builder2.append("{");
        TypeScriptImplementMemberUtil.appendDefaultMethodBody(jsClass, returnType, builder2, name);
        builder2.append("\n}");
    }

    public static void appendDefaultMethodBody(@NotNull PsiElement contextNode, @Nullable JSType returnType, @NotNull StringBuilder builder2, @NotNull String name) {
        if (contextNode == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(78);
        }
        if (builder2 == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(79);
        }
        if (name == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(80);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)contextNode.getProject());
        FileTemplate template = fileTemplateManager.getCodeTemplate(ourImplementedMethodBodyTemplate);
        Properties properties = fileTemplateManager.getDefaultProperties();
        properties.setProperty("RETURN_TYPE", returnType == null ? "any" : BaseCreateFix.getTypeText(returnType, contextNode));
        properties.setProperty("DEFAULT_RETURN_VALUE", JSRefactoringUtil.defaultValueOfType(returnType));
        properties.setProperty("METHOD_NAME", name);
        properties.setProperty("SEMICOLON", JSCodeStyleSettings.getSemicolon(contextNode));
        builder2.append(TypeScriptImplementMemberUtil.getBodyTextFromTemplate(template, properties));
    }

    @NotNull
    public static String getBodyTextFromTemplate(@NotNull FileTemplate template, @NotNull Properties properties) {
        String bodyText;
        if (template == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(81);
        }
        if (properties == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(82);
        }
        try {
            bodyText = template.getText(properties);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Failed to parse file template", (Throwable)e);
        }
        String string = bodyText;
        if (string == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(83);
        }
        return string;
    }

    private static void fixSemicolon(@NotNull PsiElement context2, @NotNull StringBuilder builder2) {
        if (context2 == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(84);
        }
        if (builder2 == null) {
            TypeScriptImplementMemberUtil.$$$reportNull$$$0(85);
        }
        builder2.append(JSCodeStyleSettings.getSemicolon(context2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 35, 42, 43, 56, 58, 60, 74, 83 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 35: 
            case 42: 
            case 43: 
            case 56: 
            case 58: 
            case 60: 
            case 74: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMemberUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImplement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 23: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 44: 
            case 49: 
            case 52: 
            case 63: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorNode";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToImplement";
                break;
            }
            case 19: 
            case 28: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 20: 
            case 45: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringIndexers";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numericIndexers";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexers";
                break;
            }
            case 25: 
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfacesForImplement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSignatureKind";
                break;
            }
            case 31: 
            case 48: 
            case 51: 
            case 62: 
            case 67: 
            case 72: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeListOwner";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 39: 
            case 40: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 46: 
            case 50: 
            case 55: 
            case 64: 
            case 68: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allMembers";
                break;
            }
            case 54: 
            case 66: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsResultClass";
                break;
            }
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionInfo";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 77: 
            case 79: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextNode";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementMemberUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnimplementedMembersForLiteral";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeListString";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeTypeSet";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersAndReturnType";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeTypeText";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeType";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionInfo";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyTextFromTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "implementAllMissingMembersForMemberOwner";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUnimplementedMembersForLiteral";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 35: 
            case 42: 
            case 43: 
            case 56: 
            case 58: 
            case 60: 
            case 74: 
            case 83: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addUnimplementedMemberCandidates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "implementMembersForMemberOwner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fixAnchorNode";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doImplementMembers";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnMemberList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fixRedundantTrailingComma";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertiesFunctionsAndIndexersForImplementation";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addIndexerToClass";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyToClass";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionByType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeText";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeListString";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "fixTypeWithBaseTypes";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getBestTypeAnnotationType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeSet";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionToClass";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "doAddFunctions";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "buildCommonSignature";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getParametersAndReturnType";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeTypeText";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeType";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addDistinctFunctionToClass";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "buildSignatureText";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionInfo";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionBody";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "appendDefaultMethodBody";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getBodyTextFromTemplate";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "fixSemicolon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 35, 42, 43, 56, 58, 60, 74, 83 -> new IllegalStateException(string);
        };
    }

    public static class Signature {
        public List<ParameterInfo> params = new ArrayList<ParameterInfo>();
        public String returnTypeString;
        public JSType returnType;
        public JSAttributeList.AccessType accessType = null;
    }

    public static class ParameterInfo {
        public String name;
        public String type;
        public boolean isOptional;
        public boolean isRest;
    }
}

