/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingStateHolder;", "", "<init>", "()V", "myHolder", "", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingStateHolder$CalcState;", "value", "", "isInitialized", "()Z", "getState", "file", "saveState", "", "state", "reset", "CalcState", "intellij.javascript.impl"})
public final class JSLanguageServiceHighlightingStateHolder {
    @NotNull
    private final Map<PsiFile, CalcState> myHolder;
    private volatile boolean isInitialized;

    public JSLanguageServiceHighlightingStateHolder() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.myHolder = concurrentMap;
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    @Nullable
    public final CalcState getState(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.myHolder.get(file);
    }

    public final void saveState(@NotNull PsiFile file, @Nullable CalcState state) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.isInitialized = true;
        if (state == null) {
            this.reset(file);
            return;
        }
        this.myHolder.put(file, state);
    }

    public final void reset(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myHolder.remove(file);
    }

    public final void reset() {
        this.myHolder.clear();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingStateHolder$CalcState;", "Ljava/lang/Record;", "future", "Ljava/util/concurrent/Future;", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "docTimeStamp", "", "<init>", "(Ljava/util/concurrent/Future;J)V", "()Ljava/util/concurrent/Future;", "()J", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.javascript.impl"})
    public static final class CalcState
    extends Record {
        @NotNull
        private final Future<List<JSAnnotationError>> future;
        private final long docTimeStamp;

        public CalcState(@NotNull Future<List<JSAnnotationError>> future, long docTimeStamp) {
            Intrinsics.checkNotNullParameter(future, (String)"future");
            this.future = future;
            this.docTimeStamp = docTimeStamp;
        }

        @NotNull
        public final Future<List<JSAnnotationError>> future() {
            return this.future;
        }

        public final long docTimeStamp() {
            return this.docTimeStamp;
        }

        @NotNull
        public final Future<List<JSAnnotationError>> component1() {
            return this.future;
        }

        public final long component2() {
            return this.docTimeStamp;
        }

        @NotNull
        public final CalcState copy(@NotNull Future<List<JSAnnotationError>> future, long docTimeStamp) {
            Intrinsics.checkNotNullParameter(future, (String)"future");
            return new CalcState(future, docTimeStamp);
        }

        public static /* synthetic */ CalcState copy$default(CalcState calcState, Future future, long l, int n, Object object) {
            if ((n & 1) != 0) {
                future = calcState.future;
            }
            if ((n & 2) != 0) {
                l = calcState.docTimeStamp;
            }
            return calcState.copy(future, l);
        }

        @Override
        @NotNull
        public String toString() {
            return "CalcState(future=" + this.future + ", docTimeStamp=" + this.docTimeStamp + ")";
        }

        @Override
        public int hashCode() {
            int result2 = this.future.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.docTimeStamp);
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CalcState)) {
                return false;
            }
            CalcState calcState = (CalcState)other;
            if (!Intrinsics.areEqual(this.future, calcState.future)) {
                return false;
            }
            return this.docTimeStamp == calcState.docTimeStamp;
        }
    }
}

