/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceAnnotationProvider;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingStateHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB;\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "project", "Lcom/intellij/openapi/project/Project;", "myLanguageService", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "myFile", "Lcom/intellij/psi/PsiFile;", "myFutureState", "Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingStateHolder;", "document", "Lcom/intellij/openapi/editor/Document;", "myServiceName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/service/JSLanguageService;Lcom/intellij/psi/PsiFile;Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingStateHolder;Lcom/intellij/openapi/editor/Document;Ljava/lang/String;)V", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doApplyInformationToEditor", "awaitResults", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "setResults", "annotationErrors", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "needProcessHighlight", "", "Companion", "intellij.javascript.impl"})
public final class JSLanguageServiceHighlightingPass
extends TextEditorHighlightingPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final JSLanguageService myLanguageService;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final JSLanguageServiceHighlightingStateHolder myFutureState;
    @NotNull
    private final String myServiceName;

    public JSLanguageServiceHighlightingPass(@NotNull Project project, @Nullable JSLanguageService myLanguageService, @NotNull PsiFile myFile, @NotNull JSLanguageServiceHighlightingStateHolder myFutureState, @NotNull Document document, @NotNull String myServiceName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)myFutureState, (String)"myFutureState");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)myServiceName, (String)"myServiceName");
        super(project, document, false);
        this.myLanguageService = myLanguageService;
        this.myFile = myFile;
        this.myFutureState = myFutureState;
        this.myServiceName = myServiceName;
    }

    @RequiresReadLock
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        List<HighlightInfo> result2;
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        List<HighlightInfo> list = result2 = this.needProcessHighlight() ? this.awaitResults(progress) : this.setResults(ContainerUtil.emptyList());
        if (result2 != null) {
            JSLanguageServiceAnnotationProvider.INSTANCE.updateWolfTheProblemSolver(this.myFile, this.myServiceName, result2);
            BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.myFile, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), (Collection)result2, (int)this.getId());
        }
    }

    public void doApplyInformationToEditor() {
    }

    private final List<HighlightInfo> awaitResults(ProgressIndicator progress) {
        Future future;
        long docTimeStamp = this.myDocument.getModificationStamp();
        JSLanguageServiceHighlightingStateHolder.CalcState runningState = this.myFutureState.getState(this.myFile);
        if (runningState != null) {
            future = runningState.future();
            if (future.isDone()) {
                List<HighlightInfo> result2 = this.setResults(JSLanguageServiceHighlightingPass.Companion.awaitResults(future, progress));
                if (docTimeStamp == runningState.docTimeStamp() && result2 != null) {
                    return result2;
                }
            } else {
                if (docTimeStamp == runningState.docTimeStamp()) {
                    return this.setResults(JSLanguageServiceHighlightingPass.Companion.awaitResults(future, progress));
                }
                this.myFutureState.reset(this.myFile);
                future.cancel(false);
            }
        }
        JSLanguageService jSLanguageService = this.myLanguageService;
        Intrinsics.checkNotNull((Object)jSLanguageService);
        future = jSLanguageService.highlight(this.myFile);
        if (future == null) {
            return CollectionsKt.emptyList();
        }
        this.myFutureState.saveState(this.myFile, new JSLanguageServiceHighlightingStateHolder.CalcState(future, docTimeStamp));
        return this.setResults(JSLanguageServiceHighlightingPass.Companion.awaitResults(future, progress));
    }

    private final List<HighlightInfo> setResults(List<? extends JSAnnotationError> annotationErrors) {
        if (annotationErrors == null) {
            return null;
        }
        List<HighlightInfo> result2 = annotationErrors.isEmpty() || this.myLanguageService == null ? CollectionsKt.emptyList() : JSLanguageServiceAnnotationProvider.INSTANCE.convertToHighlightingInfos(this.myFile, annotationErrors, this.myLanguageService);
        this.myFutureState.reset(this.myFile);
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needProcessHighlight() {
        if (this.myLanguageService == null) return false;
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        if (!this.myLanguageService.isAcceptable(virtualFile)) return false;
        if (!this.myLanguageService.canHighlight(this.myFile)) return false;
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0018\u0010\u0007\u001a\u0014\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPass$Companion;", "", "<init>", "()V", "awaitResults", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "future", "Ljava/util/concurrent/Future;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final List<JSAnnotationError> awaitResults(Future<? extends List<? extends JSAnnotationError>> future, ProgressIndicator progress) {
            return JSLanguageServiceUtil.awaitFuture(future, JSLanguageServiceUtil.getTimeout(), 5L, progress);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

