/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u0013\u001a\u00020\u0014J>\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider;", "", "<init>", "()V", "JS_SERVICE_SOURCE", "", "Lorg/jetbrains/annotations/NonNls;", "updateWolfTheProblemSolver", "", "file", "Lcom/intellij/psi/PsiFile;", "name", "holder", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "getServiceName", "convertToHighlightingInfos", "annotationResult", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "languageService", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "registerAnnotation", "result", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "isAnnotationAtEndOfLine", "", "annotation", "Lcom/intellij/openapi/util/Segment;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceAnnotationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceAnnotationProvider.kt\ncom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1755#2,3:162\n1863#2,2:165\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceAnnotationProvider.kt\ncom/intellij/lang/javascript/service/highlighting/JSLanguageServiceAnnotationProvider\n*L\n42#1:162,3\n145#1:165,2\n*E\n"})
public final class JSLanguageServiceAnnotationProvider {
    @NotNull
    public static final JSLanguageServiceAnnotationProvider INSTANCE = new JSLanguageServiceAnnotationProvider();
    @NotNull
    public static final String JS_SERVICE_SOURCE = "JS Language Service Source";

    private JSLanguageServiceAnnotationProvider() {
    }

    public final void updateWolfTheProblemSolver(@NotNull PsiFile file, @NotNull String name, @NotNull List<? extends HighlightInfo> holder) {
        boolean hasErrorResults;
        VirtualFile virtualFile;
        Project project;
        block6: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(holder, (String)"holder");
            Project project2 = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            project = project2;
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            virtualFile = file.getVirtualFile();
            if (document == null) {
                WolfTheProblemSolver.getInstance((Project)project).clearProblemsFromExternalSource(virtualFile, (Object)this.getServiceName(name));
                return;
            }
            Iterable $this$any$iv = holder;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HighlightInfo it = (HighlightInfo)element$iv;
                    boolean bl = false;
                    if (!(it.getSeverity() == HighlightSeverity.ERROR)) continue;
                    v1 = true;
                    break block6;
                }
                v1 = hasErrorResults = false;
            }
        }
        if (hasErrorResults) {
            WolfTheProblemSolver.getInstance((Project)project).reportProblemsFromExternalSource(virtualFile, (Object)this.getServiceName(name));
        } else {
            WolfTheProblemSolver.getInstance((Project)project).clearProblemsFromExternalSource(virtualFile, (Object)this.getServiceName(name));
        }
    }

    private final String getServiceName(String name) {
        return "JS Language Service Source " + name;
    }

    @NotNull
    public final List<HighlightInfo> convertToHighlightingInfos(@NotNull PsiFile file, @NotNull List<? extends JSAnnotationError> annotationResult, @NotNull JSLanguageService languageService) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(annotationResult, (String)"annotationResult");
        Intrinsics.checkNotNullParameter((Object)languageService, (String)"languageService");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return CollectionsKt.emptyList();
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String simplePath = string;
        String canonicalPath = virtualFile.getCanonicalPath();
        VirtualFileSystem virtualFileSystem = virtualFile.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem system = virtualFileSystem;
        Path path2 = system.getNioPath(virtualFile);
        if (path2 == null) {
            return CollectionsKt.emptyList();
        }
        List holder = new ArrayList(annotationResult.size());
        String ioFilePath = LocalFilePath.Companion.asLocalFilePath(path2);
        for (JSAnnotationError jSAnnotationError : annotationResult) {
            String annotationFilePath = jSAnnotationError.getAbsoluteFilePath();
            if (StringUtil.isEmpty((String)annotationFilePath) || !FileUtil.pathsEqual((String)annotationFilePath, (String)simplePath) && !FileUtil.pathsEqual((String)annotationFilePath, (String)canonicalPath) && !FileUtil.pathsEqual((String)annotationFilePath, (String)ioFilePath)) continue;
            try {
                HighlightInfo annotation;
                JSLanguageServiceUtil.PsiElementInfo info;
                if (JSLanguageServiceUtil.getElementInfo(file, document, jSAnnotationError) == null) continue;
                PsiElement element = info.getElement();
                TextRange range = info.getRange();
                if (element == null && range == null || (annotation = this.registerAnnotation(file, jSAnnotationError, element, range, languageService, document)) == null) continue;
                holder.add(annotation);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return holder;
    }

    private final HighlightInfo registerAnnotation(PsiFile file, JSAnnotationError result2, PsiElement element, TextRange range, JSLanguageService languageService, Document document) {
        ProblemHighlightType problemHighlightType;
        TextRange actualRange;
        boolean bl;
        boolean bl2 = bl = element != null || range != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = result2.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
        String message = string;
        TextRange textRange = range;
        if (textRange == null) {
            PsiElement psiElement = element;
            Intrinsics.checkNotNull((Object)psiElement);
            textRange = actualRange = psiElement.getTextRange();
        }
        if ((problemHighlightType = result2.getHighlightType()) == null) {
            if (result2.getSeverity() == HighlightSeverity.ERROR) {
                problemHighlightType = ProblemHighlightType.GENERIC_ERROR;
            } else {
                ProblemHighlightType problemHighlightType2 = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)result2.getSeverity());
                problemHighlightType = problemHighlightType2;
                Intrinsics.checkNotNullExpressionValue((Object)problemHighlightType2, (String)"convertSeverityToProblemHighlight(...)");
            }
        }
        ProblemHighlightType type = problemHighlightType;
        HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)type, (HighlightSeverity)result2.getSeverity(), (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)file.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType, (String)"getHighlightInfoType(...)");
        HighlightInfoType highlightInfoType2 = highlightInfoType;
        String string2 = result2.getTooltipText();
        if (string2 == null) {
            string2 = message;
        }
        String tooltip = string2;
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType2).range(actualRange).description(message);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"description(...)");
        HighlightInfo.Builder builder3 = builder2;
        builder3.escapedToolTip(tooltip);
        Intrinsics.checkNotNull((Object)actualRange);
        if (this.isAnnotationAtEndOfLine((Segment)actualRange, document)) {
            builder3.endOfLine();
        }
        Collection<IntentionAction> fixes = languageService.getServiceFixes(file, element, result2);
        Iterable $this$forEach$iv = fixes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntentionAction it = (IntentionAction)element$iv;
            boolean bl3 = false;
            builder3.registerFix(it, null, null, null, null);
        }
        return builder3.create();
    }

    private final boolean isAnnotationAtEndOfLine(Segment annotation, Document document) {
        int startOffset = annotation.getStartOffset();
        int endOffset = annotation.getEndOffset();
        if (startOffset >= document.getTextLength()) {
            return true;
        }
        return document.getImmutableCharSequence().charAt(startOffset) == '\n' && (startOffset == endOffset || endOffset == startOffset + 1);
    }
}

