/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.util.ThrowableRunnable;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLanguageServiceTracerUtil {
    private static final boolean CREATE_SERVER_LIFECYCLE_SPAN = "true".equals(System.getProperty("idea.diagnostic.opentelemetry.js-server-lifecycle-span"));
    public static final IJTracer JS_LANG_SERVICE_TRACER = TelemetryManager.getInstance().getTracer(new com.intellij.platform.diagnostic.telemetry.Scope("JS Language Service", null, true));

    @Nullable
    public static Span createServerLifecycleSpanIfNeeded(@NotNull Class<?> clazz, @NotNull String name) {
        if (clazz == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(1);
        }
        return CREATE_SERVER_LIFECYCLE_SPAN ? JSLanguageServiceTracerUtil.traceSpanBuilder(clazz, name).setNoParent().startSpan() : null;
    }

    public static SpanBuilder traceSpanBuilder(@NotNull Class<?> clazz, @NotNull String name) {
        if (clazz == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(3);
        }
        String className = clazz.getSimpleName();
        className = StringUtil.trimEnd((String)className, (String)"Impl");
        return JS_LANG_SERVICE_TRACER.spanBuilder(className + ": " + name);
    }

    public static SpanBuilder traceSpanBuilder(@NotNull Class<?> clazz, @NotNull String name, @Nullable Span parent) {
        if (clazz == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(5);
        }
        SpanBuilder result2 = JSLanguageServiceTracerUtil.traceSpanBuilder(clazz, name);
        if (parent != null) {
            result2 = result2.setParent(Context.current().with((ImplicitContextKeyed)parent));
        }
        return result2;
    }

    public static <E extends Throwable> void withTraceSpan(@NotNull Class<?> clazz, @NotNull String name, @NotNull ThrowableRunnable<E> operation) throws E {
        if (clazz == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(7);
        }
        if (operation == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(8);
        }
        JSLanguageServiceTracerUtil.withTraceSpan(clazz, name, null, operation);
    }

    public static <E extends Throwable> void withTraceSpan(@NotNull Class<?> clazz, @NotNull String name, @Nullable Span parent, @NotNull ThrowableRunnable<E> operation) throws E {
        if (clazz == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(10);
        }
        if (operation == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(11);
        }
        SpanBuilder spanBuilder = JSLanguageServiceTracerUtil.traceSpanBuilder(clazz, name, parent);
        TraceUtil.runWithSpanThrows((SpanBuilder)spanBuilder, span -> operation.run());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R, T extends CompletableFuture<R>, E extends Throwable> T futureWithTraceSpan(@NotNull Class<?> clazz, @NotNull String name, @Nullable Span parent, @NotNull ThrowableComputable<T, E> operation) throws E {
        if (clazz == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(12);
        }
        if (name == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(13);
        }
        if (operation == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(14);
        }
        SpanBuilder builder2 = JSLanguageServiceTracerUtil.traceSpanBuilder(clazz, name, parent);
        Span span = builder2.startSpan();
        try (Scope ignored = span.makeCurrent();){
            CompletableFuture result2 = (CompletableFuture)operation.compute();
            result2.whenComplete((r, t) -> span.end());
            CompletableFuture completableFuture = result2;
            return (T)completableFuture;
        }
        catch (Throwable t2) {
            span.end();
            throw t2;
        }
    }

    public static <T, E extends Throwable> T withTraceSpan(@NotNull Class<?> clazz, @NotNull String name, @NotNull ThrowableComputable<T, E> operation) throws E {
        if (clazz == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(15);
        }
        if (name == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(16);
        }
        if (operation == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(17);
        }
        return JSLanguageServiceTracerUtil.withTraceSpan(clazz, name, null, operation);
    }

    public static <T, E extends Throwable> T withTraceSpan(@NotNull Class<?> clazz, @NotNull String name, @Nullable Span parent, @NotNull ThrowableComputable<T, E> operation) throws E {
        if (clazz == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(18);
        }
        if (name == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(19);
        }
        if (operation == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(20);
        }
        SpanBuilder spanBuilder = JSLanguageServiceTracerUtil.traceSpanBuilder(clazz, name, parent);
        Ref result2 = new Ref();
        TraceUtil.runWithSpanThrows((SpanBuilder)spanBuilder, span -> result2.set(operation.compute()));
        return (T)result2.get();
    }

    @NotNull
    public static <T> CompletableFuture<T> supplyAsyncAndEndSpanOnComplete(@NotNull Span actionSpan, @NotNull Supplier<T> supplier, @NotNull Executor executor) {
        CompletableFuture<Object> completableFuture;
        if (actionSpan == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(21);
        }
        if (supplier == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(22);
        }
        if (executor == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(23);
        }
        try {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> {
                try (Scope ignore = actionSpan.makeCurrent();){
                    Object t = supplier.get();
                    return t;
                }
            }, executor);
            future.whenComplete((r, t) -> actionSpan.end());
            completableFuture = future;
        }
        catch (Throwable t2) {
            actionSpan.end();
            throw t2;
        }
        if (completableFuture == null) {
            JSLanguageServiceTracerUtil.$$$reportNull$$$0(24);
        }
        return completableFuture;
    }

    private JSLanguageServiceTracerUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionSpan";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceTracerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceTracerUtil";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "supplyAsyncAndEndSpanOnComplete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createServerLifecycleSpanIfNeeded";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "traceSpanBuilder";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withTraceSpan";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "futureWithTraceSpan";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "supplyAsyncAndEndSpanOnComplete";
                break;
            }
            case 24: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24 -> new IllegalStateException(string);
        };
    }
}

