/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutorImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceTracerUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceTracerUtilKt;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceUtilKt;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceConnector;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.Consumer;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J2\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0017\u0018\u00010\u0016\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001cH\u0016J2\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0017\u0018\u00010\u0016\"\b\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00170 H\u0016J<\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0010\u0010$\u001a\f\u0012\u0006\b\u0000\u0012\u00020&\u0018\u00010%2\u0010\u0010'\u001a\f\u0012\u0006\b\u0000\u0012\u00020(\u0018\u00010%H\u0016JD\u0010)\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0010\u0010*\u001a\f\u0012\u0006\b\u0000\u0012\u00020&\u0018\u00010%2\u0010\u0010+\u001a\f\u0012\u0006\b\u0000\u0012\u00020(\u0018\u00010%2\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0002Ji\u0010/\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0017\u0018\u00010\u0016\"\b\b\u0000\u0010\u0017*\u00020\u0018\"\b\b\u0001\u00100*\u00020\u001f2\u0006\u00101\u001a\u0002022\u0006\u0010\u0019\u001a\u0002H02\u0010\u00103\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0017\u0018\u0001042\u001a\u00105\u001a\u0016\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020&\u0012\u0006\u0012\u0004\u0018\u0001H\u001706H\u0002\u00a2\u0006\u0002\u00107J\u001a\u00108\u001a\u0004\u0018\u00010&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00109\u001a\u00020(H\u0002J\u001a\u0010:\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010;\u001a\u0004\u0018\u00010#H\u0002J\"\u0010<\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00109\u001a\u00020(2\b\u0010*\u001a\u0004\u0018\u00010=H\u0004J\b\u0010>\u001a\u00020\u0014H\u0014J\u0012\u0010A\u001a\u0004\u0018\u00010(2\u0006\u0010\u0019\u001a\u00020\u001fH\u0004J\u0010\u0010B\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010C\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010D\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\u00a8\u0006E"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceQueueImpl;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "project", "Lcom/intellij/openapi/project/Project;", "protocol", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;", "connector", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ProcessConnector;", "reporter", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ServiceInfoReporter;", "myCacheData", "Lcom/intellij/lang/javascript/service/JSLanguageServiceCacheData;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ProcessConnector;Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ServiceInfoReporter;Lcom/intellij/lang/javascript/service/JSLanguageServiceCacheData;)V", "myCacheSyncLock", "Lkotlinx/coroutines/sync/Mutex;", "getMyCacheSyncLock", "()Lkotlinx/coroutines/sync/Mutex;", "resetCaches", "", "executeWithCache", "Ljava/util/concurrent/CompletableFuture;", "T", "", "input", "Lcom/intellij/lang/javascript/service/JSLanguageServiceCacheableCommand;", "processor", "Lcom/intellij/lang/javascript/service/JSLanguageServiceCacheableCommandProcessor;", "execute", "command", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceCommandProcessor;", "executeNoBlocking", "Ljava/util/concurrent/Future;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol$CancellationToken;", "answerConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "serviceObjectConsumer", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "executeNoBlockingImpl", "consumer", "afterSendData", "serviceObject", "executeSpan", "Lio/opentelemetry/api/trace/Span;", "executeBlocking", "C", "spanName", "", "valueFromCacheProvider", "Ljava/util/function/Supplier;", "answerProcessor", "Ljava/util/function/BiFunction;", "(Ljava/lang/String;Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;Ljava/util/function/Supplier;Ljava/util/function/BiFunction;)Ljava/util/concurrent/CompletableFuture;", "await", "data", "handleCommandTimeout", "cancellationToken", "sendData", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswerConsumer;", "doDispose", "getProtocol", "()Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;", "updateCacheAndGetServiceObject", "lockCacheCancellable", "unlockCache", "assertCacheLocked", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceQueueImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceQueueImpl.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceQueueImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,380:1\n1#2:381\n*E\n"})
public class JSLanguageServiceQueueImpl
extends JSLanguageServiceExecutorImpl
implements JSLanguageServiceQueue {
    @NotNull
    private final JSLanguageServiceCacheData myCacheData;
    @NotNull
    private final Mutex myCacheSyncLock;

    public JSLanguageServiceQueueImpl(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @Nullable JSLanguageServiceQueue.ProcessConnector connector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter reporter, @NotNull JSLanguageServiceCacheData myCacheData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)myCacheData, (String)"myCacheData");
        super(project, protocol, connector, reporter);
        this.myCacheData = myCacheData;
        this.myCacheSyncLock = MutexKt.Mutex((boolean)false);
        LowMemoryWatcher.register(() -> JSLanguageServiceQueueImpl._init_$lambda$0(this), (Disposable)this);
    }

    @NotNull
    protected final Mutex getMyCacheSyncLock() {
        return this.myCacheSyncLock;
    }

    @Override
    public void resetCaches() {
        this.myCacheData.clear();
    }

    @Override
    @Nullable
    public <T> CompletableFuture<T> executeWithCache(@NotNull JSLanguageServiceCacheableCommand input, @NotNull JSLanguageServiceCacheableCommandProcessor<T> processor) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        return this.executeBlocking("executeWithCache", (JSLanguageServiceCommand)input, () -> JSLanguageServiceQueueImpl.executeWithCache$lambda$2(this, input, processor), (arg_0, arg_1) -> JSLanguageServiceQueueImpl.executeWithCache$lambda$3(processor, input, arg_0, arg_1));
    }

    @Override
    @Nullable
    public <T> CompletableFuture<T> execute(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        return this.executeBlocking("execute", command, null, (arg_0, arg_1) -> JSLanguageServiceQueueImpl.execute$lambda$4(processor, arg_0, arg_1));
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceProtocol.CancellationToken> executeNoBlocking(@NotNull JSLanguageServiceCommand command, @Nullable Consumer<? super JSLanguageServiceAnswer> answerConsumer, @Nullable Consumer<? super JSLanguageServiceObject> serviceObjectConsumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Span executeSpan = JSLanguageServiceTracerUtil.traceSpanBuilder(this.getClass(), "executeNoBlocking " + command.getCommand()).startSpan();
        this.lockCacheCancellable(command);
        try {
            JSLanguageServiceObject serviceObject = (JSLanguageServiceObject)JSLanguageServiceTracerUtilKt.withTraceSpan$default(this.getClass(), "updateCacheAndGetServiceObject", null, () -> JSLanguageServiceQueueImpl.executeNoBlocking$lambda$5(this, command), 4, null);
            if (serviceObject == null) {
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Execute no-blocking - nothing to send for " + JSLanguageServiceUtilKt.getDebugString(command));
                }
                this.unlockCache(command);
                return null;
            }
            return (Future)((Object)JSLanguageServiceTracerUtil.supplyAsyncAndEndSpanOnComplete(executeSpan, () -> JSLanguageServiceQueueImpl.executeNoBlocking$lambda$6(this, command, answerConsumer, serviceObjectConsumer, serviceObject, executeSpan), this.getMyExecutorService()).whenComplete((arg_0, arg_1) -> JSLanguageServiceQueueImpl.executeNoBlocking$lambda$8((arg_0, arg_1) -> JSLanguageServiceQueueImpl.executeNoBlocking$lambda$7(this, command, arg_0, arg_1), arg_0, arg_1)));
        }
        catch (RejectedExecutionException exception) {
            this.unlockCache(command);
            JSLanguageServiceQueue.Holder.LOGGER.debug(exception.getMessage(), (Throwable)exception);
            executeSpan.end();
        }
        catch (Throwable ex) {
            this.unlockCache(command);
            executeSpan.end();
            throw ex;
        }
        return null;
    }

    private final JSLanguageServiceProtocol.CancellationToken executeNoBlockingImpl(JSLanguageServiceCommand command, Consumer<? super JSLanguageServiceAnswer> consumer, Consumer<? super JSLanguageServiceObject> afterSendData, JSLanguageServiceObject serviceObject, Span executeSpan) throws Exception {
        long startTime = System.currentTimeMillis();
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Send data no-blocking for: " + JSLanguageServiceUtilKt.getDebugString(command));
        }
        this.startAction(command);
        JSLanguageServiceProtocol.CancellationToken cancellationToken = this.sendData(command, serviceObject, arg_0 -> JSLanguageServiceQueueImpl.executeNoBlockingImpl$lambda$9(this, consumer, startTime, command, executeSpan, arg_0));
        if (afterSendData != null) {
            JSLanguageServiceTracerUtilKt.withTraceSpan$default(this.getClass(), "afterSendDataConsumer", null, () -> JSLanguageServiceQueueImpl.executeNoBlockingImpl$lambda$10(afterSendData, serviceObject), 4, null);
        }
        return cancellationToken;
    }

    private final <T, C extends JSLanguageServiceCommand> CompletableFuture<T> executeBlocking(String spanName, C input, Supplier<T> valueFromCacheProvider, BiFunction<JSLanguageServiceObject, JSLanguageServiceAnswer, T> answerProcessor) {
        Span executeWithCacheSpan = JSLanguageServiceTracerUtil.traceSpanBuilder(this.getClass(), spanName + " " + input.getCommand()).startSpan();
        this.lockCacheCancellable(input);
        try {
            T resultFromCache;
            Supplier<T> supplier = valueFromCacheProvider;
            Object object = resultFromCache = supplier != null ? supplier.get() : null;
            if (resultFromCache != null) {
                this.unlockCache(input);
                return CompletableFuture.completedFuture(resultFromCache);
            }
            JSLanguageServiceObject objectToSend = (JSLanguageServiceObject)JSLanguageServiceTracerUtilKt.withTraceSpan$default(this.getClass(), "updateCacheAndGetServiceObject", null, () -> JSLanguageServiceQueueImpl.executeBlocking$lambda$11(this, input), 4, null);
            if (objectToSend == null) {
                this.unlockCache(input);
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Execute blocking - nothing to send for " + JSLanguageServiceUtilKt.getDebugString(input));
                }
                return null;
            }
            AtomicReference<Boolean> startedJob = new AtomicReference<Boolean>(false);
            return JSLanguageServiceTracerUtil.supplyAsyncAndEndSpanOnComplete(executeWithCacheSpan, () -> JSLanguageServiceQueueImpl.executeBlocking$lambda$14(startedJob, this, input, objectToSend, answerProcessor), this.getMyExecutorService()).whenComplete((arg_0, arg_1) -> JSLanguageServiceQueueImpl.executeBlocking$lambda$16((arg_0, arg_1) -> JSLanguageServiceQueueImpl.executeBlocking$lambda$15(startedJob, this, input, arg_0, arg_1), arg_0, arg_1));
        }
        catch (RejectedExecutionException exception) {
            this.unlockCache(input);
            executeWithCacheSpan.end();
            JSLanguageServiceQueue.Holder.LOGGER.debug(exception.getMessage(), (Throwable)exception);
        }
        catch (Throwable t) {
            this.unlockCache(input);
            executeWithCacheSpan.end();
            throw t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JSLanguageServiceAnswer await(JSLanguageServiceCommand command, JSLanguageServiceObject data) {
        this.assertCacheLocked(command);
        if (this.getState() != JSLanguageServiceExecutor.State.STARTED) {
            this.unlockCache(command);
            return null;
        }
        try {
            if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Start await " + JSLanguageServiceUtilKt.getDebugString(command));
            }
            JSLanguageServiceProtocol.CancellationToken cancellationToken = null;
            AtomicReference ref2 = new AtomicReference();
            CountDownLatch latch = new CountDownLatch(1);
            try {
                this.startAction(command);
                cancellationToken = this.sendData(command, data, arg_0 -> JSLanguageServiceQueueImpl.await$lambda$17(this, ref2, latch, arg_0));
            }
            finally {
                this.unlockCache(command);
            }
            if (JSLanguageServiceUtil.TIMEOUT_DISABLED) {
                latch.await();
            } else if (!latch.await(command.getTimeout(), TimeUnit.MILLISECONDS)) {
                this.handleCommandTimeout(command, cancellationToken);
            }
            JSLanguageServiceAnswer jSLanguageServiceAnswer = (JSLanguageServiceAnswer)ref2.get();
            return jSLanguageServiceAnswer;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (Throwable err) {
            if (!(err instanceof ControlFlowException)) {
                JSLanguageServiceQueue.Holder.LOGGER.error(err.getMessage(), err);
            }
        }
        finally {
            this.endAction();
        }
        return null;
    }

    private final void handleCommandTimeout(JSLanguageServiceCommand command, JSLanguageServiceProtocol.CancellationToken cancellationToken) {
        JSLanguageServiceTracerUtilKt.withTraceSpan$default(this.getClass(), "cancelCommand", null, () -> JSLanguageServiceQueueImpl.handleCommandTimeout$lambda$18(this, cancellationToken), 4, null);
        JSLanguageServiceExecutorImpl.infoLog$default(this, JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Timeout waiting answer for: " + JSLanguageServiceUtilKt.getDebugString(command), null, 2, null);
    }

    @NotNull
    protected final JSLanguageServiceProtocol.CancellationToken sendData(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer consumer) throws Exception {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JSLanguageServiceUtil.assertServiceRequestAllowed();
        this.assertCacheLocked(command);
        return this.getProtocol().sendCommand(command, data, consumer);
    }

    @Override
    protected void doDispose() {
        super.doDispose();
        Disposer.dispose((Disposable)this.myCacheData);
    }

    @Override
    @NotNull
    public JSLanguageServiceProtocol getProtocol() {
        JSLanguageServiceConnector jSLanguageServiceConnector = super.getProtocol();
        Intrinsics.checkNotNull((Object)jSLanguageServiceConnector, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol");
        return (JSLanguageServiceProtocol)jSLanguageServiceConnector;
    }

    @Nullable
    protected final JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.assertCacheLocked(input);
        return this.myCacheData.updateCacheAndGetServiceObject(input);
    }

    private final void lockCacheCancellable(JSLanguageServiceCommand command) {
        if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.trace(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Trying to lock cache from blocking context for " + JSLanguageServiceUtilKt.getDebugString(command));
        }
        AtomicReference<Boolean> wasLocked = new AtomicReference<Boolean>(false);
        try {
            JSLanguageServiceTracerUtilKt.withTraceSpan$default(this.getClass(), "wait for cache lock", null, () -> JSLanguageServiceQueueImpl.lockCacheCancellable$lambda$19(this, wasLocked), 4, null);
            if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                JSLanguageServiceQueue.Holder.LOGGER.trace(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Cache locked from blocking context for " + JSLanguageServiceUtilKt.getDebugString(command));
            }
        }
        catch (Throwable e) {
            if (wasLocked.get().booleanValue()) {
                this.myCacheSyncLock.unlock(null);
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Releasing lock after exception from blocking context for " + JSLanguageServiceUtilKt.getDebugString(command), e);
                }
            }
            throw e;
        }
    }

    private final void unlockCache(JSLanguageServiceCommand command) {
        if (!this.myCacheSyncLock.isLocked()) {
            JSLanguageServiceQueue.Holder.LOGGER.error(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Cache already unlocked from blocking context during " + JSLanguageServiceUtilKt.getDebugString(command));
        } else {
            try {
                if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.trace(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Trying to unlock cache from blocking context after " + JSLanguageServiceUtilKt.getDebugString(command));
                }
                this.myCacheSyncLock.unlock(null);
                if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.trace(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Cache unlocked from blocking context after " + JSLanguageServiceUtilKt.getDebugString(command));
                }
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.error(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Failed to unlock cache from blocking context during " + JSLanguageServiceUtilKt.getDebugString(command), (Throwable)e);
                throw e;
            }
        }
    }

    private final void assertCacheLocked(JSLanguageServiceCommand input) {
        if (!this.myCacheSyncLock.isLocked()) {
            boolean bl = false;
            String string = JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Cache is not locked for " + JSLanguageServiceUtilKt.getDebugString(input);
            throw new IllegalStateException(string.toString());
        }
    }

    private static final void _init_$lambda$0(JSLanguageServiceQueueImpl this$0) {
        this$0.resetCaches();
    }

    private static final Object executeWithCache$lambda$2$lambda$1(JSLanguageServiceCacheableCommandProcessor $processor, JSLanguageServiceCacheableCommand $input, Object $valueFromCache) {
        return $processor.processFromCache($input, $valueFromCache);
    }

    private static final Object executeWithCache$lambda$2(JSLanguageServiceQueueImpl this$0, JSLanguageServiceCacheableCommand $input, JSLanguageServiceCacheableCommandProcessor $processor) {
        Object valueFromCache = this$0.myCacheData.getValueFromCache($input);
        if (valueFromCache != null) {
            if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.Holder.LOGGER.debug("Used service cache " + $input);
            }
            return JSLanguageServiceTracerUtilKt.withTraceSpan$default(this$0.getClass(), "processFromCache", null, () -> JSLanguageServiceQueueImpl.executeWithCache$lambda$2$lambda$1($processor, $input, valueFromCache), 4, null);
        }
        return null;
    }

    private static final Object executeWithCache$lambda$3(JSLanguageServiceCacheableCommandProcessor $processor, JSLanguageServiceCacheableCommand $input, JSLanguageServiceObject obj, JSLanguageServiceAnswer answer2) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)answer2, (String)"answer");
        return $processor.process($input, obj, answer2);
    }

    private static final Object execute$lambda$4(JSLanguageServiceCommandProcessor $processor, JSLanguageServiceObject obj, JSLanguageServiceAnswer answer2) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)answer2, (String)"answer");
        return $processor.process(obj, answer2);
    }

    private static final JSLanguageServiceObject executeNoBlocking$lambda$5(JSLanguageServiceQueueImpl this$0, JSLanguageServiceCommand $command) {
        return this$0.updateCacheAndGetServiceObject($command);
    }

    private static final JSLanguageServiceProtocol.CancellationToken executeNoBlocking$lambda$6(JSLanguageServiceQueueImpl this$0, JSLanguageServiceCommand $command, Consumer $answerConsumer, Consumer $serviceObjectConsumer, JSLanguageServiceObject $serviceObject, Span $executeSpan) {
        block5: {
            try {
                JSLanguageServiceProtocol.CancellationToken cancellationToken;
                if (this$0.getState() != JSLanguageServiceExecutor.State.STARTED) {
                    cancellationToken = null;
                } else {
                    Intrinsics.checkNotNull((Object)$executeSpan);
                    cancellationToken = this$0.executeNoBlockingImpl($command, (Consumer<? super JSLanguageServiceAnswer>)$answerConsumer, (Consumer<? super JSLanguageServiceObject>)$serviceObjectConsumer, $serviceObject, $executeSpan);
                }
                return cancellationToken;
            }
            catch (IOException e) {
                JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ControlFlowException || throwable instanceof CancellationException) break block5;
                JSLanguageServiceQueue.Holder.LOGGER.error(throwable.getMessage(), throwable);
            }
        }
        return null;
    }

    private static final Unit executeNoBlocking$lambda$7(JSLanguageServiceQueueImpl this$0, JSLanguageServiceCommand $command, JSLanguageServiceProtocol.CancellationToken cancellationToken, Throwable throwable) {
        this$0.unlockCache($command);
        return Unit.INSTANCE;
    }

    private static final void executeNoBlocking$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void executeNoBlockingImpl$lambda$9(JSLanguageServiceQueueImpl this$0, Consumer $consumer, long $startTime, JSLanguageServiceCommand $command, Span $executeSpan, JSLanguageServiceAnswer message) {
        try {
            this$0.endAction();
            if (this$0.getState() != JSLanguageServiceExecutor.State.STARTED) {
                return;
            }
            if (message != null) {
                message.logIfError();
                Consumer consumer = $consumer;
                if (consumer != null) {
                    consumer.consume((Object)message);
                }
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    long processingTime = System.currentTimeMillis() - $startTime;
                    JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Total process queue non-blocking command " + JSLanguageServiceUtilKt.getDebugString($command) + " time, millis: " + processingTime);
                }
            }
        }
        finally {
            $executeSpan.end();
        }
    }

    private static final Unit executeNoBlockingImpl$lambda$10(Consumer $afterSendData, JSLanguageServiceObject $serviceObject) {
        $afterSendData.consume((Object)$serviceObject);
        return Unit.INSTANCE;
    }

    private static final JSLanguageServiceObject executeBlocking$lambda$11(JSLanguageServiceQueueImpl this$0, JSLanguageServiceCommand $input) {
        return this$0.updateCacheAndGetServiceObject($input);
    }

    private static final JSLanguageServiceAnswer executeBlocking$lambda$14$lambda$12(JSLanguageServiceQueueImpl this$0, JSLanguageServiceCommand $input, JSLanguageServiceObject $objectToSend) {
        return this$0.await($input, $objectToSend);
    }

    private static final Object executeBlocking$lambda$14$lambda$13(BiFunction $answerProcessor, JSLanguageServiceObject $objectToSend, JSLanguageServiceAnswer $answer) {
        return $answerProcessor.apply($objectToSend, $answer);
    }

    private static final Object executeBlocking$lambda$14(AtomicReference $startedJob, JSLanguageServiceQueueImpl this$0, JSLanguageServiceCommand $input, JSLanguageServiceObject $objectToSend, BiFunction $answerProcessor) {
        try {
            long startTime = System.currentTimeMillis();
            $startedJob.set(true);
            JSLanguageServiceAnswer answer2 = (JSLanguageServiceAnswer)JSLanguageServiceTracerUtilKt.withTraceSpan$default(this$0.getClass(), "await", null, () -> JSLanguageServiceQueueImpl.executeBlocking$lambda$14$lambda$12(this$0, $input, $objectToSend), 4, null);
            Object result2 = null;
            if (answer2 == null || answer2.isEmpty() || this$0.getState() != JSLanguageServiceExecutor.State.STARTED) {
                JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " No answer received for " + JSLanguageServiceUtilKt.getDebugString($input));
                result2 = null;
            } else {
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Answer was received: " + JSLanguageServiceUtilKt.getDebugString($input));
                }
                result2 = JSLanguageServiceTracerUtilKt.withTraceSpan$default(this$0.getClass(), "process answer", null, () -> JSLanguageServiceQueueImpl.executeBlocking$lambda$14$lambda$13($answerProcessor, $objectToSend, answer2), 4, null);
            }
            if ($input instanceof JSLanguageServiceCacheableCommand) {
                this$0.myCacheData.putCacheValue((JSLanguageServiceCacheableCommand)$input, answer2, result2);
            }
            if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                long totalTime = System.currentTimeMillis() - startTime;
                JSLanguageServiceQueue.Holder.LOGGER.debug(JSLanguageServiceUtilKt.getCurrentThreadDebugInfo() + " Total process queue command " + JSLanguageServiceUtilKt.getDebugString($input) + " time, millis: " + totalTime);
            }
            return result2;
        }
        catch (Throwable err) {
            if (!(err instanceof ControlFlowException)) {
                JSLanguageServiceQueue.Holder.LOGGER.error(err.getMessage(), err);
            }
            return null;
        }
    }

    private static final Unit executeBlocking$lambda$15(AtomicReference $startedJob, JSLanguageServiceQueueImpl this$0, JSLanguageServiceCommand $input, Object object, Throwable throwable) {
        if (!((Boolean)$startedJob.get()).booleanValue()) {
            this$0.unlockCache($input);
        }
        return Unit.INSTANCE;
    }

    private static final void executeBlocking$lambda$16(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void await$lambda$17(JSLanguageServiceQueueImpl this$0, AtomicReference $ref, CountDownLatch $latch, JSLanguageServiceAnswer message) {
        if (this$0.getState() == JSLanguageServiceExecutor.State.STARTED) {
            JSLanguageServiceAnswer jSLanguageServiceAnswer = message;
            if (jSLanguageServiceAnswer != null) {
                jSLanguageServiceAnswer.logIfError();
            }
        }
        $ref.set(message);
        $latch.countDown();
    }

    private static final Unit handleCommandTimeout$lambda$18(JSLanguageServiceQueueImpl this$0, JSLanguageServiceProtocol.CancellationToken $cancellationToken) {
        this$0.getProtocol().cancelCommand($cancellationToken);
        return Unit.INSTANCE;
    }

    private static final Unit lockCacheCancellable$lambda$19(JSLanguageServiceQueueImpl this$0, AtomicReference $wasLocked) {
        JSLanguageServiceUtilKt.lockCancellable(this$0.myCacheSyncLock, $wasLocked);
        return Unit.INSTANCE;
    }
}

