/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAnnotationErrorsFilter;
import com.intellij.lang.javascript.service.JSLanguageServiceFileProblem;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u001e\n\u0002\b\u0006\b&\u0018\u0000 R*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003:\u0002QRB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u00122\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J$\u00102\u001a\u00020/2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001d\u00105\u001a\u00020/2\u0006\u00106\u001a\u00028\u00002\b\u00107\u001a\u0004\u0018\u000108\u00a2\u0006\u0002\u00109J\u001d\u0010:\u001a\u00020/2\u0006\u00106\u001a\u00028\u00002\b\u00107\u001a\u0004\u0018\u000108\u00a2\u0006\u0002\u00109J\u001d\u0010;\u001a\u00020/2\u0006\u00106\u001a\u00028\u00002\b\u00107\u001a\u0004\u0018\u000108\u00a2\u0006\u0002\u00109J'\u0010<\u001a\u00020/2\u0006\u00106\u001a\u00028\u00002\u0006\u0010=\u001a\u00020\u00132\b\u00107\u001a\u0004\u0018\u000108H\u0002\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u00020/H\u0014J\b\u0010@\u001a\u00020/H\u0014J'\u0010A\u001a\u00020)2\u0006\u00106\u001a\u00028\u00002\u0006\u0010=\u001a\u00020\u00132\b\u00107\u001a\u0004\u0018\u000108H\u0002\u00a2\u0006\u0002\u0010BJ&\u0010C\u001a\u00020/2\u0006\u0010=\u001a\u00020\u00132\u0006\u0010D\u001a\u00020\u00122\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014J&\u0010F\u001a\u00020)2\u0006\u0010=\u001a\u00020\u00132\u0006\u0010D\u001a\u00020\u00122\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J3\u0010H\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0018\u00010\u00112\u0006\u00106\u001a\u00028\u00002\b\u00107\u001a\u0004\u0018\u000108H$\u00a2\u0006\u0002\u0010IJ*\u0010J\u001a\u00020/2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0004J\u001c\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001a0M2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\b\u0010N\u001a\u00020/H\u0002J\b\u0010O\u001a\u00020/H\u0002J\b\u0010P\u001a\u00020/H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R,\u0010\u0018\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006S"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors;", "AnswerT", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "myErrorFilter", "Lcom/intellij/lang/javascript/service/JSAnnotationErrorsFilter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/service/JSAnnotationErrorsFilter;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myExecutorService", "Ljava/util/concurrent/ThreadPoolExecutor;", "Lorg/jetbrains/annotations/NotNull;", "myErrors", "", "Lcom/intellij/openapi/util/Pair;", "", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors$ServiceError;", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "getMyErrors", "()Ljava/util/Map;", "myNewErrors", "", "Lcom/intellij/analysis/problemsView/FileProblem;", "myGlobalErrors", "", "getMyGlobalErrors", "()Ljava/util/List;", "myDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "getMyDisposable", "()Lcom/intellij/openapi/util/CheckedDisposable;", "myProjectContext", "getMyProjectContext", "()Ljava/lang/String;", "setMyProjectContext", "(Ljava/lang/String;)V", "myDisposed", "", "getMyDisposed", "()Z", "setMyDisposed", "(Z)V", "setProjectContext", "", "projectContext", "globalErrors", "reportGlobalErrorsNew", "newErrors", "old", "pushSyntaxErrors", "answer", "languageServiceInfo", "Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;", "(Ljava/lang/Object;Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;)V", "pushSemanticErrors", "pushSuggestions", "handleAnswer", "serviceError", "(Ljava/lang/Object;Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors$ServiceError;Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;)V", "cancelAllUpdates", "queueUpdate", "convertEventsToAnnotationsAndUpdateErrors", "(Ljava/lang/Object;Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors$ServiceError;Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;)Z", "receivedDiagnostics", "path", "errors", "processEventAnnotations", "newElements", "getPathAndErrors", "(Ljava/lang/Object;Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;)Lcom/intellij/openapi/util/Pair;", "handleNewProjectErrors", "key", "convertToFileProblem", "", "clear", "clearNew", "dispose", "ServiceError", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceProjectErrors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceProjectErrors.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,249:1\n1863#2,2:250\n1619#2:252\n1863#2:253\n1864#2:255\n1620#2:256\n1863#2,2:258\n1863#2,2:261\n1#3:254\n216#4:257\n217#4:260\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceProjectErrors.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors\n*L\n190#1:250,2\n213#1:252\n213#1:253\n213#1:255\n213#1:256\n232#1:258,2\n234#1:261,2\n213#1:254\n231#1:257\n231#1:260\n*E\n"})
public abstract class JSLanguageServiceProjectErrors<AnswerT>
implements Disposable,
ProblemsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JSAnnotationErrorsFilter myErrorFilter;
    @NotNull
    private final ThreadPoolExecutor myExecutorService;
    @NotNull
    private final Map<Pair<String, ServiceError>, List<JSAnnotationError>> myErrors;
    @NotNull
    private final Map<Pair<String, ServiceError>, Set<FileProblem>> myNewErrors;
    @NotNull
    private final List<JSAnnotationError> myGlobalErrors;
    @NotNull
    private final CheckedDisposable myDisposable;
    @Nullable
    private String myProjectContext;
    private volatile boolean myDisposed;
    @NotNull
    private static final Logger LOGGER;

    public JSLanguageServiceProjectErrors(@NotNull Project project, @NotNull JSAnnotationErrorsFilter myErrorFilter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myErrorFilter, (String)"myErrorFilter");
        this.project = project;
        this.myErrorFilter = myErrorFilter;
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Project errors processing");
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolExecutor, (String)"newSingleThreadExecutor(...)");
        this.myExecutorService = threadPoolExecutor;
        this.myErrors = new HashMap();
        this.myNewErrors = new HashMap();
        this.myGlobalErrors = new CopyOnWriteArrayList();
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.myDisposable = checkedDisposable;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    protected final Map<Pair<String, ServiceError>, List<JSAnnotationError>> getMyErrors() {
        return this.myErrors;
    }

    @NotNull
    protected final List<JSAnnotationError> getMyGlobalErrors() {
        return this.myGlobalErrors;
    }

    @NotNull
    protected final CheckedDisposable getMyDisposable() {
        return this.myDisposable;
    }

    @Nullable
    protected final String getMyProjectContext() {
        return this.myProjectContext;
    }

    protected final void setMyProjectContext(@Nullable String string) {
        this.myProjectContext = string;
    }

    protected final boolean getMyDisposed() {
        return this.myDisposed;
    }

    protected final void setMyDisposed(boolean bl) {
        this.myDisposed = bl;
    }

    public final synchronized void setProjectContext(@Nullable String projectContext, @NotNull List<? extends JSAnnotationError> globalErrors) {
        Intrinsics.checkNotNullParameter(globalErrors, (String)"globalErrors");
        if (this.myDisposed) {
            return;
        }
        if (!Intrinsics.areEqual((Object)projectContext, (Object)this.myProjectContext)) {
            this.myProjectContext = projectContext;
            this.clear();
            this.cancelAllUpdates();
        }
        if (projectContext != null && !Intrinsics.areEqual(globalErrors, this.myGlobalErrors)) {
            ArrayList old = new ArrayList(this.myGlobalErrors);
            this.myGlobalErrors.clear();
            this.myGlobalErrors.addAll((Collection<JSAnnotationError>)globalErrors);
            this.reportGlobalErrorsNew(globalErrors, old);
            this.queueUpdate();
        }
    }

    private final synchronized void reportGlobalErrorsNew(List<? extends JSAnnotationError> newErrors, List<? extends JSAnnotationError> old) {
        ProblemsCollector collector = ProblemsCollector.Companion.getInstance(this.getProject());
        Collection<FileProblem> oldProblems = this.convertToFileProblem(old);
        Collection<FileProblem> newProblems = this.convertToFileProblem(newErrors);
        for (FileProblem problem : oldProblems) {
            collector.problemDisappeared((Problem)problem);
        }
        for (FileProblem problem : newProblems) {
            collector.problemAppeared((Problem)problem);
        }
    }

    public final void pushSyntaxErrors(AnswerT answer2, @Nullable LanguageServiceInfo languageServiceInfo) {
        this.handleAnswer(answer2, ServiceError.SYNTAX, languageServiceInfo);
    }

    public final void pushSemanticErrors(AnswerT answer2, @Nullable LanguageServiceInfo languageServiceInfo) {
        this.handleAnswer(answer2, ServiceError.SEMANTICS, languageServiceInfo);
    }

    public final void pushSuggestions(AnswerT answer2, @Nullable LanguageServiceInfo languageServiceInfo) {
        this.handleAnswer(answer2, ServiceError.SUGGESTIONS, languageServiceInfo);
    }

    private final void handleAnswer(AnswerT answer2, ServiceError serviceError, LanguageServiceInfo languageServiceInfo) {
        this.myExecutorService.execute(() -> JSLanguageServiceProjectErrors.handleAnswer$lambda$0(this, answer2, serviceError, languageServiceInfo));
    }

    protected void cancelAllUpdates() {
    }

    protected void queueUpdate() {
    }

    private final boolean convertEventsToAnnotationsAndUpdateErrors(AnswerT answer2, ServiceError serviceError, LanguageServiceInfo languageServiceInfo) {
        if (this.getProject().isDisposed() || this.myDisposable.isDisposed()) {
            return false;
        }
        Pair<String, List<JSAnnotationError>> pair = this.getPathAndErrors(answer2, languageServiceInfo);
        if (pair == null) {
            return false;
        }
        String path2 = (String)pair.first;
        List errors = (List)pair.second;
        Intrinsics.checkNotNull((Object)path2);
        Intrinsics.checkNotNull((Object)errors);
        this.receivedDiagnostics(serviceError, path2, errors);
        if (serviceError == ServiceError.SUGGESTIONS) {
            return false;
        }
        List newElements = (List)ReadAction.nonBlocking(() -> JSLanguageServiceProjectErrors.convertEventsToAnnotationsAndUpdateErrors$lambda$1(this, path2, errors)).expireWhen(() -> JSLanguageServiceProjectErrors.convertEventsToAnnotationsAndUpdateErrors$lambda$2(this)).executeSynchronously();
        Intrinsics.checkNotNull((Object)newElements);
        return this.processEventAnnotations(serviceError, path2, newElements);
    }

    protected void receivedDiagnostics(@NotNull ServiceError serviceError, @NotNull String path2, @NotNull List<? extends JSAnnotationError> errors) {
        Intrinsics.checkNotNullParameter((Object)((Object)serviceError), (String)"serviceError");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
    }

    private final synchronized boolean processEventAnnotations(ServiceError serviceError, String path2, List<? extends JSAnnotationError> newElements) {
        if (this.myProjectContext == null) {
            return false;
        }
        Pair key = new Pair((Object)path2, (Object)serviceError);
        List<JSAnnotationError> oldElements = this.myErrors.get(key);
        this.handleNewProjectErrors((Pair<String, ServiceError>)key, newElements);
        if (newElements.isEmpty()) {
            this.myErrors.remove(key);
            return oldElements != null;
        }
        this.myErrors.put((Pair<String, ServiceError>)key, newElements);
        return !Intrinsics.areEqual(newElements, oldElements);
    }

    @Nullable
    protected abstract Pair<String, List<JSAnnotationError>> getPathAndErrors(AnswerT var1, @Nullable LanguageServiceInfo var2);

    protected final synchronized void handleNewProjectErrors(@NotNull Pair<String, ServiceError> key, @NotNull List<? extends JSAnnotationError> newElements) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(newElements, (String)"newElements");
        Set set = this.myNewErrors.get(key);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Set oldEls = set;
        ProblemsCollector collector = ProblemsCollector.Companion.getInstance(this.getProject());
        if (newElements.isEmpty()) {
            if (!oldEls.isEmpty()) {
                Iterable $this$forEach$iv = oldEls;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FileProblem it = (FileProblem)element$iv;
                    boolean bl = false;
                    collector.problemDisappeared((Problem)it);
                }
                this.myNewErrors.remove(key);
            }
            return;
        }
        Collection<FileProblem> newEls = this.convertToFileProblem(newElements);
        HashSet<FileProblem> newProblems = new HashSet<FileProblem>(newEls);
        if (!Intrinsics.areEqual(newProblems, (Object)oldEls)) {
            this.myNewErrors.put(key, newProblems);
            for (FileProblem el : oldEls) {
                collector.problemDisappeared((Problem)el);
            }
            for (FileProblem el : newEls) {
                collector.problemAppeared((Problem)el);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<FileProblem> convertToFileProblem(List<? extends JSAnnotationError> newElements) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Iterable iterable = newElements;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            JSLanguageServiceFileProblem it$iv;
            VirtualFile path2;
            String pathCandidate;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            JSAnnotationError el = (JSAnnotationError)element$iv;
            boolean bl2 = false;
            if ((el.getAbsoluteFilePath() == null ? null : (LocalFileSystem.getInstance().findFileByPath(pathCandidate) == null ? null : new JSLanguageServiceFileProblem(this, el, path2))) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return var3_3;
    }

    private final synchronized void clear() {
        Cancellation.executeInNonCancelableSection(() -> JSLanguageServiceProjectErrors.clear$lambda$5(this));
        this.myGlobalErrors.clear();
        this.myErrors.clear();
    }

    private final synchronized void clearNew() {
        if (!this.getProject().isDisposed()) {
            Map.Entry<Object, Set<Object>> element$iv;
            ProblemsCollector collector = ProblemsCollector.Companion.getInstance(this.getProject());
            Object $this$forEach$iv = this.myNewErrors;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Object, Set<Object>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Pair<String, ServiceError>, Set<FileProblem>> entry = element$iv = iterator.next();
                boolean bl = false;
                Set<FileProblem> value = entry.getValue();
                Iterable $this$forEach$iv2 = value;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    FileProblem it = (FileProblem)element$iv2;
                    boolean bl2 = false;
                    collector.problemDisappeared((Problem)it);
                }
            }
            $this$forEach$iv = this.convertToFileProblem(this.myGlobalErrors);
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                FileProblem it = (FileProblem)element$iv;
                boolean bl = false;
                collector.problemDisappeared((Problem)it);
            }
        }
        this.myNewErrors.clear();
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.myDisposable));
        this.clear();
        this.myDisposed = true;
    }

    private static final void handleAnswer$lambda$0(JSLanguageServiceProjectErrors this$0, Object $answer, ServiceError $serviceError, LanguageServiceInfo $languageServiceInfo) {
        block4: {
            if (this$0.myDisposed) {
                return;
            }
            try {
                if (this$0.convertEventsToAnnotationsAndUpdateErrors($answer, $serviceError, $languageServiceInfo)) {
                    this$0.queueUpdate();
                }
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) break block4;
                LOGGER.error("Exception during project errors processing", (Throwable)e);
            }
        }
    }

    private static final List convertEventsToAnnotationsAndUpdateErrors$lambda$1(JSLanguageServiceProjectErrors this$0, String $path, List $errors) {
        JSAnnotationErrorsFilter jSAnnotationErrorsFilter = this$0.myErrorFilter;
        Intrinsics.checkNotNull((Object)$path);
        Intrinsics.checkNotNull((Object)$errors);
        return jSAnnotationErrorsFilter.process($path, $errors);
    }

    private static final boolean convertEventsToAnnotationsAndUpdateErrors$lambda$2(JSLanguageServiceProjectErrors this$0) {
        return this$0.getProject().isDisposed() || this$0.myDisposable.isDisposed();
    }

    private static final void clear$lambda$5(JSLanguageServiceProjectErrors this$0) {
        this$0.clearNew();
    }

    static {
        Logger logger = Logger.getInstance(JSLanguageServiceProjectErrors.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOGGER", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors$ServiceError;", "", "<init>", "(Ljava/lang/String;I)V", "SYNTAX", "SEMANTICS", "SUGGESTIONS", "GLOBAL", "intellij.javascript.impl"})
    protected static final class ServiceError
    extends Enum<ServiceError> {
        public static final /* enum */ ServiceError SYNTAX = new ServiceError();
        public static final /* enum */ ServiceError SEMANTICS = new ServiceError();
        public static final /* enum */ ServiceError SUGGESTIONS = new ServiceError();
        public static final /* enum */ ServiceError GLOBAL = new ServiceError();
        private static final /* synthetic */ ServiceError[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ServiceError[] values() {
            return (ServiceError[])$VALUES.clone();
        }

        public static ServiceError valueOf(String value) {
            return Enum.valueOf(ServiceError.class, value);
        }

        @NotNull
        public static EnumEntries<ServiceError> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = serviceErrorArray = new ServiceError[]{ServiceError.SYNTAX, ServiceError.SEMANTICS, ServiceError.SUGGESTIONS, ServiceError.GLOBAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

