/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ0\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0011\u0018\u00010\u0010\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0016J\u000e\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H$J\b\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u0012\u0010\n\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00198TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceBase;", "Lcom/intellij/lang/javascript/service/JSAsyncLanguageServiceBase;", "Lcom/intellij/lang/javascript/linter/LinterLanguageServiceClient;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "consoleId", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "myDefaultReporter", "Lcom/intellij/lang/javascript/service/JSAsyncLanguageServiceBase$JSLanguageServiceInfoReporter;", "defaultReporter", "getDefaultReporter", "()Lcom/intellij/lang/javascript/service/JSAsyncLanguageServiceBase$JSLanguageServiceInfoReporter;", "sendCommand", "Ljava/util/concurrent/CompletableFuture;", "T", "", "command", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "processor", "Lcom/intellij/lang/javascript/service/JSLanguageServiceCommandProcessor;", "", "createLanguageServiceQueue", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "process", "getProcess", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "processIfCreated", "getProcessIfCreated", "isServiceCreated", "", "getServiceCreationError", "setDefaultReporter", "intellij.javascript.impl"})
public abstract class JSLanguageServiceBase
extends JSAsyncLanguageServiceBase
implements LinterLanguageServiceClient {
    @JvmField
    @NotNull
    protected volatile JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter myDefaultReporter;

    @NotNull
    public final JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter getDefaultReporter() {
        return this.myDefaultReporter;
    }

    public JSLanguageServiceBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, null, 2, null);
        this.myDefaultReporter = this.createDefaultReporter();
    }

    public JSLanguageServiceBase(@NotNull Project project, @NotNull String consoleId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleId, (String)"consoleId");
        super(project, consoleId);
        this.myDefaultReporter = this.createDefaultReporter();
    }

    @Nullable
    public final <T> CompletableFuture<T> sendCommand(@NotNull JSLanguageServiceSimpleCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcess();
        return jSLanguageServiceQueue != null ? jSLanguageServiceQueue.execute(command, processor) : null;
    }

    public final void sendCommand(@NotNull JSLanguageServiceSimpleCommand command) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcess();
            if (jSLanguageServiceQueue == null) break block0;
            jSLanguageServiceQueue.executeNoBlocking(command);
        }
    }

    @Override
    @Nullable
    protected abstract JSLanguageServiceQueue createLanguageServiceQueue();

    @Override
    @Nullable
    protected JSLanguageServiceQueue getProcess() {
        return (JSLanguageServiceQueue)super.getProcess();
    }

    @Override
    @Nullable
    public JSLanguageServiceQueue getProcessIfCreated() {
        return (JSLanguageServiceQueue)super.getProcessIfCreated();
    }

    @Override
    public boolean isServiceCreated() {
        return this.getProcessIfCreated() != null;
    }

    @Override
    @Nullable
    public String getServiceCreationError() {
        JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcessIfCreated();
        return jSLanguageServiceQueue != null ? jSLanguageServiceQueue.getStartErrorMessage() : null;
    }

    @TestOnly
    public final void setDefaultReporter(@NotNull JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter defaultReporter) {
        Intrinsics.checkNotNullParameter((Object)defaultReporter, (String)"defaultReporter");
        this.myDefaultReporter = defaultReporter;
    }
}

