/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExternalModule;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSModuleTypeImpl
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType,
JSTypeWithIncompleteSubstitution,
JSPropertiesOwnerType {
    private final boolean myIsFromRequire;

    public JSModuleTypeImpl(@NotNull JSFile file, boolean isFromRequire) {
        if (file == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(0);
        }
        this((PsiFile)file, isFromRequire);
    }

    public JSModuleTypeImpl(@NotNull PsiFile file, boolean isFromRequire) {
        if (file == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(1);
        }
        this(JSTypeSourceFactory.createTypeSource((PsiElement)file, true), isFromRequire);
    }

    public JSModuleTypeImpl(@NotNull JSEmbeddedContent embeddedContent, boolean isFromRequire) {
        if (embeddedContent == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(2);
        }
        this(JSTypeSourceFactory.createTypeSource(embeddedContent, true), isFromRequire);
    }

    public JSModuleTypeImpl(@NotNull TypeScriptModule tsModule, boolean isFromRequire) {
        if (tsModule == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(3);
        }
        this(JSTypeSourceFactory.createTypeSource(tsModule, true), isFromRequire);
    }

    private JSModuleTypeImpl(@NotNull JSTypeSource source, boolean isFromRequire) {
        if (source == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(4);
        }
        super(source);
        this.myIsFromRequire = isFromRequire;
    }

    public JSModuleTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(5);
        }
        if (inputStream == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(6);
        }
        super(source);
        PsiElement module = source.getSourceElement();
        if (!(module instanceof PsiFile) && !ES6PsiUtil.isEmbeddedModule(module)) {
            throw new IllegalStateException("Source element must be a JSFile or an embedded module: " + module);
        }
        this.myIsFromRequire = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(7);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myIsFromRequire, outputStream);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(8);
        }
        return new JSModuleTypeImpl(source, this.myIsFromRequire);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(9);
        }
        return Objects.equals(this.getSourceElement(), type.getSourceElement()) && this.myIsFromRequire == ((JSModuleTypeImpl)type).myIsFromRequire;
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.getSourceElement(), this.myIsFromRequire);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(10);
        }
        if (builder2 == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(11);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            builder2.append("modt()");
            return;
        }
        JSType evaluatedType = this.substitute();
        if (evaluatedType != this) {
            evaluatedType.buildTypeText(format, builder2);
        } else {
            builder2.append("any");
        }
    }

    @Override
    @NotNull
    public JSType substituteCompletely() {
        JSType jSType = this.substitute();
        if (jSType == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        JSExternalModule externalModule;
        JSType moduleType;
        PsiElement module;
        PsiFile psiFile;
        if (evaluateContext == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(13);
        }
        if ((psiFile = (module = this.getModule()).getContainingFile()) instanceof JSExternalModule && (moduleType = (externalModule = (JSExternalModule)psiFile).buildModuleType(module)) != null) {
            JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(Collections.singletonList(JSEvaluationResultElement.fromType(moduleType, evaluateContext)));
            if (jSEvaluationTask == null) {
                JSModuleTypeImpl.$$$reportNull$$$0(14);
            }
            return jSEvaluationTask;
        }
        List<JSPsiBasedTypeOfType> typesFromExportedElements = this.getTypesFromExportedElements(evaluateContext);
        JSEvaluationTask taskFromExportedElements = this.getTaskFromExportedElementTypes(typesFromExportedElements, evaluateContext);
        if (typesFromExportedElements.size() == 1 && typesFromExportedElements.get(0).getElement() instanceof TypeScriptExportAssignment) {
            JSEvaluationTask jSEvaluationTask = taskFromExportedElements;
            if (jSEvaluationTask == null) {
                JSModuleTypeImpl.$$$reportNull$$$0(15);
            }
            return jSEvaluationTask;
        }
        ArrayList<JSEvaluationTask> tasks = new ArrayList<JSEvaluationTask>(2);
        tasks.add(taskFromExportedElements);
        JSSimpleRecordTypeImpl recordType = JSModuleTypeImpl.getRecordTypeFromModuleExports(module);
        tasks.add(recordType != null ? JSEvaluationResultElement.fromType(recordType.copyWithStrict(this.isSourceStrict()), evaluateContext) : JSModuleTypeImpl.getTaskForUnknownElement(module, evaluateContext));
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(tasks);
        if (jSEvaluationTask == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(16);
        }
        return jSEvaluationTask;
    }

    @NotNull
    private List<? extends PsiElement> getExportedElements() {
        PsiElement module = this.getModule();
        List exportedElements = JSResolveUtil.getExportedElements(module);
        if (exportedElements.size() == 1 && exportedElements.get(0) instanceof TypeScriptExportAssignment) {
            List list = exportedElements;
            if (list == null) {
                JSModuleTypeImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        boolean processDefaultExportForLegacyCompatibility = this.myIsFromRequire;
        if (this.myIsFromRequire) {
            boolean bl = processDefaultExportForLegacyCompatibility = !(module instanceof JSFile) || ((JSFile)module).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.ES6;
        }
        if (processDefaultExportForLegacyCompatibility) {
            JSElement defaultExport = ES6PsiUtil.findDefaultExport(module);
            if (defaultExport instanceof ES6ExportDefaultAssignment) {
                exportedElements = ContainerUtil.concat(exportedElements, JSModuleTypeImpl.resolveExportAssignmentLocally((JSExportAssignment)defaultExport));
            } else if (defaultExport != null) {
                exportedElements = ContainerUtil.concat((List)exportedElements, Collections.singletonList(defaultExport));
            }
        }
        List list = exportedElements;
        if (list == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public PsiElement getModule() {
        PsiElement psiElement = Objects.requireNonNull(this.getSource().getSourceElement());
        if (psiElement == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    public boolean isFromRequire() {
        return this.myIsFromRequire;
    }

    @NotNull
    private JSEvaluationTask getTaskFromExportedElementTypes(@NotNull List<JSPsiBasedTypeOfType> types, @NotNull JSEvaluateContext context2) {
        if (types == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(20);
        }
        if (context2 == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(21);
        }
        List tasks = ContainerUtil.map(types, t -> JSEvaluationResultElement.fromType(t, context2));
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromSet(tasks, this.isJavaScript());
        if (jSEvaluationTask == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(22);
        }
        return jSEvaluationTask;
    }

    @NotNull
    public List<JSPsiBasedTypeOfType> getTypesFromExportedElements(@NotNull JSEvaluateContext context2) {
        if (context2 == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(23);
        }
        List<? extends PsiElement> exportedElements = Collections.unmodifiableList(this.getExportedElements());
        List list = ContainerUtil.map(exportedElements, e -> JSCodeBasedTypeFactory.getPsiBasedType(e, context2));
        if (list == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Nullable
    public static JSSimpleRecordTypeImpl getRecordTypeFromModuleExports(@NotNull PsiElement module) {
        if (module == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(25);
        }
        return (JSSimpleRecordTypeImpl)CachedValuesManager.getCachedValue((PsiElement)module, () -> CachedValueProvider.Result.create((Object)JSModuleTypeImpl.buildRecordTypeFromModuleExports(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    private static JSSimpleRecordTypeImpl buildRecordTypeFromModuleExports(@NotNull PsiElement module) {
        PsiElement aliased;
        JSElement defaultExport;
        if (module == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(26);
        }
        final ArrayList exportedMembers = new ArrayList();
        PsiScopeProcessor collectingProcessor = new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                exportedMembers.add(element);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/types/JSModuleTypeImpl$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        boolean isTypeScript = DialectDetector.isTypeScript(module);
        JSModuleElementsResolveProcessor exportedMembersProcessor = new JSModuleElementsResolveProcessor(collectingProcessor);
        ES6PsiUtil.processExportDeclarationInScope(module, exportedMembersProcessor);
        boolean isOptional = !isTypeScript;
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        for (PsiElement member : exportedMembers) {
            JSPsiNamedElementBase named = member instanceof JSPsiNamedElementBase ? (JSPsiNamedElementBase)member : null;
            if (named == null || StringUtil.isEmpty((String)named.getName())) continue;
            if (member instanceof JSRecordType.TypeMember) {
                typeMembers.add((JSRecordType.TypeMember)member);
                continue;
            }
            JSPsiBasedTypeOfType type = new JSPsiBasedTypeOfType((PsiElement)named, new JSEvaluateContext(named.getContainingFile()).withAstAccessForbidden());
            typeMembers.add(new PropertySignatureImpl(named.getName(), (JSType)type, isOptional, false, (PsiElement)named));
        }
        JSElement jSElement = defaultExport = module instanceof JSElement ? ES6PsiUtil.findDefaultExport(module) : null;
        if (defaultExport instanceof JSExportAssignment) {
            JSType type = ((JSExportAssignment)defaultExport).getJSType();
            typeMembers.add(JSModuleTypeImpl.getDefaultPropertyFromExportedElement(defaultExport, type, isOptional));
        } else if (defaultExport instanceof ES6ExportSpecifierAlias && (aliased = ((ES6ExportSpecifierAlias)defaultExport).findAliasedElement()) != null) {
            JSPsiBasedTypeOfType type = new JSPsiBasedTypeOfType(aliased, new JSEvaluateContext(aliased.getContainingFile()).withAstAccessForbidden());
            typeMembers.add(JSModuleTypeImpl.getDefaultPropertyFromExportedElement((JSElement)aliased, type, isOptional));
        }
        return new JSSimpleRecordTypeImpl(JSTypeSourceFactory.createTypeSource(module, true), typeMembers);
    }

    @NotNull
    private static JSRecordType.TypeMember getDefaultPropertyFromExportedElement(@NotNull JSElement exported, @Nullable JSType type, boolean isOptional) {
        if (exported == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(27);
        }
        return new PropertySignatureImpl("default", type, isOptional, true, (PsiElement)exported);
    }

    @NotNull
    public static List<PsiElement> resolveExportAssignmentLocally(@NotNull JSExportAssignment defaultExport) {
        String reference;
        if (defaultExport == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(28);
        }
        if ((reference = defaultExport.getInitializerReference()) != null) {
            List<PsiElement> list = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(reference, (PsiElement)defaultExport);
            if (list == null) {
                JSModuleTypeImpl.$$$reportNull$$$0(29);
            }
            return list;
        }
        JSElement element = defaultExport.getStubSafeElement();
        if (element != null) {
            List<JSElement> list = Collections.singletonList(element);
            if (list == null) {
                JSModuleTypeImpl.$$$reportNull$$$0(30);
            }
            return list;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14, 15, 16, 17, 18, 19, 22, 24, 29, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedContent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsModule";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSModuleTypeImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exported";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSModuleTypeImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedElements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskFromExportedElementTypes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesFromExportedElements";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveExportAssignmentLocally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTaskFromExportedElementTypes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypesFromExportedElements";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRecordTypeFromModuleExports";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromModuleExports";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropertyFromExportedElement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveExportAssignmentLocally";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14, 15, 16, 17, 18, 19, 22, 24, 29, 30, 31 -> new IllegalStateException(string);
        };
    }
}

