/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.resolve.InsertedString;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlTokenType;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"toleratedChangesKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/javascript/psi/resolve/InsertedString;", "getInsertedString", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "change", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "appendInsertedString", "currentString", "isToleratedChange", "", "insertedString", "isAcceptable", "element", "Lcom/intellij/psi/PsiElement;", "tagStart", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nTolerantPsiModificationTrackerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TolerantPsiModificationTrackerService.kt\ncom/intellij/lang/javascript/psi/resolve/TolerantPsiModificationTrackerServiceKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,197:1\n1069#2,2:198\n*S KotlinDebug\n*F\n+ 1 TolerantPsiModificationTrackerService.kt\ncom/intellij/lang/javascript/psi/resolve/TolerantPsiModificationTrackerServiceKt\n*L\n187#1:198,2\n*E\n"})
public final class TolerantPsiModificationTrackerServiceKt {
    @NotNull
    private static final Key<InsertedString> toleratedChangesKey = new Key("js.TolerantPsiModificationTracker.toleratedChanges");
    private static final Pattern tagStart = Pattern.compile("<[-\\w]*");

    private static final InsertedString getInsertedString(Project project, PsiFile psiFile, DocumentEvent change) {
        if (change.getOldLength() != 0 || change.getOffset() != change.getMoveOffset()) {
            return null;
        }
        long l = PsiModificationTracker.getInstance((Project)project).getModificationCount();
        int n = change.getOffset();
        CharSequence charSequence = change.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
        return new InsertedString(l, psiFile, n, charSequence);
    }

    private static final InsertedString appendInsertedString(InsertedString currentString, DocumentEvent change) {
        if (change.getOffset() != change.getMoveOffset()) {
            return null;
        }
        int offsetInInsertedString = change.getOffset() - currentString.getOffset();
        if (offsetInInsertedString < 0 || offsetInInsertedString > currentString.getNewFragment().length()) {
            return null;
        }
        int removedBound = offsetInInsertedString + change.getOldLength();
        if (removedBound > currentString.getNewFragment().length()) {
            return null;
        }
        long l = currentString.getBeforePsiModCount();
        PsiFile psiFile = currentString.getFile();
        int n = currentString.getOffset();
        CharSequence charSequence = currentString.getNewFragment();
        CharSequence charSequence2 = change.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getNewFragment(...)");
        return new InsertedString(l, psiFile, n, StringsKt.replaceRange((CharSequence)charSequence, (int)offsetInInsertedString, (int)removedBound, (CharSequence)charSequence2));
    }

    private static final boolean isToleratedChange(InsertedString insertedString) {
        PsiFile psiFile = insertedString.getFile();
        if (!psiFile.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE) && !DialectDetector.isJSX((PsiElement)psiFile)) {
            return false;
        }
        if (insertedString.getNewFragment().length() == 0) {
            return true;
        }
        PsiElement currentToken = psiFile.findElementAt(insertedString.getOffset());
        return tagStart.matcher(insertedString.getNewFragment()).matches() && (currentToken == null || TolerantPsiModificationTrackerServiceKt.isAcceptable(currentToken));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAcceptable(PsiElement element) {
        IElementType iElementType = element.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        if (element instanceof PsiWhiteSpace) {
            block3: {
                String string = ((PsiWhiteSpace)element).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                CharSequence $this$all$iv = string;
                boolean $i$f$all = false;
                int n = 0;
                while (n < $this$all$iv.length()) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(n);
                    boolean bl = false;
                    if (it == ' ' || it == '\t') {
                        ++n;
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            boolean bl = false;
            if (bl) return true;
        }
        if (element instanceof PsiComment) return true;
        if (Intrinsics.areEqual((Object)type, (Object)XmlTokenType.XML_START_TAG_START)) return true;
        if (Intrinsics.areEqual((Object)type, (Object)XmlTokenType.XML_TAG_NAME)) return true;
        if (Intrinsics.areEqual((Object)type, (Object)XmlTokenType.XML_NAME)) return true;
        if (Intrinsics.areEqual((Object)type, (Object)XmlTokenType.XML_DATA_CHARACTERS)) return true;
        if (!Intrinsics.areEqual((Object)type, (Object)XmlTokenType.XML_END_TAG_START)) return false;
        return true;
    }

    public static final /* synthetic */ Key access$getToleratedChangesKey$p() {
        return toleratedChangesKey;
    }

    public static final /* synthetic */ InsertedString access$getInsertedString(Project project, PsiFile psiFile, DocumentEvent change) {
        return TolerantPsiModificationTrackerServiceKt.getInsertedString(project, psiFile, change);
    }

    public static final /* synthetic */ InsertedString access$appendInsertedString(InsertedString currentString, DocumentEvent change) {
        return TolerantPsiModificationTrackerServiceKt.appendInsertedString(currentString, change);
    }

    public static final /* synthetic */ boolean access$isToleratedChange(InsertedString insertedString) {
        return TolerantPsiModificationTrackerServiceKt.isToleratedChange(insertedString);
    }
}

