/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSVariantRecordTypeConverter {
    @Nullable
    public static JSRecordType getTypeAsRecord(@Nullable JSType type, @Nullable PsiElement context2) {
        JSRecordType recordType;
        PsiElement sourceElement;
        JSRecordType mergedMembers;
        if (type == null) {
            return null;
        }
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type, context2)) instanceof JSRecordType) {
            return (JSRecordType)type;
        }
        if (type.getSource().isEcma()) {
            return null;
        }
        if ((type instanceof JSUnionType || type instanceof JSContextualUnionType) && (mergedMembers = JSVariantRecordTypeConverter.mergeMappedRecordTypes(type, context2, ((JSUnionOrIntersectionType)type).getTypes())) != null) {
            return mergedMembers;
        }
        if (context2 != null && (DialectDetector.isTypeScript(context2) || type.isTypeScript())) {
            return type.asRecordType();
        }
        if (context2 != null && type.isJavaScript() && ((sourceElement = type.getSource().getSourceElement()) != null && JSQualifiedNameResolver.isFromJSDoc(sourceElement) || sourceElement instanceof TypeScriptType) && (recordType = type.asRecordType()).hasProperties()) {
            return recordType;
        }
        Collection<TypeScriptInterface> classTypes = JSTypeUtils.getTypeScriptInterfaceInJavaScriptContext(type);
        return JSVariantRecordTypeConverter.buildSimpleRecordType(type, classTypes);
    }

    @Nullable
    private static JSRecordType mergeMappedRecordTypes(@NotNull JSType type, @Nullable PsiElement context2, @NotNull List<? extends JSType> types) {
        if (type == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(0);
        }
        if (types == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(1);
        }
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        for (JSType jSType : types) {
            JSRecordType record = JSVariantRecordTypeConverter.getTypeAsRecord(jSType, context2);
            if (record == null) continue;
            typeMembers.addAll(record.getTypeMembers());
        }
        if (!typeMembers.isEmpty()) {
            return JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(context2, () -> new JSRecordTypeImpl(type.getSource(), typeMembers));
        }
        return null;
    }

    @Nullable
    public static JSRecordType buildSimpleRecordType(@NotNull JSType type, Collection<? extends TypeScriptInterface> types) {
        if (type == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(2);
        }
        if (types.isEmpty()) {
            return null;
        }
        ArrayList<PropertySignatureImpl> recordMembers = new ArrayList<PropertySignatureImpl>();
        for (JSClass jSClass : types) {
            Collection<JSClass> parents = TypeScriptUtil.getNonStrictParents(jSClass, true);
            for (JSClass jsClass : parents) {
                Iterable<? extends JSElement> members = jsClass.getMembers();
                for (JSElement jSElement : members) {
                    String name;
                    if (!(jSElement instanceof JSFunction) && !(jSElement instanceof JSProperty) && !(jSElement instanceof TypeScriptPropertySignature) || (name = jSElement.getName()) == null) continue;
                    recordMembers.add(new PropertySignatureImpl(jSElement.getName(), null, false, false));
                }
            }
        }
        return new JSRecordTypeImpl(type.getSource(), recordMembers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSVariantRecordTypeConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeMappedRecordTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSimpleRecordType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

