/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTryStatementImpl
extends JSStatementImpl
implements JSTryStatement {
    public JSTryStatementImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    public JSStatement getStatement() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(type)) {
                return (JSStatement)child.getPsi();
            }
            if (type == JSTokenTypes.FINALLY_KEYWORD) break;
        }
        return null;
    }

    @Override
    @Nullable
    public JSCatchBlock getCatchBlock() {
        ASTNode catchChild = this.getNode().findChildByType(JSElementTypes.CATCH_BLOCK);
        if (catchChild == null) {
            return null;
        }
        return (JSCatchBlock)catchChild.getPsi();
    }

    @Override
    public JSCatchBlock @NotNull [] getAllCatchBlocks() {
        JSCatchBlock[] blocks = (JSCatchBlock[])PsiTreeUtil.getChildrenOfType((PsiElement)this, JSCatchBlock.class);
        JSCatchBlock[] jSCatchBlockArray = blocks != null ? blocks : JSCatchBlock.EMPTY_ARRAY;
        if (jSCatchBlockArray == null) {
            JSTryStatementImpl.$$$reportNull$$$0(0);
        }
        return jSCatchBlockArray;
    }

    @Override
    public JSStatement getFinallyStatement() {
        boolean foundFinally = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (foundFinally && JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(type)) {
                return (JSStatement)child.getPsi();
            }
            if (type != JSTokenTypes.FINALLY_KEYWORD) continue;
            foundFinally = true;
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSTryStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSTryStatement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public JSVarStatement getVarDeclaration() {
        ASTNode node = this.getNode().findChildByType(JSStubElementTypes.VAR_STATEMENT);
        return (JSVarStatement)(node != null ? node.getPsi() : null);
    }

    @Override
    public JSExpression getResourceExpression() {
        for (ASTNode child = this.getNode().findChildByType(JSTokenTypes.LPAR); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.RPAR) {
                return null;
            }
            if (!JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSTryStatementImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCatchBlocks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSTryStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

