/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSReferenceResolver;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSReferenceSetElement
implements PsiPolyVariantReference,
LocalQuickFixProvider {
    @NotNull
    protected final String myCanonicalText;
    @NotNull
    protected final TextRange myRangeInElement;
    @NotNull
    protected final JSReferenceSet mySet;

    protected JSReferenceSetElement(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSReferenceSetElement.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSReferenceSetElement.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            JSReferenceSetElement.$$$reportNull$$$0(2);
        }
        this.mySet = set;
        this.myCanonicalText = s;
        this.myRangeInElement = rangeInElement;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.mySet.getElement();
        if (psiElement == null) {
            JSReferenceSetElement.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            JSReferenceSetElement.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Nullable
    public final PsiElement resolve() {
        Object[] resolveResults = JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(this.mySet.getElement(), () -> this.multiResolve(false));
        if (resolveResults.length == 1) {
            return resolveResults[0].getElement();
        }
        if (resolveResults.length == 0) {
            return null;
        }
        int validElements = 0;
        PsiElement lastValid = null;
        for (ResolveResult resolveResult : resolveResults) {
            if (!resolveResult.isValidResult()) continue;
            ++validElements;
            lastValid = resolveResult.getElement();
        }
        if (validElements > 1) {
            return null;
        }
        if (validElements == 1) {
            return lastValid;
        }
        ResolveResult element = (ResolveResult)ArrayUtil.getLastElement((Object[])resolveResults);
        return element != null ? element.getElement() : null;
    }

    public final ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file = this.mySet.getElement().getContainingFile();
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(file, this, (reference, __) -> reference.doResolve(), incompleteCode);
        if (resolveResultArray == null) {
            JSReferenceSetElement.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    protected ResolveResult @NotNull [] doResolve() {
        ResolveResult[] resolveResultArray = this.doResolveQualifiedName(JSReferenceSetElement.getQualifierNameForResolve(this), false);
        if (resolveResultArray == null) {
            JSReferenceSetElement.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    public ResolveResult @NotNull [] doResolveQualifiedName(@NotNull JSQualifiedName qualifiedName, boolean ignorePerformanceLimit) {
        if (qualifiedName == null) {
            JSReferenceSetElement.$$$reportNull$$$0(7);
        }
        ResolveResult[] resolveResultArray = this.createResolver().doResolveQualifiedName(qualifiedName, ignorePerformanceLimit);
        if (resolveResultArray == null) {
            JSReferenceSetElement.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    @NotNull
    public JSReferenceResolver createResolver() {
        return new JSReferenceResolver(this.getElement());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            JSReferenceSetElement.$$$reportNull$$$0(9);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSReferenceSetElement.$$$reportNull$$$0(10);
        }
        return JSReferenceSetElement.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String qName;
        if (element == null) {
            JSReferenceSetElement.$$$reportNull$$$0(11);
        }
        if ((qName = JSPsiImplUtils.getQNameForMove(this.getElement(), element)) != null) {
            JSReferenceSetElement.handleContentChange(this.getElement(), new TextRange(this.mySet.myReferences[0].getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset()), qName);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            JSReferenceSetElement.$$$reportNull$$$0(12);
        }
        if (element instanceof PsiNamedElement || element instanceof XmlAttributeValue) {
            return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, this.myCanonicalText, element);
        }
        return false;
    }

    public boolean isPrimary() {
        return this.mySet.getReferences()[0] == this;
    }

    @Nullable
    public PsiReference getQualifier() {
        if (this.isPrimary()) {
            return null;
        }
        PsiReference qualifier = null;
        for (PsiReference reference : this.mySet.getReferences()) {
            if (reference == this) {
                return qualifier;
            }
            qualifier = reference;
        }
        return qualifier;
    }

    public boolean isSoft() {
        return this.mySet.isSoft();
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        return this.mySet.myLocalQuickFixProvider == null ? LocalQuickFix.EMPTY_ARRAY : this.mySet.myLocalQuickFixProvider.getQuickFixes();
    }

    @NotNull
    public JSQualifiedName getQualifiedName() {
        return this.getReferenceQualifiedName();
    }

    @NotNull
    protected final JSQualifiedName getReferenceQualifiedName() {
        JSQualifiedNameImpl qName = null;
        for (PsiReference ref2 : this.mySet.myReferences) {
            qName = JSQualifiedNameImpl.create(ref2.getCanonicalText(), qName);
            if (ref2 == this) break;
        }
        assert (qName != null) : this;
        JSQualifiedNameImpl jSQualifiedNameImpl = qName;
        if (jSQualifiedNameImpl == null) {
            JSReferenceSetElement.$$$reportNull$$$0(13);
        }
        return jSQualifiedNameImpl;
    }

    @NotNull
    public static JSQualifiedName getQualifierNameForResolve(@NotNull JSReferenceSetElement reference) {
        JSQualifiedName name;
        JSQualifiedName parent;
        if (reference == null) {
            JSReferenceSetElement.$$$reportNull$$$0(14);
        }
        if ((parent = (name = reference.getQualifiedName()).getParent()) == null && reference.getSet().getReferences()[0] != reference) {
            return reference.getReferenceQualifiedName();
        }
        JSQualifiedName jSQualifiedName = name;
        if (jSQualifiedName == null) {
            JSReferenceSetElement.$$$reportNull$$$0(15);
        }
        return jSQualifiedName;
    }

    protected static PsiElement handleContentChange(PsiElement elt, TextRange range, String newElementName) {
        return ElementManipulators.handleContentChange((PsiElement)elt, (TextRange)range, (String)newElementName);
    }

    @NotNull
    public JSReferenceSet getSet() {
        JSReferenceSet jSReferenceSet = this.mySet;
        if (jSReferenceSet == null) {
            JSReferenceSetElement.$$$reportNull$$$0(16);
        }
        return jSReferenceSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 9, 13, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveQualifiedName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceQualifiedName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierNameForResolve";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doResolveQualifiedName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierNameForResolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 9, 13, 15, 16 -> new IllegalStateException(string);
        };
    }
}

