/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLocalVariable;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceExpressionImpl
extends JSExpressionImpl
implements JSReferenceExpression,
BindablePsiReference {
    private static final TokenSet IDENTIFIER_TOKENS_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.IDENTIFIER_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.ANY_IDENTIFIER})});

    public JSReferenceExpressionImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    @Nullable
    public JSExpression getQualifier() {
        ASTNode node = JSReferenceExpressionImpl.getQualifierNode(this.getNode());
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public static ASTNode getQualifierNode(@NotNull ASTNode node) {
        if (node == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        return node.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
    }

    @Override
    @NotNull
    public JSReferenceExpression.Kind getReferenceKind() {
        IElementType elementType;
        ASTNode accessToken = this.getNode().findChildByType(JSElementTypes.REFERENCE_QUALIFIER_DELIMITERS);
        IElementType iElementType = elementType = accessToken == null ? null : accessToken.getElementType();
        if (elementType == JSTokenTypes.ELVIS) {
            JSReferenceExpression.Kind kind = JSReferenceExpression.Kind.ElvisAccess;
            if (kind == null) {
                JSReferenceExpressionImpl.$$$reportNull$$$0(1);
            }
            return kind;
        }
        if (elementType == JSTokenTypes.DOT) {
            JSReferenceExpression.Kind kind = JSReferenceExpression.Kind.PropertyAccess;
            if (kind == null) {
                JSReferenceExpressionImpl.$$$reportNull$$$0(2);
            }
            return kind;
        }
        JSReferenceExpression.Kind kind = JSReferenceExpression.Kind.Unknown;
        if (kind == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(3);
        }
        return kind;
    }

    @Override
    @Nullable
    public String getReferencedName() {
        return JSReferenceExpressionImpl.getReferenceName(this.getNode());
    }

    @Override
    @Nullable
    public String getReferenceName() {
        return this.getReferencedName();
    }

    @Override
    @Nullable
    public PsiElement getReferenceNameElement() {
        ASTNode element = JSReferenceExpressionImpl.getNameElement(this.getNode());
        return element != null ? element.getPsi() : null;
    }

    @Nullable
    public static String getReferenceName(@NotNull ASTNode referenceNode) {
        ASTNode nameElement;
        if (referenceNode == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        return (nameElement = JSReferenceExpressionImpl.getNameElement(referenceNode)) != null ? JSPsiImplUtils.getNameFromIdentifier(nameElement) : null;
    }

    @NotNull
    public PsiElement getElement() {
        JSReferenceExpressionImpl jSReferenceExpressionImpl = this;
        if (jSReferenceExpressionImpl == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(5);
        }
        return jSReferenceExpressionImpl;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode astNode = this.getNode();
        ASTNode nameElement = JSReferenceExpressionImpl.getNameElement(astNode);
        int startOffset = nameElement != null ? nameElement.getStartOffset() : astNode.getTextRange().getStartOffset();
        ASTNode signature = astNode.findChildByType(JSElementTypes.GENERIC_SIGNATURE);
        int endOffsetInParent = signature != null ? signature.getTextRange().getStartOffset() - astNode.getTextRange().getStartOffset() : this.getTextLength();
        return new TextRange(startOffset - astNode.getStartOffset(), endOffsetInParent);
    }

    public static ASTNode getNameElement(ASTNode node) {
        return node.findChildByType(IDENTIFIER_TOKENS_SET);
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 && resolveResults[0].isValidResult() ? resolveResults[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(7);
        }
        return this.handleElementRenameInternal(newElementName);
    }

    public PsiElement handleElementRenameInternal(String newElementName) throws IncorrectOperationException {
        int i = newElementName.lastIndexOf(46);
        if (i != -1) {
            newElementName = newElementName.substring(0, i);
        }
        if (!this.isIdentifierName(newElementName)) {
            throw new IncorrectOperationException("Invalid javascript element name:" + newElementName);
        }
        if (JSResolveUtil.isSelfReference((PsiElement)this)) {
            return this;
        }
        ASTNode astNode = this.getNode();
        JSChangeUtil.doIdentifierReplacement(astNode, JSReferenceExpressionImpl.getNameElement(astNode), newElementName, this.getProject());
        return this.getParent();
    }

    private boolean isIdentifierName(String name) {
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage())).createLexer(this.getProject());
        lexer.start((CharSequence)name);
        return JSKeywordSets.IDENTIFIER_NAMES.contains(lexer.getTokenType()) && lexer.getTokenEnd() == name.length();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        JSClass jsClass;
        ASTNode node;
        PsiElement parent;
        if (element == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(8);
        }
        if (((parent = this.getParent()) instanceof JSClass || parent instanceof JSNamespaceDeclaration || parent instanceof JSFunction) && (node = ((JSNamedElement)parent).findNameIdentifier()) != null && node.getPsi() == this && (parent == element || element instanceof PsiFile)) {
            return this;
        }
        if (parent instanceof JSNewExpression && element instanceof JSFunction && (jsClass = ES6PsiUtil.getES6ConstructorClass(element)) != null) {
            return JSReferenceExpressionImpl.bindToElement(this, jsClass.getName(), jsClass, false);
        }
        String qName = JSPsiImplUtils.getQNameForMove((PsiElement)this, element);
        return JSReferenceExpressionImpl.bindToElement(this, qName, (PsiNamedElement)element, false);
    }

    @Nullable
    protected String getNameToBind(@NotNull PsiNamedElement element) {
        if (element == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(9);
        }
        return JSReferenceExpressionImpl.getNameToBindInternal(element);
    }

    @Nullable
    private static String getNameToBindInternal(@NotNull PsiNamedElement element) {
        String name;
        if (element == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(10);
        }
        if ((name = element.getName()) == null) {
            return null;
        }
        if (element instanceof CssClass) {
            name = CssClass.kebabToCamelCase((String)name);
        }
        return element instanceof PsiFile ? FileUtilRt.getNameWithoutExtension((String)name) : name;
    }

    public static JSReferenceExpression bindToElement(JSReferenceExpression ref2, @Nullable String qName, @NotNull PsiNamedElement element, boolean justMakeQualified) {
        String newName;
        if (element == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(11);
        }
        if (ref2 instanceof JSReferenceExpressionImpl) {
            JSReferenceExpressionImpl impl = (JSReferenceExpressionImpl)ref2;
            v0 = impl.getNameToBind(element);
        } else {
            v0 = newName = JSReferenceExpressionImpl.getNameToBindInternal(element);
        }
        if (newName == null) {
            return ref2;
        }
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            ref2 = helper.bindReferenceToElement(ref2, qName, newName, justMakeQualified, element);
        }
        if (!newName.equals(ref2.getReferencedName())) {
            ASTNode nameElement = JSInheritedLanguagesHelper.createNameIdentifierFromText(newName, (PsiElement)ref2);
            ASTNode refNode = ref2.getNode();
            refNode.replaceChild(JSReferenceExpressionImpl.getNameElement(refNode), nameElement);
        }
        return ref2;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        boolean hasQualifier;
        if (element == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(12);
        }
        boolean bl = hasQualifier = this.getQualifier() != null;
        if (hasQualifier && element instanceof JSVariable && !(element instanceof JSField) && !JSClassUtils.isClassMember(element) && !((JSVariable)element).isExported() && !((JSVariable)element).isExportedWithDefault()) {
            return false;
        }
        if (element instanceof JSNamedElement && DialectDetector.isActionScript(element) != DialectDetector.isActionScript((PsiElement)this)) {
            return false;
        }
        if (JSResolveUtil.isSameReference(this, element) && !(element instanceof JSLocalVariable)) {
            return false;
        }
        if (element instanceof PsiFile && !DialectDetector.isActionScript((PsiElement)this)) {
            return false;
        }
        if (element instanceof PsiNamedElement || element instanceof XmlAttributeValue || element instanceof ES6ExportDefaultAssignment) {
            if (this.isReferenceToElement(element)) {
                return true;
            }
            if (DialectDetector.isActionScript((PsiElement)this)) {
                return false;
            }
            if (JSUseScopeProvider.isLexicalScopeElement(element) && element.getUseScope() instanceof LocalSearchScope) {
                return false;
            }
            String referencedName = this.getReferencedName();
            if (element instanceof JSPsiElementBase && referencedName != null && referencedName.equals(((JSPsiElementBase)element).getName())) {
                PsiElement parent = this.getParent();
                if (parent instanceof JSDefinitionExpression) {
                    JSDefinitionExpression parentAsDefinition = (JSDefinitionExpression)parent;
                    if (!JSResolveUtil.isDummyResolve(this)) {
                        return false;
                    }
                    return JSSymbolUtil.canElementsBeFromSameNamespace(parentAsDefinition, (JSPsiElementBase)element);
                }
                if (element instanceof JSDefinitionExpression || element instanceof JSProperty) {
                    if (hasQualifier && JSSymbolUtil.canElementBeFromAnyNamespace((JSQualifiedNamedElement)element)) {
                        return true;
                    }
                    ResolveResult[] assignedElements = JSReferenceExpressionImpl.resolveAssignedElements((JSQualifiedNamedElement)element);
                    if (this.resolveResultsOverlap(assignedElements)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean isReferenceToElement(@NotNull PsiElement element) {
        if (element == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(13);
        }
        String referencedName = this.getReferencedName();
        return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, referencedName, element);
    }

    private static ResolveResult @NotNull [] resolveAssignedElements(@NotNull JSQualifiedNamedElement definitionOrProperty) {
        if (definitionOrProperty == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(14);
        }
        JSReferenceExpression ref2 = null;
        if (definitionOrProperty instanceof JSDefinitionExpression) {
            PsiReference textReference;
            JSExpression indexExpression;
            JSExpression expression = ((JSDefinitionExpression)definitionOrProperty).getExpression();
            if (expression instanceof JSReferenceExpression) {
                ref2 = (JSReferenceExpression)expression;
            } else if (expression instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression()) instanceof JSLiteralExpression && (textReference = indexExpression.getReference()) instanceof JSTextReference) {
                ref2 = (PsiPolyVariantReference)textReference;
            }
        } else if (definitionOrProperty instanceof JSProperty) {
            ref2 = new PsiMultiReference(definitionOrProperty.getReferences(), (PsiElement)definitionOrProperty);
        }
        ResolveResult[] resolveResultArray = ref2 != null ? ref2.multiResolve(false) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(15);
        }
        return resolveResultArray;
    }

    private boolean resolveResultsOverlap(ResolveResult @NotNull [] otherResults) {
        ResolveResult[] thisResults;
        if (otherResults == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(16);
        }
        if (otherResults.length == 0) {
            return false;
        }
        for (ResolveResult thisResult : thisResults = this.multiResolve(false)) {
            for (ResolveResult otherResult : otherResults) {
                if (!thisResult.isValidResult() || !otherResult.isValidResult() || !Objects.equals(thisResult.getElement(), otherResult.getElement())) continue;
                return true;
            }
        }
        return false;
    }

    public static void doProcessLocalDeclarations(@NotNull PsiElement context2, @Nullable JSExpression qualifier, ResolveProcessor processor, boolean ecma, boolean completion, Boolean forceInTypeContext) {
        if (context2 == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(17);
        }
        JSReferenceExpressionImpl.doProcessLocalDeclarations(context2, qualifier, processor, ecma, completion, forceInTypeContext, null);
    }

    public static void doProcessLocalDeclarations(@NotNull PsiElement context2, @Nullable JSExpression qualifier, ResolveProcessor processor, boolean ecma, boolean completion, Boolean forceInTypeContext, PsiElement forceStopElement) {
        boolean toProcessHierarchy;
        if (context2 == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(18);
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext(context2, qualifier instanceof JSThisExpression);
        if (qualifier instanceof JSThisExpression && ES6PsiUtil.isInsideDecorator((PsiElement)qualifier)) {
            jsClass = JSResolveUtil.getClassOfContext(jsClass, true);
        }
        boolean inTypeContext = JSReferenceExpressionImpl.isTypeContext(context2, forceInTypeContext);
        boolean whereTypeCanBe = JSReferenceExpressionImpl.isWhereTypeCanBe(context2, qualifier, ecma, completion, inTypeContext);
        PsiElement elToProcess = context2;
        JSClass scopeToStopAt = null;
        PsiElement parent = context2.getParent();
        boolean strictClassOffset = JSResolveUtil.getTopReferenceParent(parent) instanceof JSImportStatement;
        boolean toProcessMembers = !strictClassOffset;
        boolean bl = toProcessHierarchy = qualifier != null || !inTypeContext || parent instanceof JSNewExpression;
        if (qualifier != null) {
            elToProcess = jsClass;
            if (jsClass == null) {
                if (qualifier instanceof JSThisExpression) {
                    if (ecma) {
                        nearestFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context2, JSFunction.class);
                        elToProcess = nearestFunction != null && !(nearestFunction instanceof JSFunctionExpression) ? nearestFunction : context2;
                    } else {
                        elToProcess = PsiTreeUtil.getParentOfType((PsiElement)context2, JSProperty.class);
                        if (elToProcess != null) {
                            scopeToStopAt = elToProcess.getParent();
                        }
                    }
                } else if (qualifier instanceof JSSuperExpression) {
                    elToProcess = JSResolveUtil.getClassFromTagNameInMxml(context2);
                }
            }
        } else if (ecma && whereTypeCanBe) {
            if (inTypeContext) {
                if (parent instanceof JSAttributeList && JSResolveUtil.findParent(parent.getParent()) instanceof JSBlockStatement) {
                    toProcessHierarchy = true;
                }
                if (!(parent instanceof JSNewExpression || parent instanceof JSAttributeList || parent instanceof JSBinaryExpression || parent instanceof JSUseNamespaceDirective)) {
                    toProcessMembers = false;
                    nearestFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)context2, JSFunction.class);
                    JSClass jSClass = elToProcess = nearestFunction != null ? nearestFunction.getFirstChild() : jsClass;
                }
                if (completion) {
                    JSReferenceExpressionImpl.addImplicitActionScriptTypes(context2, processor, parent);
                }
            } else if (parent instanceof JSExpressionStatement && JSResolveUtil.isPlaceWhereNsCanBe(parent)) {
                toProcessMembers = false;
                elToProcess = null;
            }
        }
        if ((qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) && jsClass != null) {
            JSFunctionExpression expression;
            scopeToStopAt = jsClass;
            if (ecma && (expression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)context2, JSFunctionExpression.class)) != null) {
                elToProcess = expression.getFirstChild();
            }
        }
        if (jsClass != null && (DialectDetector.isTypeScript(context2) || DialectDetector.isES6(context2))) {
            boolean contextSensitive;
            toProcessHierarchy = qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression || jsClass instanceof TypeScriptEnum;
            toProcessMembers = toProcessHierarchy;
            boolean bl2 = contextSensitive = qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression || qualifier == null;
            if (contextSensitive) {
                processor.getAccessibilityProcessingHandler().setProcessStatics(JSResolveUtil.calculateStaticFromContext(context2));
            }
        }
        if (ecma && elToProcess == null && whereTypeCanBe && (elToProcess = PsiTreeUtil.getParentOfType((PsiElement)context2, (Class[])new Class[]{JSPackageStatement.class, JSFile.class})) != null && (elToProcess = PsiTreeUtil.getChildOfType((PsiElement)elToProcess, PsiWhiteSpace.class)) == null) {
            elToProcess = context2;
        }
        processor.setTypeContext(whereTypeCanBe || qualifier == null && parent instanceof JSReferenceExpression || strictClassOffset);
        processor.setToProcessMembers(toProcessMembers);
        if (elToProcess != null) {
            processor.setToProcessHierarchy(toProcessHierarchy);
            processor.setToSkipClassDeclarationsOnce(qualifier instanceof JSSuperExpression);
            if (ecma) {
                processor.getAccessibilityProcessingHandler().setProcessStatics(JSReferenceExpressionImpl.isStaticContext(elToProcess));
            }
            boolean wasWalkingUpTree = processor.setWalkingUpTree(true);
            JSResolveUtil.treeWalkUp(processor, elToProcess, elToProcess, context2, forceStopElement == null ? scopeToStopAt : forceStopElement);
            processor.setWalkingUpTree(wasWalkingUpTree);
            processor.setToProcessHierarchy(false);
            processor.setToSkipClassDeclarationsOnce(false);
            processor.getAccessibilityProcessingHandler().setProcessStatics(false);
        }
    }

    private static void addImplicitActionScriptTypes(@NotNull PsiElement context2, @NotNull ResolveProcessor processor, @Nullable PsiElement parent) {
        if (context2 == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(20);
        }
        if (parent instanceof JSVariable || parent instanceof JSFunction || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext()) {
            PsiFile containingFile = context2.getContainingFile();
            JSImplicitElementImpl element = new JSImplicitElementImpl("*", null, (PsiElement)containingFile);
            processor.execute((PsiElement)element, ResolveState.initial());
            if (parent instanceof JSFunction || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext()) {
                element = new JSImplicitElementImpl("void", null, (PsiElement)containingFile);
                processor.execute((PsiElement)element, ResolveState.initial());
            }
        }
    }

    public static boolean isWhereTypeCanBe(@NotNull PsiElement context2, @Nullable JSExpression qualifier, boolean ecma, boolean completion, boolean inTypeContext) {
        if (context2 == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(21);
        }
        return inTypeContext || qualifier == null && DialectDetector.isTypeScript(context2) || completion && ecma && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion(context2);
    }

    public static boolean isTypeContext(@Nullable PsiElement context2, Boolean forceInTypeContext) {
        return forceInTypeContext != null ? forceInTypeContext : context2 instanceof JSReferenceExpression && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)context2);
    }

    private static boolean isStaticContext(PsiElement element) {
        PsiElement p;
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSVariable.class, JSFunction.class, JSClass.class, JSFile.class});
        if (parent instanceof JSClass) {
            return true;
        }
        if (parent instanceof JSFile) {
            PsiElement context2 = parent.getContext();
            if (context2 instanceof XmlText) {
                context2 = context2.getParent();
            }
            if (context2 instanceof XmlTag && "Script".equals(((XmlTag)context2).getLocalName())) {
                return true;
            }
        }
        return parent instanceof JSFunction && (p = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class, JSAttributeList.class})) == ((JSFunction)parent).getAttributeList();
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(22);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSReferenceExpression(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file = this.getContainingFile();
        ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)this).createReferenceExpressionResolver(this, false);
        ResolveResult[] resolveResultArray = JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)file, () -> JSResolveUtil.resolve(file, this, resolver, incompleteCode));
        if (resolveResultArray == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(23);
        }
        return resolveResultArray;
    }

    @Nullable
    public static JSReferenceExpression getNamespaceReference(JSReferenceExpression thisElement) {
        PsiElement parent = thisElement.getParent();
        if (parent instanceof JSE4XNamespaceReference) {
            return ((JSE4XNamespaceReference)parent).getNamespaceReference();
        }
        return thisElement.getNamespaceElement();
    }

    @Override
    public boolean shouldCheckReferences() {
        return true;
    }

    @Override
    public boolean isAttributeReference() {
        return this.getNode().findChildByType(JSTokenTypes.AT) != null;
    }

    @Override
    public JSReferenceExpression getNamespaceElement() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.E4X_NAMESPACE_REFERENCE);
        return node == null ? null : ((JSE4XNamespaceReference)node.getPsi()).getNamespaceReference();
    }

    public static ResolveResult[] resolveUnqualified(@NotNull String referenceName, PsiElement context2, Boolean forceInTypeContext) {
        if (referenceName == null) {
            JSReferenceExpressionImpl.$$$reportNull$$$0(24);
        }
        SinkResolveProcessor<ResolveResultSink> resolveProcessor = new SinkResolveProcessor<ResolveResultSink>(referenceName, context2, new ResolveResultSink(context2, referenceName)){

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof JSQualifiedNamedElement)) {
                    return true;
                }
                super.execute(element, state);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        resolveProcessor.setNeedsAllVariants();
        resolveProcessor.setForceImportsForPlace(!(context2 instanceof JSReferenceExpressionImpl));
        boolean ecma = context2.getContainingFile().getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4);
        JSReferenceExpressionImpl.doProcessLocalDeclarations(context2, null, resolveProcessor, ecma, false, forceInTypeContext);
        HashMap<String, ResolveResult> uniqueResults = new HashMap<String, ResolveResult>();
        for (ResolveResult result2 : resolveProcessor.getResultsAsResolveResults()) {
            String qname = ((JSQualifiedNamedElement)result2.getElement()).getQualifiedName();
            ResolveResult existing = (ResolveResult)uniqueResults.get(qname);
            if (existing != null && (((JSResolveResult)existing).getActionScriptImport() == null || ((JSResolveResult)result2).getActionScriptImport() != null)) continue;
            uniqueResults.put(qname, result2);
        }
        return !uniqueResults.isEmpty() ? uniqueResults.values().toArray(ResolveResult.EMPTY_ARRAY) : ResolveResult.EMPTY_ARRAY;
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof JSReferenceListMember) {
            parent.delete();
        } else {
            super.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 15, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionOrProperty";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherResults";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceKind";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAssignedElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNameToBind";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNameToBindInternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveAssignedElements";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveResultsOverlap";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doProcessLocalDeclarations";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitActionScriptTypes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isWhereTypeCanBe";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveUnqualified";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 15, 23 -> new IllegalStateException(string);
        };
    }
}

