/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitMemberForComputedPropertyImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptMergedTypeImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptClassBase<StubT extends JSQualifiedStub<?>>
extends JSClassBase<StubT>
implements TypeScriptTypeParameterListOwner,
TypeScriptInterfaceClass {
    private static final Key<ParameterizedCachedValue<JSClass[], JSClass>> SUPER_CLASSES_CACHE_KEY = Key.create((String)"ts.super.classes");
    private static final ParameterizedCachedValueProvider<JSClass[], JSClass> SUPER_CLASSES_CACHE_PROVIDER = param -> {
        JSReferenceList extendsList = param.getExtendsList();
        JSClass[] classes = extendsList != null ? extendsList.getReferencedClasses() : JSClass.EMPTY_ARRAY;
        return CachedValueProvider.Result.create((Object)classes, (Object[])new Object[]{param, JSTypeUtils.getTypeInvalidationDependency()});
    };

    protected TypeScriptClassBase(ASTNode node) {
        super(node);
    }

    public TypeScriptClassBase(StubT stub, IStubElementType<StubT, ?> aClass) {
        super(stub, aClass);
    }

    @Override
    public JSClass @NotNull [] getSuperClasses() {
        JSClass[] jSClassArray = (JSClass[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, SUPER_CLASSES_CACHE_KEY, SUPER_CLASSES_CACHE_PROVIDER, false, (Object)this);
        if (jSClassArray == null) {
            TypeScriptClassBase.$$$reportNull$$$0(0);
        }
        return jSClassArray;
    }

    @Override
    @Nullable
    public TypeScriptTypeParameterList getTypeParameterList() {
        return (TypeScriptTypeParameterList)this.getStubOrPsiChild(TypeScriptStubElementTypes.TYPE_PARAMETER_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        ResolveProcessor resolveProcessor;
        if (processor == null) {
            TypeScriptClassBase.$$$reportNull$$$0(1);
        }
        if (state == null) {
            TypeScriptClassBase.$$$reportNull$$$0(2);
        }
        if (place == null) {
            TypeScriptClassBase.$$$reportNull$$$0(3);
        }
        if ((resolveProcessor = TypeScriptClassBase.getResolveProcessor(processor)) != null && resolveProcessor.checkVisited(this)) {
            return true;
        }
        if (!TypeScriptClassBase.processTypeAndTypeParameters(processor, lastParent, this, state, place)) {
            return false;
        }
        if (lastParent == null) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        int savedNestingLevel = -1;
        if (resolveProcessor instanceof SinkResolveProcessor && lastParent instanceof ES6Class) {
            Object sink = ((SinkResolveProcessor)processor).getResultSink();
            savedNestingLevel = ((ResultSink)sink).getNestingLevel();
            ((ResultSink)sink).setNestingLevel(savedNestingLevel + 1);
        }
        try {
            boolean toProcessMembers;
            boolean bl = toProcessMembers = resolveProcessor == null || !resolveProcessor.isToSkipClassDeclarationOnce() && resolveProcessor.isToProcessMembers();
            if (toProcessMembers) {
                if (!this.processMembers(processor, state, lastParent, place)) {
                    List<PsiElement> results;
                    if (processor instanceof SinkResolveProcessor && QualifiedItemProcessor.hasOnlyIndexers(results = ((SinkResolveProcessor)processor).getResults())) {
                        boolean bl2 = TypeScriptClassBase.processSupers(this, processor, state, lastParent, place);
                        return bl2;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
            } else {
                resolveProcessor.setToSkipClassDeclarationsOnce(false);
            }
        }
        finally {
            if (savedNestingLevel != -1) {
                ((ResultSink)((SinkResolveProcessor)resolveProcessor).getResultSink()).setNestingLevel(savedNestingLevel);
            }
        }
        return TypeScriptClassBase.processSupers(this, processor, state, lastParent, place);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processSupers(@NotNull TypeScriptInterfaceClass startClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (startClass == null) {
            TypeScriptClassBase.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            TypeScriptClassBase.$$$reportNull$$$0(5);
        }
        if (state == null) {
            TypeScriptClassBase.$$$reportNull$$$0(6);
        }
        if (place == null) {
            TypeScriptClassBase.$$$reportNull$$$0(7);
        }
        if (lastParent == null) {
            return true;
        }
        ResolveProcessor resolveProcessor = TypeScriptClassBase.getResolveProcessor(processor);
        if (resolveProcessor == null || !((ResolveProcessor)processor).isToProcessHierarchy() || JSUtils.isPrivateNameReference(place)) {
            return true;
        }
        int savedNestingLevel = 0;
        if (processor instanceof SinkResolveProcessor) {
            Object sink = ((SinkResolveProcessor)processor).getResultSink();
            savedNestingLevel = ((ResultSink)sink).getNestingLevel();
            ((ResultSink)sink).setNestingLevel(savedNestingLevel + 1);
        }
        boolean savedProcessStatics = resolveProcessor.getAccessibilityProcessingHandler().isProcessStatics();
        processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_STARTED, (Object)startClass);
        try {
            JSTypeSubstitutor jsTypeSubstitutor = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)((JSTypeSubstitutor)state.get(JSResolveResult.GENERICS)), (Object)JSTypeSubstitutor.EMPTY);
            boolean result2 = JSClassUtils.processClassesInHierarchy(startClass, true, (currentClass, typeSubstitutor, fromImplements, fromStaticContext, nestedLevel) -> {
                if (currentClass == startClass || fromImplements || fromStaticContext && !savedProcessStatics) {
                    return true;
                }
                ResolveState newState = typeSubstitutor.isEmpty() ? state : state.put(JSResolveResult.GENERICS, (Object)typeSubstitutor);
                resolveProcessor.getAccessibilityProcessingHandler().setProcessStatics(!fromStaticContext && savedProcessStatics);
                try {
                    boolean bl = TypeScriptQualifiedItemProcessor.processNamespaceChildren(resolveProcessor, newState, lastParent, place, currentClass);
                    return bl;
                }
                finally {
                    resolveProcessor.getAccessibilityProcessingHandler().setProcessStatics(savedProcessStatics);
                }
            }, (Condition<? super JSClass>)Conditions.alwaysTrue(), jsTypeSubstitutor, 1);
            if (!result2) {
                boolean bl = false;
                return bl;
            }
            if (!savedProcessStatics && !TypeScriptClassBase.processNonClassExtendsItem(startClass, processor, state)) {
                boolean bl = false;
                return bl;
            }
            if (processor instanceof SinkResolveProcessor) {
                ((ResultSink)((SinkResolveProcessor)processor).getResultSink()).setNestingLevel(10);
            }
            resolveProcessor.getAccessibilityProcessingHandler().setProcessStatics(false);
            String baseClassName = TypeScriptClassBase.getBaseClassName(savedProcessStatics, startClass);
            boolean bl = TypeScriptClassBase.processClassByQName(baseClassName, place, resolveProcessor, state, lastParent, place);
            return bl;
        }
        finally {
            resolveProcessor.getAccessibilityProcessingHandler().setProcessStatics(savedProcessStatics);
            if (processor instanceof SinkResolveProcessor) {
                ((ResultSink)((SinkResolveProcessor)processor).getResultSink()).setNestingLevel(savedNestingLevel);
            }
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_FINISHED, (Object)startClass);
        }
    }

    public static boolean processNonClassExtendsItem(@NotNull TypeScriptInterfaceClass startClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        boolean allowPreservingSource;
        JSType type;
        if (startClass == null) {
            TypeScriptClassBase.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            TypeScriptClassBase.$$$reportNull$$$0(9);
        }
        if (state == null) {
            TypeScriptClassBase.$$$reportNull$$$0(10);
        }
        if (!(processor instanceof JSResolveProcessor)) {
            return true;
        }
        String name = ((JSResolveProcessor)processor).getName();
        JSReferenceList extendsList = startClass.getExtendsList();
        if (extendsList == null) {
            return true;
        }
        JSReferenceListMember[] members = extendsList.getMembers();
        if (members.length != 1) {
            return true;
        }
        String text = members[0].getReferenceText();
        if (text == null) {
            JSResolvedTypeInfo info;
            type = JSResolveUtil.getExpressionJSType(members[0].getExpression());
            if (type instanceof JSResolvableType && !(info = ((JSResolvableType)type).resolveType()).getDeclarationsOfType(JSClass.class).isEmpty()) {
                return true;
            }
            allowPreservingSource = true;
        } else {
            allowPreservingSource = false;
            JSTypeResolveResult resolved = JSDialectSpecificHandlersFactory.forElement(startClass).getImportHandler().resolveName(text, startClass);
            if (!resolved.hasElements()) {
                return true;
            }
            PsiElement next = resolved.getElements().iterator().next();
            if (next == null || next instanceof JSClass) {
                return true;
            }
            type = JSResolveUtil.getElementJSType(next);
        }
        if (type == null) {
            return true;
        }
        JSRecordType recordType = type.asRecordType();
        List signatures2 = ContainerUtil.filter(recordType.getCallSignatures(), s -> s.hasNew());
        for (JSRecordType.CallSignature signature : signatures2) {
            JSRecordType.PropertySignature propertySignature;
            JSType returnType = signature.getReturnType();
            if (returnType == null) continue;
            JSRecordType asRecordType = returnType.asRecordType();
            JSRecordType.PropertySignature propertySignature2 = propertySignature = name == null ? null : asRecordType.findPropertySignature(name);
            if (propertySignature != null) {
                return TypeScriptClassBase.addProp(processor, startClass, state, name, propertySignature, allowPreservingSource);
            }
            for (JSRecordType.PropertySignature property : asRecordType.getProperties()) {
                TypeScriptClassBase.addProp(processor, startClass, state, property.getMemberName(), property, allowPreservingSource);
            }
        }
        return true;
    }

    private static boolean addProp(@NotNull PsiScopeProcessor processor, @NotNull TypeScriptInterfaceClass startClass, @NotNull ResolveState state, @NotNull String name, @NotNull JSRecordType.PropertySignature propertySignature, boolean allowPreservingSource) {
        JSRecordType.MemberSource memberSource;
        PsiElement element;
        if (processor == null) {
            TypeScriptClassBase.$$$reportNull$$$0(11);
        }
        if (startClass == null) {
            TypeScriptClassBase.$$$reportNull$$$0(12);
        }
        if (state == null) {
            TypeScriptClassBase.$$$reportNull$$$0(13);
        }
        if (name == null) {
            TypeScriptClassBase.$$$reportNull$$$0(14);
        }
        if (propertySignature == null) {
            TypeScriptClassBase.$$$reportNull$$$0(15);
        }
        if ((element = (memberSource = propertySignature.getMemberSource()).getSingleElement()) == null) {
            return processor.execute((PsiElement)new JSLocalImplicitElementImpl(name, propertySignature.getJSType(), startClass, JSImplicitElement.Type.Property), state);
        }
        if (element instanceof JSAttributeListOwner && JSPsiImplUtils.hasModifier((JSAttributeListOwner)element, JSAttributeList.ModifierType.ABSTRACT)) {
            return true;
        }
        if (allowPreservingSource && memberSource.isIdentity()) {
            return processor.execute(element, state);
        }
        return processor.execute((PsiElement)new TypeScriptMergedTypeImplicitElementImpl(name, propertySignature.getJSType(), element, element instanceof JSConstStatusOwner && ((JSConstStatusOwner)element).isConst(), element instanceof JSOptionalOwner && ((JSOptionalOwner)element).isOptional(), false, JSRecordType.MemberSourceKind.MappedNoStatus), state);
    }

    @NotNull
    protected static String getBaseClassName(boolean savedProcessStatics, TypeScriptInterfaceClass context2) {
        return savedProcessStatics || context2.hasCallSignature() ? JSTypeUtils.getFunctionTypeName(context2.getContainingFile(), true) : "Object";
    }

    @Nullable
    public static ResolveProcessor getResolveProcessor(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            TypeScriptClassBase.$$$reportNull$$$0(16);
        }
        return processor instanceof ResolveProcessor ? (ResolveProcessor)processor : null;
    }

    public static boolean processTypeAndTypeParameters(PsiScopeProcessor processor, @Nullable PsiElement lastParent, @NotNull TypeScriptTypeParameterListOwner owner, @NotNull ResolveState state, @NotNull PsiElement place) {
        ResolveProcessor resolveProcessor;
        boolean typeContext;
        if (owner == null) {
            TypeScriptClassBase.$$$reportNull$$$0(17);
        }
        if (state == null) {
            TypeScriptClassBase.$$$reportNull$$$0(18);
        }
        if (place == null) {
            TypeScriptClassBase.$$$reportNull$$$0(19);
        }
        boolean bl = typeContext = (resolveProcessor = TypeScriptClassBase.getResolveProcessor(processor)) != null && resolveProcessor.isTypeContext();
        if (typeContext || lastParent == null) {
            TypeScriptTypeParameterList typeParameterList;
            if (typeContext && lastParent != null && (typeParameterList = owner.getTypeParameterList()) != null && !typeParameterList.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            if (!processor.execute((PsiElement)owner, state)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasCallSignature() {
        return false;
    }

    public static boolean processClassByQName(@NotNull String qName, @NotNull PsiElement resolvePlace, ResolveProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (qName == null) {
            TypeScriptClassBase.$$$reportNull$$$0(20);
        }
        if (resolvePlace == null) {
            TypeScriptClassBase.$$$reportNull$$$0(21);
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(qName, resolvePlace);
        boolean result2 = true;
        for (JSQualifiedNamedElement element : elements) {
            result2 &= TypeScriptQualifiedItemProcessor.processNamespaceChildren(processor, state, lastParent, place, (PsiElement)element);
        }
        return result2;
    }

    @Override
    protected boolean processMembers(PsiScopeProcessor processor, ResolveState substitutor, PsiElement lastParent, PsiElement place) {
        boolean result2 = super.processMembers(processor, substitutor, lastParent, place);
        if (!result2) {
            return false;
        }
        if (JSUtils.isPrivateNameReference(place)) {
            return true;
        }
        return TypeScriptClassBase.processIndexSignatureAndComputedNameMembers(processor, substitutor, this.getMembers(), this.getIndexSignatures());
    }

    static boolean processIndexSignatureAndComputedNameMembers(@Nullable PsiScopeProcessor processor, @NotNull ResolveState substitutor, @NotNull Iterable<? extends JSElement> members, TypeScriptIndexSignature @NotNull [] indexSignatures) {
        if (substitutor == null) {
            TypeScriptClassBase.$$$reportNull$$$0(22);
        }
        if (members == null) {
            TypeScriptClassBase.$$$reportNull$$$0(23);
        }
        if (indexSignatures == null) {
            TypeScriptClassBase.$$$reportNull$$$0(24);
        }
        if (processor instanceof JSResolveProcessor) {
            boolean staticsOnly = processor instanceof QualifiedItemProcessor && ((QualifiedItemProcessor)processor).getAccessibilityProcessingHandler().isProcessStatics();
            String name = ((JSResolveProcessor)processor).getName();
            if (name != null) {
                for (JSElement jSElement : members) {
                    JSStringLiteralTypeImpl literalType;
                    JSType type;
                    if (staticsOnly && jSElement instanceof JSElementBase && ((JSElementBase)((Object)jSElement)).getJSContext() == JSContext.INSTANCE || (type = TypeScriptLiteralKeyUtil.getTypeForComputedNameMember(literalType = new JSStringLiteralTypeImpl(name, false, JSTypeSourceFactory.createTypeSource((PsiElement)jSElement, true)), (PsiElement)jSElement, null)) == null || processor.execute((PsiElement)new TypeScriptImplicitMemberForComputedPropertyImpl(name, type, (PsiElement)jSElement, false), substitutor)) continue;
                    return false;
                }
                for (TypeScriptIndexSignature signature : indexSignatures) {
                    if (processor.execute((PsiElement)signature, substitutor)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected TypeScriptIndexSignature[] getIndexSignatures() {
        return (TypeScriptIndexSignature[])this.getStubOrPsiChildren(TypeScriptStubElementTypes.INDEX_SIGNATURE, TypeScriptIndexSignature.ARRAY_FACTORY);
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSQualifiedStub stub = (JSQualifiedStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return TypeScriptPsiUtil.isTopLevelContainerMember(this);
    }

    @Override
    public TypeScriptFunction @NotNull [] findFunctionsByNameAndKind(@Nullable String name, @Nullable JSFunction.FunctionKind kind) {
        Map<String, Object> functions = this.getFunctionsMap();
        Object o = functions.get(name);
        if (o instanceof TypeScriptFunction) {
            TypeScriptFunction[] typeScriptFunctionArray;
            TypeScriptFunction function = (TypeScriptFunction)o;
            if (kind == null || function.getKind() == kind) {
                TypeScriptFunction[] typeScriptFunctionArray2 = new TypeScriptFunction[1];
                typeScriptFunctionArray = typeScriptFunctionArray2;
                typeScriptFunctionArray2[0] = function;
            } else {
                typeScriptFunctionArray = TypeScriptFunction.EMPTY;
            }
            if (typeScriptFunctionArray == null) {
                TypeScriptClassBase.$$$reportNull$$$0(25);
            }
            return typeScriptFunctionArray;
        }
        if (o instanceof JSFunction[]) {
            SmartList result2 = new SmartList();
            for (JSFunction fun : (JSFunction[])o) {
                if (!(fun instanceof TypeScriptFunction) || kind != null && fun.getKind() != kind) continue;
                result2.add((TypeScriptFunction)fun);
            }
            TypeScriptFunction[] typeScriptFunctionArray = result2.toArray(TypeScriptFunction.EMPTY);
            if (typeScriptFunctionArray == null) {
                TypeScriptClassBase.$$$reportNull$$$0(26);
            }
            return typeScriptFunctionArray;
        }
        if (TypeScriptFunction.EMPTY == null) {
            TypeScriptClassBase.$$$reportNull$$$0(27);
        }
        return TypeScriptFunction.EMPTY;
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = JSUseScopeProvider.findUseScope(this);
        if (searchScope == null) {
            TypeScriptClassBase.$$$reportNull$$$0(28);
        }
        return searchScope;
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvePlace";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptClassBase";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunctionsByNameAndKind";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processSupers";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processNonClassExtendsItem";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addProp";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getResolveProcessor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processTypeAndTypeParameters";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processClassByQName";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processIndexSignatureAndComputedNameMembers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> new IllegalArgumentException(string);
        };
    }
}

