/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptTypeDeclarationProvider
implements TypeDeclarationProvider {
    public PsiElement[] getSymbolTypeDeclarations(@NotNull PsiElement symbol) {
        if (symbol == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(0);
        }
        return JavaScriptTypeDeclarationProvider.getDeclarationElements(symbol);
    }

    @Nullable
    public static PsiElement[] getDeclarationElements(@NotNull PsiElement symbol) {
        if (symbol == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(1);
        }
        if (!(symbol instanceof JSNamedElement)) {
            return null;
        }
        JSType type = null;
        if (symbol instanceof JSFunction) {
            type = ((JSFunction)symbol).getReturnType();
        } else if (symbol instanceof JSVariable) {
            Collection<PsiElement> constructors = JavaScriptTypeDeclarationProvider.findReferencedModuleConstructors((JSVariable)symbol);
            if (!constructors.isEmpty()) {
                return constructors.toArray(PsiElement.EMPTY_ARRAY);
            }
            type = ((JSVariable)symbol).getJSType();
        } else if (symbol instanceof JSExpression) {
            type = JSResolveUtil.getExpressionJSType((JSExpression)symbol);
        }
        type = JSCompositeTypeFactory.optimizeTypeIfComposite(JavaScriptTypeDeclarationProvider.getNestedCollectionTypeOrSelf(type, symbol), JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
        if (type != null && type.isTypeScript()) {
            PsiElement[] elements = TypeScriptTypeParser.resolveElementsByType(type).toArray(PsiElement.EMPTY_ARRAY);
            if (elements.length > 0) {
                return elements;
            }
            PsiElement sourceElement = type.getSourceElement();
            if (sourceElement instanceof TypeScriptType) {
                PsiElement parent = sourceElement.getContext();
                PsiElement targetElement = parent instanceof TypeScriptTypeAlias ? parent : sourceElement;
                return new PsiElement[]{targetElement};
            }
        }
        if (type instanceof JSNamedType) {
            PsiFile containingFile = symbol.getContainingFile();
            String s = type.getResolvedTypeText();
            boolean ecmaL4 = DialectDetector.isActionScript((PsiElement)containingFile);
            GlobalSearchScope scope2 = JSResolveUtil.getResolveScope((PsiElement)containingFile);
            PsiElement item = JSDialectSpecificHandlersFactory.forElement(symbol).getClassResolver().findClassByQName(s, symbol);
            if (item == null) {
                ArrayList result2 = new ArrayList();
                JSClassResolver.processElementsByNameIncludingImplicit(s, scope2, false, (Processor<? super JSPsiElementBase>)((Processor)namedElement -> {
                    boolean ecmalL4File = DialectDetector.isActionScript((PsiElement)namedElement.getContainingFile());
                    if (ecmalL4File != ecmaL4) {
                        return true;
                    }
                    result2.add(0, namedElement);
                    return true;
                }));
                if (!result2.isEmpty()) {
                    item = (PsiElement)result2.get(0);
                }
            }
            if (item != null && item.isPhysical()) {
                return new PsiElement[]{item};
            }
        }
        return new PsiElement[]{symbol};
    }

    @NotNull
    private static Collection<PsiElement> findReferencedModuleConstructors(JSVariable element) {
        if (element instanceof JSParameter) {
            JSLiteralExpression argument = JSSymbolUtil.getParameterInitializationIfRequireArgument((JSParameter)element);
            if (argument != null) {
                Collection<PsiElement> modules = JSFileReferencesUtil.resolveModuleReferences((PsiElement)argument);
                for (PsiElement resolve2 : modules) {
                    if (!(resolve2 instanceof JSFile)) continue;
                    List<? extends PsiElement> exportedElements = JSResolveUtil.getExportedElements((JSFile)resolve2);
                    Collection<Object> collection = exportedElements.isEmpty() ? Collections.singleton(resolve2) : Collections.unmodifiableCollection(exportedElements);
                    if (collection == null) {
                        JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(2);
                    }
                    return collection;
                }
            }
        } else {
            JSExpression initializer = element.getInitializer();
            if (initializer instanceof JSCallExpression) {
                return JavaScriptTypeDeclarationProvider.findReferencedModuleConstructorIfRequireCall((JSCallExpression)initializer);
            }
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static JSType getNestedCollectionTypeOrSelf(@Nullable JSType type, @NotNull PsiElement symbol) {
        JSType nested;
        if (symbol == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(4);
        }
        return (nested = JavaScriptTypeDeclarationProvider.getNestedType(type = JSTypeUtils.getValuableType(type, symbol))) instanceof JSNamedType ? nested : type;
    }

    @Nullable
    private static JSType getNestedType(@Nullable JSType type) {
        if (type instanceof JSAliasTypeImpl) {
            JSAliasTypeImpl aliasType = (JSAliasTypeImpl)type;
            return aliasType.getAlias();
        }
        if (type instanceof JSGenericTypeImpl) {
            if (JSTypeUtils.isMapType(type)) {
                return (JSType)ContainerUtil.getLastItem(((JSGenericTypeImpl)type).getArguments());
            }
            return JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)type, false, baseType -> JSNamedType.isNamedTypeWithNames(baseType, JSCommonTypeNames.UTIL_TYPES) ? Function.identity() : JSTypeUtils.isSingleGenericComponentType(baseType, true));
        }
        return JSTypeUtils.getIndexableComponentType(type, false, true);
    }

    @NotNull
    private static Collection<PsiElement> findReferencedModuleConstructorIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(5);
        }
        SmartList result2 = new SmartList();
        PsiElement module = CommonJSUtil.findReferencedModuleIfRequireCall(callExpression);
        if (module instanceof JSFile) {
            List<? extends PsiElement> exportedElements = JSResolveUtil.getExportedElements((JSFile)module);
            for (PsiElement psiElement : exportedElements) {
                PsiElement element;
                String reference;
                if (psiElement instanceof JSDefinitionExpression && (reference = JSPsiImplUtils.getInitializerReference((JSDefinitionExpression)psiElement)) != null && (element = JSStubBasedPsiTreeUtil.resolveLocally(reference, psiElement)) != null) {
                    result2.add(element);
                    continue;
                }
                if (psiElement == null) continue;
                result2.add(psiElement);
            }
        }
        if (result2.isEmpty() && module != null) {
            result2.add(module);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/navigation/JavaScriptTypeDeclarationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/navigation/JavaScriptTypeDeclarationProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModuleConstructors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModuleConstructorIfRequireCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolTypeDeclarations";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationElements";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNestedCollectionTypeOrSelf";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModuleConstructorIfRequireCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

