/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.config.JSModuleResolution;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.frameworks.modules.JSResolvableModuleReference;
import com.intellij.lang.javascript.inspections.JSFileReferencesInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.ES6CheckImportVisitor;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDevDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.JSModuleVisitor;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.NpmUsedModulesInstalledInspection;
import com.intellij.lang.javascript.modules.TypeScriptCheckImportInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.inspection.TypeScriptConfigEnableOptionFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/javascript/modules/TypeScriptCheckImportInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "<init>", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getRangeForError", "Lcom/intellij/openapi/util/TextRange;", "psiElementForError", "Lcom/intellij/psi/PsiElement;", "moduleName", "", "isFileAcceptable", "", "file", "Lcom/intellij/psi/PsiFile;", "checkConfigIsAcceptable", "tsConfig", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "isAcceptableModule", "it", "getEnableOptionFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "importExportPart", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;", "intellij.javascript.impl"})
public final class TypeScriptCheckImportInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        boolean isServiceEnabled = this.isFileAcceptable(file) && TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file) instanceof TypeScriptLanguageServiceAnnotatorCheckerProvider;
        return new JSModuleVisitor(this, holder, isServiceEnabled){
            private final ES6CheckImportVisitor importVisitor;
            final /* synthetic */ TypeScriptCheckImportInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isServiceEnabled;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isServiceEnabled = $isServiceEnabled;
                this.importVisitor = new ES6CheckImportVisitor($receiver){
                    final /* synthetic */ TypeScriptCheckImportInspection this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    protected LocalQuickFix[] getFixes(ES6ImportExportDeclarationPart importExportPart, PsiElement resolveResult, JSResolveResult.ProblemKind resolveProblemKind) {
                        Intrinsics.checkNotNullParameter((Object)importExportPart, (String)"importExportPart");
                        Object[] result2 = super.getFixes(importExportPart, resolveResult, resolveProblemKind);
                        if (importExportPart instanceof ES6ImportedBinding) {
                            TypeScriptConfig tsConfig = TypeScriptConfigUtil.getConfigForPsiFile(((ES6ImportedBinding)importExportPart).getContainingFile());
                            if (tsConfig == null) {
                                return result2;
                            }
                            if (!tsConfig.allowSyntheticDefaultImports()) {
                                LocalQuickFix localQuickFix = TypeScriptCheckImportInspection.access$getEnableOptionFix(this.this$0, (ES6ImportedBinding)importExportPart, tsConfig);
                                if (localQuickFix == null) {
                                    return result2;
                                }
                                LocalQuickFix fix = localQuickFix;
                                List newResult = new ArrayList<E>();
                                CollectionsKt.addAll((Collection)newResult, (Object[])result2);
                                newResult.add(fix);
                                Collection $this$toTypedArray$iv = newResult;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                return thisCollection$iv.toArray(new LocalQuickFix[0]);
                            }
                        }
                        return result2;
                    }
                };
            }

            protected boolean isAvailable(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return DialectDetector.isTypeScript(element);
            }

            public void visitES6ImportedBinding(ES6ImportedBinding importedBinding) {
                Intrinsics.checkNotNullParameter((Object)importedBinding, (String)"importedBinding");
                if (!this.isAvailable((PsiElement)importedBinding)) {
                    return;
                }
                ProblemHighlightType problemHighlightType = this.getProblemHighlightType();
                if (this.shouldIgnoreErrors(problemHighlightType)) {
                    return;
                }
                this.importVisitor.visitES6ImportedBindingImpl(importedBinding, this.$holder, problemHighlightType);
            }

            public void visitES6ImportExportSpecifier(ES6ImportExportSpecifier node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)node, () -> createVisitor.1.visitES6ImportExportSpecifier$lambda$0(this, node));
            }

            private final void doVisitES6ImportExportSpecifier(ES6ImportExportSpecifier node) {
                boolean bl;
                block7: {
                    if (!this.isAvailable((PsiElement)node)) {
                        return;
                    }
                    Object object = node.getDeclaration();
                    if (object == null || (object = object.getFromClause()) == null || (object = object.resolveReferencedElements()) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    Collection<PsiElement> elements = object;
                    Iterable $this$any$iv = elements;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof TypeScriptModule && ((TypeScriptModule)it).isShorthandAmbientModule())) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                ProblemHighlightType problemHighlightType = this.getProblemHighlightType();
                if (this.shouldIgnoreErrors(problemHighlightType)) {
                    return;
                }
                this.importVisitor.visitSpecifierImpl(this.$holder, node, problemHighlightType);
            }

            protected void processImport(PsiElement literalElement, String quotedLiteralValue, PsiReference[] references, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkNotNullParameter((Object)literalElement, (String)"literalElement");
                Intrinsics.checkNotNullParameter((Object)quotedLiteralValue, (String)"quotedLiteralValue");
                Intrinsics.checkNotNullParameter((Object)references, (String)"references");
                Intrinsics.checkNotNullParameter((Object)importResolver, (String)"importResolver");
                Intrinsics.checkNotNullParameter((Object)pointerBuilder, (String)"pointerBuilder");
                this.checkImports(literalElement, quotedLiteralValue, references, importResolver, pointerBuilder);
            }

            protected void processRequire(JSCallExpression element, JSLiteralExpression argument, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
                Intrinsics.checkNotNullParameter((Object)importResolver, (String)"importResolver");
                Intrinsics.checkNotNullParameter((Object)pointerBuilder, (String)"pointerBuilder");
            }

            private final void checkImports(PsiElement psiElementForError, String refText, PsiReference[] references, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                if (!this.checkAsNodePackage(psiElementForError, refText, importResolver, pointerBuilder)) {
                    Collection<PsiElement> resolveImportModules = importResolver.resolveImportModules();
                    if (!resolveImportModules.isEmpty()) {
                        return;
                    }
                    this.validateImportReferences(references);
                }
            }

            private final void validateImportReferences(PsiReference[] references) {
                boolean resolve2 = false;
                List unresolvedRefs = new ArrayList<E>();
                int n = references.length;
                for (int i = 0; i < n; ++i) {
                    PsiReference reference;
                    block8: {
                        block7: {
                            block6: {
                                reference = references[i];
                                if (!(reference instanceof PsiPolyVariantReference)) break block6;
                                ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)reference).multiResolve(false);
                                Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
                                if (!(((Object[])resolveResultArray).length == 0)) break block7;
                            }
                            if (reference.resolve() == null) break block8;
                        }
                        if (reference instanceof FileReference && !((FileReference)reference).isLast()) continue;
                        resolve2 = true;
                        continue;
                    }
                    if (reference instanceof JSResolvableModuleReference) continue;
                    unresolvedRefs.add(reference);
                }
                if (!resolve2 && !(references.length == 0)) {
                    PsiReference element = (PsiReference)CollectionsKt.first((List)unresolvedRefs);
                    ProblemHighlightType problemHighlightType = this.getProblemHighlightType();
                    if (this.shouldIgnoreErrors(problemHighlightType)) {
                        return;
                    }
                    this.$holder.registerProblem(element, JSFileReferencesInspection.getErrorDescription(element, this.$holder.getProject()), problemHighlightType);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final boolean checkAsNodePackage(PsiElement psiElementForError, String refText, JSModuleVisitor.ImportResolver importResolver, JSModuleVisitor.ModulePointerBuilder pointerBuilder) {
                boolean isNodeJSCoreModule;
                Object expectedTypesName;
                TypeScriptConfig contextFile;
                VirtualFile nodeModulesDirectory;
                VirtualFile packageJson;
                boolean bl;
                Collection<PsiElement> resolveImportModules;
                VirtualFile virtualFile;
                TypeScriptConfig tsConfig;
                String moduleName;
                block16: {
                    void $this$any$iv;
                    String string = JSFileReferencesUtil.getNodeModuleName(refText);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeModuleName(...)");
                    moduleName = string;
                    if (!JSFileReferencesUtil.isAcceptableNodeModulesPackageName(moduleName)) {
                        return false;
                    }
                    PsiFile containingFile = psiElementForError.getContainingFile();
                    tsConfig = TypeScriptConfigUtil.getConfigForPsiFile(containingFile);
                    if (!TypeScriptCheckImportInspection.access$checkConfigIsAcceptable(this.this$0, tsConfig)) {
                        return false;
                    }
                    virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)containingFile));
                    if (virtualFile == null) {
                        return false;
                    }
                    resolveImportModules = importResolver.resolveImportModules();
                    Iterable iterable = resolveImportModules;
                    TypeScriptCheckImportInspection typeScriptCheckImportInspection = this.this$0;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (!TypeScriptCheckImportInspection.access$isAcceptableModule(typeScriptCheckImportInspection, it)) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (bl || resolveImportModules.size() > 1) {
                    return true;
                }
                TypeScriptConfig typeScriptConfig = tsConfig;
                if (typeScriptConfig == null || (typeScriptConfig = typeScriptConfig.getConfigFile()) == null) {
                    typeScriptConfig = virtualFile;
                }
                if ((packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDirectory = NodeModuleUtil.findUpClosestNodeModulesResolveRoot((VirtualFile)(contextFile = typeScriptConfig)))) == null) {
                    packageJson = PackageJsonUtil.findChildPackageJsonFile(contextFile.getParent());
                }
                Object object = expectedTypesName = (isNodeJSCoreModule = NodeCoreLibraryManager.isCoreModuleName(moduleName)) ? "@types/node" : "@types/" + moduleName;
                if (!isNodeJSCoreModule) {
                    if (packageJson == null) {
                        return false;
                    }
                    PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
                    Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
                    PackageJsonData data = packageJsonData;
                    if (data.isDependencyOfAnyType((String)expectedTypesName)) {
                        return false;
                    }
                    if (!data.isDependencyOfAnyType(moduleName)) {
                        InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerBuilder.createPointer();
                        boolean reportOwnError = tsConfig != null && tsConfig.getEffectiveResolution() != JSModuleResolution.CLASSIC;
                        NpmUsedModulesInstalledInspection.Reporter errorReporter = this.createReporter(psiElementForError, moduleName, !reportOwnError);
                        NpmUsedModulesInstalledInspection.reportModulesIsNotInstalledErrorWithFixes(moduleElement, CollectionsKt.listOf((Object)packageJson), false, nodeModulesDirectory, errorReporter);
                        return reportOwnError;
                    }
                    NpmUsedModulesInstalledInspection.ModuleTypingsState typingsState = NpmUsedModulesInstalledInspection.modulePackageJsonHasTypings(moduleName, nodeModulesDirectory);
                    if (typingsState == NpmUsedModulesInstalledInspection.ModuleTypingsState.HAS_TYPINGS) {
                        return false;
                    }
                    if (typingsState == NpmUsedModulesInstalledInspection.ModuleTypingsState.MODULE_DIRECTORY_NOT_EXIST) {
                        InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerBuilder.createPointer();
                        NpmUsedModulesInstalledInspection.Reporter errorReporter = this.createReporter(psiElementForError, moduleName, false);
                        NpmUsedModulesInstalledInspection.reportModulesIsNotInstalledErrorWithFixes(moduleElement, CollectionsKt.listOf((Object)packageJson), true, nodeModulesDirectory, errorReporter);
                        return true;
                    }
                }
                if (StringsKt.startsWith$default((String)moduleName, (String)"@", (boolean)false, (int)2, null)) {
                    return false;
                }
                InstallNodeModuleQuickFix.ModuleElement moduleElement = pointerBuilder.createPointer();
                InstallNodeModuleQuickFix.ModuleElement moduleElementWrapper2 = new InstallNodeModuleQuickFix.ModuleElement(moduleElement, moduleName, (String)expectedTypesName, psiElementForError){
                    final /* synthetic */ InstallNodeModuleQuickFix.ModuleElement $moduleElement;
                    final /* synthetic */ String $moduleName;
                    final /* synthetic */ String $expectedTypesName;
                    final /* synthetic */ PsiElement $psiElementForError;
                    {
                        this.$moduleElement = $moduleElement;
                        this.$moduleName = $moduleName;
                        this.$expectedTypesName = $expectedTypesName;
                        this.$psiElementForError = $psiElementForError;
                    }

                    public String getModuleName() {
                        return Intrinsics.areEqual((Object)this.$moduleElement.getModuleName(), (Object)this.$moduleName) ? this.$expectedTypesName : null;
                    }

                    public Project getProject() {
                        Project project = this.$psiElementForError.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        return project;
                    }
                };
                this.registerErrorWithFixes(packageJson, moduleElementWrapper2, psiElementForError, moduleName, resolveImportModules);
                return true;
            }

            private final NpmUsedModulesInstalledInspection.Reporter createReporter(PsiElement psiElementForError, String moduleName, boolean infoOnly) {
                return (arg_0, arg_1) -> createVisitor.1.createReporter$lambda$3(this.this$0, psiElementForError, moduleName, infoOnly, this, this.$holder, arg_0, arg_1);
            }

            private final void registerErrorWithFixes(VirtualFile packageJson, InstallNodeModuleQuickFix.ModuleElement moduleElementWrapper2, PsiElement psiElementForError, String moduleName, Collection<? extends PsiElement> resolveImportModules) {
                ProblemHighlightType defaultHighlight;
                InstallNodeModuleQuickFix fix = packageJson == null ? new InstallNodeModuleQuickFix(moduleElementWrapper2, CollectionsKt.emptyList()) : (InstallNodeModuleQuickFix)new InstallNodeModuleAddToDevDependenciesQuickFix(moduleElementWrapper2, CollectionsKt.listOf((Object)packageJson));
                TextRange range = TypeScriptCheckImportInspection.access$getRangeForError(this.this$0, psiElementForError, moduleName);
                ProblemHighlightType problemHighlightType = defaultHighlight = !resolveImportModules.isEmpty() ? ProblemHighlightType.INFORMATION : this.getProblemHighlightType();
                if (this.shouldIgnoreErrors(defaultHighlight)) {
                    return;
                }
                Object[] objectArray = new Object[]{moduleName};
                String string = JavaScriptBundle.message("typescript.types.module.not.installed.warning", objectArray);
                objectArray = new LocalQuickFix[]{fix};
                this.$holder.registerProblem(psiElementForError, string, defaultHighlight, range, (LocalQuickFix[])objectArray);
            }

            private final boolean shouldIgnoreErrors(ProblemHighlightType problemHighlightType) {
                return !this.$holder.isOnTheFly() && problemHighlightType == ProblemHighlightType.INFORMATION;
            }

            private final ProblemHighlightType getProblemHighlightType() {
                return this.$isServiceEnabled ? ProblemHighlightType.INFORMATION : ProblemHighlightType.ERROR;
            }

            private static final void visitES6ImportExportSpecifier$lambda$0(createVisitor.1 this$0, ES6ImportExportSpecifier $node) {
                this$0.doVisitES6ImportExportSpecifier($node);
            }

            private static final void createReporter$lambda$3(TypeScriptCheckImportInspection this$0, PsiElement $psiElementForError, String $moduleName, boolean $infoOnly, createVisitor.1 this$1, ProblemsHolder $holder, String text, List fixes) {
                ProblemHighlightType problemHighlightType;
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
                TextRange range = TypeScriptCheckImportInspection.access$getRangeForError(this$0, $psiElementForError, $moduleName);
                ProblemHighlightType problemHighlightType2 = problemHighlightType = $infoOnly ? ProblemHighlightType.INFORMATION : this$1.getProblemHighlightType();
                if (this$1.shouldIgnoreErrors(problemHighlightType)) {
                    return;
                }
                Collection $this$toTypedArray$iv = fixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                $holder.registerProblem($psiElementForError, text, problemHighlightType, range, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        };
    }

    private final TextRange getRangeForError(PsiElement psiElementForError, String moduleName) {
        int indexOfModuleName = StringUtil.indexOf((CharSequence)psiElementForError.getText(), (CharSequence)moduleName);
        return new TextRange(indexOfModuleName, indexOfModuleName + moduleName.length());
    }

    private final boolean isFileAcceptable(PsiFile file) {
        return DialectDetector.isTypeScript((PsiElement)file);
    }

    private final boolean checkConfigIsAcceptable(TypeScriptConfig tsConfig) {
        if (tsConfig == null) {
            return true;
        }
        return tsConfig.getEffectiveResolution() != JSModuleResolution.CLASSIC;
    }

    private final boolean isAcceptableModule(PsiElement it) {
        if (DialectDetector.isTypeScript(it)) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)it);
        return virtualFile != null && !JSLibraryUtil.isProbableLibraryFile(virtualFile);
    }

    private final LocalQuickFix getEnableOptionFix(ES6ImportedBinding importExportPart, TypeScriptConfig tsConfig) {
        JSElement jSElement = importExportPart.getDeclaration();
        if (jSElement == null || (jSElement = jSElement.getFromClause()) == null) {
            return null;
        }
        JSElement fromClause = jSElement;
        Collection<PsiElement> collection = fromClause.resolveReferencedElements();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveReferencedElements(...)");
        Collection<PsiElement> resolveReferencedElements = collection;
        if (resolveReferencedElements.isEmpty()) {
            return null;
        }
        boolean preferAllow = true;
        for (PsiElement module : resolveReferencedElements) {
            if (!(module instanceof PsiFile) || TypeScriptUtil.isDefinitionFile((PsiFile)module)) continue;
            if (TypeScriptPsiUtil.findExportAssignment(module) == null) {
                return null;
            }
            preferAllow = false;
        }
        boolean configHasESInterop = tsConfig.hasCompilerOption("esModuleInterop");
        String optionName = !configHasESInterop && preferAllow ? "allowSyntheticDefaultImports" : "esModuleInterop";
        return new TypeScriptConfigEnableOptionFix(optionName, JsonSchemaType._boolean, "true");
    }

    public static final /* synthetic */ boolean access$checkConfigIsAcceptable(TypeScriptCheckImportInspection $this, TypeScriptConfig tsConfig) {
        return $this.checkConfigIsAcceptable(tsConfig);
    }

    public static final /* synthetic */ TextRange access$getRangeForError(TypeScriptCheckImportInspection $this, PsiElement psiElementForError, String moduleName) {
        return $this.getRangeForError(psiElementForError, moduleName);
    }

    public static final /* synthetic */ boolean access$isAcceptableModule(TypeScriptCheckImportInspection $this, PsiElement it) {
        return $this.isAcceptableModule(it);
    }

    public static final /* synthetic */ LocalQuickFix access$getEnableOptionFix(TypeScriptCheckImportInspection $this, ES6ImportedBinding importExportPart, TypeScriptConfig tsConfig) {
        return $this.getEnableOptionFix(importExportPart, tsConfig);
    }
}

