/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSSubclassIndex;
import com.intellij.lang.javascript.psi.stubs.JSTypedefIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JSTypeEvaluateManager {
    private static final Logger LOG = Logger.getInstance(JSTypeEvaluateManager.class);
    private static final AtomicBoolean ourAssertOnStubLoading = new AtomicBoolean();
    private static final int NAME_MIN_LENGTH = SystemProperties.getIntProperty((String)"idea.javascript.inheritance.name.min.length", (int)0);

    public static String getBaseArrayType(String type) {
        if (JSTypeEvaluateManager.isArrayType(type) && type.contains("[]")) {
            return "Array";
        }
        return type;
    }

    public static Collection<JSPsiElementBase> findNearestExtendedJSTypes(JSPsiElementBase function, @NotNull String functionQName) {
        if (functionQName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(0);
        }
        LinkedList extendedTypes = new LinkedList();
        HashSet hasNonImplicitNamespaceElement = new HashSet();
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)function).getClassResolver();
        PsiFile psiFile = function.getContainingFile();
        JSNamespace ns = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName(functionQName), JSContext.INSTANCE, (PsiElement)function, true);
        JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex((PsiElement)function, ns, false, false, (Processor<? super JSType>)((Processor)type -> {
            if (type instanceof JSNamedType && ((JSNamedType)type).getTypeContext() == JSTypeContext.STATIC) {
                return true;
            }
            String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
            if (qName == null) {
                return true;
            }
            for (JSPsiElementBase element : resolver.findElementsByQNameIncludingImplicit(qName, JSResolveUtil.getResolveScope((PsiElement)psiFile))) {
                extendedTypes.add(Pair.create((Object)element, (Object)qName));
                if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance()) continue;
                hasNonImplicitNamespaceElement.add(qName);
            }
            return true;
        }));
        ArrayList<JSPsiElementBase> result2 = new ArrayList<JSPsiElementBase>(extendedTypes.size());
        for (Pair type2 : extendedTypes) {
            JSPsiElementBase element = (JSPsiElementBase)type2.first;
            if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance() && hasNonImplicitNamespaceElement.contains(type2.second)) continue;
            result2.add(element);
        }
        return result2;
    }

    public static boolean iterateTypeHierarchy(@NotNull JSNamespace type, @Nullable Processor<JSClass> baseClassProcessor, @Nullable Processor<? super JSType> baseTypeProcessor, @NotNull PsiElement myContext, boolean processTopClasses) {
        String typeName;
        if (type == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(1);
        }
        if (myContext == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(2);
        }
        if (baseClassProcessor != null && (typeName = JSQualifiedNameImpl.toString(type.getQualifiedName())) != null && !JSTypeEvaluateManager.iterateTypeHierarchyFromJSClasses(typeName, baseClassProcessor, myContext, processTopClasses)) {
            return false;
        }
        return baseTypeProcessor == null || JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(myContext, type, false, true, baseTypeProcessor);
    }

    private static boolean iterateTypeHierarchyFromJSClasses(@NotNull String typeName, @NotNull Processor<JSClass> processor, @NotNull PsiElement myContext, boolean processTopClasses) {
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(4);
        }
        if (myContext == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(5);
        }
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement(myContext).getClassResolver();
        List<JSClass> classes = resolver.findClassesByQName(typeName, JSResolveUtil.getResolveScope(myContext));
        return JSTypeEvaluateManager.iterateTypeHierarchyFromJSClasses(classes, processor, processTopClasses);
    }

    public static boolean iterateTypeHierarchyFromJSClasses(@NotNull Collection<JSClass> classes, @NotNull Processor<? super JSClass> processor, boolean processTopClasses) {
        if (classes == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(7);
        }
        if (!classes.isEmpty()) {
            HashSet<JSClass> visitedClasses = new HashSet<JSClass>();
            if (processTopClasses) {
                for (JSClass aClass : classes) {
                    if (!visitedClasses.add(aClass) || processor.process((Object)aClass)) continue;
                    return false;
                }
            }
            ArrayDeque<JSClass> parentClasses = new ArrayDeque<JSClass>(classes);
            while (!parentClasses.isEmpty()) {
                JSClass parentClass = (JSClass)parentClasses.removeFirst();
                for (JSClass superClass : parentClass.getSupers()) {
                    if (!visitedClasses.add(superClass)) continue;
                    if (!processor.process((Object)superClass)) {
                        return false;
                    }
                    parentClasses.add(superClass);
                }
            }
        }
        return true;
    }

    public static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context2, @Nullable String type, @NotNull Processor<? super JSType> processor) {
        if (context2 == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(9);
        }
        if (type == null) {
            return true;
        }
        JSNamespace ns = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName(type), JSContext.INSTANCE, context2, true);
        return JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(context2, ns, true, true, processor);
    }

    public static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context2, @NotNull JSNamespace initialType, boolean processObjectClass, boolean withGrandparents, @NotNull Processor<? super JSType> processor) {
        if (context2 == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(10);
        }
        if (initialType == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(12);
        }
        return JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(context2, initialType, processObjectClass, withGrandparents, false, processor);
    }

    public static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context2, @NotNull JSNamespace initialType, boolean processObjectClass, boolean withGrandparents, boolean limitScopeForInitialType, @NotNull Processor<? super JSType> processor) {
        if (context2 == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(13);
        }
        if (initialType == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(15);
        }
        return JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(context2, initialType, processObjectClass, withGrandparents, limitScopeForInitialType, (? super JSType parent, ? super JSType child) -> processor.process(child));
    }

    private static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context2, @NotNull JSNamespace initialType, boolean processObjectClass, boolean withGrandparents, boolean limitScopeForInitialType, @NotNull BiPredicate<? super JSType, ? super JSType> parentAndChildProcessor) {
        JSNamespace objectNs;
        if (context2 == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(16);
        }
        if (initialType == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(17);
        }
        if (parentAndChildProcessor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(18);
        }
        if (DialectDetector.isTypeScript(context2)) {
            return true;
        }
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope(context2);
        PsiManager psiManager = context2.getManager();
        JSHierarchyProcessingState state = new JSHierarchyProcessingState(initialType);
        while (state.hasNext()) {
            JSQualifiedName name;
            JSType currentType = state.next();
            JSNamespace ns = JSTypeUtils.getNamespaceMatchingType(currentType, false);
            if (ns == null || NAME_MIN_LENGTH > 1 && (name = ns.getQualifiedName()) != null && name.getParent() == null && !name.getName().isEmpty() && name.getName().length() < NAME_MIN_LENGTH) continue;
            if (!JSTypeEvaluateManager.processNamespaceBaseTypes(ns, limitScopeForInitialType, context2, scope2, state)) {
                return false;
            }
            List<JSType> newResults = state.pullResults(psiManager);
            for (JSType newResult : newResults) {
                if (parentAndChildProcessor.test(currentType, newResult)) continue;
                return false;
            }
            if (withGrandparents) continue;
            break;
        }
        return !processObjectClass || state.hasObjectInHierarchy() || parentAndChildProcessor.test(initialType, objectNs = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName("Object"), JSContext.INSTANCE, context2, true));
    }

    private static boolean processNamespaceBaseTypes(@NotNull JSNamespace namespace, boolean limitScopeForInitialType, @NotNull PsiElement context2, @Nullable GlobalSearchScope contextScope, @NotNull JSHierarchyProcessingState state) {
        PsiFile nsFile;
        if (namespace == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(20);
        }
        if (state == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(21);
        }
        String indexKey = JSBaseTypesIndex.getHierarchyIndexKey(namespace);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching for " + indexKey + " base types");
        }
        GlobalSearchScope scope2 = contextScope;
        if ((namespace.isLocal() || limitScopeForInitialType && state.isInitialType(namespace)) && (nsFile = namespace.getSource().getScope()) != null) {
            scope2 = GlobalSearchScope.fileScope((PsiFile)nsFile);
        }
        return StubIndex.getInstance().processElements(JSBaseTypesIndex.KEY, (Object)indexKey, context2.getProject(), scope2, JSElement.class, element -> {
            if (ourAssertOnStubLoading.get()) {
                throw new RuntimeException("Inheritance checked at " + element.getContainingFile().getVirtualFile().getPath());
            }
            if (element instanceof JSImplicitElementProvider) {
                Collection<Pair<String, String>> baseTypes;
                PsiFile containingFile = element.getContainingFile();
                VirtualFile file = containingFile.getVirtualFile();
                JSElementIndexingData indexingData = ((JSImplicitElementProvider)element).getIndexingData();
                Collection<Pair<String, String>> collection = baseTypes = indexingData != null ? indexingData.getBaseTypes() : null;
                if (baseTypes != null) {
                    for (Pair<String, String> inheritance : baseTypes) {
                        String subType = (String)inheritance.first;
                        if (!JSBaseTypesIndex.areTypesRelevant(namespace, subType, containingFile)) continue;
                        String inherited = (String)inheritance.second;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found " + subType + " extends " + (String)inheritance.second);
                        }
                        state.addBaseType(file, inherited);
                    }
                }
            }
            return true;
        });
    }

    @NotNull
    private static List<JSType> removeNonGenericExtensions(@NotNull List<JSType> children) {
        boolean hasGenericType;
        if (children == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(22);
        }
        if (!(hasGenericType = ContainerUtil.exists(children, c -> JSTypeUtils.getGenericOriginalType(c) != null))) {
            List<JSType> list = children;
            if (list == null) {
                JSTypeEvaluateManager.$$$reportNull$$$0(23);
            }
            return list;
        }
        boolean hasNonGenericType = ContainerUtil.exists(children, c -> JSTypeUtils.getGenericOriginalType(c) == null);
        if (!hasNonGenericType) {
            List<JSType> list = children;
            if (list == null) {
                JSTypeEvaluateManager.$$$reportNull$$$0(24);
            }
            return list;
        }
        List originalTypes = ContainerUtil.mapNotNull(children, JSTypeUtils::getGenericOriginalType);
        List list = ContainerUtil.filter(children, child -> {
            for (JSType originalType : originalTypes) {
                if (!child.isEquivalentTo(originalType, null, false)) continue;
                return false;
            }
            return true;
        });
        if (list == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public static TreeItem<String> buildSuperClassesHierarchy(@NotNull PsiElement scopeElement, @NotNull String type) {
        if (scopeElement == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(26);
        }
        if (type == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(27);
        }
        TreeItem root = new TreeItem((Object)type);
        JSNamespace initialType = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName(type), JSContext.INSTANCE, scopeElement, true);
        HashMap<JSNamespace, TreeItem> typeToNode = new HashMap<JSNamespace, TreeItem>();
        typeToNode.put(initialType, root);
        JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(scopeElement, initialType, false, true, false, (? super JSType parent, ? super JSType child) -> {
            TreeItem childNode = new TreeItem((Object)child.getTypeText(JSType.TypeTextFormat.SIMPLE));
            typeToNode.put((JSNamespace)child, childNode);
            TreeItem parentNode = (TreeItem)typeToNode.get(parent);
            if (parentNode != null) {
                parentNode.addChild(childNode);
            } else {
                Logger.getInstance(JSTypeEvaluateManager.class).error("Parent not found");
            }
            return true;
        });
        TreeItem treeItem = root;
        if (treeItem == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(28);
        }
        return treeItem;
    }

    @Nullable
    public static TreeItem<String> findSuperClass(@NotNull PsiElement scopeElement, @NotNull TreeItem<String> root, @NotNull String parentClassName) {
        JSType type;
        String rootQName;
        if (scopeElement == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(29);
        }
        if (root == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(30);
        }
        if (parentClassName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(31);
        }
        String string = rootQName = (type = JSTypeParser.createType(scopeElement.getProject(), (String)root.getData(), JSTypeSource.EXPLICITLY_DECLARED)) != null ? JSTypeUtils.getQualifiedNameMatchingType(type, true) : null;
        if (parentClassName.equals(rootQName)) {
            return root;
        }
        for (TreeItem child : root.getChildren()) {
            TreeItem<String> childSuper = JSTypeEvaluateManager.findSuperClass(scopeElement, (TreeItem<String>)child, parentClassName);
            if (childSuper == null) continue;
            return childSuper;
        }
        return null;
    }

    @Nullable
    public static JSType getTypedefValue(@Nullable PsiElement context2, String typeName) {
        if (context2 == null) {
            return null;
        }
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope(context2);
        Ref associatedType = Ref.create(null);
        Ref associatedTypeSource = Ref.create(null);
        Processor processor = element -> {
            if (!(element instanceof JSImplicitElementProvider)) {
                LOG.error("only JSImplicitElementProviders should add info to typedef index, found " + element.getClass());
                return true;
            }
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            if (data == null) {
                LOG.error("JSElementIndexingData mustn't be null for element referenced in typedef index");
                return true;
            }
            Collection<Pair<String, String>> typedefs = data.getTypedefs();
            if (typedefs == null || typedefs.isEmpty()) {
                LOG.error("JSElementIndexingData.getTypedef() mustn't be null");
                return true;
            }
            for (Pair<String, String> typedef : typedefs) {
                String leftName = (String)typedef.first;
                if (!typeName.equals(leftName)) continue;
                String rightName = (String)typedef.second;
                associatedType.set((Object)rightName);
                JSElement sourceElement = element;
                List<JSImplicitElement> implicitElements = data.findElementsByQualifiedName(leftName);
                if (implicitElements.size() == 1) {
                    sourceElement = implicitElements.get(0);
                }
                associatedTypeSource.set((Object)sourceElement);
            }
            return false;
        };
        PsiFile file = context2.getContainingFile();
        if (scope2.contains(file.getViewProvider().getVirtualFile())) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)file);
            StubIndex.getInstance().processElements(JSTypedefIndex.KEY, (Object)typeName, context2.getProject(), fileScope, JSElement.class, processor);
        }
        if (associatedType.isNull()) {
            StubIndex.getInstance().processElements(JSTypedefIndex.KEY, (Object)typeName, context2.getProject(), scope2, JSElement.class, processor);
        }
        if (!associatedType.isNull()) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)associatedTypeSource.get(), true);
            return JSTypeParser.parseSerializedOrJSDocType(context2.getProject(), (String)associatedType.get(), source);
        }
        return null;
    }

    public static boolean iterateSubclasses(@NotNull PsiElement context2, @NotNull String typeName, @NotNull Processor<? super JSType> processor) {
        if (context2 == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(32);
        }
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(34);
        }
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope(context2);
        HashMap indexValues = new HashMap();
        Collection elements = StubIndex.getElements(JSSubclassIndex.KEY, (Object)typeName, (Project)context2.getProject(), (GlobalSearchScope)scope2, JSElement.class);
        for (JSElement element : elements) {
            Collection<Pair<String, String>> baseTypes;
            JSElementIndexingData indexingData = element instanceof JSImplicitElementProvider ? ((JSImplicitElementProvider)element).getIndexingData() : null;
            if (indexingData == null || (baseTypes = indexingData.getBaseTypes()) == null) continue;
            VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
            HashSet<String> fileBaseTypes = (HashSet<String>)indexValues.get(virtualFile);
            if (fileBaseTypes == null) {
                fileBaseTypes = new HashSet<String>();
                indexValues.put(virtualFile, fileBaseTypes);
            }
            for (Pair<String, String> baseType : baseTypes) {
                fileBaseTypes.add((String)baseType.first);
            }
        }
        PsiManager psiManager = context2.getManager();
        Collection<VirtualFile> files = JSResolveUtil.sortFiles(indexValues.keySet());
        for (VirtualFile file : files) {
            for (String s : (Set)indexValues.get(file)) {
                JSType type = JSBaseTypesIndex.deserializeHierarchyElement(context2.getProject(), s, true, psiManager.findFile(file));
                if (type == null || processor.process((Object)type)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static boolean isArrayType(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith("[]") || s.indexOf(91) != -1 || s.startsWith("...") || s.indexOf(60) != -1 && (s.startsWith("Vector") || s.startsWith("Array") || s.startsWith("Object"));
    }

    @Deprecated
    public static String getComponentType(@NotNull Project project, String s) {
        JSType type;
        if (project == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(35);
        }
        if (s.endsWith("[]")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.startsWith("...")) {
            return s.substring(3);
        }
        int i = s.indexOf(91);
        if (i != -1) {
            return s.substring(i + 1);
        }
        if (s.indexOf(60) != -1 && (s.startsWith("Vector") || s.startsWith("Array") || s.startsWith("Object")) && (type = new JSTypeParser(project, s, JSTypeSource.EMPTY).parse()) instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            List<JSType> genericArguments = genericType.getArguments();
            JSType lastGenericType = genericArguments.get(genericArguments.size() - 1);
            return lastGenericType.getResolvedTypeText();
        }
        return s;
    }

    @TestOnly
    public static void assertOnStubLoading(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(36);
        }
        JSTypeEvaluateManager.setFlag(parentDisposable, true, ourAssertOnStubLoading);
    }

    private static void setFlag(@NotNull Disposable parentDisposable, final boolean toAssert, final @NotNull AtomicBoolean flag) {
        boolean prev;
        if (parentDisposable == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(37);
        }
        if (flag == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(38);
        }
        if (toAssert == (prev = flag.get())) {
            return;
        }
        flag.set(toAssert);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                if (flag.get() != toAssert) {
                    throw new IllegalStateException("Non-nested assertion flag modifications");
                }
                flag.set(prev);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 23, 24, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionQName";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myContext";
                break;
            }
            case 3: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentAndChildProcessor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNonGenericExtensions";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSuperClassesHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findNearestExtendedJSTypes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "iterateTypeHierarchy";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "iterateTypeHierarchyFromJSClasses";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "iterateTypeHierarchyFromBaseTypesIndex";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceBaseTypes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeNonGenericExtensions";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildSuperClassesHierarchy";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findSuperClass";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "iterateSubclasses";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getComponentType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "assertOnStubLoading";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setFlag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 23, 24, 25, 28 -> new IllegalStateException(string);
        };
    }

    private static final class JSHierarchyProcessingState {
        private final Map<String, List<VirtualFile>> myCurrentBaseTypes;
        private final Set<String> myProcessedSerializedTypes;
        private final Deque<JSType> myBaseTypesQueue;
        private final JSNamespace myInitialType;
        private boolean myInitialTypeProcessed;

        private JSHierarchyProcessingState(@NotNull JSNamespace initialType) {
            if (initialType == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(0);
            }
            this.myCurrentBaseTypes = new LinkedHashMap<String, List<VirtualFile>>();
            this.myProcessedSerializedTypes = new HashSet<String>();
            this.myBaseTypesQueue = new ArrayDeque<JSType>();
            this.myInitialTypeProcessed = false;
            this.myInitialType = initialType;
        }

        public boolean hasNext() {
            return !this.myInitialTypeProcessed || !this.myBaseTypesQueue.isEmpty();
        }

        @NotNull
        public JSType next() {
            if (!this.myInitialTypeProcessed) {
                this.myInitialTypeProcessed = true;
                JSNamespace jSNamespace = this.myInitialType;
                if (jSNamespace == null) {
                    JSHierarchyProcessingState.$$$reportNull$$$0(1);
                }
                return jSNamespace;
            }
            JSType jSType = this.myBaseTypesQueue.removeFirst();
            if (jSType == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(2);
            }
            return jSType;
        }

        public void addBaseType(@NotNull VirtualFile file, @NotNull String inherited) {
            if (file == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(3);
            }
            if (inherited == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(4);
            }
            if (!this.myProcessedSerializedTypes.contains(inherited)) {
                SmartList files = this.myCurrentBaseTypes.get(inherited);
                if (files == null) {
                    files = new SmartList();
                    this.myCurrentBaseTypes.put(inherited, (List<VirtualFile>)files);
                }
                if (!files.contains(file)) {
                    files.add(file);
                }
            }
        }

        @NotNull
        public List<JSType> pullResults(@NotNull PsiManager psiManager) {
            if (psiManager == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(5);
            }
            this.myProcessedSerializedTypes.addAll(this.myCurrentBaseTypes.keySet());
            Object result2 = new SmartList();
            for (Map.Entry<String, List<VirtualFile>> entry : this.myCurrentBaseTypes.entrySet()) {
                Collection<VirtualFile> files = JSResolveUtil.sortFiles((Collection<? extends VirtualFile>)entry.getValue());
                for (VirtualFile file : files) {
                    JSType type = JSBaseTypesIndex.deserializeHierarchyElement(psiManager.getProject(), entry.getKey(), false, psiManager.findFile(file));
                    if (type == null) continue;
                    result2.add(type);
                }
            }
            this.myCurrentBaseTypes.clear();
            result2 = JSTypeEvaluateManager.removeNonGenericExtensions((List<JSType>)result2);
            Iterator<Map.Entry<String, List<Object>>> iterator = result2.iterator();
            while (iterator.hasNext()) {
                JSType type = (JSType)((Object)iterator.next());
                this.myBaseTypesQueue.addLast(type);
            }
            Object object = result2;
            if (object == null) {
                JSHierarchyProcessingState.$$$reportNull$$$0(6);
            }
            return object;
        }

        public boolean hasObjectInHierarchy() {
            return this.myInitialType instanceof JSObjectType || this.myProcessedSerializedTypes.contains("Object");
        }

        public boolean isInitialType(@Nullable JSNamespace type) {
            return type == this.myInitialType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialType";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager$JSHierarchyProcessingState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inherited";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager$JSHierarchyProcessingState";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "next";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pullResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addBaseType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "pullResults";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 6 -> new IllegalStateException(string);
            };
        }
    }
}

