/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.highlighting.JSBasicGutterIconNavigationHandler;
import com.intellij.lang.javascript.index.JSInheritanceCallEvaluator;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSDefinitionsSearchExecutor;
import com.intellij.lang.javascript.search.JSMembersSearch;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectionQuery;
import com.intellij.util.EmptyQuery;
import com.intellij.util.MergeQuery;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JavaScriptLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final GutterIconDescriptor.Option myOverriddenOption = new GutterIconDescriptor.Option("js.overridden", JavaScriptBundle.message("linemarker.overridden", new Object[0]), AllIcons.Gutter.OverridenMethod);
    private static final GutterIconDescriptor.Option myImplementedOption = new GutterIconDescriptor.Option("js.implemented", JavaScriptBundle.message("linemarker.implemented", new Object[0]), AllIcons.Gutter.ImplementedMethod);
    private static final GutterIconDescriptor.Option myOverridingOption = new GutterIconDescriptor.Option("js.overriding", JavaScriptBundle.message("linemarker.overriding", new Object[0]), AllIcons.Gutter.OverridingMethod);
    private static final GutterIconDescriptor.Option myImplementingOption = new GutterIconDescriptor.Option("js.implementing", JavaScriptBundle.message("linemarker.implementing", new Object[0]), AllIcons.Gutter.ImplementingMethod);
    private static final GutterIconDescriptor.Option[] OPTIONS = new GutterIconDescriptor.Option[]{myImplementedOption, myImplementingOption, myOverriddenOption, myOverridingOption};
    private static final JSBasicGutterIconNavigationHandler<JSPsiElementBase> ourOverriddenOrImplementedNavHandler = new JSBasicGutterIconNavigationHandler<JSPsiElementBase>(){

        @Override
        protected String getTitle(JSPsiElementBase elt, int size) {
            String name = new JSNamedElementPresenter((PsiElement)elt, Capitalization.EachWordUpperCase).describeWithShortName();
            return JavaScriptBundle.message(JavaScriptLineMarkerProvider.isClassMember(elt) ? "choose.super.method" : "choose.super.function", name, size);
        }

        @Override
        @Nullable
        public Query<JSPsiElementBase> search(JSPsiElementBase elt) {
            if (!elt.isValid()) {
                return EmptyQuery.getEmptyQuery();
            }
            HashSet<JSPsiElementBase> results = new HashSet<JSPsiElementBase>();
            Pair<JSClass, JSPsiElementBase> literalMember = JSInheritanceUtil.findSuperMembersFromContextType(elt);
            if (literalMember != null) {
                results.add((JSPsiElementBase)literalMember.second);
            }
            if (results.isEmpty()) {
                JSInheritanceUtil.iterateOverriddenMembersUp(elt, true, (functions, s) -> {
                    results.addAll((Collection<JSPsiElementBase>)functions);
                    return true;
                }, false);
            }
            return new CollectionQuery(results);
        }
    };
    public static final JSBasicGutterIconNavigationHandler<JSClass> ourClassInheritorsNavHandler = new JSBasicGutterIconNavigationHandler<JSClass>(){

        @Override
        @NotNull
        protected String getTitle(JSClass elt, int size) {
            String name = new JSNamedElementPresenter(elt).describeWithShortName();
            String string = JavaScriptBundle.message("choose.subclass", name, size);
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Query<JSClass> search(JSClass elt) {
            Query<JSClass> query = JSClassSearch.searchClassInheritors(elt, true);
            if (query == null) {
                2.$$$reportNull$$$0(1);
            }
            return query;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "search";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    public static final JSBasicGutterIconNavigationHandler<JSClass> ourInterfaceImplementationsNavHandler = new JSBasicGutterIconNavigationHandler<JSClass>(){

        @Override
        @NotNull
        protected String getTitle(JSClass elt, int size) {
            String name = new JSNamedElementPresenter(elt).describeWithShortName();
            String string = JavaScriptBundle.message("choose.implementing.class", name, size);
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Query<JSClass> search(JSClass elt) {
            Query<JSClass> query = JSDefinitionsSearchExecutor.query(elt, JSClass.class);
            if (query == null) {
                3.$$$reportNull$$$0(1);
            }
            return query;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "search";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    public static final JSBasicGutterIconNavigationHandler<JSPsiElementBase> ourOverridingMembersNavHandler = new JSBasicGutterIconNavigationHandler<JSPsiElementBase>(){

        @Override
        @NotNull
        protected String getTitle(JSPsiElementBase elt, int size) {
            if (elt instanceof JSFunction) {
                String name = new JSNamedElementPresenter((PsiElement)elt, Capitalization.EachWordUpperCase).describeWithShortName();
                String string = JavaScriptBundle.message(JavaScriptLineMarkerProvider.isClassMember(elt) ? "choose.overriding.method" : "choose.overriding.function", name, size);
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = JavaScriptBundle.message("choose.overriding.function", elt.getName(), size);
            if (string == null) {
                4.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public Query<JSPsiElementBase> search(JSPsiElementBase elt) {
            Query<JSPsiElementBase> query = JSDefinitionsSearchExecutor.query((PsiElement)elt, JSPsiElementBase.class);
            if (query == null) {
                4.$$$reportNull$$$0(2);
            }
            return query;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "search";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    public static final JSBasicGutterIconNavigationHandler<JSPsiElementBase> ourImplementingMembersNavHandler = new JSBasicGutterIconNavigationHandler<JSPsiElementBase>(){

        @Override
        @NotNull
        protected String getTitle(JSPsiElementBase elt, int size) {
            String name = new JSNamedElementPresenter((PsiElement)elt, Capitalization.EachWordUpperCase).describeWithShortName();
            String string = JavaScriptBundle.message("choose.implementing.method", name, size);
            if (string == null) {
                5.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Query<JSPsiElementBase> search(JSPsiElementBase elt) {
            Query<JSPsiElementBase> query = JSDefinitionsSearchExecutor.query((PsiElement)elt, JSPsiElementBase.class);
            if (query == null) {
                5.$$$reportNull$$$0(1);
            }
            return query;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider$5";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "search";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    @Nullable
    @TestOnly
    public static GutterIconDescriptor.Option getOption(@NotNull String name) {
        if (name == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return StreamEx.of((Object[])OPTIONS).findFirst(el -> el.getId().equals(name)).orElse(null);
    }

    @NotNull
    private static String getImplementationTail() {
        return JavaScriptLineMarkerProvider.getTooltipTail("GotoImplementation");
    }

    @NotNull
    private static String getBaseMemberTail() {
        return JavaScriptLineMarkerProvider.getTooltipTail("GotoSuperMethod");
    }

    @NotNull
    public static String getClassInheritorsTooltip(@NotNull PsiElement element) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(1);
        }
        String string = "Has subclasses" + JavaScriptLineMarkerProvider.getImplementationTail();
        if (string == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getImplementedInterfacesTooltip(@NotNull PsiElement element) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(3);
        }
        String string = "Has implementations" + JavaScriptLineMarkerProvider.getImplementationTail();
        if (string == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getOverriddenFunctionsTooltip(@NotNull PsiElement element) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(5);
        }
        String string = "Is overridden" + JavaScriptLineMarkerProvider.getImplementationTail();
        if (string == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String getOverriddenFunctionsTooltip2(@NotNull PsiElement element) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(7);
        }
        String string = "Has subtypes" + JavaScriptLineMarkerProvider.getImplementationTail();
        if (string == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String getImplementingFunctionsTooltip(@NotNull PsiElement element) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(9);
        }
        String string = "Is implemented" + JavaScriptLineMarkerProvider.getImplementationTail();
        if (string == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static boolean isClassMember(@Nullable JSPsiElementBase elt) {
        return JSUtils.getMemberContainingClass((PsiElement)elt) != null;
    }

    @Nullable
    private static PsiElement findPrev(@NotNull PsiElement element, Class ... classes) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(11);
        }
        PsiElement startFrom = element.getFirstChild();
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if (prev instanceof PsiComment) {
            startFrom = prev;
        }
        if (startFrom != null) {
            PsiElement cur = element.getPrevSibling();
            while (cur != null) {
                cur = cur.getPrevSibling();
                for (Class cls : classes) {
                    if (!cls.isInstance(cur)) continue;
                    return cur;
                }
            }
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createBottomMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        if (startFrom == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(12);
        }
        if (colorsManager == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(13);
        }
        LineMarkerInfo info = LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)startFrom, (EditorColorsManager)colorsManager);
        info.separatorPlacement = SeparatorPlacement.BOTTOM;
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(14);
        }
        return lineMarkerInfo;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(15);
        }
        if ((file = element.getContainingFile().getVirtualFile()) != null && file.getFileType().isBinary()) {
            return null;
        }
        LineMarkerInfo<PsiElement> elementParent = JavaScriptLineMarkerProvider.createSeparatorMarker(element);
        if (elementParent != null) {
            return elementParent;
        }
        if (!myOverridingOption.isEnabled() && !myImplementingOption.isEnabled()) {
            return null;
        }
        JSPsiElementBase namedElement = JSBasicGutterIconNavigationHandler.getElementFromLineMarker(element, false);
        if (namedElement == null) {
            return null;
        }
        if (JSBasicGutterIconNavigationHandler.getPlaceForLineMarker((PsiElement)namedElement) != element) {
            return null;
        }
        JSInheritanceUtil.JSOverriddenState state = JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)namedElement, () -> JSInheritanceUtil.findSuperMemberInfo(namedElement));
        if (state == null) {
            return null;
        }
        return JavaScriptLineMarkerProvider.createOverridingOrImplementingMarker(namedElement, state.className(), state.isInterface());
    }

    @NotNull
    @Contract(pure=true)
    public String getName() {
        String string = JavaScriptBundle.message("linemarker.javascript.typescript", new Object[0]);
        if (string == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Contract(pure=true)
    public // Could not load outer class - annotation placement on inner may be incorrect
    GutterIconDescriptor.Option @NotNull [] getOptions() {
        if (OPTIONS == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(17);
        }
        return OPTIONS;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> createOverridingOrImplementingMarker(JSPsiElementBase namedElement, String className, boolean isInterface) {
        String tooltip = JavaScriptBundle.message(isInterface ? "linemarker.implements.text" : "linemarker.overrides.text", new JSNamedElementPresenter((PsiElement)namedElement).describeWithShortName(), className);
        return JavaScriptLineMarkerProvider.createOverridingOrImplementingMarker(namedElement, isInterface, tooltip);
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> createSeparatorMarker(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(18);
        }
        if (!DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS) {
            return null;
        }
        if (JavaScriptLineMarkerProvider.isInClassMethod(element)) {
            return null;
        }
        if (element instanceof JSProperty) {
            PsiElement prev = JavaScriptLineMarkerProvider.findPrev(element, JSProperty.class);
            if (JavaScriptLineMarkerProvider.propertyContainsFunction((JSProperty)element) || prev instanceof JSProperty && JavaScriptLineMarkerProvider.propertyContainsFunction((JSProperty)prev)) {
                return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(element), (EditorColorsManager)EditorColorsManager.getInstance());
            }
        }
        if ((element instanceof JSFunctionExpression || element instanceof JSBlockStatement) && (parent = element.getParent()) instanceof JSProperty && PsiTreeUtil.getNextSiblingOfType((PsiElement)parent, JSProperty.class) == null) {
            return JavaScriptLineMarkerProvider.createBottomMethodSeparatorLineMarker(element.getFirstChild(), EditorColorsManager.getInstance());
        }
        if (element instanceof JSFunction) {
            PsiElement parent2;
            Object owner;
            Object varStatement = null;
            if (element instanceof JSFunctionDeclaration) {
                owner = element;
            } else if (element.getParent() instanceof JSExportAssignment) {
                owner = element.getParent();
            } else if (element instanceof JSFunctionExpression) {
                JSQualifiedNamedElement initializedElement = JSPsiImplUtils.getInitializedElement((JSFunctionExpression)element);
                if (initializedElement instanceof JSDefinitionExpression) {
                    PsiElement assignmentExpression = initializedElement.getParent();
                    owner = assignmentExpression instanceof JSAssignmentExpression ? assignmentExpression.getParent() : null;
                } else {
                    if (initializedElement instanceof JSVariable) {
                        varStatement = ((JSVariable)initializedElement).getStatement();
                    }
                    owner = initializedElement;
                }
            } else {
                owner = null;
            }
            PsiElement outerOwner = varStatement != null ? varStatement : owner;
            PsiElement psiElement = parent2 = owner != null ? JSResolveUtil.findParent(outerOwner) : null;
            if (JavaScriptLineMarkerProvider.isContainer(parent2) && (!JavaScriptLineMarkerProvider.isFirstMemberOfContainer(outerOwner) || varStatement != null && varStatement.getVariables()[0] != owner)) {
                return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(owner), (EditorColorsManager)EditorColorsManager.getInstance());
            }
        }
        return null;
    }

    private static boolean isFirstMemberOfContainer(@NotNull PsiElement element) {
        PsiElement prev;
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(19);
        }
        return (prev = JavaScriptLineMarkerProvider.findPrev(element, JSSourceElement.class)) == null || prev instanceof TypeScriptFunction && ((TypeScriptFunction)prev).isOverloadDeclaration();
    }

    private static boolean propertyContainsFunction(@NotNull JSProperty element) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(20);
        }
        return element instanceof JSFunction || element.tryGetFunctionInitializer() != null;
    }

    private static boolean isInClassMethod(@NotNull PsiElement element) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(21);
        }
        while (element != null) {
            if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class)) == null || !JavaScriptLineMarkerProvider.isClassMember((JSFunction)element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String getTooltipTail(@Nullable String actionId) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return "";
        }
        if (actionId == null) {
            return "";
        }
        Object[] shortcuts = ActionManager.getInstance().getAction(actionId).getShortcutSet().getShortcuts();
        Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcuts);
        Object postfix = "<br><div style='margin-top: 5px'><font size='2'>Click";
        if (shortcut != null) {
            postfix = (String)postfix + " or press " + KeymapUtil.getShortcutText((Shortcut)shortcut);
        }
        Object object = postfix = (String)postfix + " to navigate</font></div>";
        if (object == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(22);
        }
        return object;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> createOverridingOrImplementingMarker(JSPsiElementBase member, boolean isInterface, String tooltip) {
        if (isInterface && !myImplementingOption.isEnabled() || !isInterface && !myOverridingOption.isEnabled()) {
            return null;
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(member, isInterface ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod, (Function<? super PsiElement, String>)new ParameterizedFunction<String>(tooltip){

            @Override
            public String apply(PsiElement element) {
                return (String)this.myParam + JavaScriptLineMarkerProvider.getBaseMemberTail();
            }
        }, ourOverriddenOrImplementedNavHandler);
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isContainer(PsiElement parent) {
        return parent instanceof JSClass || parent instanceof JSBlockStatement && parent.getParent() instanceof JSFunction || parent instanceof JSFile || parent instanceof JSEmbeddedContent;
    }

    @NotNull
    private static PsiElement findElementToStartMethodSeparator(@NotNull PsiElement parent) {
        PsiElement deepestFirst;
        ASTNode commentNode;
        if (parent == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(23);
        }
        if ((commentNode = (deepestFirst = PsiTreeUtil.getDeepestFirst((PsiElement)parent)).getNode()) != null && commentNode.getElementType() == JSDocTokenTypes.DOC_COMMENT_START) {
            PsiElement psiElement = deepestFirst;
            if (psiElement == null) {
                JavaScriptLineMarkerProvider.$$$reportNull$$$0(24);
            }
            return psiElement;
        }
        PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)deepestFirst);
        PsiElement comment = null;
        while (!(!(leaf instanceof PsiWhiteSpace) && !(leaf instanceof PsiComment) || leaf instanceof PsiComment && (commentNode = (comment = leaf).getNode()) != null && commentNode.getElementType() == JSDocTokenTypes.DOC_COMMENT_START)) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        if (comment != null) {
            PsiElement psiElement = comment;
            if (psiElement == null) {
                JavaScriptLineMarkerProvider.$$$reportNull$$$0(25);
            }
            return psiElement;
        }
        PsiElement psiElement = deepestFirst;
        if (psiElement == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(26);
        }
        return psiElement;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(27);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(28);
        }
        HashMap<String, Set<JSPsiElementBase>> jsFunctionsToProcess = new HashMap<String, Set<JSPsiElementBase>>();
        HashMap<JSClass, Set<JSQualifiedNamedElement>> classMembersToProcess = new HashMap<JSClass, Set<JSQualifiedNamedElement>>();
        HashSet classesToProcess = new HashSet();
        JavaScriptLineMarkerProvider.fillElementsToCheckMarkers(elements, jsFunctionsToProcess, classMembersToProcess, classesToProcess);
        if (myOverriddenOption.isEnabled() || myImplementedOption.isEnabled()) {
            JavaScriptLineMarkerProvider.addFunctionMarkers(elements, jsFunctionsToProcess, result2);
        }
        for (Map.Entry entry : classMembersToProcess.entrySet()) {
            ProgressManager.checkCanceled();
            JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)entry.getKey(), () -> JavaScriptLineMarkerProvider.addMarkersForMembers((JSClass)entry.getKey(), (Set)entry.getValue(), result2));
        }
        for (JSClass clazz : classesToProcess) {
            ProgressManager.checkCanceled();
            JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)clazz, () -> JavaScriptLineMarkerProvider.addMarkersForClass(clazz, result2));
        }
    }

    private static void addMarkersForMembers(@NotNull JSClass clazz, @Nullable Set<? extends JSQualifiedNamedElement> members, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        boolean classCanBeImplemented;
        HashSet<? extends JSQualifiedNamedElement> membersClone;
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(29);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(30);
        }
        boolean isInterface = clazz.isInterface();
        HashSet<? extends JSQualifiedNamedElement> hashSet = membersClone = members == null ? Collections.emptySet() : new HashSet<JSQualifiedNamedElement>(members);
        if (myOverriddenOption.isEnabled() && !membersClone.isEmpty()) {
            JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)clazz, () -> JavaScriptLineMarkerProvider.addOverriddenMarkersForClass(clazz, result2, membersClone));
        }
        boolean bl = classCanBeImplemented = isInterface || DialectDetector.isTypeScript(clazz);
        if (members == null) {
            return;
        }
        ProgressManager.checkCanceled();
        boolean showImplemented = myImplementedOption.isEnabled();
        boolean showImplementing = myImplementingOption.isEnabled();
        for (JSQualifiedNamedElement jSQualifiedNamedElement : members) {
            Collection<JSPsiElementBase> implementedMembers;
            Query<JSPsiElementBase> query;
            JSPsiElementBase firstItem;
            ProgressManager.checkCanceled();
            if (showImplemented && classCanBeImplemented && (firstItem = (JSPsiElementBase)(query = JavaScriptLineMarkerProvider.createSearchImplementedMemberQuery(isInterface, jSQualifiedNamedElement)).findFirst()) != null && firstItem.getAccessType() != JSAttributeList.AccessType.PRIVATE) {
                result2.add(JavaScriptLineMarkerProvider.createImplementedMemberMarker(jSQualifiedNamedElement));
            }
            if (!showImplementing || isInterface) continue;
            ProgressManager.checkCanceled();
            if (jSQualifiedNamedElement instanceof JSFunction && JavaScriptLineMarkerProvider.hasOverrideModifier((JSFunction)jSQualifiedNamedElement) || (implementedMembers = JSInheritanceUtil.findImplementedMembers(jSQualifiedNamedElement)).isEmpty()) continue;
            result2.add(JavaScriptLineMarkerProvider.createImplementingMemberMarker(jSQualifiedNamedElement, implementedMembers));
        }
        if (showImplemented && JavaScriptLineMarkerProvider.isJSDocInterface(clazz)) {
            JavaScriptLineMarkerProvider.addLineMarkersForJSDocInterfaceMembers(members, result2);
        }
    }

    private static void addOverriddenMarkersForClass(@NotNull JSClass clazz, @NotNull Collection<? super LineMarkerInfo<?>> result2, Set<JSQualifiedNamedElement> membersClone) {
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(31);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(32);
        }
        Query<JSClass> inheritorsClassQuery = JSClassSearch.searchClassInheritors(clazz, true);
        inheritorsClassQuery.forEach(jsClassInheritor -> {
            Iterator membersIterator = membersClone.iterator();
            while (membersIterator.hasNext()) {
                JSQualifiedNamedElement possibleOverrideMember;
                String memberName;
                JSQualifiedNamedElement member = (JSQualifiedNamedElement)membersIterator.next();
                if (member == null || (memberName = member.getName()) == null) continue;
                JSFunction.FunctionKind possibleFunctionKind = null;
                if (member instanceof JSFunction) {
                    possibleFunctionKind = ((JSFunction)member).getKind();
                }
                if (!JavaScriptLineMarkerProvider.isOverrideMember((JSAttributeListOwner)((Object)(possibleOverrideMember = JSInheritanceUtil.findMember(memberName, jsClassInheritor, JSInheritanceUtil.SearchedMemberType.FieldsAndMethods, possibleFunctionKind, false))), (JSAttributeListOwner)((Object)member))) continue;
                result2.add((LineMarkerInfo<?>)JavaScriptLineMarkerProvider.createOverriddenMemberMarker(member));
                membersIterator.remove();
            }
            return !membersClone.isEmpty();
        });
    }

    private static void addLineMarkersForJSDocInterfaceMembers(@NotNull Set<? extends JSQualifiedNamedElement> members, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (members == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(33);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(34);
        }
        for (JSQualifiedNamedElement jSQualifiedNamedElement : members) {
            ProgressManager.checkCanceled();
            JSPsiElementBase implementingMethod = (JSPsiElementBase)JSResolveUtil.findOverridingFunctionsByNamespaces(jSQualifiedNamedElement).findFirst();
            if (implementingMethod == null) continue;
            result2.add(JavaScriptLineMarkerProvider.createImplementedMemberMarker(jSQualifiedNamedElement));
        }
    }

    private static void addMarkersForClass(@NotNull JSClass clazz, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        JSPsiElementBase implementation;
        boolean classCanBeImplemented;
        JSClass jsClassInheritor;
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(35);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(36);
        }
        boolean isInterface = clazz.isInterface();
        if (!(clazz instanceof XmlBackedJSClass) && !isInterface && myOverriddenOption.isEnabled() && (jsClassInheritor = (JSClass)JSClassSearch.searchClassInheritors(clazz, false).findFirst()) != null) {
            result2.add(JavaScriptLineMarkerProvider.createClassHasInheritorsMarker(clazz));
        }
        boolean bl = classCanBeImplemented = isInterface || DialectDetector.isTypeScript(clazz);
        if (classCanBeImplemented && myImplementedOption.isEnabled() && JavaScriptLineMarkerProvider.createSearchImplementationsQuery(clazz).findFirst() != null) {
            result2.add(JavaScriptLineMarkerProvider.createClassHasImplementationsMarker(clazz));
        }
        if (JavaScriptLineMarkerProvider.isJSDocInterface(clazz) && myImplementedOption.isEnabled() && (implementation = (JSPsiElementBase)JSResolveUtil.findOverridingFunctionsByNamespaces(clazz).findFirst()) != null) {
            result2.add(JavaScriptLineMarkerProvider.createClassHasImplementationsMarker(clazz));
        }
    }

    private static boolean isJSDocInterface(@NotNull JSClass clazz) {
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(37);
        }
        String classQName = clazz.getQualifiedName();
        return DialectDetector.isJavaScript(clazz) && !StringUtil.isEmpty((String)classQName) && JSSymbolUtil.isInterface(classQName, clazz);
    }

    @NotNull
    private static Query<JSPsiElementBase> createSearchImplementedMemberQuery(boolean isInterface, JSPsiElementBase member) {
        MergeQuery query = JSMembersSearch.searchImplementingMembers(member, false);
        if (isInterface) {
            query = new MergeQuery(query, JSMembersSearch.searchOverridingMembers(member, false));
        }
        MergeQuery mergeQuery = query;
        if (mergeQuery == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(38);
        }
        return mergeQuery;
    }

    @Contract(value="null, _ -> false")
    private static boolean isOverrideMember(@Nullable JSAttributeListOwner possibleOverrideMember, @NotNull JSAttributeListOwner member) {
        if (member == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(39);
        }
        return possibleOverrideMember != null && JSInheritanceUtil.canHaveSuperMember(possibleOverrideMember) && JSInheritanceUtil.isRealOverride(possibleOverrideMember, ActionScriptPsiImplUtil.getNamespaceValue(member.getAttributeList()), (PsiElement)member);
    }

    @NotNull
    private static Query<JSClass> createSearchImplementationsQuery(@NotNull JSClass clazz) {
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(40);
        }
        if (!clazz.isInterface()) {
            Query<JSClass> query = JSClassSearch.searchInterfaceImplementations(clazz, false);
            if (query == null) {
                JavaScriptLineMarkerProvider.$$$reportNull$$$0(41);
            }
            return query;
        }
        return new MergeQuery(JSClassSearch.searchInterfaceImplementations(clazz, false), JSClassSearch.searchClassInheritors(clazz, false));
    }

    private static boolean hasOverrideModifier(@NotNull JSFunction function) {
        JSAttributeList attributeList;
        if (function == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(42);
        }
        return (attributeList = function.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE);
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createClassHasInheritorsMarker(@NotNull JSClass clazz) {
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(43);
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(clazz, AllIcons.Gutter.OverridenMethod, JavaScriptLineMarkerProvider::getClassInheritorsTooltip, ourClassInheritorsNavHandler);
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createClassHasImplementationsMarker(@NotNull JSClass clazz) {
        if (clazz == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(44);
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(clazz, AllIcons.Gutter.ImplementedMethod, JavaScriptLineMarkerProvider::getImplementedInterfacesTooltip, ourInterfaceImplementationsNavHandler);
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createOverriddenMemberMarker(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(45);
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(member, AllIcons.Gutter.OverridenMethod, JavaScriptLineMarkerProvider::getOverriddenFunctionsTooltip, ourOverridingMembersNavHandler);
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createImplementedMemberMarker(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(46);
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(member, AllIcons.Gutter.ImplementedMethod, JavaScriptLineMarkerProvider::getImplementingFunctionsTooltip, ourImplementingMembersNavHandler);
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createImplementingMemberMarker(@NotNull JSPsiElementBase member, @NotNull Collection<? extends JSPsiElementBase> implementedMembers) {
        if (member == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(47);
        }
        if (implementedMembers == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(48);
        }
        PsiElement implementedMember = implementedMembers.size() == 1 ? (PsiElement)ContainerUtil.getFirstItem(implementedMembers) : null;
        SmartPsiElementPointer pointer = implementedMember != null ? SmartPointerManager.createPointer((PsiElement)implementedMember) : null;
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(member, AllIcons.Gutter.ImplementingMethod, (Function<? super PsiElement, String>)new ParameterizedFunction<SmartPsiElementPointer<PsiElement>>(pointer){

            @Override
            public String apply(PsiElement place) {
                PsiElement implementedMethodIfOnly;
                PsiElement psiElement = implementedMethodIfOnly = this.myParam != null ? ((SmartPsiElementPointer)this.myParam).getElement() : null;
                if (implementedMethodIfOnly != null) {
                    String name;
                    PsiElement element;
                    String in = JavaScriptBundle.message("linemarker.implements.invalid", new Object[0]);
                    if (implementedMethodIfOnly.isValid() && (element = PsiTreeUtil.getParentOfType((PsiElement)implementedMethodIfOnly, JSClass.class)) != null && (name = ((NavigationItem)element).getName()) != null) {
                        in = name;
                    }
                    String name2 = new JSNamedElementPresenter((PsiElement)JSBasicGutterIconNavigationHandler.getElementFromLineMarker(place, true)).describeWithShortName();
                    return JavaScriptBundle.message("linemarker.implements.text", name2, in) + JavaScriptLineMarkerProvider.getBaseMemberTail();
                }
                return JavaScriptBundle.message("linemarker.implements.several", new Object[0]);
            }
        }, (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)(e, place) -> {
            JSQualifiedNamedElement elt = (JSQualifiedNamedElement)JSBasicGutterIconNavigationHandler.getElementFromLineMarker(place, true);
            Collection<JSPsiElementBase> results = JSInheritanceUtil.findImplementedMembers(elt);
            String name = new JSNamedElementPresenter((PsiElement)elt, Capitalization.EachWordUpperCase).describeWithShortName();
            JSBasicGutterIconNavigationHandler.doNavigate(results, JavaScriptBundle.message("choose.super.method", name, results.size()), e);
        }));
    }

    private static void addFunctionMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, final @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(49);
        }
        if (jsFunctionsToProcess == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(50);
        }
        if (result2 == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(51);
        }
        for (Map.Entry<String, Set<JSPsiElementBase>> entry : jsFunctionsToProcess.entrySet()) {
            ProgressManager.checkCanceled();
            final boolean isInterface = JSSymbolUtil.isInterface(entry.getKey(), (PsiElement)entry.getValue().iterator().next());
            final HashSet processed = new HashSet();
            JSResolveUtil.MyNamespaceProcessor processor = new JSResolveUtil.MyNamespaceProcessor(entry.getValue(), false){

                @Override
                protected boolean doProcess(PsiElement elt) {
                    Icon icon;
                    if (processed.contains(this.function)) {
                        return false;
                    }
                    if (isInterface && !myImplementedOption.isEnabled() || !isInterface && !myOverriddenOption.isEnabled()) {
                        return true;
                    }
                    boolean isClassOverride = JSSymbolUtil.isConstructorSymbol(this.function);
                    Icon icon2 = icon = isInterface ? AllIcons.Gutter.ImplementedMethod : AllIcons.Gutter.OverridenMethod;
                    Function<PsiElement, String> tooltipProvider = isClassOverride && isInterface ? JavaScriptLineMarkerProvider::getImplementedInterfacesTooltip : (isClassOverride ? JavaScriptLineMarkerProvider::getOverriddenFunctionsTooltip2 : (isInterface ? JavaScriptLineMarkerProvider::getImplementingFunctionsTooltip : JavaScriptLineMarkerProvider::getOverriddenFunctionsTooltip));
                    result2.add(JavaScriptLineMarkerProvider.createLineMarkerInfo(this.function, icon, tooltipProvider, ourOverridingMembersNavHandler));
                    processed.add(this.function);
                    return false;
                }
            };
            processor.processDescendantsOf(entry.getKey(), elements.get(0));
        }
    }

    private static void fillElementsToCheckMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, @NotNull Map<JSClass, Set<JSQualifiedNamedElement>> classMembersToProcess, @NotNull Set<? super JSClass> classesToProcess) {
        if (elements == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(52);
        }
        if (jsFunctionsToProcess == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(53);
        }
        if (classMembersToProcess == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(54);
        }
        if (classesToProcess == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(55);
        }
        for (PsiElement psiElement : elements) {
            ProgressManager.checkCanceled();
            JSPsiElementBase el = JSBasicGutterIconNavigationHandler.getElementFromLineMarker(psiElement, false);
            if (el == null) continue;
            if (JSClassUtils.isPossibleHierarchyMember((PsiElement)el)) {
                JSQualifiedNamedElement member = (JSQualifiedNamedElement)el;
                if (member instanceof JSFunction && JavaScriptLineMarkerProvider.isNativeFunction((JSFunction)member)) continue;
                JSClass parentClass = JSUtils.getMemberContainingClass((PsiElement)member);
                if (!JSInheritanceUtil.canBeSuperMember((JSAttributeListOwner)((Object)member)) && (member instanceof JSFunction && !((JSFunction)member).isConstructor() || parentClass != null)) continue;
                if (parentClass != null) {
                    Set<JSQualifiedNamedElement> members = classMembersToProcess.get(parentClass);
                    if (members == null) {
                        members = new HashSet<JSQualifiedNamedElement>();
                        classMembersToProcess.put(parentClass, members);
                    }
                    members.add(member);
                    continue;
                }
                PsiElement parent = member.getParent();
                if (!(parent instanceof JSFile) && !(member instanceof JSFunctionExpression)) continue;
                JavaScriptLineMarkerProvider.addJSSymbolToSearch(jsFunctionsToProcess, member);
                continue;
            }
            if (el instanceof JSClass) {
                classesToProcess.add((JSClass)el);
                continue;
            }
            if (!(el instanceof JSDefinitionExpression) && !(el instanceof JSVariable) || !JavaScriptLineMarkerProvider.isExtension(el)) continue;
            JavaScriptLineMarkerProvider.addJSSymbolToSearch(jsFunctionsToProcess, el);
        }
    }

    private static boolean isNativeFunction(@NotNull JSFunction function) {
        JSAttributeList attrList;
        if (function == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(56);
        }
        return function.getContainingFile().getLanguage() != FlexSupportLoader.ECMA_SCRIPT_L4 && (attrList = function.getAttributeList()) != null && attrList.hasModifier(JSAttributeList.ModifierType.NATIVE);
    }

    private static boolean isExtension(JSElement def) {
        JSExpression rOperand = null;
        if (def instanceof JSDefinitionExpression) {
            rOperand = ((JSDefinitionExpression)def).getInitializer();
        } else if (def instanceof JSVariable) {
            rOperand = ((JSVariable)def).getInitializer();
        }
        if (rOperand instanceof JSCallExpression) {
            JSCallExpression callExpression = (JSCallExpression)rOperand;
            return JSInheritanceCallEvaluator.findInheritance(callExpression) != null;
        }
        return false;
    }

    private static void addJSSymbolToSearch(Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, JSPsiElementBase function) {
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(function);
        if (qName != null) {
            Set<JSPsiElementBase> functions = jsFunctionsToProcess.get(qName);
            if (functions == null) {
                functions = new HashSet<JSPsiElementBase>();
                jsFunctionsToProcess.put(qName, functions);
            }
            functions.add(function);
        }
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    private static LineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull JSPsiElementBase element, Icon icon, @Nullable Function<? super PsiElement, String> tooltipProvider, @NotNull GutterIconNavigationHandler<PsiElement> navHandler) {
        if (element == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(57);
        }
        if (navHandler == null) {
            JavaScriptLineMarkerProvider.$$$reportNull$$$0(58);
        }
        return new JSMergeableLineMarkerInfo(JSBasicGutterIconNavigationHandler.getPlaceForLineMarker((PsiElement)element), icon, tooltipProvider, navHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 14, 16, 17, 22, 24, 25, 26, 38, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFrom";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsManager";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 27: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 40: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 39: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 42: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedMembers";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFunctionsToProcess";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMembersToProcess";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesToProcess";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassInheritorsTooltip";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedInterfacesTooltip";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenFunctionsTooltip";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenFunctionsTooltip2";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementingFunctionsTooltip";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createBottomMethodSeparatorLineMarker";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTail";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementToStartMethodSeparator";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchImplementedMemberQuery";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchImplementationsQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassInheritorsTooltip";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 38: 
            case 41: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedInterfacesTooltip";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenFunctionsTooltip";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenFunctionsTooltip2";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getImplementingFunctionsTooltip";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPrev";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createBottomMethodSeparatorLineMarker";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSeparatorMarker";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isFirstMemberOfContainer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "propertyContainsFunction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInClassMethod";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findElementToStartMethodSeparator";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addMarkersForMembers";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addOverriddenMarkersForClass";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addLineMarkersForJSDocInterfaceMembers";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addMarkersForClass";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isJSDocInterface";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isOverrideMember";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createSearchImplementationsQuery";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasOverrideModifier";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createClassHasInheritorsMarker";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createClassHasImplementationsMarker";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createOverriddenMemberMarker";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createImplementedMemberMarker";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createImplementingMemberMarker";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionMarkers";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "fillElementsToCheckMarkers";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isNativeFunction";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarkerInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 10, 14, 16, 17, 22, 24, 25, 26, 38, 41 -> new IllegalStateException(string);
        };
    }

    public static class JSMergeableLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final Function<? super PsiElement, String> myTooltipProvider;

        JSMergeableLineMarkerInfo(PsiElement place, Icon icon, Function<? super PsiElement, String> tooltipProvider, GutterIconNavigationHandler<PsiElement> navHandler) {
            super(place, place.getTextRange(), icon, new JavaFunctionAdapter<PsiElement, String>(tooltipProvider), navHandler, GutterIconRenderer.Alignment.RIGHT);
            this.myTooltipProvider = tooltipProvider;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            if (infos == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(0);
            }
            GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.RIGHT;
            if (alignment == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(1);
            }
            return alignment;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(2);
            }
            return info instanceof JSMergeableLineMarkerInfo && info.getIcon() == this.getIcon();
        }

        @NotNull
        public String getElementPresentation(@NotNull PsiElement element) {
            String fun;
            if (element == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(3);
            }
            String descr = fun = this.myTooltipProvider.apply((PsiElement)element);
            if (!JSMergeableLineMarkerInfo.isTestWithEmptyTails()) {
                int br = fun.indexOf(JavaScriptLineMarkerProvider.getImplementationTail());
                if (br == -1) {
                    br = fun.indexOf(JavaScriptLineMarkerProvider.getBaseMemberTail());
                }
                descr = br == -1 ? fun : fun.substring(0, br);
            }
            String string = JSMergeableLineMarkerInfo.fixInfo(descr, element);
            if (string == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nls
        @NotNull
        private static String fixFirstLetter(@Nls @NotNull String descr) {
            if (descr == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(5);
            }
            if (descr.isEmpty()) {
                String string = descr;
                if (string == null) {
                    JSMergeableLineMarkerInfo.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = Character.toLowerCase(descr.charAt(0)) + descr.substring(1);
            if (string == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            if (infos == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(8);
            }
            return !infos.isEmpty() ? infos.get(0).getIcon() : null;
        }

        @NotNull
        public com.intellij.util.Function<? super PsiElement, String> getCommonTooltip(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            if (infos == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(9);
            }
            com.intellij.util.Function function = element -> {
                StringBuilder tooltip = new StringBuilder();
                boolean hasImplementsInfo = false;
                boolean hasImplementedInfo = false;
                HashSet<String> allInfos = new HashSet<String>();
                for (MergeableLineMarkerInfo infoItem : infos) {
                    String info = infoItem.getLineMarkerTooltip();
                    if (info == null) continue;
                    String finalInfo = info = JSMergeableLineMarkerInfo.fixInfo(info, infoItem.getElement());
                    if (!JSMergeableLineMarkerInfo.isTestWithEmptyTails()) {
                        int indexImplements = info.indexOf(JavaScriptLineMarkerProvider.getImplementationTail());
                        if (indexImplements != -1) {
                            hasImplementsInfo = true;
                            finalInfo = info.substring(0, indexImplements);
                        } else {
                            int indexImplemented = info.indexOf(JavaScriptLineMarkerProvider.getBaseMemberTail());
                            if (indexImplemented != -1) {
                                hasImplementedInfo = true;
                                finalInfo = info.substring(0, indexImplemented);
                            }
                        }
                    }
                    if (!allInfos.add(finalInfo)) continue;
                    if (!tooltip.isEmpty()) {
                        tooltip.append("<hr size=1 noshade>");
                    }
                    tooltip.append(UIUtil.getHtmlBody((String)finalInfo));
                }
                if (!JSMergeableLineMarkerInfo.isTestWithEmptyTails()) {
                    if (hasImplementsInfo) {
                        tooltip.append(StringUtil.trimEnd((String)JavaScriptLineMarkerProvider.getImplementationTail(), (String)"</font></div>")).append(" to inherited members");
                    }
                    if (hasImplementedInfo) {
                        String str = StringUtil.trimEnd((String)JavaScriptLineMarkerProvider.getBaseMemberTail(), (String)"</font></div>");
                        if (hasImplementsInfo) {
                            str = str.replace("<div style='margin-top: 5px'>", "");
                        }
                        tooltip.append(str).append(" to base members").append("</font></div>");
                    } else {
                        tooltip.append("</font></div>");
                    }
                }
                return XmlStringUtil.wrapInHtml((CharSequence)tooltip);
            };
            if (function == null) {
                JSMergeableLineMarkerInfo.$$$reportNull$$$0(10);
            }
            return function;
        }

        @Contract(value="_, null -> param1")
        @Nls(capitalization=Nls.Capitalization.Title)
        private static String fixInfo(@Nls String info, PsiElement infoElement) {
            if (infoElement != null && !((String)info).contains("'" + infoElement.getText() + "'")) {
                PsiElement parent = infoElement.getParent();
                if (parent instanceof JSReferenceExpression) {
                    parent = parent.getParent();
                }
                info = new JSNamedElementPresenter(parent, Capitalization.UpperCase).describeWithShortName() + " " + JSMergeableLineMarkerInfo.fixFirstLetter((String)info);
            }
            return info;
        }

        @Contract(pure=true)
        private static boolean isTestWithEmptyTails() {
            return StringUtil.isEmptyOrSpaces((String)JavaScriptLineMarkerProvider.getBaseMemberTail());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 6, 7, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider$JSMergeableLineMarkerInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider$JSMergeableLineMarkerInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonIconAlignment";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementPresentation";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixFirstLetter";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonIconAlignment";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canMergeWith";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fixFirstLetter";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonIcon";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonTooltip";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 6, 7, 10 -> new IllegalStateException(string);
            };
        }
    }

    private static class JavaFunctionAdapter<Param, Result>
    implements com.intellij.util.Function<Param, Result> {
        @NotNull
        private final Function<Param, Result> myFunction;

        private JavaFunctionAdapter(@NotNull Function<Param, Result> function) {
            if (function == null) {
                JavaFunctionAdapter.$$$reportNull$$$0(0);
            }
            this.myFunction = function;
        }

        public Result fun(Param param) {
            return this.myFunction.apply(param);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaFunctionAdapter adapter = (JavaFunctionAdapter)o;
            return Objects.equals(this.myFunction, adapter.myFunction);
        }

        public int hashCode() {
            return Objects.hashCode(this.myFunction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider$JavaFunctionAdapter", "<init>"));
        }
    }

    private static abstract class ParameterizedFunction<P>
    implements Function<PsiElement, String> {
        @Nullable
        final P myParam;

        @Contract(pure=true)
        ParameterizedFunction(@Nullable P param) {
            this.myParam = param;
        }

        @Contract(value="null -> false", pure=true)
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParameterizedFunction)) {
                return false;
            }
            P otherParam = ((ParameterizedFunction)obj).myParam;
            return Objects.equals(this.myParam, otherParam);
        }

        public int hashCode() {
            return this.myParam != null ? this.myParam.hashCode() : 0;
        }
    }
}

