/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.extjs;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtXTypeReference
implements PsiReference,
HighlightSeverityHolder,
EmptyResolveMessageProvider {
    static final String EXT_NAMESPACE = "ext$xtype";
    static final String EXT_XTYPE_PROPERTY = "xtype";
    @NotNull
    private final JSLiteralExpression myStringLiteral;

    public ExtXTypeReference(@NotNull JSLiteralExpression stringLiteral) {
        if (stringLiteral == null) {
            ExtXTypeReference.$$$reportNull$$$0(0);
        }
        this.myStringLiteral = stringLiteral;
    }

    @NotNull
    public PsiElement getElement() {
        JSLiteralExpression jSLiteralExpression = this.myStringLiteral;
        if (jSLiteralExpression == null) {
            ExtXTypeReference.$$$reportNull$$$0(1);
        }
        return jSLiteralExpression;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)this.myStringLiteral);
        if (textRange == null) {
            ExtXTypeReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        String typeName = StringUtil.unquoteString((String)this.myStringLiteral.getText());
        JSType type = JSTypeEvaluateManager.getTypedefValue((PsiElement)this.myStringLiteral, typeName);
        JSTypeSource source = type != null ? type.getSource() : null;
        PsiElement element = source != null && source.getSourceElement() != null && source.getSourceElement().isValid() ? source.getSourceElement() : null;
        return element;
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.unquoteString((String)this.myStringLiteral.getText());
        if (string == null) {
            ExtXTypeReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ExtXTypeReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ExtXTypeReference.$$$reportNull$$$0(5);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ExtXTypeReference.$$$reportNull$$$0(6);
        }
        return this.resolve() == element;
    }

    public Object @NotNull [] getVariants() {
        HashSet<String> xtypes = new HashSet<String>();
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope((PsiElement)this.myStringLiteral);
        Collection<JSPsiElementBase> members = JSClassResolver.getInstance().findNamespaceMembers(EXT_NAMESPACE, scope2);
        for (JSPsiElementBase member : members) {
            xtypes.add(member.getName());
        }
        Object[] objectArray = xtypes.toArray();
        if (objectArray == null) {
            ExtXTypeReference.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
        if (highlightSeverity == null) {
            ExtXTypeReference.$$$reportNull$$$0(8);
        }
        return highlightSeverity;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JavaScriptBundle.message("js.frameworks.sencha.xtype.not.found", StringUtil.unquoteString((String)this.myStringLiteral.getText()));
        if (string == null) {
            ExtXTypeReference.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/extjs/ExtXTypeReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedReferenceSeverity";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

