/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.documentation.JSTooltipCachedCodeStyleSettingsService;
import com.intellij.lang.javascript.documentation.JSTooltipWithHtmlHighlighterImplKt;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.validation.JSTooltipWithHtmlHighlighter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\fH\u0002J\"\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\fH\u0002J\u0018\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/lang/javascript/documentation/JSTooltipWithHtmlHighlighterImpl;", "Lcom/intellij/lang/javascript/validation/JSTooltipWithHtmlHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "highlightTypeOrStmt", "", "typePlainText", "wrapWithCodeTag", "", "wrapLimit", "", "highlightName", "name", "element", "Lcom/intellij/psi/PsiElement;", "applyAttributes", "text", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "highlightWithLexer", "language", "Lcom/intellij/lang/Language;", "isBlock", "highlightImpl", "doHighlight", "code", "limit", "shouldWrapWithBlock", "originalCode", "htmlCode", "wrapToCodeTagsForTooltip", "codeInnerHtml", "simpleLinesFallback", "fullErrorText", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSTooltipWithHtmlHighlighterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTooltipWithHtmlHighlighterImpl.kt\ncom/intellij/lang/javascript/documentation/JSTooltipWithHtmlHighlighterImpl\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n52#2:140\n52#2:141\n52#2:142\n52#2:143\n739#3,9:144\n37#4,2:153\n1#5:155\n*S KotlinDebug\n*F\n+ 1 JSTooltipWithHtmlHighlighterImpl.kt\ncom/intellij/lang/javascript/documentation/JSTooltipWithHtmlHighlighterImpl\n*L\n35#1:140\n39#1:141\n43#1:142\n47#1:143\n125#1:144,9\n125#1:153,2\n*E\n"})
public final class JSTooltipWithHtmlHighlighterImpl
implements JSTooltipWithHtmlHighlighter {
    @NotNull
    private final Project project;

    public JSTooltipWithHtmlHighlighterImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    @NotNull
    public String highlightTypeOrStmt(@NotNull String typePlainText, boolean wrapWithCodeTag, int wrapLimit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)typePlainText, (String)"typePlainText");
        String string2 = this.highlightImpl(typePlainText, wrapLimit);
        boolean $i$f$applyIf = false;
        if (wrapWithCodeTag) {
            void $this$highlightTypeOrStmt_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            string = this.wrapWithCodeTag((String)$this$highlightTypeOrStmt_u24lambda_u240, this.shouldWrapWithBlock(typePlainText, (String)$this$highlightTypeOrStmt_u24lambda_u240, wrapLimit));
        } else {
            string = $this$applyIf$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public String highlightName(@NotNull String name, @NotNull PsiElement element, boolean wrapWithCodeTag) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string2 = JSQuickNavigateBuilder.Companion.buildHtmlForName(element, name);
        boolean $i$f$applyIf = false;
        if (wrapWithCodeTag) {
            void $this$highlightName_u24lambda_u241 = $this$applyIf$iv;
            boolean bl = false;
            string = this.wrapWithCodeTag((String)$this$highlightName_u24lambda_u241, false);
        } else {
            string = $this$applyIf$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public String applyAttributes(@NotNull String text, @NotNull TextAttributesKey textAttributesKey, boolean wrapWithCodeTag) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textAttributesKey, (String)"textAttributesKey");
        String string2 = QuickDocHighlightingHelper.getStyledFragment((String)text, (TextAttributesKey)textAttributesKey);
        boolean $i$f$applyIf = false;
        if (wrapWithCodeTag) {
            void $this$applyAttributes_u24lambda_u242 = $this$applyIf$iv;
            boolean bl = false;
            string = this.wrapWithCodeTag((String)$this$applyAttributes_u24lambda_u242, JSTooltipWithHtmlHighlighterImpl.shouldWrapWithBlock$default(this, text, (String)$this$applyAttributes_u24lambda_u242, 0, 4, null));
        } else {
            string = $this$applyIf$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public String highlightWithLexer(@NotNull String text, @NotNull Language language, boolean wrapWithCodeTag) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String string2 = QuickDocHighlightingHelper.getStyledCodeFragment((Project)this.project, (Language)language, (String)text);
        boolean $i$f$applyIf = false;
        if (wrapWithCodeTag) {
            void $this$highlightWithLexer_u24lambda_u243 = $this$applyIf$iv;
            boolean bl = false;
            string = this.wrapWithCodeTag((String)$this$highlightWithLexer_u24lambda_u243, JSTooltipWithHtmlHighlighterImpl.shouldWrapWithBlock$default(this, text, (String)$this$highlightWithLexer_u24lambda_u243, 0, 4, null));
        } else {
            string = $this$applyIf$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public String wrapWithCodeTag(@NotNull String text, boolean isBlock) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.wrapToCodeTagsForTooltip(text, isBlock);
    }

    private final String highlightImpl(String typePlainText, int wrapLimit) {
        String string;
        if (JSTooltipWithHtmlHighlighterImplKt.access$getSKIP_HTML_HIGHLIGHT_PATTERN$p().matcher(typePlainText).matches()) {
            string = typePlainText;
        } else {
            string = this.doHighlight(this.project, typePlainText, wrapLimit);
            if (string == null) {
                string = this.simpleLinesFallback(typePlainText);
            }
        }
        return string;
    }

    private final String doHighlight(Project project, String code, int limit) {
        Pair<PsiElement, Boolean> pair = JSTooltipWithHtmlHighlighterImpl.doHighlight$buildPsiInReadActionWithErrorsChecked(project, (Function0<? extends PsiElement>)((Function0)() -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$8(code, project)));
        PsiElement typeElement = (PsiElement)pair.component1();
        boolean typeElementHasErrors = (Boolean)pair.component2();
        if (typeElement == null || typeElementHasErrors) {
            Pair<PsiElement, Boolean> pair2 = JSTooltipWithHtmlHighlighterImpl.doHighlight$buildPsiInReadActionWithErrorsChecked(project, (Function0<? extends PsiElement>)((Function0)() -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$9(project, code)));
            PsiElement jsElement = (PsiElement)pair2.component1();
            boolean jsElementHasErrors = (Boolean)pair2.component2();
            if (jsElement == null || jsElementHasErrors) {
                return null;
            }
            String fakeText = jsElement.getText();
            String string = (String)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, () -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$10(project, fakeText));
            return string != null ? string.toString() : null;
        }
        SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, () -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$11(typeElement));
        if (smartPsiElementPointer == null) {
            return null;
        }
        SmartPsiElementPointer pointer = smartPsiElementPointer;
        PsiFile psiFile = (PsiFile)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, () -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$12(typeElement));
        if (psiFile == null) {
            return null;
        }
        PsiFile containingFile = psiFile;
        CodeStyleSettings tooltipStyleSettings = ((JSTooltipCachedCodeStyleSettingsService)project.getService(JSTooltipCachedCodeStyleSettingsService.class)).getTooltipSettings(code.length() >= limit);
        JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, () -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$14(containingFile, project, tooltipStyleSettings, typeElement));
        PsiElement psiElement = (PsiElement)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, () -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$15(pointer));
        if (psiElement == null) {
            return null;
        }
        PsiElement afterTypeElement = psiElement;
        String prefix = "let foo: ";
        String string = (String)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, () -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$16(typeElement));
        if (string == null) {
            return null;
        }
        String fakeText = prefix + string;
        int startOffset = prefix.length();
        int endOffset = fakeText.length();
        CharSequence charSequence = (CharSequence)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction(project, () -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$17(afterTypeElement, fakeText, startOffset, endOffset));
        if (charSequence == null) {
            return null;
        }
        CharSequence html = charSequence;
        return ((Object)html).toString();
    }

    private final boolean shouldWrapWithBlock(String originalCode, String htmlCode, int limit) {
        return originalCode.length() > limit || StringsKt.contains$default((CharSequence)htmlCode, (CharSequence)"<br", (boolean)false, (int)2, null);
    }

    static /* synthetic */ boolean shouldWrapWithBlock$default(JSTooltipWithHtmlHighlighterImpl jSTooltipWithHtmlHighlighterImpl, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = JSTooltipWithHtmlHighlighter.Companion.getMinCodeLengthToMultiline();
        }
        return jSTooltipWithHtmlHighlighterImpl.shouldWrapWithBlock(string, string2, n);
    }

    private final String wrapToCodeTagsForTooltip(String codeInnerHtml, boolean isBlock) {
        return isBlock ? "<pre><code>" + codeInnerHtml + "</code></pre>" : "<code>" + codeInnerHtml + "</code>";
    }

    /*
     * WARNING - void declaration
     */
    private final String simpleLinesFallback(String fullErrorText) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        String text = XmlStringUtil.escapeString((String)fullErrorText);
        Intrinsics.checkNotNull((Object)text);
        Object object = text;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] rows = thisCollection$iv.toArray(new String[0]);
        object = StringUtil.join((Object[])rows, arg_0 -> JSTooltipWithHtmlHighlighterImpl.simpleLinesFallback$lambda$20(JSTooltipWithHtmlHighlighterImpl::simpleLinesFallback$lambda$19, arg_0), (String)"<br>");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"join(...)");
        return object;
    }

    private static final Object doHighlight$projectReadAction$lambda$4(Function0 $tmp0) {
        return $tmp0.invoke();
    }

    private static final Object doHighlight$projectReadAction$lambda$5(Function0 $action) {
        return $action.invoke();
    }

    private static final <T> T doHighlight$projectReadAction(Project $project, Function0<? extends T> action) {
        return (T)($project.isDisposed() ? null : (ApplicationKt.getApplication().isDispatchThread() ? ReadAction.compute(() -> JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction$lambda$4(action)) : ReadAction.computeCancellable(() -> JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction$lambda$5(action))));
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair doHighlight$buildPsiInReadActionWithErrorsChecked$lambda$7(Function0 $builder) {
        boolean bl;
        PsiElement result2;
        PsiElement psiElement = result2 = (PsiElement)$builder.invoke();
        PsiElement psiElement2 = result2;
        if (psiElement2 != null && (psiElement2 = psiElement2.getContainingFile()) != null) {
            void it;
            PsiElement psiElement3 = psiElement2;
            PsiElement psiElement4 = psiElement;
            boolean bl2 = false;
            boolean bl3 = PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)it));
            psiElement = psiElement4;
            bl = bl3;
        } else {
            bl = true;
        }
        Boolean bl4 = bl;
        PsiElement psiElement5 = psiElement;
        return new Pair((Object)psiElement5, (Object)bl4);
    }

    private static final Pair<PsiElement, Boolean> doHighlight$buildPsiInReadActionWithErrorsChecked(Project $project, Function0<? extends PsiElement> builder2) {
        Pair pair = (Pair)JSTooltipWithHtmlHighlighterImpl.doHighlight$projectReadAction($project, () -> JSTooltipWithHtmlHighlighterImpl.doHighlight$buildPsiInReadActionWithErrorsChecked$lambda$7(builder2));
        if (pair == null) {
            pair = new Pair(null, (Object)true);
        }
        return pair;
    }

    private static final PsiElement doHighlight$lambda$8(String $code, Project $project) {
        return JSChangeUtil.tryCreateTypeElement($code, $project);
    }

    private static final PsiElement doHighlight$lambda$9(Project $project, String $code) {
        return (PsiElement)JSChangeUtil.createJSContentFromText($project, $code, null);
    }

    private static final String doHighlight$lambda$10(Project $project, String $fakeText) {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)javascriptLanguage), (String)"INSTANCE");
        Language language = javascriptLanguage;
        Intrinsics.checkNotNull((Object)$fakeText);
        return QuickDocHighlightingHelper.getStyledCodeFragment((Project)$project, (Language)language, (String)$fakeText);
    }

    private static final SmartPsiElementPointer doHighlight$lambda$11(PsiElement $typeElement) {
        return SmartPointerManager.createPointer((PsiElement)$typeElement);
    }

    private static final PsiFile doHighlight$lambda$12(PsiElement $typeElement) {
        return $typeElement.getContainingFile();
    }

    private static final void doHighlight$lambda$14$lambda$13(PsiElement $typeElement) {
        FormatFixer.create($typeElement, FormatFixer.Mode.Reformat).fixFormat();
    }

    private static final Unit doHighlight$lambda$14(PsiFile $containingFile, Project $project, CodeStyleSettings $tooltipStyleSettings, PsiElement $typeElement) {
        Document document = $containingFile.getViewProvider().getDocument();
        if (document != null) {
            PsiDocumentManager.getInstance((Project)$project).commitDocument(document);
        }
        CodeStyle.runWithLocalSettings((Project)$project, (CodeStyleSettings)$tooltipStyleSettings, () -> JSTooltipWithHtmlHighlighterImpl.doHighlight$lambda$14$lambda$13($typeElement));
        return Unit.INSTANCE;
    }

    private static final PsiElement doHighlight$lambda$15(SmartPsiElementPointer $pointer) {
        return $pointer.getElement();
    }

    private static final String doHighlight$lambda$16(PsiElement $typeElement) {
        return $typeElement.getText();
    }

    private static final CharSequence doHighlight$lambda$17(PsiElement $afterTypeElement, String $fakeText, int $startOffset, int $endOffset) {
        return JSHtmlHighlightingUtil.tryGetHtmlHighlighting($afterTypeElement, $fakeText, null, $startOffset, $endOffset);
    }

    private static final String simpleLinesFallback$lambda$19(String it) {
        String string = StringUtil.trimLeading((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimLeading(...)");
        String withoutLeading = string;
        int spacesSize = it.length() - withoutLeading.length();
        return StringUtil.repeat((String)"&nbsp;", (int)spacesSize) + withoutLeading;
    }

    private static final String simpleLinesFallback$lambda$20(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

