/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSymbolCompletionUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSDestructuringPropertyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        JSDestructuringObject objectPattern;
        PsiElement position;
        PsiElement parent;
        if (parameters == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((parent = (position = parameters.getPosition()).getParent()) instanceof JSVariable) {
            parent = parent.getParent();
        }
        assert (parent instanceof JSDestructuringProperty) : "must be filtered in JSPatternBasedCompletionContributor";
        JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)parent;
        JSDestructuringObject jSDestructuringObject = objectPattern = destructuringProperty.getParent() instanceof JSDestructuringObject ? (JSDestructuringObject)destructuringProperty.getParent() : null;
        if (objectPattern == null) {
            return;
        }
        Set existingProperties = ContainerUtil.map2Set((Object[])objectPattern.getProperties(), JSNamedElementBase::getName);
        PsiFile file = objectPattern.getContainingFile();
        QualifiedItemProcessor<? extends ResultSink> localProcessor = JSDestructuringPropertyCompletionProvider.createCompletionItemProcessor(destructuringProperty, result2.getPrefixMatcher());
        JSTypeEvaluator.evaluateExpressionOrElementTypes(file, localProcessor, (PsiElement)objectPattern);
        List<PsiElement> localResults = localProcessor.getResults();
        VariantsProcessor processor = new VariantsProcessor(file, (PsiElement)destructuringProperty, true, parameters, result2);
        if (localResults != null) {
            processor.populateCompletionList(JSDestructuringPropertyCompletionProvider.filterResults(JSDestructuringPropertyCompletionProvider.toLookupElements(localResults), existingProperties), false, result2);
        }
        JSSymbolCompletionUtil.processCompeteMatchedElements(processor);
        Collection<LookupElement> variantProcessorResults = processor.getCurrentResults();
        processor.populateCompletionList(JSDestructuringPropertyCompletionProvider.filterResults(variantProcessorResults, existingProperties), false, result2);
    }

    private static List<LookupElement> filterResults(@NotNull Collection<? extends LookupElement> results, @NotNull Set<String> existingProperties) {
        if (results == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(3);
        }
        if (existingProperties == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(4);
        }
        return ContainerUtil.filter(results, lookupElement -> {
            JSQualifiedName namespace;
            PsiElement element = lookupElement.getPsiElement();
            if (element instanceof ES6ExportDefaultAssignment && existingProperties.contains("default")) {
                return false;
            }
            if (element instanceof JSQualifiedNamedElement && (namespace = ((JSQualifiedNamedElement)element).getNamespace()) != null && JSCommonTypeNames.OBJECT_FUNCTION_CLASS_NAMES.contains(namespace.getName())) {
                return false;
            }
            return !(element instanceof PsiNamedElement) || !existingProperties.contains(((PsiNamedElement)element).getName());
        });
    }

    @NotNull
    private static List<LookupElement> toLookupElements(@NotNull List<PsiElement> localResults) {
        if (localResults == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.mapNotNull(localResults, e -> {
            if (e instanceof ES6ExportDefaultAssignment) {
                return PrioritizedLookupElement.withPriority((LookupElement)JSLookupUtilImpl.createLookupElement(e, "default"), (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue());
            }
            if (!(e instanceof PsiNamedElement)) {
                return null;
            }
            return JSLookupUtilImpl.createPrioritizedLookupElement((PsiNamedElement)e, JSLookupPriority.SMART_PRIORITY);
        });
        if (list == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static QualifiedItemProcessor<? extends ResultSink> createCompletionItemProcessor(@NotNull JSElement destructuringElement, PrefixMatcher matcher) {
        if (destructuringElement == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(7);
        }
        QualifiedItemProcessor<? extends ResultSink> qualifiedItemProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)destructuringElement).createCompletionItemProcessor(new CompletionResultSink((PsiElement)destructuringElement, matcher), destructuringElement.getContainingFile());
        if (qualifiedItemProcessor == null) {
            JSDestructuringPropertyCompletionProvider.$$$reportNull$$$0(8);
        }
        return qualifiedItemProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingProperties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localResults";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSDestructuringPropertyCompletionProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSDestructuringPropertyCompletionProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toLookupElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionItemProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterResults";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toLookupElements";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionItemProcessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

