/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandler;
import com.intellij.lang.javascript.frameworks.modules.JSFileModuleReference;
import com.intellij.lang.javascript.navigation.JSDeclarationEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImplicitMemberForComputedProperty;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class JSTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    private static boolean ourAssertOnResolveWithAllResults = false;

    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        JSClass containingClass;
        if (element == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        if (element instanceof JSFunction ? (containingClass = JSUtils.getMemberContainingClass(element)) != null && containingClass.isInterface() : element instanceof JSClass) {
            return false;
        }
        if (element instanceof JSQualifiedNamedElement && TypeScriptUtil.isDefinitionFile(element.getContainingFile().getVirtualFile())) {
            return false;
        }
        return !(element instanceof ES6ImportedBinding);
    }

    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference ref2, int flags) {
        if (ref2 == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        if (ref2 instanceof ES6ImportExportSpecifier) {
            return JSTargetElementEvaluator.getImplementationIfOverloads(((ES6ImportExportSpecifier)ref2).multiResolve(false));
        }
        if (ref2 instanceof JSReferenceExpression || ref2 instanceof JSDocReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)ref2).multiResolve(false);
            if (results.length > 1) {
                return (PsiElement)ObjectUtils.coalesce((Object)JSTargetElementEvaluator.getImplementationIfOverloads(results), (Object)JSTargetElementEvaluator.getFirstDefinitionIfDuplicates(results));
            }
            if (results.length == 1 && results[0].getElement() instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                return ((TypeScriptProxyImplicitElementWithBackingItem)results[0].getElement()).getExplicitElement();
            }
        } else {
            if (JSTargetElementEvaluator.isLastTypeScriptModuleRef(ref2)) {
                return JSTargetElementEvaluator.getForTypeScriptModuleRef((JSFileModuleReference)ref2);
            }
            if (ref2 instanceof PsiMultiReference) {
                for (PsiReference reference : ((PsiMultiReference)ref2).getReferences()) {
                    if (!JSTargetElementEvaluator.isLastTypeScriptModuleRef(reference)) continue;
                    return JSTargetElementEvaluator.getForTypeScriptModuleRef((JSFileModuleReference)reference);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getImplementationIfOverloads(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        if (results.length < 2) {
            return null;
        }
        PsiElement firstElement = results[0].getElement();
        if (!(firstElement instanceof TypeScriptFunction)) {
            return null;
        }
        TypeScriptFunction implementation = TypeScriptPsiUtil.getLastOverload((TypeScriptFunction)firstElement);
        List<TypeScriptFunction> overloadDeclarations = implementation.getOverloadDeclarations();
        for (ResolveResult result2 : results) {
            PsiElement element = result2.getElement();
            if (element == implementation || element instanceof TypeScriptFunction && overloadDeclarations.contains(element)) continue;
            return null;
        }
        return implementation;
    }

    @Nullable
    private static PsiElement getFirstDefinitionIfDuplicates(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(3);
        }
        boolean first = true;
        JSQualifiedName namespace = null;
        PsiFile file = null;
        for (ResolveResult result2 : results) {
            PsiElement element = result2.getElement();
            if (!(element instanceof JSDefinitionExpression)) {
                return null;
            }
            if (((JSDefinitionExpression)element).getInitializerOrStub() instanceof JSFunctionItem) {
                return null;
            }
            if (first) {
                first = false;
                namespace = ((JSDefinitionExpression)element).getNamespace();
                file = element.getContainingFile();
                continue;
            }
            if (Comparing.equal(namespace, (Object)((JSDefinitionExpression)element).getNamespace()) && Comparing.equal((Object)file, (Object)element.getContainingFile())) continue;
            return null;
        }
        return results[0].getElement();
    }

    private static boolean isLastTypeScriptModuleRef(@NotNull PsiReference ref2) {
        if (ref2 == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(4);
        }
        if (ref2 instanceof JSFileModuleReference) {
            JSFileModuleReference moduleReference = (JSFileModuleReference)ref2;
            if (DialectDetector.isTypeScript(ref2.getElement()) && moduleReference.isLast()) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement getForTypeScriptModuleRef(@NotNull JSFileModuleReference reference) {
        Collection<PsiElement> elements;
        PsiElement element;
        if (reference == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(5);
        }
        if ((element = reference.getElement()) instanceof ES6FromClause && (elements = ((ES6FromClause)element).resolveReferencedElements()).size() == 1) {
            return (PsiElement)ContainerUtil.getFirstItem(elements);
        }
        return null;
    }

    @Nullable
    public PsiElement getNamedElement(@NotNull PsiElement element) {
        ASTNode node;
        JSElementIndexingData indexingData;
        if (element == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(6);
        }
        PsiElement parent = element.getParent();
        if (!(element instanceof JSNamedElement) && !(element instanceof JSImplicitElementProvider) && parent instanceof JSImplicitElementProvider && (indexingData = ((JSImplicitElementProvider)parent).getIndexingData()) != null) {
            List<JSImplicitElement> elements;
            String text = element.getText();
            if (element.getNode().getElementType() == JSTokenTypes.STRING_LITERAL) {
                text = StringUtil.unquoteString((String)text);
            }
            if (!(elements = indexingData.findElementsByNameOrQName(text)).isEmpty()) {
                return (PsiElement)ContainerUtil.getFirstItem(elements);
            }
        }
        if (parent instanceof ES6ExportDefaultAssignment && ((node = element.getNode()).getElementType() == JSTokenTypes.EXPORT_KEYWORD || node.getElementType() == JSTokenTypes.DEFAULT_KEYWORD)) {
            return parent;
        }
        if (parent instanceof JSFunction && element.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD || parent instanceof JSClass && element.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD) {
            JSQualifiedNamedElement initializedElement;
            if (parent instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)parent)) != null) {
                return initializedElement;
            }
            return parent;
        }
        return null;
    }

    @Nullable
    public PsiElement adjustTargetElement(Editor editor, int offset, int flags, @NotNull PsiElement targetElement) {
        if (targetElement == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(7);
        }
        for (JSFrameworkSpecificHandler handler : JSFrameworkSpecificHandler.EP_NAME.allForLanguage(targetElement.getLanguage())) {
            PsiElement adjusted = handler.adjustTargetElement(editor, offset, flags, targetElement);
            if (adjusted == targetElement) continue;
            return adjusted;
        }
        if (targetElement instanceof TypeScriptProxyImplicitElement && !(targetElement instanceof TypeScriptImplicitMemberForComputedProperty) || targetElement instanceof JSQualifiedNamedElement && !BitUtil.isSet((int)flags, (int)2)) {
            targetElement = JSTargetElementEvaluator.adjustTargetElement(targetElement);
        }
        return targetElement;
    }

    @Nullable
    public static PsiElement adjustTargetElement(@Nullable PsiElement targetElement) {
        if (targetElement == null) {
            return null;
        }
        if (targetElement instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            targetElement = ((TypeScriptProxyImplicitElementWithBackingItem)targetElement).getBackingElement();
        }
        if (targetElement instanceof TypeScriptProxyImplicitElement) {
            targetElement = ((TypeScriptProxyImplicitElement)targetElement).getExplicitElement();
        }
        return targetElement;
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static PsiElement replaceWithSourceElement(@Nullable PsiElement targetElement, @Nullable PsiElement context2) {
        JSQualifiedNamedElement qualifiedNamedElement;
        PsiElement sourceElement;
        if (targetElement instanceof JSQualifiedNamedElement && (sourceElement = JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(context2 != null ? context2 : targetElement, () -> JSTargetElementEvaluator.lambda$replaceWithSourceElement$0(qualifiedNamedElement = (JSQualifiedNamedElement)targetElement, context2))) != null) {
            targetElement = sourceElement;
        }
        targetElement = JSTargetElementEvaluator.findSourceOfJSDocImplicitElement(targetElement);
        return targetElement;
    }

    @Nullable
    private static PsiElement findSourceOfJSDocImplicitElement(@Nullable PsiElement element) {
        String name;
        if (element instanceof JSImplicitElement && element.getParent() instanceof JSDocComment && (name = ((JSImplicitElement)element).getName()) != null) {
            List sourceElements = JSClassResolver.getInstance().findElementsByNameIncludingImplicit(name, GlobalSearchScope.fileScope((PsiFile)element.getContainingFile()));
            if ((sourceElements = ContainerUtil.filter(sourceElements, it -> !(it instanceof JSImplicitElement))).size() == 1) {
                PsiElement sourceElement = (PsiElement)ContainerUtil.getFirstItem((Collection)sourceElements);
                if (PsiTreeUtil.isAncestor((PsiElement)element.getParent().getParent(), (PsiElement)sourceElement, (boolean)true)) {
                    return sourceElement;
                }
            }
        }
        return element;
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        PsiElement adjusted;
        if (element == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(8);
        }
        return (adjusted = JSDeclarationEvaluator.adjustDeclaration(element, null)) != element ? adjusted : null;
    }

    @Nullable
    public Collection<PsiElement> getTargetCandidates(@NotNull PsiReference reference) {
        if (reference == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(9);
        }
        if (!(reference instanceof JSElement) && !(reference instanceof JSReferenceSetElement)) {
            return super.getTargetCandidates(reference);
        }
        if (reference instanceof PsiPolyVariantReference) {
            return JSTargetElementEvaluator.resolveAndAdjustTarget((PsiPolyVariantReference)reference);
        }
        PsiElement resolve2 = JSTargetElementEvaluator.adjustTargetElement(reference.resolve());
        return ContainerUtil.createMaybeSingletonList((Object)(TargetElementUtil.getInstance().isNavigatableSource(resolve2) ? resolve2 : null));
    }

    @NotNull
    public static List<PsiElement> resolveAndAdjustTarget(@NotNull PsiPolyVariantReference reference) {
        ResolveResult[] results;
        if (reference == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(10);
        }
        if ((results = JSTargetElementEvaluator.resolveReferenceExpressionWithAllResolveResults(reference)).length == 0) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSTargetElementEvaluator.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<PsiElement> navigatableResults = new ArrayList<PsiElement>(results.length);
        for (ResolveResult r : results) {
            PsiElement element = JSTargetElementEvaluator.adjustTargetElement(r.getElement());
            if (!TargetElementUtil.getInstance().isNavigatableSource(element)) continue;
            navigatableResults.add(element);
        }
        ArrayList<PsiElement> arrayList = navigatableResults;
        if (arrayList == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @TestOnly
    public static void forbidResolveWithAllResults(@NotNull Disposable disposable) {
        if (disposable == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(13);
        }
        ourAssertOnResolveWithAllResults = true;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ourAssertOnResolveWithAllResults = false;
            }
        });
    }

    public static ResolveResult @NotNull [] resolveReferenceExpressionWithAllResolveResults(@NotNull PsiPolyVariantReference polyReference) {
        if (polyReference == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(14);
        }
        if (ourAssertOnResolveWithAllResults) {
            throw new RuntimeException("Unlimited resolve is not allowed");
        }
        ResolveResult[] results = polyReference.multiResolve(false);
        if (JSResolveResult.isTooManyCandidatesResult(results)) {
            if (polyReference instanceof JSReferenceExpressionImpl) {
                ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)((JSReferenceExpressionImpl)polyReference)).createReferenceExpressionResolver((JSReferenceExpressionImpl)polyReference, true);
                ResolveResult[] resolveResultArray = resolver.resolve((PsiPolyVariantReference)((JSReferenceExpressionImpl)polyReference), false);
                if (resolveResultArray == null) {
                    JSTargetElementEvaluator.$$$reportNull$$$0(15);
                }
                return resolveResultArray;
            }
            if (polyReference instanceof JSReferenceSetElement) {
                JSReferenceSetElement ref2 = (JSReferenceSetElement)polyReference;
                ResolveResult[] resolveResultArray = ref2.doResolveQualifiedName(JSReferenceSetElement.getQualifierNameForResolve(ref2), true);
                if (resolveResultArray == null) {
                    JSTargetElementEvaluator.$$$reportNull$$$0(16);
                }
                return resolveResultArray;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSTargetElementEvaluator.$$$reportNull$$$0(17);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (results == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(18);
        }
        return results;
    }

    @Nullable
    public PsiElement adjustElement(Editor editor, int flags, @Nullable PsiElement element, @Nullable PsiElement contextElement) {
        ResolveResult[] results;
        if (element instanceof ES6ImportedBinding && (results = ((ES6ImportedBinding)element).multiResolve(false)).length == 1) {
            return JSTargetElementEvaluator.adjustTargetElement(results[0].getElement());
        }
        return super.adjustElement(editor, flags, element, contextElement);
    }

    public boolean isAcceptableNamedParent(@NotNull PsiElement parent) {
        PsiElement context2;
        if (parent == null) {
            JSTargetElementEvaluator.$$$reportNull$$$0(19);
        }
        if (parent instanceof JSDefinitionExpression) {
            JSExpression expression = ((JSDefinitionExpression)parent).getExpression();
            if (expression instanceof JSReferenceExpression && !DumbService.isDumb((Project)parent.getProject())) {
                return ((JSReferenceExpression)expression).resolve() == parent;
            }
            return false;
        }
        if (parent instanceof JSVariable && !DumbService.isDumb((Project)parent.getProject()) && (context2 = parent.getContext()) instanceof JSDestructuringShorthandedProperty) {
            PsiReference reference = context2.getReference();
            return reference == null || reference.resolve() == null;
        }
        if (parent instanceof JSParameter && !DumbService.isDumb((Project)parent.getProject())) {
            for (PsiReference reference : parent.getReferences()) {
                if (reference == null || reference.resolve() == null) continue;
                return false;
            }
        }
        if (parent instanceof ES6ExportSpecifier) {
            return false;
        }
        if (parent instanceof ES6ImportSpecifier && !DumbService.isDumb((Project)parent.getProject())) {
            return ((ES6ImportSpecifier)parent).multiResolve(false).length == 0;
        }
        return super.isAcceptableNamedParent(parent);
    }

    private static /* synthetic */ PsiElement lambda$replaceWithSourceElement$0(JSQualifiedNamedElement qualifiedNamedElement, PsiElement context2) {
        TypeScriptDeclarationMappings mappings = TypeScriptDeclarationMappings.getInstance(qualifiedNamedElement.getProject());
        Collection<JSQualifiedNamedElement> tsSources = mappings.getTSSourceElements(qualifiedNamedElement);
        Collection<JSQualifiedNamedElement> sources = tsSources.isEmpty() && context2 != null && DialectDetector.isJavaScript(context2) ? mappings.getJSSourceElements(qualifiedNamedElement) : tsSources;
        return !tsSources.isEmpty() || sources.size() == 1 ? (PsiElement)ContainerUtil.getFirstItem(sources) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSTargetElementEvaluator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "polyReference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSTargetElementEvaluator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndAdjustTarget";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceExpressionWithAllResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "includeSelfInGotoImplementation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementByReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationIfOverloads";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDefinitionIfDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLastTypeScriptModuleRef";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getForTypeScriptModuleRef";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustTargetElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTargetCandidates";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndAdjustTarget";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "forbidResolveWithAllResults";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceExpressionWithAllResolveResults";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNamedParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

