/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceExport;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.ecmascript6.resolve.JSModuleExportsProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flow.FlowJSStubElementTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExportScopeProvider;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSCandidateResultProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessorBase;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSExportScope;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6PsiUtil {
    public static final TokenSet DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.EXPORT_DECLARATION});
    private static final TokenSet EXPORT_DEFAULT_DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT, FlowJSStubElementTypes.DECLARE_EXPORT_DECLARATION});
    public static final String DEFAULT_NAME = "default";

    @NotNull
    public static Collection<PsiElement> getBindingAllPossibleExports(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            ES6PsiUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.map(elements, el -> {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(el);
            if (assignment != null) {
                return assignment;
            }
            return el;
        });
        if (list == null) {
            ES6PsiUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public static JSElement findDefaultExport(@NotNull PsiElement scopeElement) {
        if (scopeElement == null) {
            ES6PsiUtil.$$$reportNull$$$0(2);
        }
        return (JSElement)ContainerUtil.getFirstItem(ES6PsiUtil.findDefaultExports(scopeElement, true));
    }

    @NotNull
    public static Collection<JSElement> findDefaultExports(@NotNull PsiElement scopeElement) {
        if (scopeElement == null) {
            ES6PsiUtil.$$$reportNull$$$0(3);
        }
        return ES6PsiUtil.findDefaultExports(scopeElement, false);
    }

    @NotNull
    private static Collection<JSElement> findDefaultExports(@NotNull PsiElement scopeElement, boolean firstOnly) {
        if (scopeElement == null) {
            ES6PsiUtil.$$$reportNull$$$0(4);
        }
        Stream<JSExportAssignment> stream = JSStubBasedPsiTreeUtil.getFilteredFileOrModuleChildrenStream(scopeElement, EXPORT_DEFAULT_DECLARATIONS, JSExportAssignment.class);
        if (firstOnly) {
            Optional<JSExportAssignment> candidate = stream.findAny();
            if (candidate.isPresent()) {
                Set<JSElement> set = Collections.singleton((JSElement)candidate.get());
                if (set == null) {
                    ES6PsiUtil.$$$reportNull$$$0(5);
                }
                return set;
            }
        } else {
            List<JSElement> exportDefaultAssignments = stream.collect(Collectors.toList());
            if (exportDefaultAssignments.size() > 0) {
                List<JSElement> list = exportDefaultAssignments;
                if (list == null) {
                    ES6PsiUtil.$$$reportNull$$$0(6);
                }
                return list;
            }
        }
        final Ref resultElement = Ref.create();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(DEFAULT_NAME){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof ES6ExportSpecifierAlias || element instanceof ES6ExportSpecifier || element instanceof ES6NamespaceExport || element instanceof ES6ExportedDefaultBinding) {
                    resultElement.set((Object)element);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(scopeElement, processor, false);
        PsiElement result2 = (PsiElement)resultElement.get();
        if (!(result2 instanceof JSElement)) {
            List<JSElement> list = Collections.emptyList();
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (result2 instanceof ES6ExportSpecifier) {
            ResolveResult[] resultResultsForSpecifier = ((ES6ExportSpecifier)result2).multiResolve(false);
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(resultResultsForSpecifier));
            List list = ContainerUtil.createMaybeSingletonList((Object)(item instanceof JSElement ? (JSElement)item : null));
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)((JSElement)result2));
        if (list == null) {
            ES6PsiUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static boolean isAsyncFunction(@Nullable JSFunction function) {
        return function != null && function.isAsync();
    }

    @Contract(value="null -> false")
    public static boolean isAwaitExpression(@Nullable PsiElement expression) {
        JSPrefixExpression prefixExpression;
        JSPrefixExpression jSPrefixExpression = prefixExpression = expression instanceof JSPrefixExpression ? (JSPrefixExpression)expression : null;
        if (prefixExpression != null) {
            return prefixExpression.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
        }
        return false;
    }

    public static boolean processExportAllDeclarations(@NotNull PsiElement owner, @NotNull JSModuleElementsProcessor processor, Collection<PsiElement> visited) {
        PsiElement[] children;
        if (owner == null) {
            ES6PsiUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(11);
        }
        if (!ES6PsiUtil.isExternalModule(owner) || !(owner instanceof JSElement)) {
            return true;
        }
        for (PsiElement child : children = JSStubBasedPsiTreeUtil.getChildrenByType(owner, DECLARATIONS)) {
            ES6FromClause clause;
            ES6ExportDeclaration declaration;
            if (!(child instanceof ES6ExportDeclaration) || !(declaration = (ES6ExportDeclaration)child).isExportAll() || (clause = declaration.getFromClause()) == null) continue;
            Collection<PsiElement> elements = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement element : elements) {
                if (!(element instanceof JSElement) || element.isEquivalentTo(owner)) continue;
                if (visited == null) {
                    visited = new HashSet<PsiElement>();
                }
                if (ES6PsiUtil.processExportDeclarationInScope(element, processor, null, false, visited)) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<PsiElement> getFromClauseResolvedReferences(@NotNull ES6FromClause clause) {
        if (clause == null) {
            ES6PsiUtil.$$$reportNull$$$0(12);
        }
        Collection<PsiElement> elements = clause.resolveReferencedElements();
        return ES6PsiUtil.convertWithExportAssignments(elements, (PsiElement)clause);
    }

    @NotNull
    public static Collection<PsiElement> convertWithExportAssignments(@NotNull Collection<PsiElement> elements, @NotNull PsiElement place) {
        if (elements == null) {
            ES6PsiUtil.$$$reportNull$$$0(13);
        }
        if (place == null) {
            ES6PsiUtil.$$$reportNull$$$0(14);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements.size());
        boolean isFromJavaScript = DialectDetector.isJavaScript(place);
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) {
                result2.add(element);
                continue;
            }
            String name = assignment.getInitializerReference();
            if (name == null) continue;
            JSTypeResolveResult typeResolveResult = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)assignment);
            for (PsiElement psiElement : typeResolveResult.getElements()) {
                if (!(psiElement instanceof TypeScriptModule) && !(psiElement instanceof JSVariable) && !isFromJavaScript) continue;
                result2.add(psiElement);
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            ES6PsiUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PsiElement> resolveDefaultExport(@Nullable ES6ImportExportDeclaration declaration) {
        Collection<Object> scopes;
        if (declaration == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        ES6FromClause clause = declaration.getFromClause();
        Collection<Object> collection = scopes = clause != null ? clause.resolveReferencedElements() : ContainerUtil.emptyList();
        if (scopes.isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        return ES6PsiUtil.resolveDefaultExport(scopes, (PsiElement)declaration);
    }

    @NotNull
    private static Collection<PsiElement> resolveDefaultExport(@NotNull Collection<PsiElement> scopes, @NotNull PsiElement context2) {
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(18);
        }
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(19);
        }
        boolean isTypeScript = DialectDetector.isTypeScript(context2);
        SmartList result2 = new SmartList();
        for (PsiElement scope2 : scopes) {
            if (scope2 instanceof JSElement) {
                boolean allowDefaultImports;
                Collection<JSElement> exports = ES6PsiUtil.findDefaultExports(scope2);
                if (exports.size() > 0) {
                    result2.addAll(exports);
                    continue;
                }
                TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(scope2);
                if (assignment != null) {
                    TypeScriptConfig config = !isTypeScript ? null : TypeScriptConfigUtil.getConfigForPsiFile(scope2.getContainingFile());
                    VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)context2);
                    if (isTypeScript && config != null && !config.allowSyntheticDefaultImports() && (file == null || !TypeScriptUtil.isDefinitionFile(file))) continue;
                    result2.add(assignment);
                    continue;
                }
                if (!isTypeScript && scope2 instanceof JSFile) {
                    JSFile jsFile = (JSFile)scope2;
                    List<? extends PsiElement> exportedElements = JSResolveUtil.getExportedElements(jsFile);
                    if (!exportedElements.isEmpty()) {
                        result2.addAll(exportedElements);
                        continue;
                    }
                    JSModuleStatusOwner.ModuleStatus status = jsFile.getModuleStatus();
                    if (status != JSModuleStatusOwner.ModuleStatus.COMMONJS && status != JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS && (status != JSModuleStatusOwner.ModuleStatus.ES6 || !TypeScriptUtil.isDefinitionFile(jsFile))) continue;
                    result2.add(scope2);
                    continue;
                }
                if (!ES6PsiUtil.isExternalModule(scope2) || scope2 instanceof TypeScriptModule && ((TypeScriptModule)scope2).isAugmentation()) continue;
                PsiFile file = scope2.getContainingFile();
                TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(file);
                boolean bl = allowDefaultImports = config == null || config.allowSyntheticDefaultImports() || scope2 instanceof JSEmbeddedContent && scope2 instanceof JSExportScopeProvider;
                if (isTypeScript && (!allowDefaultImports || scope2 instanceof PsiFile && !TypeScriptUtil.isDefinitionFile(file))) continue;
                result2.add(scope2);
                continue;
            }
            result2.add(scope2);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ES6PsiUtil.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    public static ResolveResult @NotNull [] resolveSymbolInModule(@NotNull String name, @NotNull PsiElement context2, @NotNull JSElement scope2) {
        if (name == null) {
            ES6PsiUtil.$$$reportNull$$$0(21);
        }
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(22);
        }
        if (scope2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(23);
        }
        return ES6PsiUtil.resolveSymbolInModules(name, context2, Collections.singleton(scope2));
    }

    public static ResolveResult @NotNull [] resolveSymbolInModules(@NotNull String name, @NotNull PsiElement context2, @NotNull Collection<PsiElement> scopes) {
        ResolveResult[] resolveWithAliasesResults;
        if (name == null) {
            ES6PsiUtil.$$$reportNull$$$0(24);
        }
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(25);
        }
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(26);
        }
        if (scopes.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6PsiUtil.$$$reportNull$$$0(27);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (StringUtil.equals((CharSequence)name, (CharSequence)DEFAULT_NAME)) {
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(ES6PsiUtil.resolveDefaultExport(scopes, context2));
            if (resolveResultArray == null) {
                ES6PsiUtil.$$$reportNull$$$0(28);
            }
            return resolveResultArray;
        }
        ResolveResultSink sink = new ResolveResultSink(context2, name, true);
        List<JSType> aliases = ES6PsiUtil.processExportedSymbols(context2, scopes, sink);
        Object[] results = sink.getResultsAsResolveResults();
        if (!ContainerUtil.exists((Object[])results, ResolveResult::isValidResult) && !aliases.isEmpty() && (resolveWithAliasesResults = ES6PsiUtil.resolveWithAliases(name, context2, aliases)).length > 0) {
            if (resolveWithAliasesResults == null) {
                ES6PsiUtil.$$$reportNull$$$0(29);
            }
            return resolveWithAliasesResults;
        }
        if (results == null) {
            ES6PsiUtil.$$$reportNull$$$0(30);
        }
        return results;
    }

    public static ResolveResult @NotNull [] resolveSymbolForSpecifier(@NotNull ES6ImportExportSpecifier specifier, boolean strictTypeContainer) {
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(31);
        }
        Object[] results = ES6PsiUtil.resolveSymbolForSpecifier(specifier);
        Object[] objectArray = strictTypeContainer ? (ResolveResult[])((StreamEx)StreamEx.of((Object[])results).filter(el -> TypeScriptPsiUtil.isNamedTypeContainerDefinition(el.getElement()))).nonNull().toArray(ResolveResult[]::new) : results;
        if (objectArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(32);
        }
        return objectArray;
    }

    public static ResolveResult @NotNull [] resolveSymbolForSpecifier(@NotNull ES6ImportExportSpecifier specifier) {
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(33);
        }
        String name = specifier.getReferenceName();
        ES6ImportExportDeclaration declaration = specifier.getDeclaration();
        if (name == null || declaration == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6PsiUtil.$$$reportNull$$$0(34);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause != null) {
            return ES6PsiUtil.resolveSymbolInModules(name, (PsiElement)specifier, ES6PsiUtil.getFromClauseResolvedReferences(clause));
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)specifier, name, true);
        ES6PsiUtil.processSpecifier(specifier, sink);
        ResolveResult[] resolveResultArray = sink.getResultsAsResolveResults();
        if (resolveResultArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(35);
        }
        return resolveResultArray;
    }

    @NotNull
    public static List<JSType> processSpecifier(@NotNull ES6ImportExportSpecifier specifier, @NotNull ResultSink sink) {
        JSElement scope2;
        ES6ImportExportDeclaration declaration;
        if (specifier == null) {
            ES6PsiUtil.$$$reportNull$$$0(36);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(37);
        }
        if ((declaration = specifier.getDeclaration()) == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                ES6PsiUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause != null) {
            return ES6PsiUtil.processExportedSymbols((PsiElement)specifier, ES6PsiUtil.getFromClauseResolvedReferences(clause), sink);
        }
        if (specifier instanceof ES6ExportSpecifier && (scope2 = ES6PsiUtil.getExportScope((PsiElement)specifier)) != null) {
            final QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor((PsiElement)specifier, (PsiElement)scope2, sink);
            JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor.getName()){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (element instanceof ES6ExportSpecifier || element instanceof ES6ExportSpecifierAlias) {
                        return true;
                    }
                    return processor.execute(element, state);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope2, delegatingProcessor, true);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ES6PsiUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public static List<JSType> processExportedSymbols(@NotNull PsiElement context2, @NotNull Collection<? extends PsiElement> scopes, @NotNull ResultSink sink) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(40);
        }
        if (scopes == null) {
            ES6PsiUtil.$$$reportNull$$$0(41);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(42);
        }
        SmartList innerAliases = new SmartList();
        JSDialectSpecificHandlersFactory factory = JSDialectSpecificHandlersFactory.forElement(context2);
        QualifiedItemProcessor<ResultSink> processor = sink.getName() != null ? factory.createQualifiedItemProcessor(sink, context2) : factory.createCompletionItemProcessor(sink, context2.getContainingFile());
        processor.setLocalResolve(true);
        for (PsiElement psiElement : scopes) {
            JSDelegatingModuleElementsProcessor delegatingProcessor = new JSDelegatingModuleElementsProcessor(processor);
            JSCompleteTypeEvaluationProcessor.evaluateTypes(psiElement, context2.getContainingFile(), (JSTypeProcessor)delegatingProcessor, true);
            ContainerUtil.addAllNotNull((Collection)innerAliases, delegatingProcessor.getInnerAliases());
        }
        SmartList smartList = innerAliases;
        if (smartList == null) {
            ES6PsiUtil.$$$reportNull$$$0(43);
        }
        return smartList;
    }

    public static void processDeclarationInJsonElement(@NotNull JsonElement element, @NotNull JSResolveProcessor processor) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(44);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(45);
        }
        JsonValue value = null;
        if (element instanceof JsonFile) {
            JsonFile file = (JsonFile)element;
            value = (JsonValue)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> file.getTopLevelValue());
        } else if (element instanceof JsonProperty) {
            value = ((JsonProperty)element).getValue();
        }
        if (!(value instanceof JsonObject)) {
            return;
        }
        JsonObject object = (JsonObject)value;
        List list = object.getPropertyList();
        for (JsonProperty property : list) {
            if (processor.execute((PsiElement)property, ResolveState.initial())) continue;
            return;
        }
    }

    @NotNull
    public static QualifiedItemProcessor<?> createSpecifierResolveProcessor(@NotNull PsiElement context2, @NotNull PsiElement scope2, @NotNull ResultSink sink) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(46);
        }
        if (scope2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(47);
        }
        if (sink == null) {
            ES6PsiUtil.$$$reportNull$$$0(48);
        }
        QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement(scope2).createCompletionItemProcessor(sink, context2.getContainingFile());
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        QualifiedItemProcessor<? extends ResultSink> qualifiedItemProcessor = processor;
        if (qualifiedItemProcessor == null) {
            ES6PsiUtil.$$$reportNull$$$0(49);
        }
        return qualifiedItemProcessor;
    }

    public static void addInnerAliases(@NotNull List<? extends JSType> innerAliases, @NotNull BaseJSSymbolProcessor processor) {
        if (innerAliases == null) {
            ES6PsiUtil.$$$reportNull$$$0(50);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(51);
        }
        for (JSType jSType : innerAliases) {
            if (!(jSType instanceof JSNamespace)) continue;
            processor.addTypeHierarchy((JSNamespace)jSType);
        }
    }

    @Nullable
    public static JSElement getExportScope(@NotNull PsiElement element) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(52);
        }
        return JSDialectSpecificHandlersFactory.forElement(element).getExportScope(element);
    }

    @Nullable
    public static JSElement getNonStrictExportScope(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        return (JSElement)PsiTreeUtil.findFirstContext((PsiElement)element, (boolean)false, ES6PsiUtil::isExportScope);
    }

    public static boolean isExportScope(@Nullable PsiElement scope2) {
        return scope2 instanceof TypeScriptModule || scope2 instanceof JSFile || ES6PsiUtil.isEmbeddedBlock(scope2) || scope2 instanceof JSExportScope;
    }

    public static boolean isEmbeddedBlock(@Nullable PsiElement scope2) {
        return scope2 instanceof JSEmbeddedContent && JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(((JSEmbeddedContent)scope2).getElementType());
    }

    public static boolean isEmbeddedModule(@Nullable PsiElement scope2) {
        return scope2 instanceof JSEmbeddedContent && JSExtendedLanguagesTokenSetProvider.MODULE_EMBEDDED_CONTENTS.contains(((JSEmbeddedContent)scope2).getElementType());
    }

    public static boolean processExportDeclarationInScope(@NotNull PsiElement scope2, @NotNull JSModuleElementsProcessor processor) {
        if (scope2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(53);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(54);
        }
        return ES6PsiUtil.processExportDeclarationInScope(scope2, processor, null, false, null);
    }

    public static boolean processExportDeclarationInScope(@NotNull PsiElement scope2, @NotNull JSModuleElementsProcessor processor, @Nullable JSEvaluateContext evaluateContext, boolean isFromRequire, @Nullable Collection<PsiElement> visited) {
        if (scope2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(55);
        }
        if (processor == null) {
            ES6PsiUtil.$$$reportNull$$$0(56);
        }
        if (visited == null) {
            visited = new HashSet<PsiElement>();
        }
        if (!visited.add(scope2)) {
            return true;
        }
        ProgressManager.checkCanceled();
        boolean isTypeScript = DialectDetector.isTypeScript(scope2);
        boolean useWeakResolve = !isTypeScript || evaluateContext != null && !evaluateContext.isStrict();
        boolean processingResult = true;
        for (JSModuleExportsProvider provider : JSModuleExportsProvider.EP_NAME.getExtensionList()) {
            if (!provider.processExports(scope2, processor, useWeakResolve || isFromRequire)) {
                processingResult = false;
            }
            Collection<PsiElement> scopes = provider.getAdditionalScopes(scope2);
            for (PsiElement additionalScope : scopes) {
                if (ES6PsiUtil.processExportDeclarationInScope(additionalScope, processor, evaluateContext, isFromRequire, visited)) continue;
                processingResult = false;
            }
        }
        return processingResult;
    }

    public static boolean isElementCanBeExported(@NotNull PsiElement element) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(57);
        }
        return element instanceof JSAttributeListOwner && !(element instanceof TypeScriptTypeMember) && !(element instanceof JSParameter) && !(element instanceof JSProperty) && !(element instanceof JSField) && !(element instanceof TypeScriptType);
    }

    @Contract(value="null->false")
    public static boolean isExternalModule(@Nullable PsiElement element) {
        if (element instanceof JSModuleStatusOwner) {
            return ((JSModuleStatusOwner)element).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.ES6;
        }
        if (ES6PsiUtil.isEmbeddedModule(element)) {
            return true;
        }
        return element instanceof TypeScriptModule && !((TypeScriptModule)element).isInternal();
    }

    @Nullable
    public static PsiElement findExternalModule(@NotNull PsiElement context2) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(58);
        }
        return ES6PsiUtil.findExternalModule(context2, true);
    }

    @Nullable
    public static PsiElement findExternalModule(@NotNull PsiElement context2, boolean strict) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(59);
        }
        if (!strict && ES6PsiUtil.isExternalModule(context2)) {
            return context2;
        }
        JSElement container = ES6PsiUtil.getExportScope(context2);
        while (container != null) {
            if (ES6PsiUtil.isExternalModule((PsiElement)container)) {
                return container;
            }
            if (container instanceof PsiFile) {
                return null;
            }
            container = ES6PsiUtil.getExportScope((PsiElement)container);
        }
        return null;
    }

    private static ResolveResult @NotNull [] resolveWithAliases(@NotNull String name, @NotNull PsiElement context2, @NotNull List<JSType> innerAliases) {
        if (name == null) {
            ES6PsiUtil.$$$reportNull$$$0(60);
        }
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(61);
        }
        if (innerAliases == null) {
            ES6PsiUtil.$$$reportNull$$$0(62);
        }
        if (DialectDetector.isTypeScript(context2)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6PsiUtil.$$$reportNull$$$0(63);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (innerAliases.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6PsiUtil.$$$reportNull$$$0(64);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(name, context2.getContainingFile(), context2);
        ES6PsiUtil.addInnerAliases(innerAliases, processor);
        processor.setAddOnlyCompleteMatches();
        JSIndexBasedResolveUtil.processAllSymbols(processor);
        ResolveResult[] resolveResultArray = processor.getResults();
        if (resolveResultArray == null) {
            ES6PsiUtil.$$$reportNull$$$0(65);
        }
        return resolveResultArray;
    }

    @Nullable
    public static ES6Decorator findDecoratorByName(@NotNull JSAttributeListOwner owner, String ... names) {
        JSAttributeList attributeList;
        if (owner == null) {
            ES6PsiUtil.$$$reportNull$$$0(66);
        }
        Object[] decorators = (attributeList = owner.getAttributeList()) != null ? attributeList.getDecorators() : ES6Decorator.EMPTY_ARRAY;
        return (ES6Decorator)ContainerUtil.find((Object[])decorators, decorator -> {
            JSReferenceExpression referenceExpression;
            JSExpression expr = decorator.getExpression();
            if (expr instanceof JSCallExpression) {
                expr = ((JSCallExpression)expr).getMethodExpression();
            }
            return (referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expr, JSReferenceExpression.class)) != null && JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, names);
        });
    }

    @Nullable
    public static PsiElement computeFromFileForImportExport(@Nullable PsiElement element) {
        ES6ImportExportDeclaration importDeclaration = (ES6ImportExportDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{ES6ImportExportDeclaration.class});
        if (importDeclaration == null) {
            return null;
        }
        ES6FromClause fromClause = importDeclaration.getFromClause();
        if (fromClause == null) {
            if (element instanceof ES6ExportSpecifier) {
                return element.getContainingFile();
            }
            return null;
        }
        Collection<PsiElement> elements = fromClause.resolveReferencedElements();
        if (elements.size() != 1) {
            return null;
        }
        return elements.iterator().next();
    }

    @Nullable
    public static PsiElement getDefaultElement(PsiElement element) {
        PsiElement exportElement = null;
        if (element instanceof JSExportAssignment || ES6PsiUtil.isDefaultExportThroughSpecifier(element)) {
            exportElement = element;
        } else {
            PsiElement parent = element.getContext();
            if (parent instanceof JSExportAssignment) {
                exportElement = parent;
            }
        }
        return exportElement;
    }

    private static boolean isDefaultExportThroughSpecifier(PsiElement element) {
        return element instanceof ES6ExportSpecifier && DEFAULT_NAME.equals(((ES6ExportSpecifier)element).getDeclaredName()) || element instanceof ES6ExportSpecifierAlias && DEFAULT_NAME.equals(((ES6ExportSpecifierAlias)element).getName());
    }

    public static boolean isLocalClass(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            ES6PsiUtil.$$$reportNull$$$0(67);
        }
        return !jsClass.isExportedWithDefault() && !jsClass.isNamespaceExplicitlyDeclared();
    }

    public static void buildSignatureForDestructuringContainer(@NotNull JSDestructuringContainer target, @NotNull StringBuilder builder2, boolean withInitializer) {
        if (target == null) {
            ES6PsiUtil.$$$reportNull$$$0(68);
        }
        if (builder2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(69);
        }
        if (target instanceof JSDestructuringObject) {
            builder2.append('{');
            JSDestructuringProperty[] properties = ((JSDestructuringObject)target).getProperties();
            boolean isFirst = true;
            for (JSDestructuringProperty property : properties) {
                if (!isFirst) {
                    builder2.append(", ");
                }
                isFirst = false;
                if (property.isRest()) {
                    builder2.append("...");
                } else if (!(property instanceof JSDestructuringShorthandedProperty)) {
                    builder2.append(property.getName()).append(": ");
                }
                JSInitializerOwner element = property.getDestructuringElement();
                if (element == null) continue;
                ES6PsiUtil.buildSignatureForInitializerOwner(element, builder2, withInitializer);
            }
            builder2.append('}');
        } else {
            builder2.append('[');
            boolean isFirst = true;
            for (JSInitializerOwner owner : ((JSDestructuringArray)target).getElements()) {
                if (!isFirst) {
                    builder2.append(", ");
                }
                isFirst = false;
                if (owner == null) continue;
                ES6PsiUtil.buildSignatureForInitializerOwner(owner, builder2, withInitializer);
            }
            JSDestructuringArrayRestElement restElement = ((JSDestructuringArray)target).getRestElement();
            if (restElement != null) {
                JSDestructuringElement pattern;
                if (!isFirst) {
                    builder2.append(", ");
                }
                builder2.append("...");
                JSVariable variable = restElement.getVariable();
                if (variable != null) {
                    ES6PsiUtil.buildSignatureForInitializerOwner(variable, builder2, withInitializer);
                }
                if ((pattern = restElement.getPattern()) != null) {
                    ES6PsiUtil.buildSignatureForInitializerOwner(pattern, builder2, withInitializer);
                }
            }
            builder2.append(']');
        }
    }

    private static void buildSignatureForInitializerOwner(@NotNull JSInitializerOwner initializerOwner, @NotNull StringBuilder builder2, boolean withInitializer) {
        JSDestructuringContainer target;
        if (initializerOwner == null) {
            ES6PsiUtil.$$$reportNull$$$0(70);
        }
        if (builder2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(71);
        }
        if (initializerOwner instanceof JSVariable) {
            builder2.append(initializerOwner.getName());
            String initializer = ((JSVariable)initializerOwner).getLiteralOrReferenceInitializerText();
            if (withInitializer && initializer != null) {
                builder2.append(" = ").append(initializer);
            } else {
                JSType type = ((JSVariable)initializerOwner).getJSType();
                if (type instanceof JSPrimitiveLiteralType) {
                    builder2.append(" = ").append(((JSPrimitiveLiteralType)type).getValueAsString());
                }
            }
        } else if (initializerOwner instanceof JSDestructuringElement && (target = ((JSDestructuringElement)initializerOwner).getTarget()) != null) {
            ES6PsiUtil.buildSignatureForDestructuringContainer(target, builder2, withInitializer);
        }
    }

    @Nullable
    public static String getInitializerReference(@NotNull JSExportAssignment exportAssignment) {
        JSExpression expression;
        if (exportAssignment == null) {
            ES6PsiUtil.$$$reportNull$$$0(72);
        }
        if ((expression = JSUtils.unparenthesize(exportAssignment.getExpression())) instanceof JSReferenceExpression) {
            JSQualifiedName name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)expression));
            return name != null ? name.getQualifiedName() : null;
        }
        return null;
    }

    @NotNull
    public static JSQualifiedNameResolver createResolver(@NotNull PsiElement context2) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(73);
        }
        return DialectDetector.isTypeScript(context2) ? new TypeScriptQualifiedNameResolver(context2, true) : new ES6QualifiedNameResolver(context2, true, true);
    }

    @NotNull
    public static Collection<PsiElement> expandElements(@NotNull PsiElement context2, @NotNull Collection<? extends PsiElement> elements) {
        if (context2 == null) {
            ES6PsiUtil.$$$reportNull$$$0(74);
        }
        if (elements == null) {
            ES6PsiUtil.$$$reportNull$$$0(75);
        }
        JSQualifiedNameResolver resolver = ES6PsiUtil.createResolver(context2);
        Collection<PsiElement> collection = resolver.expandElements(elements);
        if (collection == null) {
            ES6PsiUtil.$$$reportNull$$$0(76);
        }
        return collection;
    }

    public static boolean checkNamesEquivalent(@NotNull JSElement first, @NotNull JSElement second) {
        if (first == null) {
            ES6PsiUtil.$$$reportNull$$$0(77);
        }
        if (second == null) {
            ES6PsiUtil.$$$reportNull$$$0(78);
        }
        String nameOne = first.getName();
        String nameTwo = second.getName();
        if (nameOne == null && nameTwo == null && first instanceof JSComputedPropertyNameOwner && second instanceof JSComputedPropertyNameOwner) {
            ES6ComputedName computedOne = ((JSComputedPropertyNameOwner)first).getComputedPropertyName();
            ES6ComputedName computedTwo = ((JSComputedPropertyNameOwner)first).getComputedPropertyName();
            if (computedOne != null && computedTwo != null) {
                return Objects.equals(computedOne.getExpressionAsReferenceName(), computedTwo.getExpressionAsReferenceName());
            }
            return false;
        }
        return Objects.equals(nameOne, nameTwo);
    }

    @Contract(value="null -> false")
    public static boolean isInsideDecorator(@Nullable PsiElement expression) {
        JSElement functionOrDecorator = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{ES6Decorator.class, JSFunction.class});
        while (functionOrDecorator != null) {
            if (functionOrDecorator instanceof ES6Decorator) {
                return true;
            }
            if (!((JSFunction)functionOrDecorator).isArrowFunction()) {
                return false;
            }
            functionOrDecorator = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)functionOrDecorator, (Class[])new Class[]{ES6Decorator.class, JSFunction.class});
        }
        return false;
    }

    @NotNull
    public static JSModuleStatusOwner.ModuleStatus getModuleStatus(@NotNull PsiElement element) {
        JSModuleStatusOwner module;
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(79);
        }
        JSModuleStatusOwner.ModuleStatus moduleStatus = (module = ES6PsiUtil.getModuleStatusOwner(element)) != null ? module.getModuleStatus() : JSModuleStatusOwner.ModuleStatus.NONE;
        if (moduleStatus == null) {
            ES6PsiUtil.$$$reportNull$$$0(80);
        }
        return moduleStatus;
    }

    @Nullable
    public static JSModuleStatusOwner getModuleStatusOwner(@NotNull PsiElement element) {
        if (element == null) {
            ES6PsiUtil.$$$reportNull$$$0(81);
        }
        return (JSModuleStatusOwner)PsiTreeUtil.getContextOfType((PsiElement)element, JSModuleStatusOwner.class, (boolean)false);
    }

    @Contract(value="null -> null")
    public static JSClass getES6ConstructorClass(@Nullable PsiElement element) {
        if (!(element instanceof JSFunction)) {
            return null;
        }
        if (JSResolveUtil.isConstructorFunction(element) && "constructor".equals(((JSFunction)element).getName())) {
            return JSUtils.getMemberContainingClass(element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 8, 9, 15, 16, 17, 20, 27, 28, 29, 30, 32, 34, 35, 38, 39, 43, 49, 63, 64, 65, 76, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 43: 
            case 49: 
            case 63: 
            case 64: 
            case 65: 
            case 76: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 10: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 11: 
            case 45: 
            case 51: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: 
            case 26: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 40: 
            case 46: 
            case 58: 
            case 59: 
            case 61: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 24: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 47: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 37: 
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 44: 
            case 52: 
            case 57: 
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 50: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerAliases";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerOwner";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportAssignment";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingAllPossibleExports";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findDefaultExports";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWithExportAssignments";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDefaultExport";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymbolInModules";
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymbolForSpecifier";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "processSpecifier";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "processExportedSymbols";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpecifierResolveProcessor";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveWithAliases";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElements";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBindingAllPossibleExports";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 43: 
            case 49: 
            case 63: 
            case 64: 
            case 65: 
            case 76: 
            case 80: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultExport";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultExports";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processExportAllDeclarations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFromClauseResolvedReferences";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertWithExportAssignments";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveDefaultExport";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInModule";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolInModules";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolForSpecifier";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processSpecifier";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processExportedSymbols";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationInJsonElement";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createSpecifierResolveProcessor";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addInnerAliases";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getExportScope";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processExportDeclarationInScope";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isElementCanBeExported";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findExternalModule";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithAliases";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findDecoratorByName";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isLocalClass";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "buildSignatureForDestructuringContainer";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "buildSignatureForInitializerOwner";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getInitializerReference";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createResolver";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "expandElements";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "checkNamesEquivalent";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getModuleStatus";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getModuleStatusOwner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 8, 9, 15, 16, 17, 20, 27, 28, 29, 30, 32, 34, 35, 38, 39, 43, 49, 63, 64, 65, 76, 80 -> new IllegalStateException(string);
        };
    }

    public static final class JSDelegatingModuleElementsProcessor
    extends JSQualifiedItemProcessorBase
    implements JSModuleElementsProcessor {
        @NotNull
        private final List<JSType> myInnerAliases;
        @NotNull
        final QualifiedItemProcessor<?> myDelegate;

        @NotNull
        public List<JSType> getInnerAliases() {
            List<JSType> list = this.myInnerAliases;
            if (list == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(0);
            }
            return list;
        }

        public JSDelegatingModuleElementsProcessor(@NotNull QualifiedItemProcessor<?> delegate) {
            if (delegate == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(1);
            }
            this.myInnerAliases = new SmartList();
            this.myDelegate = delegate;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(3);
            }
            return this.myDelegate.execute(element, state);
        }

        @Override
        @Nullable
        public String getName() {
            return this.myDelegate.getName();
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
            if (type == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(4);
            }
            if (evaluateContext == null) {
                JSDelegatingModuleElementsProcessor.$$$reportNull$$$0(5);
            }
            this.myDelegate.process(type, evaluateContext);
            this.myInnerAliases.add(type);
        }

        @Override
        public void executeCandidateResult(PsiElement element, JSResolveResult.ProblemKind problemKind) {
            this.myDelegate.executeCandidateResult(element, problemKind);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInnerAliases";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSDelegatingModuleElementsProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class ES6ExportedElementsProcessor
    extends JSResolveProcessorBase {
        @NotNull
        private final PsiScopeProcessor myDelegate;

        public ES6ExportedElementsProcessor(@NotNull PsiScopeProcessor delegateProcessor) {
            if (delegateProcessor == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(0);
            }
            super(delegateProcessor instanceof JSResolveProcessor ? ((JSResolveProcessor)delegateProcessor).getName() : null);
            this.myDelegate = delegateProcessor;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                ES6ExportedElementsProcessor.$$$reportNull$$$0(2);
            }
            if (element instanceof ES6NamespaceExport) {
                return this.myDelegate.execute(element, state);
            }
            if (element instanceof ES6ExportSpecifier) {
                ES6ExportDeclaration declaration = ((ES6ExportSpecifier)element).getDeclaration();
                if (declaration != null && declaration.getFromClause() == null) {
                    return true;
                }
                return this.myDelegate.execute(element, state);
            }
            if (ES6ImportHandler.isExported(element)) {
                return this.myDelegate.execute(element, state);
            }
            if (this.myDelegate instanceof JSCandidateResultProcessor) {
                JSResolveResult.ProblemKind kind;
                JSResolveResult.ProblemKind problemKind = element instanceof JSPsiElementBase && ((JSPsiElementBase)element).isExportedWithDefault() ? JSResolveResult.ProblemKind.JS_DEFAULT_INSTEAD_NAMED : (kind = JSUseScopeProvider.isLexicalScopeElement(element) ? JSResolveResult.ProblemKind.JS_NEED_TO_BE_EXPORTED : null);
                if (kind != null) {
                    ((JSCandidateResultProcessor)this.myDelegate).executeCandidateResult(element, kind);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$ES6ExportedElementsProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

