/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.execution;

import com.intellij.execution.Platform;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.target.ContributedTypeBase;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.ResolvedPortBindingKt;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.DeferredLocalTargetValue;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeTargetRunSetup;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.reference.NodePathManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.LangCoreBundle;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMapper;
import com.intellij.util.PathUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.pty4j.PtyProcess;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.UnaryOperator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u00a2\u00012\u00020\u0001:\n\u009f\u0001\u00a0\u0001\u00a1\u0001\u00a2\u0001\u00a3\u0001B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB5\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u000f\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0010J\u0006\u0010G\u001a\u00020HJ\u0014\u0010I\u001a\u000e\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020$0#H\u0002J\b\u0010K\u001a\u00020)H\u0002J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020N0M2\u0006\u0010O\u001a\u00020NH\u0002J\u0006\u0010P\u001a\u00020QJ\u0018\u0010R\u001a\u00020)2\u0006\u0010S\u001a\u00020J2\u0006\u0010T\u001a\u00020$H\u0002J\b\u0010U\u001a\u00020/H\u0002J\b\u0010V\u001a\u00020WH\u0002J\b\u0010X\u001a\u00020/H\u0002J\u000e\u0010Y\u001a\u00020)2\u0006\u0010Z\u001a\u00020WJ\b\u0010[\u001a\u00020)H\u0002J\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]2\u0006\u0010_\u001a\u00020^J\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]2\u0006\u0010_\u001a\u000207J\u0014\u0010`\u001a\b\u0012\u0004\u0012\u00020^0]2\u0006\u0010_\u001a\u00020^J\u0012\u0010a\u001a\u0004\u0018\u00010N2\u0006\u0010\\\u001a\u00020^H\u0002J\u0016\u0010b\u001a\b\u0012\u0004\u0012\u00020^0]2\u0006\u0010c\u001a\u00020^H\u0002J!\u0010d\u001a\u00020^2\u0012\u0010e\u001a\n\u0012\u0006\b\u0001\u0012\u00020^0f\"\u00020^H\u0002\u00a2\u0006\u0002\u0010gJ\u0010\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u000207H\u0002J\u0010\u0010k\u001a\u0002072\u0006\u0010l\u001a\u000207H\u0002J\u0010\u0010m\u001a\u00020/2\u0006\u0010\\\u001a\u000207H\u0002J\u0014\u0010n\u001a\b\u0012\u0004\u0012\u00020o0(2\u0006\u0010p\u001a\u00020qJ\u0014\u0010r\u001a\b\u0012\u0004\u0012\u00020q0]2\u0006\u0010s\u001a\u00020qJ\u0018\u0010t\u001a\u00020)2\u0006\u0010T\u001a\u00020$2\u0006\u0010u\u001a\u00020%H\u0002J\u001e\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\u0006\u0010S\u001a\u00020J2\u0006\u0010T\u001a\u00020$J \u0010z\u001a\u00020w2\u0006\u0010x\u001a\u00020{2\u0006\u0010S\u001a\u00020J2\u0006\u0010T\u001a\u00020$H\u0002J \u0010|\u001a\u00020}2\u0006\u0010x\u001a\u00020y2\u0006\u0010S\u001a\u00020J2\u0006\u0010T\u001a\u00020$H\u0002J\b\u0010~\u001a\u00020\u007fH\u0002J\u0015\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020^0(2\u0006\u0010_\u001a\u00020^J\u0011\u0010\u0081\u0001\u001a\u0002072\u0006\u0010_\u001a\u000207H\u0002J\u0012\u0010\u0082\u0001\u001a\u00020^2\u0007\u0010\u0083\u0001\u001a\u00020^H\u0002JC\u0010\u0084\u0001\u001a\u0011\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u000207\u0018\u00010\u0085\u00012\u0006\u0010\\\u001a\u0002072!\u0010\u0086\u0001\u001a\u001c\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u0002070\u0085\u0001\u0012\u0004\u0012\u0002070\u0087\u0001H\u0002J\u0016\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020^0(2\u0007\u0010\u0089\u0001\u001a\u00020^J\u0010\u0010\u008a\u0001\u001a\u00020^2\u0007\u0010\u0089\u0001\u001a\u00020^J\u000f\u0010\u008b\u0001\u001a\u00020^2\u0006\u0010_\u001a\u00020^J%\u0010\u008c\u0001\u001a\u00020^2\u0007\u0010\u008d\u0001\u001a\u00020^2\u0007\u0010\u008e\u0001\u001a\u00020^2\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0002J\u0018\u0010\u0091\u0001\u001a\u00020)2\u0007\u0010\u0092\u0001\u001a\u00020/2\u0006\u00108\u001a\u00020^J7\u0010\u0093\u0001\u001a\u00020)2\u0007\u0010\u0092\u0001\u001a\u00020/2\u001f\u0010\u0094\u0001\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020^0]0f\"\b\u0012\u0004\u0012\u00020^0]\u00a2\u0006\u0003\u0010\u0095\u0001J'\u0010\u0093\u0001\u001a\u00020)2\u0007\u0010\u0092\u0001\u001a\u00020/2\u0013\u0010\u0094\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020^0]0MH\u0002J&\u0010\u0096\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020^0]0M2\t\u0010\u0092\u0001\u001a\u0004\u0018\u00010/H\u0002\u00a2\u0006\u0003\u0010\u0097\u0001J\u001b\u0010\u0096\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020^0]0MH\u0000\u00a2\u0006\u0003\b\u0098\u0001J$\u0010\u0099\u0001\u001a\u00020)2\u0013\u0010\u009a\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020^0]0MH\u0000\u00a2\u0006\u0003\b\u009b\u0001J\u001d\u0010\u009c\u0001\u001a\u00020)2\u0012\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020^0]0MH\u0002J\u0007\u0010\u009d\u0001\u001a\u00020/J\u0011\u0010\u009e\u0001\u001a\u00020)2\u0006\u0010:\u001a\u00020;H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R \u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020-0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00104\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020706X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\b\u0012\u0004\u0012\u0002090'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010:\u001a\u00020;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R$\u0010@\u001a\u00020/8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bA\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010F\u00a8\u0006\u00a4\u0001"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "project", "Lcom/intellij/openapi/project/Project;", "debugConfigurator", "Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;", "options", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRunOptions;", "interpreterRunSetup", "Lcom/intellij/javascript/nodejs/interpreter/NodeTargetRunSetup;", "<init>", "(Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;Lcom/intellij/javascript/nodejs/execution/NodeTargetRunOptions;Lcom/intellij/javascript/nodejs/interpreter/NodeTargetRunSetup;)V", "configurator", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Options;", "(Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Options;Lcom/intellij/javascript/nodejs/interpreter/NodeTargetRunSetup;)V", "getInterpreter", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getOptions", "()Lcom/intellij/javascript/nodejs/execution/NodeTargetRunOptions;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "commandLineBuilder", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "getCommandLineBuilder", "()Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "environmentPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/TargetProgressIndicator;", "dependingOnEnvironmentPromise", "", "Lorg/jetbrains/concurrency/Promise;", "", "uploads", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Upload;", "myRequiredNodePackages", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpNodePackage;", "enableWrappingWithYarnNode", "", "getEnableWrappingWithYarnNode", "()Ljava/lang/Boolean;", "setEnableWrappingWithYarnNode", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "copiedUploadVolumes", "", "Ljava/nio/file/Path;", "nodeOptions", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$NodeOptionValue;", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvData", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "enableWrappingWithYarnPnpNode", "getEnableWrappingWithYarnPnpNode$annotations", "()V", "getEnableWrappingWithYarnPnpNode", "()Z", "setEnableWrappingWithYarnPnpNode", "(Z)V", "startProcess", "Lcom/intellij/execution/process/ProcessHandler;", "prepareCommandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "configureNodePathForPnpm", "collectNodeModulesInPathForPnpm", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "startFile", "startProcessEx", "Lcom/intellij/javascript/nodejs/execution/ProcessWithCmdLine;", "logCommandDetails", "commandLine", "environment", "configureYarnPnpNode", "getRequiredYarnPkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "shouldWrapWithYarnNodeCommand", "withRequiredNodePackage", "requiredNodePackage", "configureUserEnvironment", "path", "Lcom/intellij/execution/target/value/TargetValue;", "", "localPath", "requestUploadProjectRootAndGetPath", "findProjectRoot", "requestUploadIntoTarget", "uploadPathString", "joinPath", "segments", "", "([Ljava/lang/String;)Ljava/lang/String;", "createUploadRoot", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "localRootPath", "copyIfNeeded", "originalDir", "shouldCopyToTmp", "localPortBinding", "Lcom/intellij/execution/target/ResolvedPortBinding;", "localPort", "", "targetPortBinding", "targetPort", "provideEnvironment", "targetProgressIndicator", "createProcessHandlerByDefault", "Lcom/intellij/execution/process/KillableProcessHandler;", "process", "Ljava/lang/Process;", "createTerminalProcessHandler", "Lcom/pty4j/PtyProcess;", "createKillableColoredProcessHandler", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "blockingReaderOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "convertLocalPathToTarget", "convertLocalPathToCopied", "convertCopiedToLocal", "copiedPath", "findCopiedVolumeEntry", "", "pathSelector", "Lkotlin/Function1;", "convertTargetPathToLocal", "targetPath", "convertTargetPathToLocalPath", "convertLocalPathToTargetPath", "joinPaths", "basePath", "relativePath", "platform", "Lcom/intellij/execution/Platform;", "addNodeOptionsWithExpandedMacros", "passThroughEnvironmentVariableOnly", "addNodeOptions", "nodeOptionsToAdd", "(Z[Lcom/intellij/execution/target/value/TargetValue;)V", "getNodeOptions", "(Ljava/lang/Boolean;)Ljava/util/List;", "getNodeOptions$intellij_javascript_impl", "setNodeOptions", "nodeOptionsToSet", "setNodeOptions$intellij_javascript_impl", "passNodeOptionsThroughEnvironmentVariable", "isExePathDefined", "configureEnvironment", "NodeOptionValue", "NodeTargetRunKillableColoredProcessHandler", "Upload", "Companion", "Options", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeTargetRun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeTargetRun.kt\ncom/intellij/javascript/nodejs/execution/NodeTargetRun\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,721:1\n1557#2:722\n1628#2,3:723\n1557#2:745\n1628#2,3:746\n1557#2:749\n1628#2,3:750\n1557#2:753\n1628#2,3:754\n216#3,2:726\n216#3,2:743\n607#4:728\n1007#4:729\n1041#4,3:730\n1044#4,3:740\n381#5,7:733\n14#6:757\n*S KotlinDebug\n*F\n+ 1 NodeTargetRun.kt\ncom/intellij/javascript/nodejs/execution/NodeTargetRun\n*L\n157#1:722\n157#1:723,3\n558#1:745\n558#1:746,3\n567#1:749\n567#1:750,3\n714#1:753\n714#1:754,3\n244#1:726,2\n388#1:743,2\n386#1:728\n387#1:729\n387#1:730,3\n387#1:740,3\n387#1:733,7\n634#1:757\n*E\n"})
public final class NodeTargetRun {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodeJsInterpreter interpreter;
    @NotNull
    private final Project project;
    @Nullable
    private final CommandLineDebugConfigurator debugConfigurator;
    @NotNull
    private final NodeTargetRunOptions options;
    @NotNull
    private final NodeTargetRunSetup interpreterRunSetup;
    @NotNull
    private final TargetEnvironmentRequest request;
    @NotNull
    private final ProgressIndicator progress;
    @NotNull
    private final TargetedCommandLineBuilder commandLineBuilder;
    @NotNull
    private final AsyncPromise<Pair<TargetEnvironment, TargetProgressIndicator>> environmentPromise;
    @NotNull
    private final List<Promise<Unit>> dependingOnEnvironmentPromise;
    @NotNull
    private final List<Upload> uploads;
    @NotNull
    private final List<YarnPnpNodePackage> myRequiredNodePackages;
    @Nullable
    private Boolean enableWrappingWithYarnNode;
    @NotNull
    private final Map<Path, Path> copiedUploadVolumes;
    @NotNull
    private final List<NodeOptionValue> nodeOptions;
    @NotNull
    private EnvironmentVariablesData envData;
    private boolean enableWrappingWithYarnPnpNode;
    @NotNull
    private static final String NODE_OPTIONS = "NODE_OPTIONS";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<NodeTargetRun> TARGET_RUN_KEY;

    @JvmOverloads
    public NodeTargetRun(@NotNull NodeJsInterpreter interpreter2, @NotNull Project project, @Nullable CommandLineDebugConfigurator debugConfigurator, @NotNull NodeTargetRunOptions options, @NotNull NodeTargetRunSetup interpreterRunSetup) throws com.intellij.execution.ExecutionException {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)interpreterRunSetup, (String)"interpreterRunSetup");
        this.interpreter = interpreter2;
        this.project = project;
        this.debugConfigurator = debugConfigurator;
        this.options = options;
        this.interpreterRunSetup = interpreterRunSetup;
        this.request = this.interpreterRunSetup.getRequest();
        ProgressIndicator progressIndicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"notNullize(...)");
        this.progress = progressIndicator;
        this.commandLineBuilder = new TargetedCommandLineBuilder(this.request);
        this.environmentPromise = new AsyncPromise();
        this.dependingOnEnvironmentPromise = new ArrayList();
        this.uploads = new ArrayList();
        this.myRequiredNodePackages = new ArrayList();
        this.copiedUploadVolumes = new LinkedHashMap();
        this.nodeOptions = new ArrayList();
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"DEFAULT");
        this.envData = environmentVariablesData;
        this.enableWrappingWithYarnPnpNode = true;
        this.commandLineBuilder.setCharset(StandardCharsets.UTF_8);
    }

    public /* synthetic */ NodeTargetRun(NodeJsInterpreter nodeJsInterpreter, Project project, CommandLineDebugConfigurator commandLineDebugConfigurator, NodeTargetRunOptions nodeTargetRunOptions, NodeTargetRunSetup nodeTargetRunSetup, int n, DefaultConstructorMarker defaultConstructorMarker) throws com.intellij.execution.ExecutionException {
        if ((n & 0x10) != 0) {
            nodeTargetRunSetup = nodeJsInterpreter.createTargetRunSetup(project, nodeTargetRunOptions);
        }
        this(nodeJsInterpreter, project, commandLineDebugConfigurator, nodeTargetRunOptions, nodeTargetRunSetup);
    }

    @NotNull
    public final NodeJsInterpreter getInterpreter() {
        return this.interpreter;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NodeTargetRunOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final TargetEnvironmentRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final TargetedCommandLineBuilder getCommandLineBuilder() {
        return this.commandLineBuilder;
    }

    @Nullable
    public final Boolean getEnableWrappingWithYarnNode() {
        return this.enableWrappingWithYarnNode;
    }

    public final void setEnableWrappingWithYarnNode(@Nullable Boolean bl) {
        this.enableWrappingWithYarnNode = bl;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.envData;
    }

    public final void setEnvData(@NotNull EnvironmentVariablesData environmentVariablesData) {
        Intrinsics.checkNotNullParameter((Object)environmentVariablesData, (String)"<set-?>");
        this.envData = environmentVariablesData;
    }

    public final boolean getEnableWrappingWithYarnPnpNode() {
        return this.enableWrappingWithYarnPnpNode;
    }

    public final void setEnableWrappingWithYarnPnpNode(boolean bl) {
        this.enableWrappingWithYarnPnpNode = bl;
    }

    @Deprecated(message="Use enableWrappingWithYarnNode instead", replaceWith=@ReplaceWith(expression="enableWrappingWithYarnNode ?: true", imports={}))
    public static /* synthetic */ void getEnableWrappingWithYarnPnpNode$annotations() {
    }

    @NotNull
    public final ProcessHandler startProcess() throws com.intellij.execution.ExecutionException {
        return (ProcessHandler)this.startProcessEx().getProcessHandler();
    }

    private final Pair<TargetedCommandLine, TargetEnvironment> prepareCommandLine() throws com.intellij.execution.ExecutionException {
        this.configureUserEnvironment();
        boolean yarnPnpNode = this.configureYarnPnpNode();
        CommandLineDebugConfigurator commandLineDebugConfigurator = this.debugConfigurator;
        if (commandLineDebugConfigurator != null) {
            commandLineDebugConfigurator.configure(this);
        }
        this.configureNodePathForPnpm();
        this.interpreterRunSetup.prependNodeDirToPATH(this.commandLineBuilder, this.envData);
        if (yarnPnpNode || !this.isExePathDefined()) {
            List<TargetValue<String>> nodeOptionsAsCliParameters = this.getNodeOptions(false);
            int insertIndex = yarnPnpNode ? 1 : 0;
            this.commandLineBuilder.addParametersAt(insertIndex, nodeOptionsAsCliParameters);
            this.passNodeOptionsThroughEnvironmentVariable(this.getNodeOptions(true));
        } else {
            this.passNodeOptionsThroughEnvironmentVariable(this.getNodeOptions(null));
        }
        this.interpreterRunSetup.configureCommandLine(this);
        TargetProgressIndicator targetProgressIndicator = (TargetProgressIndicator)new TargetProgressIndicatorAdapter(this.progress);
        TargetEnvironment environment = null;
        try {
            environment = this.request.prepareEnvironment(targetProgressIndicator);
            this.provideEnvironment(environment, targetProgressIndicator);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getLocalizedMessage()};
            throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message("node.execution.failed.to.prepare.target.environment.error", objectArray), (Throwable)e);
        }
        return new Pair((Object)this.commandLineBuilder.build(), (Object)environment);
    }

    /*
     * WARNING - void declaration
     */
    private final void configureNodePathForPnpm() {
        NodePackageRef nodePackageRef = NpmManager.getInstance(this.project).getPackageRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getPackageRef(...)");
        NodePackageRef projectNpmPackageRef = nodePackageRef;
        if (NpmUtil.isPnpmPackageRef(projectNpmPackageRef)) {
            VirtualFile canonicalFile;
            VirtualFile file;
            String string;
            try {
                TargetValue targetValue = (TargetValue)CollectionsKt.firstOrNull((List)this.commandLineBuilder.getParameters());
                string = PathUtil.toSystemIndependentName(targetValue != null && (targetValue = targetValue.getLocalValue()) != null ? (String)targetValue.blockingGet(0) : null);
            }
            catch (Exception exception) {
                string = null;
            }
            String mainScriptPath = string;
            if (mainScriptPath != null && StringsKt.contains$default((CharSequence)mainScriptPath, (CharSequence)"/node_modules/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)mainScriptPath, (CharSequence)"/node_modules/.pnpm/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)mainScriptPath, (CharSequence)"/node_modules/.bin/", (boolean)false, (int)2, null) && (file = LocalFileSystem.getInstance().findFileByPath(mainScriptPath)) != null && (canonicalFile = file.getCanonicalFile()) != null && !Intrinsics.areEqual((Object)canonicalFile, (Object)file)) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<VirtualFile> nodeModulesDirs = this.collectNodeModulesInPathForPnpm(canonicalFile);
                Iterable iterable = nodeModulesDirs;
                NodeTargetRun nodeTargetRun = this;
                boolean $i$f$map = false;
                void var8_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getPath());
                }
                NodePathManager.prependNodePaths(nodeTargetRun, (List)destination$iv$iv);
            }
        }
    }

    private final List<VirtualFile> collectNodeModulesInPathForPnpm(VirtualFile startFile) {
        VirtualFile dir;
        List nodeModulesDirs = new ArrayList();
        VirtualFile virtualFile = dir = startFile.isDirectory() ? startFile : startFile.getParent();
        while (dir != null) {
            if (NodeModuleUtil.findChildNodeModulesDir(dir) != null) {
                VirtualFile it;
                boolean bl = false;
                nodeModulesDirs.add(it);
            }
            if (Intrinsics.areEqual((Object)dir.getName(), (Object)".pnpm")) {
                return nodeModulesDirs;
            }
            dir = dir.getParent();
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final ProcessWithCmdLine startProcessEx() throws com.intellij.execution.ExecutionException {
        Pair<TargetedCommandLine, TargetEnvironment> pair = this.prepareCommandLine();
        TargetedCommandLine commandLine = (TargetedCommandLine)pair.component1();
        TargetEnvironment environment = (TargetEnvironment)pair.component2();
        this.logCommandDetails(commandLine, environment);
        Process process = environment.createProcess(commandLine, this.progress);
        KillableProcessHandler processHandler = this.interpreterRunSetup.createProcessHandler(this, process, commandLine, environment);
        processHandler.putUserData(TARGET_RUN_KEY, (Object)this);
        return new ProcessWithCmdLine(processHandler, commandLine, environment);
    }

    private final void logCommandDetails(TargetedCommandLine commandLine, TargetEnvironment environment) {
        if (LOG.isDebugEnabled()) {
            TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.request.getConfiguration();
            ContributedTypeBase targetType = (ContributedTypeBase)(targetEnvironmentConfiguration != null ? TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)targetEnvironmentConfiguration) : null);
            Map uploadVolumes = environment.getUploadVolumes();
            Object object = targetType;
            if (object == null || (object = object.getId()) == null) {
                object = "local";
            }
            LOG.debug("[" + (String)object + "] running " + commandLine.getCommandPresentation(environment) + "\n" + uploadVolumes.size() + " upload volumes: {" + CollectionsKt.joinToString$default((Iterable)uploadVolumes.values(), null, null, null, (int)0, null, NodeTargetRun::logCommandDetails$lambda$2, (int)31, null) + "}");
        }
    }

    private final boolean configureYarnPnpNode() {
        boolean bl;
        boolean it = bl = this.shouldWrapWithYarnNodeCommand();
        boolean bl2 = false;
        if (it) {
            NodePackage yarnPkg = this.getRequiredYarnPkg();
            String[] stringArray = new String[]{"node"};
            NpmNodePackage.configureNpmPackage(this, yarnPkg, stringArray);
        }
        return bl;
    }

    private final NodePackage getRequiredYarnPkg() {
        NodePackage nodePackage;
        NpmManager npmManager = NpmManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)npmManager, (String)"getInstance(...)");
        NpmManager npmManager2 = npmManager;
        if (NpmUtil.isYarnAlikePackageRef(npmManager2.getPackageRef()) && (nodePackage = npmManager2.getPackage(this.interpreter)) != null) {
            NodePackage it = nodePackage;
            boolean bl = false;
            return it;
        }
        throw new NpmManager.YarnPackageNotConfiguredException(this.project);
    }

    private final boolean shouldWrapWithYarnNodeCommand() {
        boolean yarn;
        block3: {
            YarnPnpNodePackage yarnPnpNodePackage;
            if (!this.enableWrappingWithYarnPnpNode) {
                return false;
            }
            Boolean bl = this.enableWrappingWithYarnNode;
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                return it;
            }
            if (this.myRequiredNodePackages.isEmpty() && YarnPnpManager.getInstance(this.project).getPnpFiles().isEmpty()) {
                return false;
            }
            NodePackageRef nodePackageRef = NpmManager.getInstance(this.project).getPackageRef();
            Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getPackageRef(...)");
            NodePackageRef projectNpmPackageRef = nodePackageRef;
            yarn = NpmUtil.isYarnAlikePackageRef(projectNpmPackageRef);
            YarnPnpNodePackage yarnPnpNodePackage2 = yarnPnpNodePackage = (YarnPnpNodePackage)CollectionsKt.firstOrNull(this.myRequiredNodePackages);
            if (yarnPnpNodePackage2 == null) break block3;
            yarnPnpNodePackage2.requireYarnPackageManager(this.project, yarn, false);
        }
        return yarn;
    }

    public final void withRequiredNodePackage(@NotNull NodePackage requiredNodePackage) {
        Intrinsics.checkNotNullParameter((Object)requiredNodePackage, (String)"requiredNodePackage");
        if (requiredNodePackage instanceof YarnPnpNodePackage) {
            this.myRequiredNodePackages.add((YarnPnpNodePackage)requiredNodePackage);
        }
    }

    private final void configureUserEnvironment() {
        this.interpreterRunSetup.configureEnvironment(this.commandLineBuilder, this.envData);
        if (this.options.getPtyOptions() == null) {
            Map $this$forEach$iv = NodeTargetRun.Companion.nonTtyColorEnvironmentVariables();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (this.commandLineBuilder.getEnvironmentVariable(key) != null) continue;
                this.commandLineBuilder.addEnvironmentVariable(key, value);
            }
        }
    }

    @NotNull
    public final TargetValue<String> path(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return this.requestUploadIntoTarget(localPath);
    }

    @NotNull
    public final TargetValue<String> path(@NotNull Path localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return this.requestUploadIntoTarget(((Object)localPath).toString());
    }

    @NotNull
    public final TargetValue<String> requestUploadProjectRootAndGetPath(@NotNull String localPath) {
        block2: {
            Unit unit;
            block3: {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                if (this.request instanceof LocalTargetEnvironmentRequest) break block2;
                unit = this.findProjectRoot(localPath);
                if (unit == null) break block3;
                Unit it = unit;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Unit unit2 = this.path(string);
                unit = unit2;
                if (unit2 != null) break block2;
            }
            NodeTargetRun $this$requestUploadProjectRootAndGetPath_u24lambda_u248 = this;
            boolean bl = false;
            LOG.warn("Cannot find project root by " + localPath);
            unit = Unit.INSTANCE;
        }
        return this.path(localPath);
    }

    private final VirtualFile findProjectRoot(String path2) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(path2);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            virtualFile = (VirtualFile)ActionsKt.runReadAction(() -> NodeTargetRun.findProjectRoot$lambda$10$lambda$9(this, it));
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    private final TargetValue<String> requestUploadIntoTarget(String uploadPathString) {
        Path path2;
        Path uploadPath = Paths.get(FileUtil.toSystemDependentName((String)uploadPathString), new String[0]);
        Intrinsics.checkNotNull((Object)uploadPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean isDir = Files.isDirectory(uploadPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (isDir) {
            path2 = uploadPath;
        } else {
            path2 = uploadPath.getParent();
            if (path2 == null) {
                path2 = Paths.get(".", new String[0]);
            }
        }
        Path localRootPath = path2;
        PathMapper pathMapper = this.interpreterRunSetup.getPathMapper();
        if (pathMapper != null) {
            PathMapper it = pathMapper;
            boolean bl = false;
            if (it.canReplaceLocal(((Object)uploadPath).toString())) {
                TargetValue targetValue = TargetValue.fixed((Object)it.convertToRemote(((Object)uploadPath).toString()));
                Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"fixed(...)");
                return targetValue;
            }
        }
        Intrinsics.checkNotNull((Object)localRootPath);
        Path pathToSearchUploadRoot = this.convertLocalPathToCopied(localRootPath);
        Pair pair = TargetEnvironmentFunctions.getUploadRootForLocalPath((TargetEnvironmentRequest)this.request, (Path)pathToSearchUploadRoot);
        if (pair == null) {
            TargetEnvironment.UploadRoot uploadRoot = this.createUploadRoot(localRootPath);
            boolean bl = false;
            ((Collection)this.request.getUploadVolumes()).add(uploadRoot);
            pair = TuplesKt.to((Object)uploadRoot, (Object)".");
        }
        Pair pair2 = pair;
        TargetEnvironment.UploadRoot uploadRoot = (TargetEnvironment.UploadRoot)pair2.component1();
        String pathToRoot = (String)pair2.component2();
        DeferredTargetValue result2 = new DeferredTargetValue((Object)uploadPathString);
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> NodeTargetRun.requestUploadIntoTarget$lambda$15(arg_0 -> NodeTargetRun.requestUploadIntoTarget$lambda$14(result2, uploadRoot, isDir, pathToRoot, uploadPath, this, arg_0), arg_0)));
        return (TargetValue)result2;
    }

    private final String joinPath(String ... segments) {
        String string = ((StringBuilder)ArraysKt.joinTo$default((Object[])segments, (Appendable)new StringBuilder(), (CharSequence)String.valueOf(this.request.getTargetPlatform().getPlatform().fileSeparator), null, null, (int)0, null, null, (int)124, null)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final TargetEnvironment.UploadRoot createUploadRoot(Path localRootPath) {
        return new TargetEnvironment.UploadRoot(this.copyIfNeeded(localRootPath), (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), false, 4, null);
    }

    private final Path copyIfNeeded(Path originalDir) {
        if (this.shouldCopyToTmp(originalDir)) {
            char[] cArray = new char[]{'/'};
            String name = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.trimStart((String)((Object)originalDir).toString(), (char[])cArray), (char)'/', (char)'-', (boolean)false, (int)4, null), (char)'\\', (char)'-', (boolean)false, (int)4, null), (char)' ', (char)'-', (boolean)false, (int)4, null);
            File file = FileUtil.createTempDirectory((String)name, null);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
            File tmpDir = file;
            FileUtil.copyDirContent((File)originalDir.toFile(), (File)tmpDir);
            this.copiedUploadVolumes.put(originalDir, tmpDir.toPath());
            this.commandLineBuilder.addFileToDeleteOnTermination(tmpDir);
            Path path2 = tmpDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            return path2;
        }
        return originalDir;
    }

    private final boolean shouldCopyToTmp(Path path2) {
        if (!SystemInfo.isMac || !StringsKt.startsWith$default((String)((Object)path2).toString(), (String)"/Applications/", (boolean)false, (int)2, null) || Registry.Companion.is("nodejs.docker.mac.Applications.is.shared", false)) {
            return false;
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.request.getConfiguration();
        String targetTypeId = targetEnvironmentConfiguration != null && (targetEnvironmentConfiguration = TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)targetEnvironmentConfiguration)) != null ? targetEnvironmentConfiguration.getId() : null;
        return Intrinsics.areEqual((Object)targetTypeId, (Object)"docker") || Intrinsics.areEqual((Object)targetTypeId, (Object)"docker-compose");
    }

    @NotNull
    public final Promise<ResolvedPortBinding> localPortBinding(int localPort) {
        TargetEnvironment.LocalPortBinding localPortBinding = new TargetEnvironment.LocalPortBinding(localPort, null);
        this.request.getLocalPortBindings().add(localPortBinding);
        AsyncPromise result2 = new AsyncPromise();
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> NodeTargetRun.localPortBinding$lambda$17(arg_0 -> NodeTargetRun.localPortBinding$lambda$16(localPortBinding, result2, arg_0), arg_0)));
        return (Promise)result2;
    }

    @NotNull
    public final TargetValue<Integer> targetPortBinding(int targetPort) {
        TargetEnvironment.TargetPortBinding binding = new TargetEnvironment.TargetPortBinding(null, targetPort);
        this.request.getTargetPortBindings().add(binding);
        DeferredLocalTargetValue result2 = new DeferredLocalTargetValue((Object)targetPort);
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> NodeTargetRun.targetPortBinding$lambda$19(arg_0 -> NodeTargetRun.targetPortBinding$lambda$18(binding, result2, arg_0), arg_0)));
        return (TargetValue)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void provideEnvironment(TargetEnvironment environment, TargetProgressIndicator targetProgressIndicator) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Sequence $this$sortedBy$iv;
        Application application = ApplicationManager.getApplication();
        LOG.assertTrue(environment instanceof LocalTargetEnvironment || this.uploads.isEmpty() || !application.isDispatchThread() || application.isUnitTestMode(), (Object)"Preparation of environment shouldn't be performed on EDT.");
        this.environmentPromise.setResult((Object)TuplesKt.to((Object)environment, (Object)targetProgressIndicator));
        Sequence sequence = CollectionsKt.asSequence((Iterable)this.uploads);
        boolean bl = false;
        $this$sortedBy$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Upload it = (Upload)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getRelativePath().length());
                it = (Upload)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRelativePath().length()));
            }
        });
        boolean bl2 = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Upload it2 = (Upload)element$iv$iv;
            boolean $i$a$-groupBy-NodeTargetRun$provideEnvironment$432 = false;
            TargetEnvironment.UploadableVolume key$iv$iv = it2.getVolume();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Upload $i$a$-groupBy-NodeTargetRun$provideEnvironment$432 = (Upload)element$iv$iv;
            List list = list$iv$iv;
            boolean bl4 = false;
            list.add(it.getRelativePath());
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean bl5 = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl6 = false;
            TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)entry.getKey();
            List relativePaths = (List)entry.getValue();
            volume.upload((String)CollectionsKt.first((List)relativePaths), targetProgressIndicator);
        }
        for (Promise promise : this.dependingOnEnvironmentPromise) {
            promise.blockingGet(0);
        }
    }

    @NotNull
    public final KillableProcessHandler createProcessHandlerByDefault(@NotNull Process process, @NotNull TargetedCommandLine commandLine, @NotNull TargetEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (process instanceof PtyProcess) {
            return this.createTerminalProcessHandler((PtyProcess)process, commandLine, environment);
        }
        return (KillableProcessHandler)this.createKillableColoredProcessHandler(process, commandLine, environment);
    }

    private final KillableProcessHandler createTerminalProcessHandler(PtyProcess process, TargetedCommandLine commandLine, TargetEnvironment environment) {
        Object object = this.debugConfigurator;
        if (object == null || (object = object.createMessagesFilter()) == null) {
            object = UnaryOperator.identity();
        }
        UnaryOperator<String> messagesFilter = object;
        String string = commandLine.getCommandPresentation(environment);
        Charset charset = commandLine.getCharset();
        Set set = this.commandLineBuilder.getFilesToDeleteOnTermination();
        return new KillableProcessHandler(process, messagesFilter, this, string, charset, set){
            final /* synthetic */ UnaryOperator<String> $messagesFilter;
            final /* synthetic */ NodeTargetRun this$0;
            {
                this.$messagesFilter = $messagesFilter;
                this.this$0 = $receiver;
                super((Process)$process, $super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void notifyTextAvailable(String text, Key<?> outputType) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    String string = (String)this.$messagesFilter.apply(text);
                    if (string == null) break block0;
                    String it = string;
                    boolean bl = false;
                    super.notifyTextAvailable(it, outputType);
                }
            }

            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = this.this$0.getOptions().getProcessReaderOptions();
                if (options == null) {
                    options = NodeTargetRun.access$blockingReaderOptions(this.this$0);
                }
                return options;
            }
        };
    }

    private final KillableColoredProcessHandler createKillableColoredProcessHandler(Process process, TargetedCommandLine commandLine, TargetEnvironment environment) {
        Object object = this.debugConfigurator;
        if (object == null || (object = object.createMessagesFilter()) == null) {
            object = UnaryOperator.identity();
        }
        UnaryOperator<String> messagesFilter = object;
        Set set = this.commandLineBuilder.getFilesToDeleteOnTermination();
        Intrinsics.checkNotNull(messagesFilter);
        return new NodeTargetRunKillableColoredProcessHandler(process, commandLine, environment, set, messagesFilter, this.options.getProcessReaderOptions());
    }

    private final BaseOutputReader.Options blockingReaderOptions() {
        return new BaseOutputReader.Options(){

            public BaseDataReader.SleepingPolicy policy() {
                BaseDataReader.SleepingPolicy sleepingPolicy = BaseDataReader.SleepingPolicy.BLOCKING;
                Intrinsics.checkNotNullExpressionValue((Object)sleepingPolicy, (String)"BLOCKING");
                return sleepingPolicy;
            }

            public boolean splitToLines() {
                return false;
            }

            public boolean withSeparators() {
                return true;
            }
        };
    }

    @NotNull
    public final Promise<String> convertLocalPathToTarget(@NotNull String localPath) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        if (this.interpreter instanceof NodeJsLocalInterpreter) {
            Promise promise = TargetValue.fixed((Object)localPath).getTargetValue();
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
            return promise;
        }
        Ref.ObjectRef nioLocalPath = new Ref.ObjectRef();
        nioLocalPath.element = Path.of(FileUtil.toSystemDependentName((String)localPath), new String[0]);
        if (!((Path)nioLocalPath.element).isAbsolute()) {
            Promise promise = TargetValue.fixed((Object)localPath).getTargetValue();
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
            return promise;
        }
        PathMapper pathMapper = this.interpreterRunSetup.getPathMapper();
        if (pathMapper != null) {
            PathMapper it = pathMapper;
            boolean bl = false;
            if (it.canReplaceLocal(nioLocalPath.element.toString())) {
                Promise promise = TargetValue.fixed((Object)it.convertToRemote(nioLocalPath.element.toString())).getTargetValue();
                Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
                return promise;
            }
        }
        Object object = nioLocalPath.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        nioLocalPath.element = this.convertLocalPathToCopied((Path)object);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean isDir = Files.isDirectory((Path)nioLocalPath.element, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (isDir) {
            path2 = (Path)nioLocalPath.element;
        } else {
            path2 = ((Path)nioLocalPath.element).getParent();
            if (path2 == null) {
                path2 = Paths.get(".", new String[0]);
            }
        }
        Path localRootPath = path2;
        Intrinsics.checkNotNull((Object)localRootPath);
        Pair pair = TargetEnvironmentFunctions.getUploadRootForLocalPath((TargetEnvironmentRequest)this.request, (Path)localRootPath);
        if (pair == null) {
            throw new IllegalStateException("No upload root registered for " + localRootPath);
        }
        Pair pair2 = pair;
        TargetEnvironment.UploadRoot uploadRoot = (TargetEnvironment.UploadRoot)pair2.component1();
        String pathToRoot = (String)pair2.component2();
        DeferredTargetValue result2 = new DeferredTargetValue((Object)localPath);
        this.environmentPromise.then(arg_0 -> NodeTargetRun.convertLocalPathToTarget$lambda$27(arg_0 -> NodeTargetRun.convertLocalPathToTarget$lambda$26(uploadRoot, isDir, pathToRoot, nioLocalPath, result2, this, arg_0), arg_0));
        Promise promise = result2.getTargetValue();
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
        return promise;
    }

    private final Path convertLocalPathToCopied(Path localPath) {
        Map.Entry<Path, Path> entry = this.findCopiedVolumeEntry(localPath, (Function1<? super Map.Entry<? extends Path, ? extends Path>, ? extends Path>)((Function1)NodeTargetRun::convertLocalPathToCopied$lambda$28));
        if (entry == null) {
            return localPath;
        }
        Map.Entry<Path, Path> closestCopiedVolume = entry;
        Path path2 = closestCopiedVolume.getValue().resolve(PathsKt.relativeTo((Path)localPath, (Path)closestCopiedVolume.getKey()));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private final String convertCopiedToLocal(String copiedPath) {
        Path path2 = Path.of(copiedPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Map.Entry<Path, Path> entry = this.findCopiedVolumeEntry(path2, (Function1<? super Map.Entry<? extends Path, ? extends Path>, ? extends Path>)((Function1)NodeTargetRun::convertCopiedToLocal$lambda$29));
        if (entry == null) {
            return copiedPath;
        }
        Map.Entry<Path, Path> closestCopiedVolume = entry;
        Path path3 = Path.of(copiedPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
        return ((Object)closestCopiedVolume.getKey().resolve(PathsKt.relativeTo((Path)path3, (Path)closestCopiedVolume.getValue()))).toString();
    }

    private final Map.Entry<Path, Path> findCopiedVolumeEntry(Path path2, Function1<? super Map.Entry<? extends Path, ? extends Path>, ? extends Path> pathSelector) {
        Map.Entry<Path, Path> closestCopiedUploadVolume = null;
        for (Map.Entry<Path, Path> copiedUploadVolume : this.copiedUploadVolumes.entrySet()) {
            Path pathToCompare = (Path)pathSelector.invoke(copiedUploadVolume);
            if (!path2.startsWith(pathToCompare) || closestCopiedUploadVolume != null && pathSelector.invoke(closestCopiedUploadVolume).toString().length() >= ((Object)pathToCompare).toString().length()) continue;
            closestCopiedUploadVolume = copiedUploadVolume;
        }
        return closestCopiedUploadVolume;
    }

    @NotNull
    public final Promise<String> convertTargetPathToLocal(@NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        if (this.interpreter instanceof NodeJsLocalInterpreter) {
            Promise promise = TargetValue.fixed((Object)targetPath).getTargetValue();
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
            return promise;
        }
        if (this.request.getTargetPlatform().getPlatform() == Platform.UNIX && !StringsKt.startsWith$default((String)targetPath, (String)"/", (boolean)false, (int)2, null)) {
            Promise promise = TargetValue.fixed((Object)targetPath).getTargetValue();
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
            return promise;
        }
        PathMapper pathMapper = this.interpreterRunSetup.getPathMapper();
        if (pathMapper != null) {
            PathMapper it = pathMapper;
            boolean bl = false;
            if (it.canReplaceRemote(targetPath)) {
                Promise promise = TargetValue.fixed((Object)it.convertToLocal(targetPath)).getTargetValue();
                Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
                return promise;
            }
        }
        AsyncPromise result2 = new AsyncPromise();
        this.environmentPromise.then(arg_0 -> NodeTargetRun.convertTargetPathToLocal$lambda$32(arg_0 -> NodeTargetRun.convertTargetPathToLocal$lambda$31(this, targetPath, result2, arg_0), arg_0));
        return (Promise)result2;
    }

    @NotNull
    public final String convertTargetPathToLocalPath(@NotNull String targetPath) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        try {
            Object object = this.convertTargetPathToLocal(targetPath).blockingGet(0);
            Intrinsics.checkNotNull((Object)object);
            return (String)object;
        }
        catch (TimeoutException e) {
            throw new IllegalArgumentException("(Unexpected timeout) Cannot covert target path '" + targetPath + "' to local", e);
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Cannot covert target path '" + targetPath + "' to local", e);
        }
    }

    @NotNull
    public final String convertLocalPathToTargetPath(@NotNull String localPath) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        try {
            Object object = this.convertLocalPathToTarget(localPath).blockingGet(0);
            Intrinsics.checkNotNull((Object)object);
            return (String)object;
        }
        catch (TimeoutException e) {
            throw new IllegalArgumentException("(Unexpected timeout) Cannot covert local path '" + localPath + "' to target", e);
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Cannot covert local path '" + localPath + "' to target", e);
        }
    }

    private final String joinPaths(String basePath, String relativePath, Platform platform) {
        char fileSeparator = platform.fileSeparator;
        String string = FileUtil.toSystemDependentName((String)(StringsKt.removeSuffix((String)basePath, (CharSequence)String.valueOf(fileSeparator)) + fileSeparator + relativePath), (char)fileSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void addNodeOptionsWithExpandedMacros(boolean passThroughEnvironmentVariableOnly, @NotNull String nodeOptions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nodeOptions, (String)"nodeOptions");
        List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)((Object)StringsKt.trim((CharSequence)nodeOptions)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TargetValue.fixed((Object)it));
        }
        List expanded = (List)destination$iv$iv;
        this.addNodeOptions(passThroughEnvironmentVariableOnly, expanded);
    }

    public final void addNodeOptions(boolean passThroughEnvironmentVariableOnly, TargetValue<String> ... nodeOptionsToAdd) {
        Intrinsics.checkNotNullParameter(nodeOptionsToAdd, (String)"nodeOptionsToAdd");
        this.addNodeOptions(passThroughEnvironmentVariableOnly, ArraysKt.toList((Object[])nodeOptionsToAdd));
    }

    /*
     * WARNING - void declaration
     */
    private final void addNodeOptions(boolean passThroughEnvironmentVariableOnly, List<? extends TargetValue<String>> nodeOptionsToAdd) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = nodeOptionsToAdd;
        List<NodeOptionValue> list = this.nodeOptions;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TargetValue targetValue = (TargetValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new NodeOptionValue((TargetValue<String>)it, passThroughEnvironmentVariableOnly));
        }
        list.addAll((List)destination$iv$iv);
    }

    private final List<TargetValue<String>> getNodeOptions(Boolean passThroughEnvironmentVariableOnly) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.nodeOptions), arg_0 -> NodeTargetRun.getNodeOptions$lambda$35(passThroughEnvironmentVariableOnly, arg_0)), NodeTargetRun::getNodeOptions$lambda$36));
    }

    @NotNull
    public final List<TargetValue<String>> getNodeOptions$intellij_javascript_impl() {
        return this.getNodeOptions(false);
    }

    public final void setNodeOptions$intellij_javascript_impl(@NotNull List<? extends TargetValue<String>> nodeOptionsToSet) {
        Intrinsics.checkNotNullParameter(nodeOptionsToSet, (String)"nodeOptionsToSet");
        this.nodeOptions.removeIf(arg_0 -> NodeTargetRun.setNodeOptions$lambda$38(NodeTargetRun::setNodeOptions$lambda$37, arg_0));
        this.addNodeOptions(false, nodeOptionsToSet);
    }

    private final void passNodeOptionsThroughEnvironmentVariable(List<? extends TargetValue<String>> nodeOptions) {
        if (!((Collection)nodeOptions).isEmpty()) {
            TargetValue targetValue = this.commandLineBuilder.getEnvironmentVariable(NODE_OPTIONS);
            if (targetValue == null) {
                targetValue = TargetValue.empty();
            }
            TargetValue prevNodeOptionsEnvValue = targetValue;
            this.commandLineBuilder.addEnvironmentVariable(NODE_OPTIONS, TargetValue.composite((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)prevNodeOptionsEnvValue), (Iterable)nodeOptions), arg_0 -> NodeTargetRun.passNodeOptionsThroughEnvironmentVariable$lambda$40(NodeTargetRun::passNodeOptionsThroughEnvironmentVariable$lambda$39, arg_0)));
        }
    }

    public final boolean isExePathDefined() {
        Promise promise = this.commandLineBuilder.getExePath().getLocalValue();
        if (promise.getState() == Promise.State.SUCCEEDED) {
            try {
                return promise.blockingGet(0) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public NodeTargetRun(@NotNull NodeJsInterpreter interpreter2, @NotNull Project project, @Nullable CommandLineDebugConfigurator configurator, @NotNull Options options, @NotNull NodeTargetRunSetup interpreterRunSetup) throws com.intellij.execution.ExecutionException {
        Collection<TargetValue> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)interpreterRunSetup, (String)"interpreterRunSetup");
        this(interpreter2, project, configurator, NodeTargetRunOptions.Companion.toNewOptions$intellij_javascript_impl(options), interpreterRunSetup);
        Iterable iterable = options.getNodeOptions();
        boolean bl = false;
        NodeTargetRun nodeTargetRun = this;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TargetValue.fixed((Object)it));
        }
        collection = (List)destination$iv$iv;
        nodeTargetRun.addNodeOptions(bl, (List<? extends TargetValue<String>>)collection);
    }

    public /* synthetic */ NodeTargetRun(NodeJsInterpreter nodeJsInterpreter, Project project, CommandLineDebugConfigurator commandLineDebugConfigurator, Options options, NodeTargetRunSetup nodeTargetRunSetup, int n, DefaultConstructorMarker defaultConstructorMarker) throws com.intellij.execution.ExecutionException {
        if ((n & 0x10) != 0) {
            nodeTargetRunSetup = nodeJsInterpreter.createTargetRunSetup(project, NodeTargetRunOptions.Companion.toNewOptions$intellij_javascript_impl(options));
        }
        this(nodeJsInterpreter, project, commandLineDebugConfigurator, options, nodeTargetRunSetup);
    }

    @Deprecated(message="Set NodeTargetRun.envData directly", replaceWith=@ReplaceWith(expression="targetRun.envData = myEnvData", imports={}))
    public final void configureEnvironment(@NotNull EnvironmentVariablesData envData) {
        Intrinsics.checkNotNullParameter((Object)envData, (String)"envData");
        this.envData = envData;
    }

    @JvmOverloads
    public NodeTargetRun(@NotNull NodeJsInterpreter interpreter2, @NotNull Project project, @Nullable CommandLineDebugConfigurator debugConfigurator, @NotNull NodeTargetRunOptions options) throws com.intellij.execution.ExecutionException {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this(interpreter2, project, debugConfigurator, options, null, 16, null);
    }

    @JvmOverloads
    public NodeTargetRun(@NotNull NodeJsInterpreter interpreter2, @NotNull Project project, @Nullable CommandLineDebugConfigurator configurator, @NotNull Options options) throws com.intellij.execution.ExecutionException {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this(interpreter2, project, configurator, options, null, 16, null);
    }

    private static final CharSequence logCommandDetails$lambda$2(TargetEnvironment.UploadableVolume it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLocalRoot() + " -> " + it.getTargetRoot();
    }

    private static final VirtualFile findProjectRoot$lambda$10$lambda$9(NodeTargetRun this$0, VirtualFile $it) {
        return ProjectFileIndex.getInstance((Project)this$0.project).getContentRootForFile($it, false);
    }

    private static final Unit requestUploadIntoTarget$lambda$14(DeferredTargetValue $result, TargetEnvironment.UploadRoot $uploadRoot, boolean $isDir, String $pathToRoot, Path $uploadPath, NodeTargetRun this$0, Pair pair) {
        TargetEnvironment environment = (TargetEnvironment)pair.component1();
        TargetProgressIndicator targetProgressIndicator = (TargetProgressIndicator)pair.component2();
        if (targetProgressIndicator.isCanceled() || targetProgressIndicator.isStopped()) {
            $result.stopProceeding();
            return Unit.INSTANCE;
        }
        TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)$uploadRoot);
        try {
            String string;
            if ($isDir) {
                string = $pathToRoot;
            } else {
                String it = ((Object)$uploadPath.getFileName()).toString();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)$pathToRoot, (Object)".")) {
                    string = it;
                } else {
                    String[] stringArray = new String[]{$pathToRoot, it};
                    string = this$0.joinPath(stringArray);
                }
            }
            String relativePath = string;
            String resolvedTargetPath = volume.resolveTargetPath(relativePath);
            this$0.uploads.add(new Upload(volume, relativePath));
            $result.resolve((Object)resolvedTargetPath);
        }
        catch (Throwable t) {
            LOG.warn(t);
            Object[] objectArray = new Object[]{volume.getLocalRoot(), t.getLocalizedMessage()};
            targetProgressIndicator.stopWithErrorMessage(LangCoreBundle.message((String)"progress.message.failed.to.resolve.0.1", (Object[])objectArray));
            $result.resolveFailure(t);
        }
        return Unit.INSTANCE;
    }

    private static final Unit requestUploadIntoTarget$lambda$15(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit localPortBinding$lambda$16(TargetEnvironment.LocalPortBinding $localPortBinding, AsyncPromise $result, Pair pair) {
        TargetEnvironment environment = (TargetEnvironment)pair.component1();
        TargetProgressIndicator targetProgressIndicator = (TargetProgressIndicator)pair.component2();
        if (targetProgressIndicator.isCanceled() || targetProgressIndicator.isStopped()) {
            return Unit.INSTANCE;
        }
        ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)environment.getLocalPortBindings().get($localPortBinding);
        if (resolvedPortBinding != null) {
            $result.setResult((Object)resolvedPortBinding);
        } else {
            $result.setError(new Throwable("Local port binding \"" + $localPortBinding + "\" cannot be found"));
        }
        return Unit.INSTANCE;
    }

    private static final Unit localPortBinding$lambda$17(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit targetPortBinding$lambda$18(TargetEnvironment.TargetPortBinding $binding, DeferredLocalTargetValue $result, Pair pair) {
        TargetEnvironment environment = (TargetEnvironment)pair.component1();
        TargetProgressIndicator targetProgressIndicator = (TargetProgressIndicator)pair.component2();
        if (targetProgressIndicator.isCanceled() || targetProgressIndicator.isStopped()) {
            return Unit.INSTANCE;
        }
        ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)environment.getTargetPortBindings().get($binding);
        Integer localPort = resolvedPortBinding != null ? Integer.valueOf(ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)resolvedPortBinding)) : null;
        $result.resolve((Object)localPort);
        return Unit.INSTANCE;
    }

    private static final Unit targetPortBinding$lambda$19(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit convertLocalPathToTarget$lambda$26(TargetEnvironment.UploadRoot $uploadRoot, boolean $isDir, String $pathToRoot, Ref.ObjectRef $nioLocalPath, DeferredTargetValue $result, NodeTargetRun this$0, Pair pair) {
        TargetEnvironment environment = (TargetEnvironment)pair.component1();
        TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)$uploadRoot);
        try {
            String string;
            if ($isDir) {
                string = $pathToRoot;
            } else {
                String it = ((Object)((Path)$nioLocalPath.element).getFileName()).toString();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)$pathToRoot, (Object)".")) {
                    string = it;
                } else {
                    String[] stringArray = new String[]{$pathToRoot, it};
                    string = this$0.joinPath(stringArray);
                }
            }
            String relativePath = string;
            $result.resolve((Object)volume.resolveTargetPath(relativePath));
        }
        catch (Throwable t) {
            LOG.warn(t);
            $result.resolveFailure(t);
        }
        return Unit.INSTANCE;
    }

    private static final Unit convertLocalPathToTarget$lambda$27(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Path convertLocalPathToCopied$lambda$28(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Path)it.getKey();
    }

    private static final Path convertCopiedToLocal$lambda$29(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Path)it.getValue();
    }

    private static final Unit convertTargetPathToLocal$lambda$31(NodeTargetRun this$0, String $targetPath, AsyncPromise $result, Pair pair) {
        TargetEnvironment environment = (TargetEnvironment)pair.component1();
        for (TargetEnvironment.UploadRoot uploadVolume : this$0.request.getUploadVolumes()) {
            TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)uploadVolume);
            if (!StringsKt.startsWith$default((String)$targetPath, (String)volume.getTargetRoot(), (boolean)false, (int)2, null)) continue;
            String string = $targetPath.substring(volume.getTargetRoot().length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = FileUtil.toSystemDependentName((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
            char[] cArray = new char[]{File.separatorChar};
            String relativePath = StringsKt.trimStart((String)string2, (char[])cArray);
            String string3 = ((Object)uploadVolume.getLocalRootPath()).toString();
            Platform platform = TargetPlatform.CURRENT.getPlatform();
            Intrinsics.checkNotNullExpressionValue((Object)platform, (String)"getPlatform(...)");
            String localPath = this$0.joinPaths(string3, relativePath, platform);
            $result.setResult((Object)this$0.convertCopiedToLocal(localPath));
            return Unit.INSTANCE;
        }
        $result.setError(new Throwable("Cannot find upload root for target path: " + $targetPath));
        return Unit.INSTANCE;
    }

    private static final Unit convertTargetPathToLocal$lambda$32(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final boolean getNodeOptions$lambda$35(Boolean $passThroughEnvironmentVariableOnly, NodeOptionValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $passThroughEnvironmentVariableOnly == null || Intrinsics.areEqual((Object)it.getPassThroughEnvironmentVariableOnly(), (Object)$passThroughEnvironmentVariableOnly);
    }

    private static final TargetValue getNodeOptions$lambda$36(NodeOptionValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    private static final boolean setNodeOptions$lambda$37(NodeOptionValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.getPassThroughEnvironmentVariableOnly();
    }

    private static final boolean setNodeOptions$lambda$38(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String passNodeOptionsThroughEnvironmentVariable$lambda$39(Collection it) {
        Intrinsics.checkNotNull((Object)it);
        List list = CollectionsKt.toList((Iterable)it);
        return Companion.formatNodeOptions((String)list.get(0), list.subList(1, list.size()));
    }

    private static final String passNodeOptionsThroughEnvironmentVariable$lambda$40(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @JvmStatic
    public static final boolean shouldEnableRemoteDevelopmentUsingTargetsApi() {
        return Companion.shouldEnableRemoteDevelopmentUsingTargetsApi();
    }

    @JvmStatic
    @NotNull
    public static final NodeTargetRun getTargetRun(@NotNull ProcessHandler processHandler) {
        return Companion.getTargetRun(processHandler);
    }

    public static final /* synthetic */ BaseOutputReader.Options access$blockingReaderOptions(NodeTargetRun $this) {
        return $this.blockingReaderOptions();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NodeTargetRun.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)NodeTargetRun.class.getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TARGET_RUN_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001e\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015J'\u0010\u0016\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ3\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\b\u0010\u001c\u001a\u0004\u0018\u0001H\u0017H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Companion;", "", "<init>", "()V", "NODE_OPTIONS", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TARGET_RUN_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "shouldEnableRemoteDevelopmentUsingTargetsApi", "", "nonTtyColorEnvironmentVariables", "", "getTargetRun", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "formatNodeOptions", "prevNodeOptionsEnvValue", "nodeOptions", "", "getConstantTargetValue", "T", "value", "Lcom/intellij/execution/target/value/TargetValue;", "getConstantTargetValue$intellij_javascript_impl", "(Lcom/intellij/execution/target/value/TargetValue;)Ljava/lang/Object;", "defaultValue", "(Lcom/intellij/execution/target/value/TargetValue;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean shouldEnableRemoteDevelopmentUsingTargetsApi() {
            return Registry.Companion.is("nodejs.remote.development.using.targets.api");
        }

        private final Map<String, String> nonTtyColorEnvironmentVariables() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEBUG_COLORS", (Object)"true"), TuplesKt.to((Object)"COLORTERM", (Object)"true"), TuplesKt.to((Object)"FORCE_COLOR", (Object)"true"), TuplesKt.to((Object)"npm_config_color", (Object)"always"), TuplesKt.to((Object)"MOCHA_COLORS", (Object)"1")};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @JvmStatic
        @NotNull
        public final NodeTargetRun getTargetRun(@NotNull ProcessHandler processHandler) {
            Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
            Object object = processHandler.getUserData(TARGET_RUN_KEY);
            Intrinsics.checkNotNull((Object)object);
            return (NodeTargetRun)object;
        }

        @NotNull
        public final String formatNodeOptions(@Nullable String prevNodeOptionsEnvValue, @NotNull List<String> nodeOptions) {
            Intrinsics.checkNotNullParameter(nodeOptions, (String)"nodeOptions");
            if (!(!nodeOptions.isEmpty())) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            String nodeOptionsStr = CollectionsKt.joinToString$default((Iterable)nodeOptions, (CharSequence)" ", null, null, (int)0, null, Companion::formatNodeOptions$lambda$0, (int)30, null);
            CharSequence charSequence = prevNodeOptionsEnvValue;
            return charSequence == null || charSequence.length() == 0 ? nodeOptionsStr : prevNodeOptionsEnvValue + " " + nodeOptionsStr;
        }

        @NotNull
        public final <T> T getConstantTargetValue$intellij_javascript_impl(@NotNull TargetValue<T> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Promise promise = value.getTargetValue();
            if (promise.getState() == Promise.State.SUCCEEDED) {
                try {
                    Object object = promise.blockingGet(0);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of com.intellij.javascript.nodejs.execution.NodeTargetRun.Companion.getConstantTargetValue");
                    return (T)object;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            throw new IllegalStateException("Unexpected promise state is " + promise.getState());
        }

        @Nullable
        public final <T> T getConstantTargetValue$intellij_javascript_impl(@NotNull TargetValue<T> value, @Nullable T defaultValue) {
            T t;
            Intrinsics.checkNotNullParameter(value, (String)"value");
            try {
                t = this.getConstantTargetValue$intellij_javascript_impl(value);
            }
            catch (Exception e) {
                t = defaultValue;
            }
            return t;
        }

        private static final CharSequence formatNodeOptions$lambda$0(String option) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            if (StringUtil.containsAnyChar((String)option, (String)" \"")) {
                char[] cArray = new char[]{'\"', '\\'};
                String string = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeChars((String)option, (char[])cArray));
                Intrinsics.checkNotNull((Object)string);
                charSequence = string;
            } else {
                charSequence = option;
            }
            return charSequence;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$NodeOptionValue;", "", "value", "Lcom/intellij/execution/target/value/TargetValue;", "", "passThroughEnvironmentVariableOnly", "", "<init>", "(Lcom/intellij/execution/target/value/TargetValue;Z)V", "getValue", "()Lcom/intellij/execution/target/value/TargetValue;", "getPassThroughEnvironmentVariableOnly", "()Z", "toString", "intellij.javascript.impl"})
    private static final class NodeOptionValue {
        @NotNull
        private final TargetValue<String> value;
        private final boolean passThroughEnvironmentVariableOnly;

        public NodeOptionValue(@NotNull TargetValue<String> value, boolean passThroughEnvironmentVariableOnly) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.value = value;
            this.passThroughEnvironmentVariableOnly = passThroughEnvironmentVariableOnly;
        }

        @NotNull
        public final TargetValue<String> getValue() {
            return this.value;
        }

        public final boolean getPassThroughEnvironmentVariableOnly() {
            return this.passThroughEnvironmentVariableOnly;
        }

        @NotNull
        public String toString() {
            return this.value + ", " + (this.passThroughEnvironmentVariableOnly ? "passThroughEnvironmentVariableOnly" : "");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0014R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$NodeTargetRunKillableColoredProcessHandler;", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "process", "Ljava/lang/Process;", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "environment", "Lcom/intellij/execution/target/TargetEnvironment;", "filesToDelete", "", "Ljava/io/File;", "messagesFilter", "Ljava/util/function/UnaryOperator;", "", "processReaderOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "<init>", "(Ljava/lang/Process;Lcom/intellij/execution/target/TargetedCommandLine;Lcom/intellij/execution/target/TargetEnvironment;Ljava/util/Set;Ljava/util/function/UnaryOperator;Lcom/intellij/util/io/BaseOutputReader$Options;)V", "coloredTextAvailable", "", "text", "attributes", "Lcom/intellij/openapi/util/Key;", "readerOptions", "intellij.javascript.impl"})
    private static final class NodeTargetRunKillableColoredProcessHandler
    extends KillableColoredProcessHandler {
        @NotNull
        private final UnaryOperator<String> messagesFilter;
        @Nullable
        private final BaseOutputReader.Options processReaderOptions;

        public NodeTargetRunKillableColoredProcessHandler(@NotNull Process process, @NotNull TargetedCommandLine commandLine, @NotNull TargetEnvironment environment, @NotNull Set<? extends File> filesToDelete, @NotNull UnaryOperator<String> messagesFilter, @Nullable BaseOutputReader.Options processReaderOptions) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Intrinsics.checkNotNullParameter(filesToDelete, (String)"filesToDelete");
            Intrinsics.checkNotNullParameter(messagesFilter, (String)"messagesFilter");
            super(process, commandLine.getCommandPresentation(environment), commandLine.getCharset(), filesToDelete);
            this.messagesFilter = messagesFilter;
            this.processReaderOptions = processReaderOptions;
        }

        public void coloredTextAvailable(@NotNull String text, @NotNull Key<?> attributes) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
                String string = (String)this.messagesFilter.apply(text);
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                super.coloredTextAvailable(it, attributes);
            }
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = this.processReaderOptions;
            if (options == null) {
                BaseOutputReader.Options options2 = BaseOutputReader.Options.forTerminalPtyProcess();
                options = options2;
                Intrinsics.checkNotNullExpressionValue((Object)options2, (String)"forTerminalPtyProcess(...)");
            }
            return options;
        }
    }

    @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="NodeTargetRunOptions", imports={}))
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Options;", "", "ptyOptions", "Lcom/intellij/execution/process/LocalPtyOptions;", "nodeOptions", "", "", "configureNodeOptionsCliImmediately", "", "processReaderOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "<init>", "(Lcom/intellij/execution/process/LocalPtyOptions;Ljava/util/List;ZLcom/intellij/util/io/BaseOutputReader$Options;Lcom/intellij/execution/configurations/RunConfigurationBase;)V", "getPtyOptions", "()Lcom/intellij/execution/process/LocalPtyOptions;", "getNodeOptions", "()Ljava/util/List;", "getConfigureNodeOptionsCliImmediately", "()Z", "getProcessReaderOptions", "()Lcom/intellij/util/io/BaseOutputReader$Options;", "getRunConfiguration", "()Lcom/intellij/execution/configurations/RunConfigurationBase;", "intellij.javascript.impl"})
    @ApiStatus.ScheduledForRemoval
    public static final class Options {
        @Nullable
        private final LocalPtyOptions ptyOptions;
        @NotNull
        private final List<String> nodeOptions;
        private final boolean configureNodeOptionsCliImmediately;
        @Nullable
        private final BaseOutputReader.Options processReaderOptions;
        @Nullable
        private final RunConfigurationBase<?> runConfiguration;

        public Options(@Nullable LocalPtyOptions ptyOptions, @NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately, @Nullable BaseOutputReader.Options processReaderOptions, @Nullable RunConfigurationBase<?> runConfiguration) {
            Intrinsics.checkNotNullParameter(nodeOptions, (String)"nodeOptions");
            this.ptyOptions = ptyOptions;
            this.nodeOptions = nodeOptions;
            this.configureNodeOptionsCliImmediately = configureNodeOptionsCliImmediately;
            this.processReaderOptions = processReaderOptions;
            this.runConfiguration = runConfiguration;
        }

        @Nullable
        public final LocalPtyOptions getPtyOptions() {
            return this.ptyOptions;
        }

        @NotNull
        public final List<String> getNodeOptions() {
            return this.nodeOptions;
        }

        public final boolean getConfigureNodeOptionsCliImmediately() {
            return this.configureNodeOptionsCliImmediately;
        }

        @Nullable
        public final BaseOutputReader.Options getProcessReaderOptions() {
            return this.processReaderOptions;
        }

        @Nullable
        public final RunConfigurationBase<?> getRunConfiguration() {
            return this.runConfiguration;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Upload;", "", "volume", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "relativePath", "", "<init>", "(Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;Ljava/lang/String;)V", "getVolume", "()Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "getRelativePath", "()Ljava/lang/String;", "intellij.javascript.impl"})
    private static final class Upload {
        @NotNull
        private final TargetEnvironment.UploadableVolume volume;
        @NotNull
        private final String relativePath;

        public Upload(@NotNull TargetEnvironment.UploadableVolume volume, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            this.volume = volume;
            this.relativePath = relativePath;
        }

        @NotNull
        public final TargetEnvironment.UploadableVolume getVolume() {
            return this.volume;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }
    }
}

