/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.execution.ExecutionException;
import com.intellij.idea.AppMode;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.util.JSPluginPathManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\f\u001a\u00020\u0007H\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/HelperFilesLocator;", "", "<init>", "()V", "findBundledHelpersDir", "Ljava/nio/file/Path;", "getFileRelativeToHelpersDir", "Ljava/io/File;", "relativePath", "", "resolvePathOrThrowExecutionExecution", "resolvePathForExecution", "getBundledHelpersDir", "intellij.javascript.impl"})
public final class HelperFilesLocator {
    @NotNull
    public static final HelperFilesLocator INSTANCE = new HelperFilesLocator();

    private HelperFilesLocator() {
    }

    private final Path findBundledHelpersDir() {
        Path path2 = JSPluginPathManager.getPluginResourceOrSource(HelperFilesLocator.class, "helpers", AppMode.isDevServer() ? "javascript-plugin" : "JavaScriptLanguage/src").toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        return path2;
    }

    @JvmStatic
    @NotNull
    public static final File getFileRelativeToHelpersDir(@NotNull String relativePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path helpersDir = INSTANCE.findBundledHelpersDir();
        String string = FileUtil.toSystemDependentName((String)relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String systemDependentRelativePath = string;
        Path file = helpersDir.resolve(systemDependentRelativePath).normalize();
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IOException("Cannot find " + relativePath + ", no such file or directory " + file.toFile());
        }
        File file2 = file.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return file2;
    }

    @JvmStatic
    @NotNull
    public static final Path resolvePathOrThrowExecutionExecution(@NotNull String relativePath) throws ExecutionException {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        try {
            File file = HelperFilesLocator.getFileRelativeToHelpersDir(relativePath);
            path2 = file.toPath();
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof IOException || exception instanceof InvalidPathException) {
                Object[] objectArray = new Object[]{relativePath};
                throw new ExecutionException(JavaScriptBundle.message("dialog.message.cannot.find.file", objectArray), (Throwable)e);
            }
            throw e;
        }
        return path2;
    }

    @JvmStatic
    @NotNull
    public static final String resolvePathForExecution(@NotNull String relativePath) throws ExecutionException {
        String string;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        try {
            File file = HelperFilesLocator.getFileRelativeToHelpersDir(relativePath);
            string = file.getAbsolutePath();
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{relativePath};
            throw new ExecutionException(JavaScriptBundle.message("dialog.message.cannot.find.file", objectArray), (Throwable)e);
        }
        return string;
    }

    @Deprecated(message="Use resolvePathOrThrowExecutionExecution(\".\") instead", replaceWith=@ReplaceWith(expression="resolvePathOrThrowExecutionExecution()", imports={"com.intellij.javascript.HelperFilesLocator.resolvePathOrThrowExecutionExecution"}))
    @JvmStatic
    @NotNull
    public static final File getBundledHelpersDir() {
        File file = INSTANCE.findBundledHelpersDir().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }
}

