/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.block.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.block.feedback.BlockTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.fus.BlockTerminalSwitchPlace;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/action/EnableBlockTerminalUiAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "<init>", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.terminal"})
public final class EnableBlockTerminalUiAction
extends DumbAwareToggleAction {
    public EnableBlockTerminalUiAction() {
        super(TerminalBundle.messagePointer("action.Terminal.EnableNewUi.text", new Object[0]));
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return Registry.Companion.is("terminal.new.ui");
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Registry.Companion.get("terminal.new.ui").setValue(state);
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        TerminalUsageTriggerCollector.triggerBlockTerminalSwitched$intellij_terminal(project2, state, BlockTerminalSwitchPlace.TOOLWINDOW_OPTIONS);
        if (!state) {
            TerminalUsageLocalStorage.Companion.getInstance().recordBlockTerminalDisabled();
            BlockTerminalFeedbackSurveyKt.showBlockTerminalFeedbackNotification(project2);
        }
        TerminalToolWindowManager.getInstance(project2).createNewSession();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && ExperimentalUI.Companion.isNewUI());
        e.getPresentation().putClientProperty(ActionUtil.SECONDARY_ICON, (Object)AllIcons.General.Beta);
        e.getPresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

