/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.BeforeRunTask;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.UploadBeforeRunTaskProvider;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadBeforeRunTask
extends BeforeRunTask<UploadBeforeRunTask> {
    @NonNls
    private static final String SERVER_ID = "server_id";
    @NonNls
    private static final String SERVER_NAME = "server_name";
    @NonNls
    private static final String GROUP_NAME = "group_name";
    private static final String PATH = "path";
    private final ServerOrGroup myServerOrGroup = new ServerOrGroup();
    private final List<String> myRoots = new ArrayList<String>();

    public UploadBeforeRunTask() {
        super(UploadBeforeRunTaskProvider.ID);
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            UploadBeforeRunTask.$$$reportNull$$$0(0);
        }
        super.writeExternal(element);
        UploadBeforeRunTask.write(element, SERVER_ID, this.myServerOrGroup.getServerId());
        UploadBeforeRunTask.write(element, SERVER_NAME, this.myServerOrGroup.getServerName());
        UploadBeforeRunTask.write(element, GROUP_NAME, this.myServerOrGroup.getGroupName());
        for (String root : this.myRoots) {
            UploadBeforeRunTask.write(element, PATH, root);
        }
    }

    private static void write(@NotNull Element element, String name, String value) {
        if (element == null) {
            UploadBeforeRunTask.$$$reportNull$$$0(1);
        }
        Element groupNameChild = new Element(name);
        groupNameChild.addContent(value);
        element.addContent(groupNameChild);
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            UploadBeforeRunTask.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        this.myRoots.clear();
        for (Element o : element.getChildren(PATH)) {
            this.myRoots.add(o.getText());
        }
        String serverId = UploadBeforeRunTask.get(SERVER_ID, element);
        String serverName = UploadBeforeRunTask.get(SERVER_NAME, element);
        String groupName = UploadBeforeRunTask.get(GROUP_NAME, element);
        this.myServerOrGroup.clean();
        if (groupName != null) {
            this.myServerOrGroup.setGroup(groupName);
        } else {
            this.myServerOrGroup.setServer(serverId, serverName);
        }
    }

    @Nullable
    private static String get(String name, Element element) {
        Element serverIdChild = element.getChild(name);
        if (serverIdChild != null) {
            return StringUtil.nullize((String)serverIdChild.getText());
        }
        return null;
    }

    public List<String> getRoots() {
        return this.myRoots;
    }

    public ServerOrGroup getServerOrGroup() {
        return this.myServerOrGroup;
    }

    public void setServerOrGroup(@NotNull ServerOrGroup serverOrGroup) {
        if (serverOrGroup == null) {
            UploadBeforeRunTask.$$$reportNull$$$0(3);
        }
        this.myServerOrGroup.copy(serverOrGroup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverOrGroup";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/UploadBeforeRunTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setServerOrGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

