/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Sinks;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.FutureMono;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AbortedException;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.Cookies;
import reactor.netty.http.HttpOperations;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientFormEncoder;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.client.HttpClientState;
import reactor.netty.http.client.PrematureCloseException;
import reactor.netty.http.client.RedirectClientException;
import reactor.netty.http.client.WebsocketClientOperations;
import reactor.netty.http.client.WebsocketClientSpec;
import reactor.netty.http.logging.HttpMessageArgProviderFactory;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

class HttpClientOperations
extends HttpOperations<NettyInbound, NettyOutbound>
implements HttpClientResponse,
HttpClientRequest {
    final boolean isSecure;
    final HttpRequest nettyRequest;
    final HttpHeaders requestHeaders;
    final ClientCookieEncoder cookieEncoder;
    final ClientCookieDecoder cookieDecoder;
    final List<Cookie> cookieList;
    final Sinks.One<HttpHeaders> trailerHeaders;
    Supplier<String>[] redirectedFrom = EMPTY_REDIRECTIONS;
    String resourceUrl;
    String path;
    Duration responseTimeout;
    volatile ResponseState responseState;
    boolean started;
    boolean retrying;
    boolean is100Continue;
    RedirectClientException redirecting;
    BiPredicate<HttpClientRequest, HttpClientResponse> followRedirectPredicate;
    Consumer<HttpClientRequest> redirectRequestConsumer;
    HttpHeaders previousRequestHeaders;
    BiConsumer<HttpHeaders, HttpClientRequest> redirectRequestBiConsumer;
    volatile Throwable unprocessedOutboundError;
    static final String INBOUND_CANCEL_LOG = "Http client inbound receiver cancelled, closing channel.";
    static final int MAX_REDIRECTS = 50;
    static final Supplier<String>[] EMPTY_REDIRECTIONS = new Supplier[0];
    static final Logger log = Loggers.getLogger(HttpClientOperations.class);

    HttpClientOperations(HttpClientOperations replaced) {
        super(replaced);
        this.started = replaced.started;
        this.retrying = replaced.retrying;
        this.redirecting = replaced.redirecting;
        this.redirectedFrom = replaced.redirectedFrom;
        this.redirectRequestConsumer = replaced.redirectRequestConsumer;
        this.previousRequestHeaders = replaced.previousRequestHeaders;
        this.redirectRequestBiConsumer = replaced.redirectRequestBiConsumer;
        this.isSecure = replaced.isSecure;
        this.nettyRequest = replaced.nettyRequest;
        this.responseState = replaced.responseState;
        this.followRedirectPredicate = replaced.followRedirectPredicate;
        this.requestHeaders = replaced.requestHeaders;
        this.cookieEncoder = replaced.cookieEncoder;
        this.cookieDecoder = replaced.cookieDecoder;
        this.cookieList = replaced.cookieList;
        this.resourceUrl = replaced.resourceUrl;
        this.path = replaced.path;
        this.responseTimeout = replaced.responseTimeout;
        this.is100Continue = replaced.is100Continue;
        this.trailerHeaders = replaced.trailerHeaders;
    }

    HttpClientOperations(Connection c, ConnectionObserver listener2, ClientCookieEncoder encoder, ClientCookieDecoder decoder, HttpMessageLogFactory httpMessageLogFactory) {
        super(c, listener2, httpMessageLogFactory);
        this.isSecure = c.channel().pipeline().get("reactor.left.sslHandler") != null;
        this.nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        this.requestHeaders = this.nettyRequest.headers();
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.cookieList = new ArrayList<Cookie>();
        this.trailerHeaders = Sinks.unsafe().one();
    }

    @Override
    public HttpClientRequest addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.cookieList.add(cookie);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerLast(ChannelHandler handler) {
        super.addHandlerLast(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerLast(String name, ChannelHandler handler) {
        super.addHandlerLast(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerFirst(ChannelHandler handler) {
        super.addHandlerFirst(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerFirst(String name, ChannelHandler handler) {
        super.addHandlerFirst(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandler(ChannelHandler handler) {
        super.addHandler(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations replaceHandler(String name, ChannelHandler handler) {
        super.replaceHandler(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations removeHandler(String name) {
        super.removeHandler(name);
        return this;
    }

    @Override
    public HttpClientRequest addHeader(CharSequence name, CharSequence value2) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.add(name, (Object)value2);
        return this;
    }

    @Override
    public InetSocketAddress address() {
        return (InetSocketAddress)this.channel().remoteAddress();
    }

    public void chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyRequest) != chunked) {
            this.requestHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.nettyRequest, (boolean)chunked);
        }
    }

    @Override
    public HttpClientOperations withConnection(Consumer<? super Connection> withConnection) {
        Objects.requireNonNull(withConnection, "withConnection");
        withConnection.accept(this);
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        ResponseState responseState = this.responseState;
        if (responseState != null && responseState.cookieHolder != null) {
            return responseState.cookieHolder.getCachedCookies();
        }
        return Collections.emptyMap();
    }

    void followRedirectPredicate(BiPredicate<HttpClientRequest, HttpClientResponse> predicate) {
        this.followRedirectPredicate = predicate;
    }

    void redirectRequestConsumer(@Nullable Consumer<HttpClientRequest> redirectRequestConsumer) {
        this.redirectRequestConsumer = redirectRequestConsumer;
    }

    @Override
    protected void onInboundCancel() {
        if (this.isInboundDisposed()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), INBOUND_CANCEL_LOG));
        }
        this.channel().close();
    }

    @Override
    protected final void onUnprocessedOutboundError(Throwable t) {
        this.unprocessedOutboundError = t;
    }

    @Override
    protected void onInboundClose() {
        if (this.isInboundCancelled() || this.isInboundDisposed()) {
            this.listener().onStateChange(this, ConnectionObserver.State.DISCONNECTING);
            return;
        }
        this.listener().onStateChange(this, HttpClientState.RESPONSE_INCOMPLETE);
        if (this.responseState == null) {
            Exception exception = this.markSentHeaderAndBody(new Object[0]) ? AbortedException.beforeSend() : (this.markSentBody() ? new PrematureCloseException("Connection has been closed BEFORE response, while sending request body") : new PrematureCloseException("Connection prematurely closed BEFORE response"));
            this.listener().onUncaughtException(this, HttpClientOperations.addOutboundErrorCause(exception, this.unprocessedOutboundError));
            return;
        }
        super.onInboundError(HttpClientOperations.addOutboundErrorCause(new PrematureCloseException("Connection prematurely closed DURING response"), this.unprocessedOutboundError));
    }

    @Override
    protected void afterInboundComplete() {
        if (this.redirecting != null) {
            this.listener().onUncaughtException(this, this.redirecting);
        } else {
            this.listener().onStateChange(this, HttpClientState.RESPONSE_COMPLETED);
        }
    }

    @Override
    public HttpClientRequest header(CharSequence name, CharSequence value2) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.set(name, (Object)value2);
        return this;
    }

    @Override
    public HttpClientRequest headers(HttpHeaders headers2) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        String host = this.requestHeaders.get((CharSequence)HttpHeaderNames.HOST);
        this.requestHeaders.set(headers2);
        this.requestHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        return this;
    }

    @Override
    public boolean isFollowRedirect() {
        return this.followRedirectPredicate != null && this.redirectedFrom.length <= 50;
    }

    @Override
    public HttpClientRequest responseTimeout(Duration maxReadOperationInterval) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseTimeout = maxReadOperationInterval;
        return this;
    }

    @Override
    public boolean isKeepAlive() {
        ResponseState rs = this.responseState;
        if (rs != null) {
            return HttpUtil.isKeepAlive((HttpMessage)rs.response);
        }
        return HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        ChannelOperations<?, ?> ops = HttpClientOperations.get(this.channel());
        return ops != null && ops.getClass().equals(WebsocketClientOperations.class);
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    public final HttpClientOperations onDispose(Disposable onDispose) {
        super.onDispose(onDispose);
        return this;
    }

    @Override
    public ContextView currentContextView() {
        return this.currentContext();
    }

    @Override
    public String[] redirectedFrom() {
        Supplier<String>[] redirectedFrom = this.redirectedFrom;
        String[] dest = new String[redirectedFrom.length];
        for (int i = 0; i < redirectedFrom.length; ++i) {
            dest[i] = redirectedFrom[i].get();
        }
        return dest;
    }

    @Override
    public HttpHeaders requestHeaders() {
        return this.nettyRequest.headers();
    }

    @Override
    public HttpHeaders responseHeaders() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return responseState.headers;
        }
        throw new IllegalStateException("Response headers cannot be accessed without server response");
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> source) {
        if (!this.channel().isActive()) {
            return this.then(Mono.error(AbortedException.beforeSend()));
        }
        if (source instanceof Mono) {
            return super.send(source);
        }
        if (Objects.equals(this.method(), HttpMethod.GET) || Objects.equals(this.method(), HttpMethod.HEAD)) {
            ByteBufAllocator alloc = this.channel().alloc();
            return new HttpOperations.PostHeadersNettyOutbound(Flux.from(source).collectList().doOnDiscard(ByteBuf.class, ReferenceCounted::release).flatMap(list2 -> {
                if (this.markSentHeaderAndBody(list2.toArray())) {
                    ByteBuf output;
                    if (list2.isEmpty()) {
                        return FutureMono.from(this.channel().writeAndFlush((Object)this.newFullBodyMessage(Unpooled.EMPTY_BUFFER)));
                    }
                    int i = list2.size();
                    if (i == 1) {
                        output = (ByteBuf)list2.get(0);
                    } else {
                        CompositeByteBuf agg = alloc.compositeBuffer(list2.size());
                        for (ByteBuf component2 : list2) {
                            agg.addComponent(true, component2);
                        }
                        output = agg;
                    }
                    if (output.readableBytes() > 0) {
                        return FutureMono.from(this.channel().writeAndFlush((Object)this.newFullBodyMessage(output)));
                    }
                    output.release();
                    return FutureMono.from(this.channel().writeAndFlush((Object)this.newFullBodyMessage(Unpooled.EMPTY_BUFFER)));
                }
                for (ByteBuf bb : list2) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(this.channel(), "Ignoring accumulated bytebuf on http GET {}"), bb);
                    }
                    bb.release();
                }
                return Mono.empty();
            }), this, null);
        }
        return super.send(source);
    }

    final URI websocketUri() {
        URI uri;
        try {
            String url = this.uri();
            if (url.startsWith("http") || url.startsWith("ws")) {
                uri = new URI(url);
            } else {
                String host = this.requestHeaders().get((CharSequence)HttpHeaderNames.HOST);
                uri = new URI((this.isSecure ? "wss" : "ws") + "://" + host + (url.startsWith("/") ? url : "/" + url));
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    @Override
    public HttpResponseStatus status() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return responseState.response.status();
        }
        throw new IllegalStateException("Trying to access status() while missing response");
    }

    @Override
    public Mono<HttpHeaders> trailerHeaders() {
        return this.trailerHeaders.asMono();
    }

    @Override
    public final String uri() {
        return this.nettyRequest.uri();
    }

    @Override
    public final String fullPath() {
        return this.path;
    }

    @Override
    public String resourceUrl() {
        return this.resourceUrl;
    }

    @Override
    public final HttpVersion version() {
        HttpVersion version = this.nettyRequest.protocolVersion();
        if (version.equals((Object)HttpVersion.HTTP_1_0)) {
            return HttpVersion.HTTP_1_0;
        }
        if (version.equals((Object)HttpVersion.HTTP_1_1)) {
            return HttpVersion.HTTP_1_1;
        }
        throw new IllegalStateException(version.protocolName() + " not supported");
    }

    @Override
    protected void onWritabilityChanged() {
        if (!(this.isSecure || this.channel().isWritable() || this.channel().config().isAutoRead() || !this.hasSentBody() || this.channel() instanceof Http2StreamChannel || this.isWebsocket())) {
            this.channel().read();
        }
    }

    @Override
    protected void afterMarkSentHeaders() {
    }

    @Override
    protected void beforeMarkSentHeaders() {
        if (this.redirectedFrom.length > 0) {
            if (this.redirectRequestConsumer != null) {
                this.redirectRequestConsumer.accept(this);
            }
            if (this.redirectRequestBiConsumer != null && this.previousRequestHeaders != null) {
                this.redirectRequestBiConsumer.accept(this.previousRequestHeaders, this);
                this.previousRequestHeaders = null;
            }
        }
        if (!this.cookieList.isEmpty()) {
            this.requestHeaders.add((CharSequence)HttpHeaderNames.COOKIE, (Object)this.cookieEncoder.encode(this.cookieList));
        }
    }

    @Override
    protected boolean isContentAlwaysEmpty() {
        return false;
    }

    @Override
    protected void onHeadersSent() {
        this.channel().read();
        if (this.channel().parent() != null) {
            this.channel().parent().read();
        }
    }

    @Override
    protected void onOutboundComplete() {
        if (this.isWebsocket() || this.isInboundCancelled()) {
            return;
        }
        if (this.markSentHeaderAndBody(new Object[0])) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "No sendHeaders() called before complete, sending zero-length header"));
            }
            this.channel().writeAndFlush((Object)this.newFullBodyMessage(Unpooled.EMPTY_BUFFER));
        } else if (this.markSentBody()) {
            this.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        this.listener().onStateChange(this, HttpClientState.REQUEST_SENT);
        if (this.responseTimeout != null) {
            if (this.channel().pipeline().get("reactor.left.httpMetricsHandler") != null) {
                if (this.channel().pipeline().get("reactor.left.responseTimeoutHandler") == null) {
                    this.channel().pipeline().addBefore("reactor.left.httpMetricsHandler", "reactor.left.responseTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(this.responseTimeout.toMillis(), TimeUnit.MILLISECONDS));
                    if (this.isPersistent()) {
                        this.onTerminate().subscribe(null, null, () -> this.removeHandler("reactor.left.responseTimeoutHandler"));
                    }
                }
            } else {
                this.addHandlerFirst("reactor.left.responseTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(this.responseTimeout.toMillis(), TimeUnit.MILLISECONDS));
            }
        }
        this.channel().read();
        if (this.channel().parent() != null) {
            this.channel().parent().read();
        }
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.isPersistent() && this.responseState == null) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Outbound error happened"), err);
            }
            this.listener().onUncaughtException(this, err);
            if (this.markSentBody()) {
                this.markPersistent(false);
            }
            this.terminate();
            return;
        }
        super.onOutboundError(err);
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse response2 = (HttpResponse)msg;
            if (response2.decoderResult().isFailure()) {
                this.onInboundError(response2.decoderResult().cause());
                ReferenceCountUtil.release((Object)msg);
                this.terminate();
                return;
            }
            if (HttpResponseStatus.CONTINUE.equals((Object)response2.status())) {
                this.is100Continue = true;
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (this.started) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(this.channel(), "HttpClientOperations cannot proceed more than one response {}"), this.httpMessageLogFactory().debug(HttpMessageArgProviderFactory.create(response2)));
                }
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            this.is100Continue = false;
            this.started = true;
            this.setNettyResponse(response2);
            if (!this.isKeepAlive()) {
                this.markPersistent(false);
            }
            if (this.isInboundCancelled()) {
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Received response (auto-read:{}) : {}"), this.channel().config().isAutoRead(), this.httpMessageLogFactory().debug(HttpMessageArgProviderFactory.create(response2)));
            }
            if (this.notRedirected(response2)) {
                try {
                    this.listener().onStateChange(this, HttpClientState.RESPONSE_RECEIVED);
                }
                catch (Exception e) {
                    this.onInboundError(e);
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
            } else {
                this.channel().config().setAutoRead(true);
            }
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse request = (FullHttpResponse)msg;
                if (request.content().readableBytes() > 0) {
                    super.onInboundNext(ctx, msg);
                } else {
                    request.release();
                }
                this.terminate();
            }
            return;
        }
        if (msg instanceof LastHttpContent) {
            LastHttpContent lastHttpContent = (LastHttpContent)msg;
            if (lastHttpContent.decoderResult().isFailure()) {
                this.onInboundError(lastHttpContent.decoderResult().cause());
                lastHttpContent.release();
                this.terminate();
                return;
            }
            if (this.is100Continue) {
                lastHttpContent.release();
                this.channel().read();
                return;
            }
            if (!this.started) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(this.channel(), "HttpClientOperations received an incorrect end delimiter (previously used connection?)"));
                }
                lastHttpContent.release();
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Received last HTTP packet"));
            }
            if (lastHttpContent != LastHttpContent.EMPTY_LAST_CONTENT) {
                if (this.redirecting != null || lastHttpContent.content().readableBytes() == 0) {
                    lastHttpContent.release();
                } else {
                    super.onInboundNext(ctx, lastHttpContent);
                }
            }
            if (this.redirecting == null) {
                this.trailerHeaders.tryEmitValue(lastHttpContent.trailingHeaders());
            }
            this.channel().config().setAutoRead(true);
            if (this.markSentBody()) {
                this.markPersistent(false);
            }
            this.terminate();
            return;
        }
        if (!this.started) {
            if (log.isDebugEnabled()) {
                if (msg instanceof ByteBufHolder) {
                    msg = ((ByteBufHolder)msg).content();
                }
                log.debug(ReactorNetty.format(this.channel(), "HttpClientOperations received an incorrect chunk {} (previously used connection?)"), msg);
            }
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        if (this.redirecting != null) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        super.onInboundNext(ctx, msg);
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyRequest;
    }

    final boolean notRedirected(HttpResponse response2) {
        if (this.isFollowRedirect() && this.followRedirectPredicate.test(this, this)) {
            try {
                this.redirecting = new RedirectClientException(response2.headers(), response2.status());
            }
            catch (RuntimeException e) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(this.channel(), "The request cannot be redirected"), e);
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Received redirect location: {}"), this.httpMessageLogFactory().debug(HttpMessageArgProviderFactory.create(response2)));
            }
            return false;
        }
        return true;
    }

    @Override
    protected HttpMessage newFullBodyMessage(ByteBuf body2) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(this.version(), this.method(), this.uri(), body2);
        this.requestHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, body2.readableBytes());
        this.requestHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        request.headers().set(this.requestHeaders);
        return request;
    }

    @Override
    protected Throwable wrapInboundError(Throwable err) {
        if (err instanceof ClosedChannelException) {
            return new PrematureCloseException(err);
        }
        return super.wrapInboundError(err);
    }

    final HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    final Mono<Void> send() {
        if (!this.channel().isActive()) {
            return Mono.error(AbortedException.beforeSend());
        }
        return FutureMono.deferFuture(() -> this.markSentHeaderAndBody(new Object[0]) ? this.channel().writeAndFlush((Object)this.newFullBodyMessage(Unpooled.EMPTY_BUFFER)) : this.channel().newSucceededFuture());
    }

    final void setNettyResponse(HttpResponse nettyResponse) {
        ResponseState state = this.responseState;
        if (state == null) {
            this.responseState = new ResponseState(nettyResponse, nettyResponse.headers(), this.cookieDecoder);
        }
    }

    final void withWebsocketSupport(WebsocketClientSpec websocketClientSpec, boolean compress) {
        URI url = this.websocketUri();
        if (this.markSentHeaders(new Object[0])) {
            WebsocketClientOperations ops;
            this.addHandlerFirst("reactor.left.httpAggregator", (ChannelHandler)new HttpObjectAggregator(8192));
            this.removeHandler("reactor.left.httpMetricsHandler");
            if (websocketClientSpec.compress()) {
                this.requestHeaders().remove((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
                this.removeHandler("reactor.left.httpDecompressor");
                PerMessageDeflateClientExtensionHandshaker perMessageDeflateClientExtensionHandshaker = new PerMessageDeflateClientExtensionHandshaker(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, websocketClientSpec.compressionAllowClientNoContext(), websocketClientSpec.compressionRequestedServerNoContext());
                this.addHandlerFirst("reactor.left.wsCompressionHandler", (ChannelHandler)new WebSocketClientExtensionHandler(new WebSocketClientExtensionHandshaker[]{perMessageDeflateClientExtensionHandshaker, new DeflateFrameClientExtensionHandshaker(false), new DeflateFrameClientExtensionHandshaker(true)}));
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Attempting to perform websocket handshake with {}"), url);
            }
            if (!this.rebind(ops = new WebsocketClientOperations(url, websocketClientSpec, this))) {
                log.error(ReactorNetty.format(this.channel(), "Error while rebinding websocket in channel attribute: " + HttpClientOperations.get(this.channel()) + " to " + ops));
            }
        }
    }

    static Throwable addOutboundErrorCause(Throwable exception, @Nullable Throwable cause) {
        if (cause != null) {
            cause.setStackTrace(new StackTraceElement[0]);
            exception.initCause(cause);
        }
        return exception;
    }

    static final class SendForm
    extends Mono<Void> {
        static final HttpDataFactory DEFAULT_FACTORY = new DefaultHttpDataFactory(16384L);
        final HttpClientOperations parent;
        final BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback;
        final Consumer<Flux<Long>> progressCallback;

        SendForm(HttpClientOperations parent, BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback, @Nullable Consumer<Flux<Long>> progressCallback) {
            this.parent = parent;
            this.formCallback = formCallback;
            this.progressCallback = progressCallback;
        }

        @Override
        public void subscribe(CoreSubscriber<? super Void> s) {
            if (!this.parent.markSentHeaders(new Object[0])) {
                Operators.error(s, new IllegalStateException("headers have already been sent"));
                return;
            }
            Subscription subscription = Operators.emptySubscription();
            s.onSubscribe(subscription);
            if (this.parent.channel().eventLoop().inEventLoop()) {
                this._subscribe(s);
            } else {
                this.parent.channel().eventLoop().execute(() -> this._subscribe(s));
            }
        }

        void _subscribe(CoreSubscriber<? super Void> s) {
            HttpDataFactory df = DEFAULT_FACTORY;
            try {
                HttpClientFormEncoder encoder = new HttpClientFormEncoder(df, this.parent.nettyRequest, false, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder.EncoderMode.RFC1738);
                this.formCallback.accept(this.parent, encoder);
                encoder = encoder.applyChanges(this.parent.nettyRequest);
                df = encoder.newFactory;
                if (!encoder.isMultipart()) {
                    this.parent.requestHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                }
                this.parent.addHandlerFirst("reactor.left.chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                boolean chunked = HttpUtil.isTransferEncodingChunked((HttpMessage)this.parent.nettyRequest);
                HttpRequest r = encoder.finalizeRequest();
                if (!chunked) {
                    HttpUtil.setTransferEncodingChunked((HttpMessage)r, (boolean)false);
                    HttpUtil.setContentLength((HttpMessage)r, (long)encoder.length());
                }
                ChannelFuture f = this.parent.channel().writeAndFlush((Object)r);
                if (encoder.isChunked()) {
                    Flux<Long> tail = encoder.progressSink.asFlux().onBackpressureLatest();
                    if (encoder.cleanOnTerminate) {
                        tail = tail.doOnCancel(encoder).doAfterTerminate(encoder);
                    }
                    if (this.progressCallback != null) {
                        this.progressCallback.accept(tail);
                    } else {
                        tail.subscribe();
                    }
                    this.parent.channel().writeAndFlush((Object)encoder);
                } else {
                    Mono<Void> mono = FutureMono.from(f);
                    if (encoder.cleanOnTerminate) {
                        mono = mono.doOnCancel(encoder).doAfterTerminate(encoder);
                    }
                    if (this.progressCallback != null) {
                        this.progressCallback.accept(mono.cast(Long.class).switchIfEmpty(Mono.just(encoder.length())).flux());
                    } else {
                        mono.subscribe();
                    }
                }
                s.onComplete();
            }
            catch (Throwable e) {
                Exceptions.throwIfJvmFatal(e);
                df.cleanRequestHttpData(this.parent.nettyRequest);
                s.onError(Exceptions.unwrap(e));
            }
        }
    }

    static final class ResponseState {
        final HttpResponse response;
        final HttpHeaders headers;
        final Cookies cookieHolder;

        ResponseState(HttpResponse response2, HttpHeaders headers2, ClientCookieDecoder decoder) {
            this.response = response2;
            this.headers = headers2;
            this.cookieHolder = Cookies.newClientResponseHolder(headers2, decoder);
        }
    }
}

