/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;

public final class InvalidBufferOffsetException
extends InteropException {
    private static final long serialVersionUID = 1857745390734085837L;
    private final long byteOffset;
    private final long length;

    private InvalidBufferOffsetException(long byteOffset, long length2) {
        super((String)null);
        this.byteOffset = byteOffset;
        this.length = length2;
    }

    private InvalidBufferOffsetException(long byteOffset, long length2, Throwable cause) {
        super(null, cause);
        this.byteOffset = byteOffset;
        this.length = length2;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getMessage() {
        return "Invalid buffer access of length " + this.length + " at byteOffset " + this.byteOffset + ".";
    }

    public static InvalidBufferOffsetException create(long byteOffset, long length2) {
        return new InvalidBufferOffsetException(byteOffset, length2);
    }

    public static InvalidBufferOffsetException create(long byteOffset, long length2, Throwable cause) {
        return new InvalidBufferOffsetException(byteOffset, length2, cause);
    }
}

