/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.path.ArrayPathToken;
import com.jayway.jsonpath.internal.path.ArraySliceOperation;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArraySliceToken
extends ArrayPathToken {
    private static final Logger logger = LoggerFactory.getLogger(ArraySliceToken.class);
    private final ArraySliceOperation operation;

    ArraySliceToken(ArraySliceOperation operation) {
        this.operation = operation;
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (!this.checkArrayModel(currentPath, model, ctx)) {
            return;
        }
        switch (this.operation.operation()) {
            case SLICE_FROM: {
                this.sliceFrom(currentPath, parent, model, ctx);
                break;
            }
            case SLICE_BETWEEN: {
                this.sliceBetween(currentPath, parent, model, ctx);
                break;
            }
            case SLICE_TO: {
                this.sliceTo(currentPath, parent, model, ctx);
            }
        }
    }

    private void sliceFrom(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        int length2 = ctx.jsonProvider().length(model);
        int from2 = this.operation.from();
        if (from2 < 0) {
            from2 = length2 + from2;
        }
        from2 = Math.max(0, from2);
        logger.debug("Slice from index on array with length: {}. From index: {} to: {}. Input: {}", new Object[]{length2, from2, length2 - 1, this.toString()});
        if (length2 == 0 || from2 >= length2) {
            return;
        }
        for (int i = from2; i < length2; ++i) {
            this.handleArrayIndex(i, currentPath, model, ctx);
        }
    }

    private void sliceBetween(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        int length2 = ctx.jsonProvider().length(model);
        int from2 = this.operation.from();
        int to = this.operation.to();
        if (from2 >= (to = Math.min(length2, to)) || length2 == 0) {
            return;
        }
        logger.debug("Slice between indexes on array with length: {}. From index: {} to: {}. Input: {}", new Object[]{length2, from2, to, this.toString()});
        for (int i = from2; i < to; ++i) {
            this.handleArrayIndex(i, currentPath, model, ctx);
        }
    }

    private void sliceTo(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        int length2 = ctx.jsonProvider().length(model);
        if (length2 == 0) {
            return;
        }
        int to = this.operation.to();
        if (to < 0) {
            to = length2 + to;
        }
        to = Math.min(length2, to);
        logger.debug("Slice to index on array with length: {}. From index: 0 to: {}. Input: {}", new Object[]{length2, to, this.toString()});
        for (int i = 0; i < to; ++i) {
            this.handleArrayIndex(i, currentPath, model, ctx);
        }
    }

    @Override
    public String getPathFragment() {
        return this.operation.toString();
    }

    @Override
    public boolean isTokenDefinite() {
        return false;
    }
}

