/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.psi.codeStyle.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.components.fields.IntegerField;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/http/request/psi/codeStyle/settings/HttpRequestLanguageCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "<init>", "()V", "getLanguage", "Lcom/intellij/lang/Language;", "getApplicableLanguages", "", "customizeSettings", "", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "customizeDefaults", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "indentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "getCodeSample", "", "intellij.restClient"})
public final class HttpRequestLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        HttpRequestLanguage httpRequestLanguage = HttpRequestLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)httpRequestLanguage), (String)"INSTANCE");
        return httpRequestLanguage;
    }

    @NotNull
    public List<Language> getApplicableLanguages() {
        return CollectionsKt.emptyList();
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{"INDENT_SIZE", "CONTINUATION_INDENT_SIZE"};
                consumer.showStandardOptions(stringArray);
                break;
            }
            case 2: {
                String[] stringArray = new String[]{"CALL_PARAMETERS_WRAP", "METHOD_PARAMETERS_WRAP"};
                consumer.showStandardOptions(stringArray);
                consumer.renameStandardOption("CALL_PARAMETERS_WRAP", RestClientBundle.message("http.client.code.style.settings.call.parameters.wrap.label", new Object[0]));
                consumer.renameStandardOption("METHOD_PARAMETERS_WRAP", RestClientBundle.message("http.client.code.style.settings.method.parameters.wrap.label", new Object[0]));
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_BEFORE_COMMA"};
                consumer.showStandardOptions(stringArray);
                consumer.moveStandardOption("SPACE_AROUND_ASSIGNMENT_OPERATORS", RestClientBundle.message("http.client.code.style.settings.form.urlencoded.group.label", new Object[0]));
                consumer.moveStandardOption("SPACE_BEFORE_COMMA", RestClientBundle.message("http.client.code.style.settings.form.urlencoded.group.label", new Object[0]));
                consumer.renameStandardOption("SPACE_AROUND_ASSIGNMENT_OPERATORS", RestClientBundle.message("http.client.code.style.settings.spaces.around.equals.label", new Object[0]));
                consumer.renameStandardOption("SPACE_BEFORE_COMMA", RestClientBundle.message("http.client.code.style.settings.space.before.and.label", new Object[0]));
            }
        }
    }

    @NotNull
    public IndentOptionsEditor getIndentOptionsEditor() {
        return new IndentOptionsEditor(this){
            private IntegerField contIndentField;
            private JLabel contIndentLabel;

            protected void addComponents() {
                super.addComponents();
                this.addContIndentField();
            }

            private final void addContIndentField() {
                String string = RestClientBundle.message("http.client.code.style.settings.continuation.indent.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String labelText = string;
                IntegerField field = this.createIndentTextField(labelText, 1, 10, 4);
                boolean bl = false;
                JLabel label = new JLabel(labelText);
                boolean bl2 = false;
                this.add(label, (JComponent)field);
                this.contIndentLabel = label;
                this.contIndentField = field;
            }

            public void showStandardOptions(String ... optionNames) {
                Intrinsics.checkNotNullParameter((Object)optionNames, (String)"optionNames");
                super.showStandardOptions(Arrays.copyOf(optionNames, optionNames.length));
                for (String optionName : optionNames) {
                    if (!Intrinsics.areEqual((Object)"CONTINUATION_INDENT_SIZE", (Object)optionName)) continue;
                    IntegerField integerField = this.contIndentField;
                    if (integerField != null) {
                        integerField.setVisible(true);
                    }
                    JLabel jLabel = this.contIndentLabel;
                    if (jLabel == null) continue;
                    jLabel.setVisible(true);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                if (super.isModified(settings, options)) return true;
                IntegerField integerField = this.contIndentField;
                if (integerField == null) return false;
                IntegerField field = integerField;
                boolean bl = false;
                if (!IndentOptionsEditor.isFieldModified((JTextField)((JTextField)field), (int)options.CONTINUATION_INDENT_SIZE)) return false;
                return true;
            }

            public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                    super.apply(settings, options);
                    IntegerField integerField = this.contIndentField;
                    if (integerField == null) break block0;
                    IntegerField it = integerField;
                    boolean bl = false;
                    options.CONTINUATION_INDENT_SIZE = it.getValue();
                }
            }

            public void reset(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                    Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                    super.reset(settings, options);
                    IntegerField integerField = this.contIndentField;
                    if (integerField == null) break block0;
                    IntegerField it = integerField;
                    boolean bl = false;
                    it.setValue(Integer.valueOf(options.CONTINUATION_INDENT_SIZE));
                }
            }
        };
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)commonSettings, (String)"commonSettings");
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        indentOptions.INDENT_SIZE = 0;
        commonSettings.CALL_PARAMETERS_WRAP = 1;
        commonSettings.METHOD_PARAMETERS_WRAP = 2;
        commonSettings.SPACE_BEFORE_COMMA = true;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        return switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 2 -> "GET https://localhost:8080/my-url-path?param1=value1&param2=value2&p3=v3\n\n###\nGET https://{{var}}/u?p=v&q=1\n\n###\nPOST https://localhost:8080/form\nContent-Type: application/x-www-form-urlencoded\n\nparam1=value1&param2=value2&param3=value3";
            case 3 -> "###\nPOST https://localhost:8080/form\nContent-Type: application/x-www-form-urlencoded\n\nparam1=value1&param2=value2&param3=value3";
            default -> "GET https://localhost:8080/\n    my-url-path?param1=value1&param2=value2\nContent-type: application/json\nAccept: application/json\n\n{\n  \"my-json-field\": \"my-json-value\"\n}\n\n> {%\n  if (response.status === 200) {\n    client.log(\"Success\")\n  }\n  else {\n    client.log(\"Other\")\n  }\n%}";
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageCodeStyleSettingsProvider.SettingsType.values().length];
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

