/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasHideableObject;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasScopeAware;
import com.intellij.database.model.DasScopeProcessor;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasPredefinedSymbol;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.PsiColumnWithSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasCollectionType;
import com.intellij.database.types.DasColumniationType;
import com.intellij.database.types.DasDataBuiltinType;
import com.intellij.database.types.DasDefinedType;
import com.intellij.database.types.DasMapType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeFacade;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.Version;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDataSourceMappings;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlAnnotator;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCodeBlockElement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlImplicitDeclarationsProvider;
import com.intellij.sql.psi.SqlImplicitSymbol;
import com.intellij.sql.psi.SqlImplicitTarget;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlScopingExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeCastExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlAsteriskSymbol;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasDefinitionImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlDeclareStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlValuesParameterInfoUtils;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.psi.stubs.SqlLazyParseablePsiElement;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.symbols.DasInlineSymbol;
import com.intellij.sql.symbols.DasPsiWrappingSymbol;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.text.TextRangeUtil;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlImplUtil {
    public static final Function<StubElement, PsiElement> STUB_TO_PSI = element -> element.getPsi();
    public static final Function<SqlNameElement, String> IDENT_TO_NAME = element -> element.getName();
    public static final DasTable NO_TABLE = new EmptyTable();
    public static final String NULL_STRING = DasUtil.NO_NAME;
    public static final DasSymbol ANY_SYMBOL = new DasPredefinedSymbol(){

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = Dbms.UNKNOWN;
            if (dbms == null) {
                1.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.ANY;
            if (objectKind == null) {
                1.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            return "";
        }

        @Override
        public boolean isQuoted() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final Key<PsiElement> CURRENT_QUALIFIER = Key.create((String)"CURRENT_QUALIFIER");
    private static final Key<PsiElement> IMMEDIATE_QUALIFIER = Key.create((String)"IMMEDIATE_QUALIFIER");
    private static final Key<PsiElement> IMMEDIATE_TARGET = Key.create((String)"IMMEDIATE_TARGET");
    private static final Key<SqlQueryExpression> LAST_QUERY_EXPRESSION = Key.create((String)"LAST_QUERY_EXPRESSION");
    private static final int ITEM_TEXT_LENGTH = 50;
    private static final Pattern SPACES = Pattern.compile("\\s+");

    private SqlImplUtil() {
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlReferenceList list) {
        List list2 = list == null ? Collections.emptyList() : list.getReferenceList();
        if (list2 == null) {
            SqlImplUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlTableColumnsList list) {
        return list == null ? Collections.emptyList() : SqlImplUtil.getReferenceList(list.getColumnsReferenceList());
    }

    public static Collection<PsiElement> getReferencedElements(@NotNull SqlDefinition o) {
        SqlNameElement nameElement;
        PsiReference reference;
        SqlFileImpl.GroupImpl mirror;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(1);
        }
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        Couple<SqlFileImpl.GroupImpl> mirrorPair = SqlImplUtil.getMirror(o);
        SqlFileImpl.GroupImpl groupImpl = mirrorPair.second != null ? (SqlFileImpl.GroupImpl)mirrorPair.second : (mirror = o.getKind() == SqlDbElementType.BODY ? (SqlFileImpl.GroupImpl)mirrorPair.first : null);
        if (mirror != null) {
            mirror.delegates().addAllTo(result2);
        }
        PsiReference psiReference = reference = (nameElement = o.getNameElement()) != null && nameElement.getTextLength() > 0 ? nameElement.findReferenceAt(nameElement.getTextLength() - 1) : null;
        if (reference != null) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results2;
                for (ResolveResult resolveResult : results2 = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element = resolveResult.getElement();
                    result2.add(element);
                }
            } else {
                PsiElement element = reference.resolve();
                result2.add(element);
            }
        }
        return result2;
    }

    @NotNull
    public static Couple<SqlFileImpl.GroupImpl> getMirror(@NotNull SqlDefinition o) {
        PsiFile file;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(2);
        }
        if ((file = o.getContainingFile()) instanceof SqlFileImpl) {
            Couple<SqlFileImpl.GroupImpl> couple = ((SqlFileImpl)file).getMirror(o);
            if (couple == null) {
                SqlImplUtil.$$$reportNull$$$0(3);
            }
            return couple;
        }
        Couple couple = Couple.getEmpty();
        if (couple == null) {
            SqlImplUtil.$$$reportNull$$$0(4);
        }
        return couple;
    }

    @NotNull
    private static <T> ResolveState getModifiedState(@NotNull ResolveState state, Key<T> key2, T value) {
        Object qual;
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(5);
        }
        if ((qual = state.get(key2)) != null || value == null) {
            ResolveState resolveState = state;
            if (resolveState == null) {
                SqlImplUtil.$$$reportNull$$$0(6);
            }
            return resolveState;
        }
        ResolveState resolveState = state.put(key2, value);
        if (resolveState == null) {
            SqlImplUtil.$$$reportNull$$$0(7);
        }
        return resolveState;
    }

    @NotNull
    public static ResolveState setQualifier(@NotNull ResolveState state, @Nullable PsiElement qualifier) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(8);
        }
        return SqlImplUtil.getModifiedState(state, CURRENT_QUALIFIER, qualifier);
    }

    @NotNull
    public static ResolveState setImmediateQualifier(@NotNull ResolveState state, @Nullable PsiElement qualifier) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(9);
        }
        return SqlImplUtil.getModifiedState(state, IMMEDIATE_QUALIFIER, qualifier);
    }

    @NotNull
    public static ResolveState setImmediateTarget(@NotNull ResolveState state, @Nullable PsiElement immediateTarget) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(10);
        }
        return SqlImplUtil.getModifiedState(state, IMMEDIATE_TARGET, immediateTarget);
    }

    public static boolean processQualifier(SqlReferenceExpression reference, SqlScopeProcessor processor2, ResolveState resolveState, PsiElement place) {
        Set<ObjectKind> expectedTypes;
        boolean found;
        if (reference == null) {
            return true;
        }
        ObjectKind kind = reference.getReferenceElementType().getTargetKind();
        if (kind != SqlDbElementType.ANY ? !SqlImplUtil.isProcessingChildOf(processor2, kind) : !(found = (expectedTypes = ((SqlReferenceImpl)reference.getReference()).getExpectedTypes(true)).stream().anyMatch(expected -> SqlImplUtil.isProcessingChildOf(processor2, expected)))) {
            return true;
        }
        if (PsiTreeUtil.isContextAncestor((PsiElement)reference, (PsiElement)place, (boolean)false)) {
            return true;
        }
        try {
            return SqlImplUtil.processQualifierImpl(reference, processor2, resolveState, place);
        }
        catch (StackOverflowError e) {
            PsiElement placeParent = place.getParent();
            PsiElement referenceParent = reference.getParent();
            Logger.getInstance(SqlImplUtil.class).error("SOE while processing qualifier", (Throwable)e, new Attachment[]{new Attachment("place parent", SqlImplUtil.getInfo(placeParent) + "\n" + SqlImplUtil.getInfo(placeParent == null ? null : placeParent.getParent())), new Attachment("reference parent", SqlImplUtil.getInfo(referenceParent) + "\n" + SqlImplUtil.getInfo(referenceParent == null ? null : referenceParent.getParent()))});
            return true;
        }
    }

    @NotNull
    private static String getInfo(PsiElement placeParent) {
        Object object = placeParent == null ? "" : placeParent.getText() + "\n" + PsiUtilCore.getElementType((PsiElement)placeParent);
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(11);
        }
        return object;
    }

    static boolean processQualifierImpl(@NotNull SqlReferenceExpression reference, SqlScopeProcessor processor2, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            SqlImplUtil.$$$reportNull$$$0(12);
        }
        ResolveResult[] results2 = reference.multiResolve(false);
        PsiElement immediateQualifier = reference.getReference().resolveImmediate();
        ResolveState immediateQualifiedState = SqlImplUtil.setImmediateQualifier(resolveState, immediateQualifier);
        if (!SqlImplUtil.processDeclarationsInType((SqlExpression)reference, processor2, immediateQualifiedState, place)) {
            return false;
        }
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(processor2);
        Project project = reference.getProject();
        for (ResolveResult result2 : results2) {
            DbNamespace schemaElement;
            DasObject qualifierObject;
            DasSymbol qualifierSymbol = DasSymbolUtil.getSymbol(result2);
            PsiElement qualifierPsi = DasSymbolUtil.getSinglePsiSource(qualifierSymbol);
            DasObject dasObject = qualifierObject = qualifierSymbol != null ? qualifierSymbol.getDasObject() : null;
            if (qualifierPsi == null) {
                if (qualifierObject == null) continue;
                for (DasObject child : qualifierObject.getDasChildren(null)) {
                    if (processor2.execute(DasSymbolUtil.wrapObjectToSymbol(child, project), resolveState)) continue;
                    return false;
                }
                continue;
            }
            ResolveState qualifiedState = SqlImplUtil.setQualifier(resolveState, qualifierPsi);
            processor2.setResolveContext(qualifierPsi);
            if (!qualifierSymbol.isValid()) continue;
            if (qualifierObject instanceof DasSynonym) {
                qualifierSymbol = DasSymbolUtil.wrapObjectToSymbol(qualifierObject = DasUtil.resolveFinalTarget((DasSynonym)qualifierObject), project);
                if (qualifierSymbol == null || !qualifierSymbol.isValid()) continue;
                qualifierPsi = DasSymbolUtil.getSinglePsiSource(qualifierSymbol);
            }
            if (qualifierSymbol instanceof DasScopeAware && !((DasScopeAware)((Object)qualifierSymbol)).processDeclarations((DasScopeProcessor)processor2, qualifiedState, null, place)) {
                return false;
            }
            if (qualifierObject instanceof DasTable) {
                if (!SqlImplUtil.processAlterStatements(processor2, qualifiedState, place, qualifierObject)) {
                    return false;
                }
                PsiFile qualFile = qualifierPsi != null ? qualifierPsi.getContainingFile() : null;
                PsiFile placeFile = place.getContainingFile();
                if (!SqlImplUtil.processOnTableCreateStatements(processor2, qualifiedState, qualifierPsi, qualFile)) {
                    return false;
                }
                if (qualFile != null && qualFile != placeFile && !SqlImplUtil.processOnTableCreateStatements(processor2, qualifiedState, qualifierPsi, placeFile)) {
                    return false;
                }
            }
            if ((schemaElement = (DbNamespace)ObjectUtils.tryCast((Object)qualifierObject, DbNamespace.class)) == null || schemaElement.getKind() != SqlDbElementType.SCHEMA || !majorChildExpected || SqlImplUtil.processSchemaMajorChildren(processor2, schemaElement.createDeclarationProcessor((DasScopeProcessor)processor2, qualifiedState, null, place), schemaElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMajorChildExpected(@Nullable SqlScopeProcessor processor2) {
        if (processor2 == null) {
            return false;
        }
        Set expectedTypes = processor2.getExpectedTypes();
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        for (ObjectKind type : expectedTypes) {
            if (!processor2.getDialect().isMajorChild(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean processOnTableCreateStatements(SqlScopeProcessor processor2, ResolveState resolveState, PsiElement qualifier, PsiFile containingFile) {
        PsiFile psiFile = containingFile = containingFile == null ? null : containingFile.getOriginalFile();
        if (containingFile instanceof SqlFile) {
            for (SqlElement statement2 : ((SqlFile)containingFile).getDdl()) {
                SqlReferenceExpression ref2;
                if (!(statement2 instanceof SqlTargetContextProvider) || !(statement2 instanceof SqlDefinition) || (ref2 = ((SqlTargetContextProvider)statement2).getTargetContextExpression()) == null || !ref2.getReference().isReferenceTo(qualifier) || processor2.execute((DasSymbol)((SqlDefinition)statement2), resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processAlterStatements(SqlScopeProcessor processor2, ResolveState resolveState, PsiElement place, DasObject qualifier) {
        return SqlImplUtil.processAlterStatements(place.getContainingFile(), place, qualifier, (Processor<? super SqlAlterInstruction>)((Processor)instruction -> instruction.processDeclarations(processor2, resolveState, null, place)));
    }

    public static boolean processAlterStatements(PsiFile file, PsiElement place, DasObject qualifierTarget, Processor<? super SqlAlterInstruction> processor2) {
        if (!(file instanceof SqlFile)) {
            return true;
        }
        SqlFile original = (SqlFile)ObjectUtils.tryCast((Object)file.getOriginalFile(), SqlFile.class);
        if (original == null) {
            return true;
        }
        NameChecker checker = new NameChecker(qualifierTarget, original.getSqlLanguage());
        for (SqlElement ddl : original.getDdl()) {
            SqlReferenceExpression target2;
            SqlAlterStatement statement2 = (SqlAlterStatement)ObjectUtils.tryCast((Object)ddl, SqlAlterStatement.class);
            if (statement2 == null || place != null && PsiTreeUtil.isContextAncestor((PsiElement)statement2, (PsiElement)place, (boolean)false) || (target2 = statement2.getAlterTargetReference()) == null || !checker.checkName((DasNamed)target2, null) || !(qualifierTarget instanceof PsiElement) || !target2.getReference().isReferenceTo((PsiElement)qualifierTarget) || ContainerUtil.process((Object[])statement2.getAlterInstructions(), processor2)) continue;
            return false;
        }
        return true;
    }

    public static boolean processPositionalDeclarationInType(SqlTableType tableType2, SqlScopeProcessor processor2, ResolveState state, SqlPositionalReference place) {
        int position = place.getPosition();
        if (position < 1 || position > tableType2.getColumnCount()) {
            return false;
        }
        PsiElement columnImmediateSource = tableType2.getImmediateSourceColumnElement(position - 1);
        DasSymbol columnSourceSymbol = DasSymbolUtil.getSymbolByPsi(columnImmediateSource);
        if (columnSourceSymbol != null) {
            processor2.execute(columnSourceSymbol, SqlImplUtil.setImmediateTarget(state, columnImmediateSource));
        }
        return false;
    }

    public static boolean processDeclarationsInType(SqlExpression expression, SqlScopeProcessor processor2, ResolveState state, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor2, SqlDbElementType.COLUMN, SqlDbElementType.TABLE, SqlDbElementType.ROUTINE, SqlDbElementType.METHOD)) {
            return true;
        }
        DasType t = DasTypeUtilsKt.unwrap(expression.getDasType());
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)t, SqlTableType.class);
        return type == null || SqlImplUtil.processDeclarationsInType(type, processor2, state, place);
    }

    private static void processUnresolvedSymbol(SqlScopeProcessor processor2, ResolveState state, PsiElement place) {
        SqlReference reference = ((SqlReferenceExpression)place).getReference();
        DasSymbol unresolvedSymbol = DasSymbolUtil.getInlineSymbol(reference, true);
        processor2.execute(unresolvedSymbol, state);
    }

    public static boolean processDeclarationsInType(SqlTableType tableType2, SqlScopeProcessor processor2, ResolveState state, PsiElement place) {
        if (tableType2 instanceof SqlTableTypeBase.UnresolvedRefType && place instanceof SqlReferenceExpression && SqlImplUtil.isProcessingOneOf(processor2, SqlDbElementType.COLUMN, SqlDbElementType.OBJECT_ATTRIBUTE)) {
            ResolveState qualifiedState = SqlImplUtil.setQualifier(state, tableType2.getTypeElement());
            SqlImplUtil.processUnresolvedSymbol(processor2, qualifiedState, place);
            return true;
        }
        Project project = place.getProject();
        if (SqlImplUtil.isProcessingOneOf(processor2, SqlDbElementType.ROUTINE, SqlDbElementType.METHOD)) {
            ResolveState qualifiedState = SqlImplUtil.setQualifier(state, tableType2.getTypeElement());
            for (DasObject m : tableType2.getMethods()) {
                if (processor2.execute(DasSymbolUtil.wrapObjectToSymbol(m, project), qualifiedState)) continue;
                return false;
            }
        }
        if (!SqlImplUtil.isProcessingOneOf(processor2, SqlDbElementType.COLUMN, SqlDbElementType.TABLE, SqlDbElementType.OBJECT_ATTRIBUTE)) {
            return true;
        }
        if (SqlImplUtil.isAsteriskRef(place)) {
            SqlReferenceExpression asteriskRef = (SqlReferenceExpression)place;
            PsiElement immediateTypeElement = tableType2.getImmediateTypeElement();
            PsiElement context = immediateTypeElement != null ? immediateTypeElement : place;
            SqlAsteriskSymbol target2 = new SqlAsteriskSymbol(context, tableType2);
            return processor2.execute(DasSymbolUtil.getInlineSymbol(asteriskRef.getReference()), SqlImplUtil.setImmediateTarget(state, (PsiElement)target2));
        }
        if (place instanceof SqlPositionalReference) {
            return SqlImplUtil.processPositionalDeclarationInType(tableType2, processor2, state, (SqlPositionalReference)place);
        }
        int columnCount = tableType2.getColumnCount();
        PsiElement prevQualifier = null;
        for (int i2 = 0; i2 < columnCount; ++i2) {
            DasSymbol qualifierSymbol;
            ResolveResult[] results2;
            SqlParenthesizedExpression parenthesized;
            ResolveResult[] deparenthesized;
            PsiElement source;
            PsiElement columnQualifier = tableType2.getColumnQualifier(i2);
            PsiElement immediateSource = tableType2.getImmediateSourceColumnElement(i2);
            ResolveState qualifiedState = SqlImplUtil.setImmediateTarget(SqlImplUtil.setQualifier(state, columnQualifier), immediateSource);
            processor2.setResolveContext(columnQualifier);
            PsiElement element = tableType2.getColumnElement(i2);
            PsiElement sourceElement = tableType2.getSourceColumnElement(i2);
            PsiElement psiElement = source = element instanceof SqlDefinition || sourceElement == null ? element : sourceElement;
            if (source instanceof SqlParenthesizedExpression && (deparenthesized = UtilsKt.deparenthesize((SqlExpression)(parenthesized = (SqlParenthesizedExpression)source))) != null) {
                source = deparenthesized;
            }
            ResolveResult[] resolveResultArray = results2 = source instanceof SqlReferenceExpression ? ((SqlReferenceExpression)source).multiResolve(false) : ResolveResult.EMPTY_ARRAY;
            if (results2.length > 0) {
                deparenthesized = results2;
                int n = deparenthesized.length;
                for (int j = 0; j < n; ++j) {
                    ResolveResult result2 = deparenthesized[j];
                    DasSymbol target3 = DasSymbolUtil.getSymbol(result2);
                    if (target3 == null || processor2.execute(target3, qualifiedState)) continue;
                    return false;
                }
            } else {
                DasSymbol sourceSymbol = DasSymbolUtil.getSymbolByPsi(source);
                if (sourceSymbol != null && !processor2.execute(sourceSymbol, qualifiedState)) {
                    return false;
                }
            }
            if (columnQualifier == null || columnQualifier == prevQualifier) continue;
            prevQualifier = columnQualifier;
            if ((processor2 instanceof SqlCompletionScopeProcessor && !SqlImplUtil.hasAcceptedCompletionSuggestions(processor2) || !SqlImplUtil.isQualifiedContext(place)) && (qualifierSymbol = DasSymbolUtil.getSymbolByPsi(columnQualifier)) != null) {
                processor2.execute(qualifierSymbol, state);
            }
            if (SqlImplUtil.hasAcceptedCompletionSuggestions(processor2) || !(columnQualifier instanceof DasTable) || SqlImplUtil.processAlterStatements(processor2, state, place, (DasObject)columnQualifier)) continue;
            return false;
        }
        return SqlImplUtil.getSqlDialectSafe(place).processTypeExtra(tableType2, processor2, state, place);
    }

    private static boolean isQualifiedContext(@Nullable PsiElement place) {
        return place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getQualifierExpression() != null;
    }

    private static boolean hasAcceptedCompletionSuggestions(@Nullable SqlScopeProcessor processor2) {
        return processor2 instanceof SqlCompletionScopeProcessor && ((SqlCompletionScopeProcessor)processor2).hasAcceptedCompletionVariants();
    }

    @Nullable
    public static PsiElement sqlParent(@Nullable PsiElement e) {
        PsiElement tmp;
        PsiElement psiElement = tmp = e == null ? null : SqlImplUtil.getStubOrPsiParent(e);
        while (tmp != null) {
            if (PsiUtilCore.getElementType((PsiElement)tmp) != SqlElementTypes.SQL_DUMMY_BLOCK) {
                return tmp;
            }
            tmp = SqlImplUtil.getStubOrPsiParent(tmp);
        }
        return null;
    }

    @NotNull
    public static CasingProvider getCasingProvider(@NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<? extends DbDataSource> dataSources) {
        DbDataSource dataSource;
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(13);
        }
        if (dataSources == null) {
            SqlImplUtil.$$$reportNull$$$0(14);
        }
        DasModel model = (dataSource = (DbDataSource)Iterables.getFirst(dataSources, null)) == null ? DasUtil.emptyModel() : dataSource.getModel();
        CasingProvider casingProvider = model == DasUtil.emptyModel() ? dialect : model;
        if (casingProvider == null) {
            SqlImplUtil.$$$reportNull$$$0(15);
        }
        return casingProvider;
    }

    @NotNull
    public static List<DbDataSource> getDataSources(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(16);
        }
        PsiFile file = element.getContainingFile();
        List<DbDataSource> list = SqlDataSourceMappings.getInstance(file.getProject()).getDataSources(file).stream().toList();
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    public static int getParentTypes(@NotNull SqlLanguageDialect dialect, ObjectKind type, int minLevel, int maxLevel, @NotNull Set<ObjectKind> ignored, Set<? super ObjectKind> result2) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(18);
        }
        if (ignored == null) {
            SqlImplUtil.$$$reportNull$$$0(19);
        }
        if (maxLevel > 0 && minLevel > maxLevel) {
            throw new IllegalArgumentException();
        }
        if (minLevel <= 0) {
            result2.add(type);
        }
        if (maxLevel == 0) {
            return 0;
        }
        LinkedList queue = new LinkedList();
        dialect.getParentDbTypes(queue, type);
        queue.removeAll(ignored);
        int curLevel = 0;
        int curSize = queue.size();
        LinkedHashSet<ObjectKind> levelSet = new LinkedHashSet<ObjectKind>();
        while (!queue.isEmpty()) {
            ObjectKind cur = (ObjectKind)queue.removeFirst();
            boolean isAdded = levelSet.add(cur);
            if (--curSize == 0) {
                if (minLevel <= ++curLevel && (maxLevel < 0 || curLevel <= maxLevel) && !result2.addAll(levelSet)) break;
                levelSet.clear();
            }
            if (maxLevel > -1 && curLevel == maxLevel) break;
            if (isAdded) {
                dialect.getParentDbTypes(queue, cur);
            }
            if (curSize != 0) continue;
            curSize = queue.size();
        }
        return curLevel;
    }

    @NotNull
    public static SqlTableType createType(final String name2, final @NotNull List<? extends Column> result2, final @Nullable PsiElement qualifier, String vagueArg) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(20);
        }
        final DataType dataType = DataTypeFactory.ofArgs(null, "table", vagueArg, false);
        return result2.isEmpty() ? SqlTableTypeBase.EMPTY_TABLE : new SqlTableTypeBase(){

            @NotNull
            public DataType toDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            @NotNull
            public List<DasObject> getMethods() {
                List<DasObject> list = Collections.emptyList();
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            @Nullable
            public String getTypeName() {
                return name2;
            }

            public int getColumnCount() {
                return result2.size();
            }

            public String getColumnName(int i2) {
                return ((Column)result2.get((int)i2)).name;
            }

            public boolean isColumnQuoted(int i2) {
                Column column2 = (Column)result2.get(i2);
                Boolean quoted = 2.isQuoted(column2.element);
                return quoted == null ? Boolean.TRUE.equals(2.isQuoted(column2.sourceElement)) : quoted.booleanValue();
            }

            public DasType getColumnDasType(int i2) {
                return ((Column)result2.get((int)i2)).dasType;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                PsiElement psiElement = ((Column)result2.get((int)i2)).element;
                if (psiElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return ((Column)result2.get((int)i2)).sourceElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toDataType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethods";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public static SqlTableType createType(@NotNull List<? extends Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(21);
        }
        return SqlImplUtil.createType(null, result2, qualifier);
    }

    @NotNull
    public static SqlTableType createType(String name2, @NotNull List<? extends Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(22);
        }
        return SqlImplUtil.createType(name2, " ", result2, qualifier);
    }

    @NotNull
    public static SqlTableType createType(String name2, String typeSeparator, @NotNull List<? extends Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(23);
        }
        StringBuilder args2 = new StringBuilder();
        for (Column column2 : result2) {
            if (args2.length() != 0) {
                args2.append(",");
            }
            if (column2.name != null) {
                args2.append(column2.name).append(typeSeparator);
            }
            args2.append(column2.dasType.getSpecification());
        }
        return SqlImplUtil.createType(name2, result2, qualifier, args2.toString());
    }

    @NotNull
    public static DasType getDasType(@NotNull SqlTypedDefinition definition, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement place) {
        DasType type;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(24);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(25);
        }
        if ((type = definition.getDasType()) == DasTypeSystemBase.UNKNOWN || DasTypeUtilsKt.getCategory(type) == DasTypeCategory.RECORD) {
            DasType res2 = dialect.getTypeSystem().getDefinitionType(definition, place);
            DasType dasType = res2 == DasTypeSystemBase.UNKNOWN ? type : res2;
            if (dasType == null) {
                SqlImplUtil.$$$reportNull$$$0(26);
            }
            return dasType;
        }
        DasType dasType = type;
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(27);
        }
        return dasType;
    }

    @NotNull
    public static DasType getDasType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(28);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(29);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(30);
        }
        return SqlImplUtil.getDasType(object, dialect, (UserDataHolder)context, context, context.getProject());
    }

    @NotNull
    public static DasType getDasType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect, @NotNull UserDataHolder holder, @Nullable PsiElement context, @NotNull Project project) {
        DasType dasType;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(31);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(32);
        }
        if (holder == null) {
            SqlImplUtil.$$$reportNull$$$0(33);
        }
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(34);
        }
        if (object instanceof SqlTypedDefinition) {
            SqlTypedDefinition typedDef = (SqlTypedDefinition)object;
            DasType dasType2 = typedDef.getDasType();
            if (dasType2 == null) {
                SqlImplUtil.$$$reportNull$$$0(35);
            }
            return dasType2;
        }
        if (object instanceof DasUserDefinedType) {
            DasUserDefinedType typeDef = (DasUserDefinedType)((Object)object);
            dasType = typeDef.getSelfDasType();
        } else {
            dasType = object.getDasType();
        }
        DasType dasType3 = dasType;
        return SqlImplUtil.rebuildDasType(DasTypeUtilsKt.unwrap(dasType3, true, object), dialect, holder, context, project);
    }

    @NotNull
    public static DasType getArrayElement(@NotNull DasType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(36);
        }
        DasType dasType = type instanceof DasArrayType ? ((DasArrayType)type).getComponentType() : type;
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(37);
        }
        return dasType;
    }

    @NotNull
    public static DasType getDasType(@NotNull DasUserDefinedType type, @NotNull PsiElement element, @NotNull SqlLanguageDialectEx dialect) {
        JBIterable children2;
        List columns;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(38);
        }
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(39);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(40);
        }
        if (!(columns = (children2 = type.getDasChildren(null).filter(DasTypedObject.class)).filter(PsiObject.class).transform(e -> {
            DasType dasType = SqlImplUtil.getDasType((DasTypedObject)((Object)e), dialect, (PsiElement)e);
            return new Column(e.getName(), dasType, (PsiElement)e, (PsiElement)e);
        }).toList()).isEmpty()) {
            return SqlImplUtil.createType(columns, element);
        }
        DataType dataType = DataTypeFactory.ofArgs(null, type.getName(), null, true);
        DasType dasType = DasTypeFacade.resolve(dialect.getTypeSystem().createDasType(dataType), DbUtil.getDasObject(type));
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(41);
        }
        return dasType;
    }

    @NotNull
    public static DasType rebuildDasType(@NotNull DasType dasType, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(42);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(43);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(44);
        }
        return SqlImplUtil.rebuildDasType(dasType, dialect, (UserDataHolder)context, context, context.getProject());
    }

    @NotNull
    public static DasType rebuildDasType(@NotNull DasType dasType, @NotNull SqlLanguageDialectEx dialect, @NotNull UserDataHolder holder, @Nullable PsiElement context, @NotNull Project project) {
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(45);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(46);
        }
        if (holder == null) {
            SqlImplUtil.$$$reportNull$$$0(47);
        }
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(48);
        }
        if (!(dasType instanceof DasUnresolvedTypeReference || dasType instanceof DasDataBuiltinType && DasTypeUtilsKt.getCategoryOrUnknown(dasType) == DasTypeCategory.UNKNOWN)) {
            DasType dasType2 = dasType;
            if (dasType2 == null) {
                SqlImplUtil.$$$reportNull$$$0(49);
            }
            return dasType2;
        }
        DasType dasType3 = (DasType)((ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue(holder, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.create(p2 -> SqlImplUtil.computeRebuiltDasType((DasType)p2.first, (SqlLanguageDialect)p2.second, context, project), ContainerUtil::createConcurrentSoftValueMap), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))).get(Pair.create((Object)dasType, (Object)dialect));
        if (dasType3 == null) {
            SqlImplUtil.$$$reportNull$$$0(50);
        }
        return dasType3;
    }

    @NotNull
    private static DasType computeRebuiltDasType(DasType dasType, SqlLanguageDialect language, @Nullable PsiElement context, @NotNull Project project) {
        SqlTypeElement unwrapped;
        SqlTypeElement type;
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(51);
        }
        if ((type = SqlPsiElementFactory.createDataTypeFromText(dasType.getSpecification(), language, project, context, true)) != null) {
            SqlReferenceImpl.IGNORE_DATA_SOURCES.set((UserDataHolder)type.getContainingFile(), (Object)true);
        }
        DasType dasType2 = (unwrapped = type) == null ? DasTypeSystemBase.UNKNOWN : unwrapped.getDasType();
        if (dasType2 == null) {
            SqlImplUtil.$$$reportNull$$$0(52);
        }
        return dasType2;
    }

    @Nullable
    public static PsiElement getQualifier(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(53);
        }
        return (PsiElement)state.get(CURRENT_QUALIFIER);
    }

    @Nullable
    public static PsiElement getImmediateQualifier(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(54);
        }
        return (PsiElement)state.get(IMMEDIATE_QUALIFIER);
    }

    @Nullable
    public static PsiElement getImmediateTarget(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(55);
        }
        return (PsiElement)state.get(IMMEDIATE_TARGET);
    }

    @Nullable
    public static SqlQueryExpression getLastQueryExpression(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(56);
        }
        return (SqlQueryExpression)state.get(LAST_QUERY_EXPRESSION);
    }

    @NotNull
    public static ResolveState setLastQueryExpression(@NotNull ResolveState state, @NotNull SqlQueryExpression queryExpression) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(57);
        }
        if (queryExpression == null) {
            SqlImplUtil.$$$reportNull$$$0(58);
        }
        return SqlImplUtil.getModifiedState(state, LAST_QUERY_EXPRESSION, queryExpression);
    }

    @Nullable
    public static PsiElement getQualifier(@Nullable ResolveResult resolve2) {
        return resolve2 instanceof SqlResolveResult ? ((SqlResolveResult)resolve2).getQualifier() : null;
    }

    @Nullable
    public static PsiElement getImmediateQualifier(@Nullable ResolveResult resolve2) {
        return resolve2 instanceof SqlResolveResult ? ((SqlResolveResult)resolve2).getImmediateQualifier() : null;
    }

    @Nullable
    public static PsiElement getImmediateTarget(@Nullable ResolveResult resolve2) {
        return resolve2 instanceof SqlResolveResult ? ((SqlResolveResult)resolve2).getImmediateTarget() : null;
    }

    @NotNull
    public static JBIterable<PsiElement> revSiblings(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(59);
        }
        return SqlImplUtil.getSiblingElements(e, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApiReversed());
    }

    @NotNull
    private static JBIterable<PsiElement> getSiblingElements(@NotNull PsiElement e, SyntaxTraverser.ApiEx<PsiElement> api) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(60);
        }
        JBIterable parents = api.parents((Object)e).takeWhile(o -> o == e || api.typeOf(o) == SqlElementTypes.SQL_DUMMY_BLOCK);
        JBIterable roots2 = parents.flatten(p2 -> p2 == e ? api.siblings(p2) : api.siblings(p2).skip(1));
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoots((Iterable)roots2)).expand(Conditions.alwaysFalse())).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(61);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> siblings(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(62);
        }
        return SqlImplUtil.getSiblingElements(e, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApi());
    }

    @NotNull
    public static JBIterable<PsiElement> siblingsNoDummy(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(63);
        }
        return SqlImplUtil.getSiblingElements(e, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApi());
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlRevTraverser(PsiElement element) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.revPsiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)).withRoot((Object)element);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(64);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlRevChildren(@Nullable PsiElement element) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlRevTraverser(element).expandAndSkip(Conditions.is((Object)element))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(65);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildrenNoWS(@Nullable PsiElement element) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren(element).filter(e -> !(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(66);
        }
        return jBIterable;
    }

    @NotNull
    public static Condition<PsiElement> byElementType(IElementType ... types) {
        if (types == null) {
            SqlImplUtil.$$$reportNull$$$0(67);
        }
        Condition condition = element -> ArrayUtil.contains((Object)element.getNode().getElementType(), (Object[])types);
        if (condition == null) {
            SqlImplUtil.$$$reportNull$$$0(68);
        }
        return condition;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlParents(@Nullable PsiElement e) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        JBIterable jBIterable = api.parents((Object)e).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.notEqualTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(69);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<SqlCompositeElement> sqlCompositeElements(@Nullable PsiElement root) {
        SyntaxTraverser s = SqlImplUtil.sqlTraverser(root).filterTypes(Conditions.notInstanceOf(SqlKeywordTokenType.class));
        JBIterable jBIterable = ((SyntaxTraverser)s.expand(Conditions.or((Condition)Conditions.is((Object)root), (Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK))))).filter(SqlCompositeElement.class);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(70);
        }
        return jBIterable;
    }

    @Contract(value="null -> null")
    @Nullable
    public static SqlExpression skipParenthesizedExprDown(SqlExpression expression) {
        while (expression instanceof SqlParenthesizedExpression) {
            expression = ((SqlParenthesizedExpression)expression).getExpression();
        }
        return expression;
    }

    @Nullable
    public static IElementType getElementType(@Nullable PsiElement element) {
        ASTNode node = element == null ? null : element.getNode();
        return node == null ? null : node.getElementType();
    }

    @Nullable
    private static String getNameOrText(@Nullable PsiElement e) {
        return e instanceof SqlNameElement ? ((SqlNameElement)e).getName() : (e instanceof DasObject ? ((DasObject)e).getName() : (e != null ? e.getText() : null));
    }

    @Nullable
    public static SqlTableType convertToTableType(@NotNull DasType type, @NotNull PsiElement context) {
        DasType unwrapped;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(71);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(72);
        }
        if ((unwrapped = DasTypeUtilsKt.unwrapCollections(type)) instanceof SqlTableType) {
            SqlTableType tableType2 = (SqlTableType)unwrapped;
            return tableType2;
        }
        if (unwrapped instanceof DasColumniationType) {
            DasColumniationType columniationType = (DasColumniationType)unwrapped;
            return new TableBasedSqlTableTypeImpl<DasTypedObject>(context, columniationType.getColumnScope().getAllElements(), null);
        }
        if (unwrapped instanceof DasDefinedType) {
            PsiElement e;
            DasDefinedType definedType = (DasDefinedType)unwrapped;
            return SqlTableTypeBase.createObjectTypeType(definedType.getTypeClass().getDefinition(), definedType instanceof PsiElement ? (e = (PsiElement)definedType) : context, context);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static SqlTableType getSelectType(@NotNull List<? extends SqlExpression> list, @Nullable PsiElement qualifier) {
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(73);
        }
        SqlTableType result2 = SqlTableTypeBase.EMPTY_TABLE;
        for (SqlExpression sqlExpression : list) {
            boolean flatten;
            void var4_4;
            void var4_7;
            SqlColumnAliasListImpl aliasList;
            if (sqlExpression instanceof SqlAsExpression && (aliasList = (SqlColumnAliasListImpl)PsiTreeUtil.getChildOfType((PsiElement)sqlExpression, SqlColumnAliasListImpl.class)) != null) {
                for (SqlDefinition alias : aliasList.getColumnAliasList()) {
                    DasType dasType = aliasList.getAliasedDasType(alias);
                    result2 = result2.add(SqlTableTypeBase.ensureTableType(dasType, (PsiElement)alias, qualifier));
                }
                continue;
            }
            DasType dasType = sqlExpression.getDasType();
            SqlTypeCastExpression cast = (SqlTypeCastExpression)ObjectUtils.tryCast((Object)sqlExpression, SqlTypeCastExpression.class);
            String name2 = null;
            String aliasName = null;
            boolean quoted = false;
            if (cast != null) {
                SqlExpression sqlExpression2 = cast.getExpression();
                SqlTypeElement element = cast.getTypeElement();
                if (element != null) {
                    name2 = element.getDasType().getSpecification();
                }
            }
            if (var4_7 instanceof SqlFunctionCallExpression) {
                String fooName;
                SqlReferenceExpression fooRef = ((SqlFunctionCallExpression)var4_7).getNameElement();
                String string = fooName = fooRef == null ? null : fooRef.getName();
                if (fooName != null && fooName.equalsIgnoreCase("cast")) {
                    List args2;
                    SqlExpressionList params = ((SqlFunctionCallExpression)var4_7).getParameterList();
                    List list2 = args2 = params == null ? null : params.getExpressionList();
                    if (!ContainerUtil.isEmpty((Collection)args2)) {
                        SqlExpression sqlExpression3 = (SqlExpression)args2.get(0);
                    }
                }
            }
            if (name2 == null) {
                name2 = SqlImplUtil.getNameOrText((PsiElement)var4_4);
                boolean bl = var4_4 instanceof SqlNameElement ? ((SqlNameElement)var4_4).isQuotedIdentifier() : (quoted = var4_4 instanceof SqlDefinition && ((SqlDefinition)var4_4).isNameQuoted());
            }
            if (var4_4 instanceof SqlReferenceExpression) {
                PsiElement columnQualifier = SqlImplUtil.getQualifier(((SqlReferenceExpression)var4_4).resolveSingle());
                aliasName = SqlImplUtil.getNameOrText(columnQualifier);
            }
            boolean bl = flatten = "*".equals(name2) || list.size() == 1 && SqlImplUtil.getSqlDialectSafe((PsiElement)var4_4).getDbms() == Dbms.EXASOL;
            if (flatten && dasType instanceof SqlTableType) {
                SqlTableType tableType2 = (SqlTableType)dasType;
                dasType = name2 == null ? dasType : tableType2.flattenedAlias(name2, qualifier, (SqlElement)var4_4);
            } else {
                if (flatten && dasType == DasTypeSystemBase.UNKNOWN) continue;
                dasType = SqlTableTypeBase.createType((PsiElement)var4_4, dasType, name2, quoted, false, qualifier, aliasName);
            }
            result2 = result2.add(SqlTableTypeBase.ensureTableType(dasType, (PsiElement)var4_4, qualifier));
        }
        if (result2 != SqlTableTypeBase.EMPTY_TABLE) {
            result2 = result2.alias(null, qualifier, Collections.emptyList());
        }
        SqlTableType sqlTableType = result2;
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(74);
        }
        return sqlTableType;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheLeftOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(75);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement psiElement = element.getPrevSibling(); psiElement != null; psiElement = psiElement.getPrevSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    public static boolean processFromReferences(SqlScopeProcessor processor2, ResolveState state, SqlExpression fromExpression, PsiElement place, PsiElement lastParent) {
        DasType type;
        if (!SqlImplUtil.isProcessingOneOf(processor2, SqlDbElementType.COLUMN, SqlDbElementType.TABLE)) {
            return true;
        }
        DasType dasType = type = fromExpression == null ? null : SqlImplUtil.getTypeLateralAware(fromExpression, place);
        if (!(type instanceof SqlTableType)) {
            SqlImplUtil.processUnresolvedSymbol(processor2, state, place);
            return true;
        }
        ResolveState newState = state;
        if (SqlImplUtil.isProcessingOneOf(processor2, SqlDbElementType.COLUMN)) {
            newState = SqlImplUtil.setImmediateQualifier(newState, (PsiElement)fromExpression);
        }
        if (SqlImplUtil.isProcessingOneOf(processor2, SqlDbElementType.TABLE)) {
            newState = SqlImplUtil.setImmediateTarget(newState, (PsiElement)fromExpression);
        }
        return SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor2, newState, place);
    }

    @NotNull
    public static DasType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement end) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(76);
        }
        Object object = expression instanceof SqlLateralAwareExpression ? ((SqlLateralAwareExpression)expression).getDasType(end) : (end != null && PsiTreeUtil.isContextAncestor((PsiElement)expression, (PsiElement)end, (boolean)false) ? SqlTableTypeBase.EMPTY_TABLE : DasTypeUtilsKt.unwrap(expression.getDasType()));
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(77);
        }
        return object;
    }

    public static List<PsiColumnWithSymbol> createColumnInfos(SqlTableDefinition tableInfo, SqlTableType tableType2) {
        int count = tableType2.getColumnCount();
        ArrayList<PsiColumnWithSymbol> result2 = new ArrayList<PsiColumnWithSymbol>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            result2.add(new MyColumnInfo(tableInfo, i2, tableType2));
        }
        return result2;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(78);
        }
        return SqlImplUtil.getSiblingToTheRightOfType(element, strict, null, classes);
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element, boolean strict, @Nullable Condition<? super PsiElement> skip, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(79);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement psiElement = element.getNextSibling(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement || skip != null && skip.value((Object)psiElement)) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    @NotNull
    public static List<Pair<PsiElement, PsiElement>> resolveQualified(@Nullable SqlReferenceExpression ref2) {
        ResolveResult[] results2;
        ResolveResult[] resolveResultArray = results2 = ref2 == null ? null : ref2.multiResolve(false);
        if (results2 == null || results2.length == 0) {
            List<Pair<PsiElement, PsiElement>> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(80);
            }
            return list;
        }
        ArrayList<Pair<PsiElement, PsiElement>> res2 = new ArrayList<Pair<PsiElement, PsiElement>>();
        for (ResolveResult result2 : results2) {
            DasSymbol symbol = DasSymbolUtil.getSymbol(result2);
            if (symbol instanceof DasInlineSymbol && ((DasInlineSymbol)symbol).isUnresolved()) continue;
            PsiElement qualifier = SqlImplUtil.getImmediateQualifier(result2);
            if (qualifier instanceof SqlReferenceExpression) {
                qualifier = (PsiElement)ObjectUtils.notNull((Object)((SqlReferenceExpression)qualifier).resolve(), (Object)qualifier);
            }
            res2.add((Pair<PsiElement, PsiElement>)Pair.create((Object)qualifier, (Object)result2.getElement()));
        }
        ArrayList<Pair<PsiElement, PsiElement>> arrayList = res2;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(81);
        }
        return arrayList;
    }

    public static boolean processObjectParents(@Nullable DasSymbol startSymbol, SqlScopeProcessor processor2, ResolveState resolveState) {
        Project project = processor2.getPlace().getProject();
        for (DasObject object = startSymbol != null ? startSymbol.getDasObject() : null; object != null; object = object.getDasParent()) {
            DasSymbol symbol = DasSymbolUtil.wrapObjectToSymbol(object, project);
            if (processor2.execute(symbol, resolveState)) continue;
            return false;
        }
        return true;
    }

    public static PsiElement getBlockContentElement(@NotNull PsiElement block) {
        if (block == null) {
            SqlImplUtil.$$$reportNull$$$0(82);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (PsiElement)api.children((Object)block).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK))).first();
    }

    public static <T> T @NotNull [] toArray(@Nullable Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        if (factory == null) {
            SqlImplUtil.$$$reportNull$$$0(83);
        }
        Object[] objectArray = c2 != null ? c2.toArray(factory.create(c2.size())) : factory.create(0);
        if (objectArray == null) {
            SqlImplUtil.$$$reportNull$$$0(84);
        }
        return objectArray;
    }

    @Nullable
    public static Version getMinDbmsVersion(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(85);
        }
        Version minVersion = null;
        for (DbDataSource dataSource : SqlImplUtil.getDataSources(element)) {
            Version version = Version.parse(dataSource.getDatabaseVersion().version);
            if (version == null || minVersion != null && version.compareTo(minVersion) >= 0) continue;
            minVersion = version;
        }
        return minVersion;
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialectSafe(@Nullable PsiElement element) {
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)ObjectUtils.notNull((Object)DbSqlUtilCore.getSqlDialect(element), (Object)SqlDialectImplUtilCore.getDefaultSqlDialect());
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(86);
        }
        return sqlLanguageDialectEx;
    }

    public static void acceptChildren(SqlElement parent, SqlVisitor visitor2) {
        for (PsiElement element : SqlImplUtil.sqlChildren((PsiElement)parent)) {
            if (!(element instanceof SqlElement)) continue;
            ((SqlElement)element).accept(visitor2);
        }
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser() {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK));
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(87);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser(PsiElement element) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoot((Object)element);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(88);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildren(@Nullable PsiElement element) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlTraverser(element).expandAndSkip(Conditions.is((Object)element))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(89);
        }
        return jBIterable;
    }

    public static JBIterable<? extends PsiElement> childrenTreeIt(PsiElement element) {
        return SqlImplUtil.sqlChildren(element).filter(SqlCompositeElement.class);
    }

    public static JBIterable<? extends PsiElement> childrenStubIt(StubElement<?> element) {
        return JBIterable.from((Iterable)element.getChildrenStubs()).transform(STUB_TO_PSI);
    }

    public static JBIterable<? extends PsiElement> childrenIt(PsiElement element) {
        StubElement stub;
        Object object = element instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            return SqlImplUtil.childrenStubIt(stub);
        }
        return SqlImplUtil.childrenTreeIt(element);
    }

    public static boolean processDeclarationsDefault(SqlElement element, boolean processChildrenDeclarations, SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        return SqlImplUtil.processDeclarationsDefault(element, SqlImplUtil.childrenTreeIt((PsiElement)element), processChildrenDeclarations, processor2, state, lastParent, place, !(element instanceof SqlExpression) && !(element instanceof SqlFromClause));
    }

    public static boolean processDeclarationsDefault(SqlElement element, JBIterable<? extends PsiElement> notableChildren, boolean processChildrenDeclarations, SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place, boolean allowForwardReferences) {
        if (lastParent instanceof SqlWithClause || lastParent instanceof SqlOnTargetClauseImpl) {
            return true;
        }
        ObjectKind kind = element instanceof DasObject ? ((DasObject)element).getKind() : SqlDbElementType.NONE;
        boolean checkLastParent = kind != SqlDbElementType.PACKAGE && kind != SqlDbElementType.OBJECT_TYPE && kind != SqlDbElementType.BODY && !(element instanceof SqlAlterInstruction) && (!(element instanceof SqlProcedureDefinitionImpl) || !processor2.getDialect().getDbms().isOracle());
        for (PsiElement psiElement : notableChildren) {
            PsiElement scope2;
            if (checkLastParent && psiElement == lastParent) {
                if (allowForwardReferences) continue;
                break;
            }
            PsiElement psiElement2 = scope2 = psiElement instanceof SqlLocalDefinition ? ((SqlLocalDefinition)psiElement).getDefinitionScope() : null;
            if (scope2 != null && !PsiTreeUtil.isContextAncestor((PsiElement)scope2, (PsiElement)place, (boolean)true) || psiElement instanceof SqlQueryExpression) continue;
            if (psiElement instanceof DasSymbol ? !processor2.execute((DasSymbol)psiElement, state) : (psiElement instanceof SqlDeclareStatementImpl || processChildrenDeclarations && (!(psiElement instanceof SqlStatement) || psiElement instanceof SqlDefinitionHolder)) && psiElement instanceof DasScopeAware && !((DasScopeAware)psiElement).processDeclarations((DasScopeProcessor)processor2, state, lastParent, place)) {
                return false;
            }
            if (!(psiElement instanceof SqlExtraDeclarationsProvider)) continue;
            ((SqlExtraDeclarationsProvider)psiElement).processExtraDeclarations(processor2, state, lastParent, place);
        }
        if (element instanceof SqlImplicitDeclarationsProvider) {
            SqlImplicitDeclarationsProvider provider = (SqlImplicitDeclarationsProvider)element;
            if (lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)element, (PsiElement)lastParent, (boolean)true)) {
                processor2.setResolveContext((PsiElement)element);
                boolean stopIfFound = processor2.getReferenceName() != null && processor2.isResultEmpty() && provider.stopProcessingIfFoundInImplicitContext();
                boolean resume = provider.processImplicitContextDeclarations(processor2, state, lastParent, place);
                return resume &= !stopIfFound || processor2.isResultEmpty();
            }
        }
        return true;
    }

    public static ObjectKind getBodyParentKind(@Nullable SqlDefinition o) {
        SqlNameElement nameElement = o != null ? o.getNameElement() : null;
        PsiElement lastChild = nameElement == null ? null : nameElement.getLastChild();
        return lastChild instanceof SqlReferenceExpression ? ((SqlReferenceExpression)lastChild).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
    }

    @NotNull
    public static String getCasedPart(@Nullable SqlReferenceExpression tableRef, @NotNull ObjectKind kind) {
        if (kind == null) {
            SqlImplUtil.$$$reportNull$$$0(90);
        }
        if (tableRef == null) {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(91);
            }
            return string;
        }
        ArrayList<Trinity<ObjectKind, Boolean, String>> parts = new ArrayList<Trinity<ObjectKind, Boolean, String>>();
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.tryCast((Object)tableRef.getContainingFile(), SqlFile.class);
        if (casingProvider == null) {
            casingProvider = SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef).getDatabaseDialect();
        }
        SqlFileImpl.splitRef(SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef), tableRef, parts);
        for (Trinity trinity : parts) {
            if (trinity.first != kind) continue;
            String string = casingProvider.getCasing(kind, null).choose((Boolean)trinity.second == false).apply((String)trinity.third);
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(92);
            }
            return string;
        }
        String string = DasUtil.NO_NAME;
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(93);
        }
        return string;
    }

    public static Dbms getSqlDialectDbms(@Nullable PsiElement element) {
        return SqlImplUtil.getSqlDialectSafe(element).getDbms();
    }

    static boolean processSchemaMajorChildren(SqlScopeProcessor processor2, Processor<? super DbElement> wrapper, DbElement schemaElement) {
        if (DbImplUtilCore.isExpandable(schemaElement, DbImplUtilCore.getIntrospectionScope(schemaElement.getDataSource()))) {
            Condition majorChildCondition = element -> processor2.getDialect().isMajorChild(element.getKind());
            for (DbTable child : schemaElement.getDasChildren(SqlDbElementType.TABLE).filter(DbTable.class)) {
                if (ContainerUtil.process((Iterable)child.getDasChildren(null).filter(majorChildCondition), wrapper)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isProcessingOneOf(@NotNull SqlScopeProcessor processor2, ObjectKind ... kinds) {
        if (processor2 == null) {
            SqlImplUtil.$$$reportNull$$$0(94);
        }
        if (kinds == null) {
            SqlImplUtil.$$$reportNull$$$0(95);
        }
        for (ObjectKind kind : kinds) {
            if (kind != SqlDbElementType.ANY && !processor2.mayAccept(kind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProcessingChildOf(@NotNull SqlScopeProcessor processor2, @NotNull ObjectKind parent) {
        if (processor2 == null) {
            SqlImplUtil.$$$reportNull$$$0(96);
        }
        if (parent == null) {
            SqlImplUtil.$$$reportNull$$$0(97);
        }
        return parent == SqlDbElementType.ANY || processor2.mayAcceptParent(parent);
    }

    public static boolean isAsteriskRef(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(98);
        }
        return SqlImplUtil.getAsterisk(element) != null;
    }

    @Nullable
    public static PsiElement getAsterisk(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(99);
        }
        if (!(element instanceof SqlReferenceExpression)) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)child) != SqlCommonTokens.SQL_ASTERISK) continue;
            return child;
        }
        return null;
    }

    @Contract(value="null,null->null")
    public static String getPresentableName(@Nullable PsiElement element, @Nullable String emptyName) {
        String name2 = SqlImplUtil.getPresentableName(element);
        return StringUtil.isEmpty((String)name2) ? emptyName : name2;
    }

    @Nullable
    private static String getPresentableName(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof SqlSelectStatement) {
            SqlTableExpression fromClause;
            SqlQueryExpression qe = ((SqlSelectStatement)element).getQueryExpression();
            SqlSelectClause selectClause = qe != null ? qe.getSelectClause() : null;
            SqlTableExpression sqlTableExpression = fromClause = qe != null ? qe.getTableExpression() : null;
            if (selectClause != null && fromClause != null) {
                return SqlImplUtil.trimLong(selectClause.getText(), 25) + " " + SqlImplUtil.trimLong(fromClause.getText(), 25);
            }
            return SqlImplUtil.fromText(element);
        }
        if (element instanceof SqlWithClause) {
            return PsiTreeUtil.firstChild((PsiElement)element).getText();
        }
        if (element instanceof DasRoutine) {
            SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe(element);
            DatabaseDialectEx dialect = sqlDialect.getDatabaseDialect();
            DdlBuilder builder = new DdlBuilder().applyCodeStyle(element.getProject(), sqlDialect).withDialect(dialect);
            if (element instanceof PsiNamedElement) {
                builder.plain(StringUtil.notNullize((String)((PsiNamedElement)element).getName()));
            }
            return dialect.sqlDefinePrototype(builder, (DasRoutine)element, false, true).getStatement();
        }
        if (element instanceof SqlDefinition) {
            String name2;
            SqlDefinition definition = (SqlDefinition)element;
            SqlNameElement namedElement = definition.getNameElement();
            if (namedElement == null) {
                if (element instanceof DasConstraint) {
                    Object info2 = DbPresentationCore.multiRef(((DasConstraint)element).getColumnsRef());
                    if (((String)info2).isEmpty()) {
                        SqlDefinition type = (SqlDefinition)PsiTreeUtil.findChildOfType((PsiElement)element, SqlDefinition.class);
                        return SqlImplUtil.getPresentableName((PsiElement)type);
                    }
                    if (element instanceof DasForeignKey) {
                        DasForeignKey key2 = (DasForeignKey)element;
                        info2 = (String)info2 + DbPresentationCore.arrowToColumns(null, key2.getRefTableName(), key2.getRefColumns());
                    }
                    return info2;
                }
                if (element instanceof DasIndex) {
                    return DbPresentationCore.multiRef(((DasIndex)element).getColumnsRef());
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)(name2 = SqlImplUtil.getPresentableName((PsiElement)namedElement)))) {
                return SqlImplUtil.fromText(element);
            }
            return name2;
        }
        if (element instanceof SqlNameElement) {
            String s = ((SqlNameElement)element).getName();
            return StringUtil.isEmptyOrSpaces((String)s) ? SqlImplUtil.fromText(element) : s;
        }
        if (element instanceof DasObject) {
            return ((DasObject)element).getName();
        }
        if (element instanceof SqlBlockStatementImpl) {
            return "begin ... end";
        }
        return SqlImplUtil.fromText(element);
    }

    @NotNull
    private static String fromText(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(100);
        }
        return SqlImplUtil.trimLong(element.getText(), 50);
    }

    @NotNull
    private static String trimLong(String text, int limit) {
        if (limit == 0) {
            return "";
        }
        String trim = SqlImplUtil.removeDuplicateSpaces(text).trim();
        Object object = trim.length() > limit ? trim.subSequence(0, (int)((double)limit * 0.9)) + "..." + trim.subSequence((int)((double)trim.length() - (double)limit * 0.1), trim.length()) : trim;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(101);
        }
        return object;
    }

    @NotNull
    private static String removeDuplicateSpaces(@Nullable String text) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return "";
        }
        String string = SPACES.matcher(text).replaceAll(" ");
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(102);
        }
        return string;
    }

    @NotNull
    static List<SqlLabelDefinitionImpl> getLabels(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(103);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create(SqlImplUtil.calcLabels(element), (Object[])new Object[]{element}));
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(104);
        }
        return list;
    }

    @NotNull
    private static List<SqlLabelDefinitionImpl> calcLabels(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(105);
        }
        List list = SqlImplUtil.sqlTraverser(element).filter(SqlLabelDefinitionImpl.class).toList();
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(106);
        }
        return list;
    }

    @Nullable
    public static PsiElement getChildOfType(@Nullable PsiElement e, @Nullable IElementType type) {
        if (e == null || type == null) {
            return null;
        }
        PsiElement child = e.getFirstChild();
        return child == null ? null : PsiTreeUtil.findSiblingForward((PsiElement)child, (IElementType)type, (boolean)false, null);
    }

    public static short calcPosition(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(107);
        }
        short count = 1;
        for (PsiElement element : SqlImplUtil.childrenIt(SqlImplUtil.sqlParent((PsiElement)definition))) {
            if (element == definition) {
                return count;
            }
            count = (short)(count + 1);
        }
        return 0;
    }

    @Nullable
    public static PsiElement getStubOrPsiParent(@Nullable PsiElement e) {
        if (e == null) {
            return null;
        }
        StubElement stub = e instanceof StubBasedPsiElement ? ((StubBasedPsiElement)e).getStub() : null;
        StubElement parent = stub == null ? null : stub.getParentStub();
        return parent == null ? e.getParent() : parent.getPsi();
    }

    @Nullable
    public static PsiReference getReference(@NotNull PsiElement element, @Nullable SqlIdentifier nameElement) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(108);
        }
        if (nameElement == null) {
            return null;
        }
        PsiReferenceBase ref2 = PsiReferenceBase.createSelfReference((PsiElement)element, (PsiElement)element);
        ref2.setRangeInElement(TextRange.from((int)nameElement.getStartOffsetInParent(), (int)nameElement.getTextLength()));
        return ref2;
    }

    public static boolean forbidGlobalTablesResolve(PsiElement place) {
        SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
        if (ref2 == null) {
            return false;
        }
        if (SqlImplUtil.getSqlDialectSafe(place).allowGlobalTableResolve(place)) {
            return false;
        }
        if (ref2.getReferenceElementType().getTargetKind() == SqlDbElementType.COLUMN) {
            return true;
        }
        SqlReferenceExpression parentRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref2.getParent(), SqlReferenceExpression.class);
        if (parentRef == null) {
            return false;
        }
        if (parentRef.getParent() instanceof SqlTypeElement) {
            return false;
        }
        return parentRef.getReferenceElementType().getTargetKind() == SqlDbElementType.COLUMN;
    }

    public static boolean ignoreKinds(@NotNull SqlScopeProcessor processor2, @NotNull Set<ObjectKind> kinds) {
        if (processor2 == null) {
            SqlImplUtil.$$$reportNull$$$0(109);
        }
        if (kinds == null) {
            SqlImplUtil.$$$reportNull$$$0(110);
        }
        processor2.addIgnoredKinds(kinds);
        return !processor2.getExpectedTypes().isEmpty();
    }

    @Nullable
    public static VirtualFile getAnyRoot(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        ProjectFileIndex index;
        VirtualFile root;
        if (virtualFile == null) {
            SqlImplUtil.$$$reportNull$$$0(111);
        }
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(112);
        }
        if ((root = (index = ProjectFileIndex.getInstance((Project)project)).getContentRootForFile(virtualFile)) == null) {
            root = index.getClassRootForFile(virtualFile);
        }
        if (root == null) {
            root = index.getSourceRootForFile(virtualFile);
        }
        return root;
    }

    public static Dbms getDbms(@Nullable PsiElement element) {
        List<DbDataSource> dataSources;
        Dbms dbms;
        if (element instanceof DbElement) {
            return DbImplUtilCore.getDbms((DbElement)element);
        }
        DbDataSource dataSource = element == null ? null : DbImplUtilCore.getForcedDataSource(element.getContainingFile().getOriginalFile());
        Dbms dataSourceDbms = dataSource == null ? Dbms.UNKNOWN : dataSource.getDbms();
        Dbms dbms2 = dbms = dataSourceDbms != Dbms.UNKNOWN ? dataSourceDbms : SqlImplUtil.getSqlDialectDbms(element);
        if (dbms == Dbms.UNKNOWN && element != null && !(dataSources = SqlDataSourceMappings.getInstance(element.getContainingFile().getProject()).getProvidedDataSources(element.getContainingFile())).isEmpty()) {
            return dataSources.get(0).getDbms();
        }
        return dbms;
    }

    public static Dbms getDbms(@Nullable DasObject dasObject) {
        return dasObject instanceof PsiElement ? SqlImplUtil.getDbms((PsiElement)dasObject) : DbImplUtilCore.getDbms(dasObject);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static PsiElement wrapObjectToPsi(@Nullable DasObject object, @NotNull Project project) {
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(113);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return new DasPsiWrappingSymbol(object, project);
    }

    @NotNull
    public static ObjectKind getKindSynonymAware(@Nullable DasObject obj2) {
        if (obj2 instanceof SqlAsExpression) {
            SqlAsExpression alias = (SqlAsExpression)obj2;
            DasType type = DasTypeUtilsKt.unwrap(alias.getDasType());
            if (type instanceof DasCollectionType || type instanceof DasMapType) {
                ObjectKind objectKind = SqlDbElementType.COLLECTION;
                if (objectKind == null) {
                    SqlImplUtil.$$$reportNull$$$0(114);
                }
                return objectKind;
            }
            boolean isTable = type instanceof SqlTableType;
            if (type == DasTypeSystemBase.UNKNOWN) {
                PsiElement parent = ((SqlAsExpression)obj2).getParent();
                isTable = parent instanceof SqlJoinExpression || parent instanceof SqlFromClause;
            }
            ObjectKind objectKind = isTable ? SqlDbElementType.TABLE : SqlDbElementType.COLUMN;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(115);
            }
            return objectKind;
        }
        if (obj2 instanceof DasSynonym) {
            DasSynonym synonym2 = (DasSynonym)obj2;
            ObjectKind kind = synonym2.getTargetObjectKind();
            if (kind != SqlDbElementType.ANY && kind != SqlDbElementType.NONE) {
                ObjectKind objectKind = kind;
                if (objectKind == null) {
                    SqlImplUtil.$$$reportNull$$$0(116);
                }
                return objectKind;
            }
            DasObject target2 = DasUtil.resolveFinalTarget(synonym2);
            ObjectKind objectKind = target2 != null ? target2.getKind() : SqlDbElementType.ANY;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(117);
            }
            return objectKind;
        }
        ObjectKind objectKind = obj2 != null ? obj2.getKind() : SqlDbElementType.ANY;
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(118);
        }
        return objectKind;
    }

    public static PsiFile getTopLevelSqlFile(@NotNull PsiFile tmpFile) {
        PsiFile topLevelFile;
        boolean sql;
        PsiFile contextFile;
        if (tmpFile == null) {
            SqlImplUtil.$$$reportNull$$$0(119);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)tmpFile)) {
            PsiElement context = tmpFile.getContext();
            PsiFile contextFile2 = context == null ? null : context.getContainingFile();
            return contextFile2 == null ? tmpFile : contextFile2;
        }
        if (tmpFile.getContext() != null && SqlImplUtil.isSameSqlFileDialect(tmpFile, contextFile = tmpFile.getContext().getContainingFile())) {
            tmpFile = contextFile;
        }
        if (sql = SqlImplUtil.isSameSqlFileDialect(tmpFile, topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile))) {
            return topLevelFile;
        }
        return tmpFile;
    }

    private static boolean isSameSqlFileDialect(@NotNull PsiFile child, @Nullable PsiFile parent) {
        if (child == null) {
            SqlImplUtil.$$$reportNull$$$0(120);
        }
        SqlLanguageDialect fileDialect = parent instanceof SqlFile ? ((SqlFile)parent).getSqlLanguage() : null;
        return fileDialect != null && fileDialect.getClass().isInstance(SqlImplUtil.getSqlDialectSafe((PsiElement)child));
    }

    @NotNull
    public static DasTypeSystem getTypeSystem(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(121);
        }
        DasTypeSystemBase dasTypeSystemBase = DasTypeSystems.getTypeSystem(SqlImplUtil.getDbms(element));
        if (dasTypeSystemBase == null) {
            SqlImplUtil.$$$reportNull$$$0(122);
        }
        return dasTypeSystemBase;
    }

    @Nullable
    public static BasicMetaObject<?> getMetaObject(@Nullable DasObject object) {
        BasicMetaObject<?> res2 = DbImplUtilCore.getMetaObject(object);
        if (res2 != null) {
            return res2;
        }
        DasObject unw = (DasObject)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(object), DasObject.class);
        if (unw == null) {
            return null;
        }
        if (unw instanceof SqlStubbedDefinitionImpl) {
            return ((SqlStubbedDefinitionImpl)((Object)unw)).getMetaObject();
        }
        if (unw instanceof SqlExplicitTableExpression) {
            return null;
        }
        if (unw instanceof PsiElement) {
            ObjectKind kind;
            Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)unw).getDbms();
            BasicMetaModel<?> metaModel = DbImplUtilCore.getMetaModel(dbms);
            ArrayList objects = ContainerUtil.newArrayList(metaModel.findMetaObjects(kind = unw.getKind()));
            if (objects.size() <= 1) {
                return (BasicMetaObject)ContainerUtil.getFirstItem((List)objects);
            }
            BasicMetaObject<?> pMeta = SqlImplUtil.getMetaObject(unw.getDasParent());
            return BasicMetaUtils.findChild(pMeta, kind);
        }
        return null;
    }

    @Nullable
    public static DasType getScopingType(@NotNull PsiElement element) {
        SqlScopingExpression scopingExpression;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(123);
        }
        if ((scopingExpression = SqlImplUtil.getScopingExpression(element)) == null) {
            return null;
        }
        SqlTypeElement typeElement = scopingExpression.getTypeElement();
        if (typeElement == null) {
            return null;
        }
        return typeElement.getDasType();
    }

    @Nullable
    public static SqlScopingExpression getScopingExpression(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(124);
        }
        if ((parent = element.getParent()) instanceof SqlFunctionCallExpression) {
            parent = parent.getParent();
        }
        return parent instanceof SqlScopingExpression ? (SqlScopingExpression)parent : null;
    }

    @NotNull
    public static DasType getCacheableDasType(@NotNull PsiElement context, @NotNull Supplier<? extends DasType> computeType) {
        DasBuiltinType<?> dasType;
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(125);
        }
        if (computeType == null) {
            SqlImplUtil.$$$reportNull$$$0(126);
        }
        DasBuiltinType<?> dasBuiltinType = (dasType = (DasBuiltinType<?>)CachedValuesManager.getCachedValue((PsiElement)context, () -> CachedValueProvider.Result.create((Object)((DasType)computeType.get()), SqlFileImpl.getMaximalDependencies(context)))) != null ? dasType : DasTypeSystemBase.UNKNOWN;
        if (dasBuiltinType == null) {
            SqlImplUtil.$$$reportNull$$$0(127);
        }
        return dasBuiltinType;
    }

    public static boolean hasLocationOf(@NotNull BuiltinFunction definition, @NotNull Set<BuiltinFunction.Location> locations) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(128);
        }
        if (locations == null) {
            SqlImplUtil.$$$reportNull$$$0(129);
        }
        for (BuiltinFunction.Prototype prototype : definition.getPrototypes()) {
            if (!locations.contains(prototype.getLocation())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getResolveScope(@Nullable PsiFile tmpFile) {
        if (tmpFile == null) {
            return null;
        }
        PsiFile file = SqlImplUtil.getTopLevelSqlFile(tmpFile);
        PsiElement context = file.getContext();
        return context instanceof DbElement ? ((DbElement)context).getDataSource() : file;
    }

    public static boolean treeWalkUp(@NotNull DasScopeProcessor processor2, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState initialState) {
        if (processor2 == null) {
            SqlImplUtil.$$$reportNull$$$0(130);
        }
        if (entrance == null) {
            SqlImplUtil.$$$reportNull$$$0(131);
        }
        if (initialState == null) {
            SqlImplUtil.$$$reportNull$$$0(132);
        }
        PsiElement prevParent = entrance;
        PsiElement scope2 = entrance;
        ResolveState state = initialState;
        while (scope2 != null) {
            if (prevParent instanceof SqlQueryExpression) {
                state = SqlImplUtil.setLastQueryExpression(state, (SqlQueryExpression)prevParent);
            }
            if (scope2 instanceof DasScopeAware && !((DasScopeAware)scope2).processDeclarations(processor2, state, prevParent, entrance)) {
                return false;
            }
            if (scope2 == maxScope) break;
            prevParent = scope2;
            scope2 = prevParent.getContext();
        }
        return true;
    }

    @Nullable
    public static DasObject unwrapPsiToObject(@Nullable PsiElement element) {
        if (element instanceof DasObject) {
            return (DasObject)element;
        }
        if (element instanceof DasSymbol) {
            return ((DasSymbol)element).getDasObject();
        }
        return null;
    }

    public static boolean canResolveToPgFunctionColumn(@Nullable PsiElement expr) {
        if (!(expr instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expr).getQualifierExpression() == null) {
            return false;
        }
        if (expr.getParent() instanceof SqlFunctionCallExpression) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expr, SqlSelectClause.class) != null;
    }

    public static JBIterable<ResolveResult> resolveVisible(SqlReferenceExpression expression) {
        return SqlImplUtil.resolveVisible((PsiPolyVariantReference)expression.getReference());
    }

    public static JBIterable<ResolveResult> resolveVisible(PsiPolyVariantReference reference) {
        JBIterable targets = JBIterable.of((Object[])reference.multiResolve(false));
        if (targets.single() != null) {
            return targets;
        }
        return targets.filter(r -> !(r instanceof SqlResolveResult) || !((SqlResolveResult)r).isHidden());
    }

    public static boolean isMarkedUnresolved(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(133);
        }
        for (ResolveResult result2 : expression.multiResolve(false)) {
            if (!SqlImplUtil.isMarkedUnresolved(result2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMarkedUnresolved(@NotNull ResolveResult resolveResult) {
        if (resolveResult == null) {
            SqlImplUtil.$$$reportNull$$$0(134);
        }
        return DasSymbolUtil.isUnresolved(DasSymbolUtil.getSymbol(resolveResult));
    }

    @Nullable
    public static VirtualFile getTopLevelFile(@NotNull PsiFile file) {
        PsiFile tmpFile;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(135);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)(tmpFile = file))) {
            PsiElement context = tmpFile.getContext();
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)(context == null ? null : context.getContainingFile()), (Object)tmpFile);
        } else {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile);
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)topLevelFile, (Object)tmpFile);
        }
        return tmpFile.getOriginalFile().getVirtualFile();
    }

    public static SqlTableType getTableTypeOfColumnList(@NotNull List<? extends SqlReferenceExpression> colList, @Nullable SqlExpression tableExpression) {
        PsiElement psiElement;
        if (colList == null) {
            SqlImplUtil.$$$reportNull$$$0(136);
        }
        if (colList.isEmpty()) {
            SqlTableType tableType2;
            DasType type = tableExpression == null ? null : SqlImplUtil.filterHiddenColumns(tableExpression.getDasType());
            return type instanceof SqlTableType ? (tableType2 = (SqlTableType)type) : SqlTableTypeBase.EMPTY_TABLE;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (SqlReferenceExpression sqlReferenceExpression : colList) {
            PsiElement element = sqlReferenceExpression.resolve();
            if (element instanceof SqlColumnDefinition) {
                SqlColumnDefinition column2 = (SqlColumnDefinition)element;
                columns.add(new Column(column2.getName(), column2.getDasType(), (PsiElement)sqlReferenceExpression, element));
                continue;
            }
            if (element instanceof DbColumn) {
                DbColumn column3 = (DbColumn)element;
                DasType dasType = SqlImplUtil.rebuildDasType(column3.getDasType(), SqlImplUtil.getSqlDialectSafe(element), (PsiElement)tableExpression);
                columns.add(new Column(column3.getName(), dasType, (PsiElement)sqlReferenceExpression, element));
                continue;
            }
            columns.add(new Column(sqlReferenceExpression.getName(), DasTypeSystemBase.UNKNOWN, (PsiElement)sqlReferenceExpression, null));
        }
        PsiElement qualifier = null;
        if (tableExpression instanceof SqlReferenceExpression && (psiElement = ((SqlReferenceExpression)tableExpression).resolve()) instanceof SqlCreateTableStatement) {
            qualifier = psiElement;
        }
        return SqlImplUtil.createType(columns, qualifier);
    }

    @Nullable
    public static ObjectKind getIdentifierKind(@NotNull SqlIdentifier identifier) {
        PsiElement parent;
        if (identifier == null) {
            SqlImplUtil.$$$reportNull$$$0(137);
        }
        if ((parent = identifier.getParent()) instanceof SqlReferenceExpression) {
            SqlReferenceExpression refExpression = (SqlReferenceExpression)parent;
            PsiElement result2 = refExpression.resolve();
            if (result2 instanceof DasObject) {
                return ((DasObject)result2).getKind();
            }
            return refExpression.getReferenceElementType().getTargetKind();
        }
        if (parent instanceof SqlColumnDefinition) {
            return SqlDbElementType.COLUMN;
        }
        if (parent instanceof SqlColumnAliasDefinitionImpl) {
            return SqlDbElementType.COLUMN_ALIAS;
        }
        if (parent instanceof SqlAsExpression) {
            return SqlDbElementType.LOCAL_ALIAS;
        }
        if (parent instanceof SqlDefinition) {
            return ((SqlDefinition)parent).getKind();
        }
        return null;
    }

    @NotNull
    public static <T extends DasTypedObject> List<T> processColumnList(@NotNull List<? extends T> tgt, @NotNull List<T> src, boolean caseSensitive, @Nullable PairFunction<? super T, ? super T, Boolean> check, boolean skip) {
        if (tgt == null) {
            SqlImplUtil.$$$reportNull$$$0(138);
        }
        if (src == null) {
            SqlImplUtil.$$$reportNull$$$0(139);
        }
        ArrayList<DasTypedObject> result2 = new ArrayList<DasTypedObject>(tgt.size());
        Map<String, DasTypedObject> tgtMap = DasUtil.newCaseAwareMap(caseSensitive);
        for (DasTypedObject column2 : src) {
            tgtMap.put(column2.getName(), column2);
        }
        for (DasTypedObject column2 : tgt) {
            boolean matched;
            DasTypedObject old2 = (DasTypedObject)tgtMap.remove(column2.getName());
            boolean bl = matched = old2 != null && (check == null || (Boolean)check.fun((Object)old2, (Object)column2) != false);
            if (matched && skip) continue;
            result2.add(matched ? old2 : column2);
        }
        ArrayList<DasTypedObject> arrayList = result2;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(140);
        }
        return arrayList;
    }

    @Nullable
    private static TrigEvent getEvent(IElementType e) {
        if (e == SqlCommonKeywords.SQL_SELECT) {
            return TrigEvent.SELECT;
        }
        if (e == SqlCommonKeywords.SQL_INSERT) {
            return TrigEvent.INSERT;
        }
        if (e == SqlCommonKeywords.SQL_UPDATE) {
            return TrigEvent.UPDATE;
        }
        if (e == SqlCommonKeywords.SQL_DELETE) {
            return TrigEvent.DELETE;
        }
        return null;
    }

    @Nullable
    private static TrigEvent getEvent(PsiElement element) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (TrigEvent)((Object)api.children((Object)element).transform(api.TO_TYPE).transform(e -> SqlImplUtil.getEvent(e)).filter(Conditions.notNull()).first());
    }

    @NotNull
    public static Set<TrigEvent> getTriggerEvents(@NotNull SqlElement element) {
        SyntaxTraverser.ApiEx api;
        JBIterable events;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(141);
        }
        if ((events = (api = SyntaxTraverser.psiApi()).children((Object)element).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE)).isEmpty()) {
            Set<TrigEvent> set = Collections.emptySet();
            if (set == null) {
                SqlImplUtil.$$$reportNull$$$0(142);
            }
            return set;
        }
        Set set = events.transform(e -> SqlImplUtil.getEvent(e)).filter(Conditions.notNull()).toSet();
        if (set == null) {
            SqlImplUtil.$$$reportNull$$$0(143);
        }
        return set;
    }

    @NotNull
    public static DasType getTupleType(SqlExpressionList expressionList, boolean forceTable) {
        boolean tableTypeExpected;
        List list = expressionList.getExpressionList();
        IElementType startType = PsiUtilCore.getElementType((PsiElement)expressionList.getFirstChild());
        boolean bl = tableTypeExpected = forceTable || expressionList.getParent() instanceof SqlValuesExpression || startType == SqlCommonKeywords.SQL_ROW || SqlImplUtil.getSqlDialectSafe((PsiElement)expressionList).getDbms().isBigQuery() && startType == SqlCommonKeywords.SQL_STRUCT;
        if (list.isEmpty()) {
            Object object = tableTypeExpected ? SqlTableTypeBase.EMPTY_TABLE : DasTypeSystemBase.UNKNOWN;
            if (object == null) {
                SqlImplUtil.$$$reportNull$$$0(144);
            }
            return object;
        }
        if (list.size() == 1 && !tableTypeExpected) {
            DasType dasType = ((SqlExpression)list.get(0)).getDasType();
            if (dasType == null) {
                SqlImplUtil.$$$reportNull$$$0(145);
            }
            return dasType;
        }
        return new ValuesTableType(expressionList);
    }

    @NotNull
    public static DasType getTupleDasType(SqlExpressionList expressionList) {
        boolean tableTypeExpected;
        List list = expressionList.getExpressionList();
        boolean bl = tableTypeExpected = expressionList.getParent() instanceof SqlValuesExpression || PsiUtilCore.getElementType((PsiElement)expressionList.getFirstChild()) == SqlCommonKeywords.SQL_ROW;
        if (list.size() == 0) {
            Object object = tableTypeExpected ? SqlTableTypeBase.EMPTY_TABLE : DasTypeSystemBase.UNKNOWN;
            if (object == null) {
                SqlImplUtil.$$$reportNull$$$0(146);
            }
            return object;
        }
        if (list.size() == 1 && !tableTypeExpected) {
            DasType dasType = ((SqlExpression)list.get(0)).getDasType();
            if (dasType == null) {
                SqlImplUtil.$$$reportNull$$$0(147);
            }
            return dasType;
        }
        return new ValuesTableType(expressionList);
    }

    @NotNull
    public static DasType filterHiddenColumns(@NotNull DasType type) {
        DasType dasType;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(148);
        }
        if (type instanceof SqlTableType) {
            SqlTableType tableType2 = (SqlTableType)type;
            dasType = SqlImplUtil.filterHiddenColumns(tableType2);
        } else {
            dasType = type;
        }
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(149);
        }
        return dasType;
    }

    @NotNull
    public static SqlTableType filterHiddenColumns(@NotNull SqlTableType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(150);
        }
        SqlTableType result2 = type;
        for (int i2 = type.getColumnCount() - 1; i2 >= 0; --i2) {
            PsiElement source = type.getSourceColumnElement(i2);
            if (!(source instanceof DasHideableObject) || !((DasHideableObject)source).isHidden()) continue;
            result2 = result2.subtract(i2);
        }
        SqlTableType sqlTableType = result2;
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(151);
        }
        return sqlTableType;
    }

    @NotNull
    public static JBIterable<Version> getDbVersions(@NotNull SqlFile file) {
        DbDataSource ds;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(152);
        }
        if ((ds = DbImplUtilCore.getForcedDataSource((PsiFile)file)) != null) {
            JBIterable jBIterable = JBIterable.of((Object)ds.getVersion());
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(153);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)file)).filterMap(DasDataSource::getVersion);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(154);
        }
        return jBIterable;
    }

    public static void quoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        String newName;
        PsiElement target2 = SqlAnnotator.getTargetByIdElement((PsiElement)identifier, true);
        if (target2 instanceof DbElement) {
            DbElement dbTarget = (DbElement)target2;
            newName = dbTarget.getName();
        } else {
            newName = identifier.getName();
            if (target2 instanceof DasObject) {
                DasObject dasTarget = (DasObject)target2;
                if (dialect instanceof SqlLanguageDialectEx) {
                    newName = ((SqlLanguageDialectEx)dialect).getCasing((ObjectKind)dasTarget.getKind(), (DasObject)dasTarget).plain.apply(newName);
                }
            }
        }
        NamingService namingService = NamingServices.getNamingService(SqlImplUtil.getDbms((PsiElement)identifier));
        String quotedName = namingService.enquote(newName, SqlImplUtil.getIdentifierKind(identifier));
        identifier.setName(quotedName);
    }

    public static void unquoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        SqlIdentifier newId = SqlPsiElementFactory.createIdentifierFromText(identifier.getName(), dialect, project);
        if (newId != null) {
            identifier.replace((PsiElement)newId);
        }
    }

    public static boolean canUnquote(@NotNull String newText, @Nullable ObjectKind kind, @NotNull NamingService namingService) {
        if (newText == null) {
            SqlImplUtil.$$$reportNull$$$0(155);
        }
        if (namingService == null) {
            SqlImplUtil.$$$reportNull$$$0(156);
        }
        return StringUtil.equals((CharSequence)namingService.catToScript(newText, kind), (CharSequence)newText);
    }

    @NotNull
    public static ObjectKind getQualifierKind(@NotNull PsiElement element) {
        PsiElement target2;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(157);
        }
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        PsiElement psiElement = target2 = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : null;
        if (qualifier == null && PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryClause.class) != null) {
            ObjectKind objectKind = SqlDbElementType.TABLE;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(158);
            }
            return objectKind;
        }
        ObjectKind objectKind = target2 instanceof DasObject ? SqlImplUtil.getKindSynonymAware((DasObject)target2) : SqlDbElementType.NONE;
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(159);
        }
        return objectKind;
    }

    @NotNull
    public static DasType getQualifierDasType(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(160);
        }
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        DasType dasType = DasTypeUtilsKt.unwrap(qualifier != null ? qualifier.getDasType() : DasTypeSystemBase.UNKNOWN, true);
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(161);
        }
        return dasType;
    }

    public static boolean isAutoVal(@NotNull SqlColumnDefinition col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(162);
        }
        return SqlImplUtil.getSqlDialectSafe((PsiElement)col).isAutoIncrementColumn((DasColumn)col);
    }

    public static boolean isAutoVal(@NotNull DasColumn col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(163);
        }
        return col instanceof SqlColumnDefinition ? SqlImplUtil.isAutoVal((SqlColumnDefinition)col) : DasUtil.isAutoGenerated(col);
    }

    public static boolean isComputedVal(@NotNull SqlColumnDefinition col) {
        SqlColumnStub stub;
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(164);
        }
        SqlColumnStub sqlColumnStub = stub = col instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)col).getGreenStub() : null;
        if (stub != null) {
            BasicTableOrViewColumn tc = (BasicTableOrViewColumn)ObjectUtils.tryCast((Object)stub.getElement(), BasicTableOrViewColumn.class);
            return tc != null && tc.isComputed();
        }
        ASTNode node = col.getNode();
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE) != null;
    }

    public static boolean isComputedVal(@NotNull DasColumn col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(165);
        }
        return col instanceof SqlColumnDefinition ? SqlImplUtil.isComputedVal((SqlColumnDefinition)col) : DasUtil.isComputed(col);
    }

    @NotNull
    public static JBIterable<SqlStatement> iterateStatementsBackward(@NotNull PsiFile file, int offset) {
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(166);
        }
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)file)).expand(element -> element.getTextRange().getStartOffset() < offset && (!(element instanceof SqlStatement) || element.getTextRange().getEndOffset() >= offset))).postOrderDfsTraversal().filter(SqlStatement.class).filter(stmt -> stmt.getTextRange().getEndOffset() <= offset);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(167);
        }
        return jBIterable;
    }

    public static <T extends DasTypedObject> void mergeColumnListInto(@NotNull List<T> a, @NotNull List<T> b, boolean caseSensitive, @Nullable PairFunction<? super T, ? super T, Boolean> mergeCheck) {
        if (a == null) {
            SqlImplUtil.$$$reportNull$$$0(168);
        }
        if (b == null) {
            SqlImplUtil.$$$reportNull$$$0(169);
        }
        a.addAll(SqlImplUtil.processColumnList(b, a, caseSensitive, mergeCheck, true));
    }

    public static boolean hasSameTypes(@Nullable PsiColumn a, @Nullable PsiColumn b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.getDasType().toDataType().equals(b.getDasType().toDataType());
    }

    public static boolean equalsInsensitiveOrTrue(@Nullable String a, @Nullable String b, boolean compare) {
        return !compare || Comparing.strEqual((String)a, (String)b, (boolean)false);
    }

    public static PsiElement @NotNull [] getRelatedElements(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(170);
        }
        PsiElement[] psiElementArray = (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)definition, () -> CachedValueProvider.Result.create((Object)SqlImplUtil.calcRelatedElements(definition), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiElementArray == null) {
            SqlImplUtil.$$$reportNull$$$0(171);
        }
        return psiElementArray;
    }

    private static PsiElement @NotNull [] calcRelatedElements(@NotNull SqlDefinition definition) {
        SqlReferenceExpression ref2;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(172);
        }
        if ((ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)definition.getNameElement(), SqlReferenceExpression.class)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(173);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(ref2.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)definition), ref2.getReferenceElementType(), (PsiElement)definition);
        if (newRef == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(174);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ResolveResult[] results2 = newRef.multiResolve(false);
        if (results2.length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(175);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] related = new PsiElement[results2.length];
        for (int i2 = 0; i2 < results2.length; ++i2) {
            related[i2] = results2[i2].getElement();
        }
        if (related == null) {
            SqlImplUtil.$$$reportNull$$$0(176);
        }
        return related;
    }

    public static boolean isBodyLazyBlock(@Nullable PsiElement e) {
        return e instanceof LazyParseablePsiElement && !(e instanceof SqlLazyParseablePsiElement) || e instanceof SqlCodeBlockElement;
    }

    @NotNull
    private static IntRange indicesOfImmediateSource(@NotNull SqlTableType type, @NotNull PsiElement source) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(177);
        }
        if (source == null) {
            SqlImplUtil.$$$reportNull$$$0(178);
        }
        int columnCount = type.getColumnCount();
        int from = -1;
        int to = columnCount;
        for (int i2 = 0; i2 < columnCount; ++i2) {
            boolean isMatched;
            PsiElement actualSource = type.getImmediateSourceColumnElement(i2);
            while (actualSource instanceof SqlImplicitTarget) {
                actualSource = ((SqlImplicitTarget)actualSource).getContextElement();
            }
            boolean bl = isMatched = actualSource == source || source instanceof SqlReferenceExpression && actualSource == ((SqlReferenceExpression)source).resolve();
            if (isMatched && from < 0) {
                from = i2;
                continue;
            }
            if (isMatched || from < 0) continue;
            to = i2;
            break;
        }
        return new IntRange(from, to - 1);
    }

    private static boolean inColumnProvidingContext(@NotNull SqlQueryExpression query) {
        if (query == null) {
            SqlImplUtil.$$$reportNull$$$0(179);
        }
        for (PsiElement parent : SqlImplUtil.sqlParents((PsiElement)query)) {
            if (parent instanceof SqlResultSetExpression || parent instanceof SqlClause && parent.getParent() instanceof SqlCreateViewStatement) continue;
            if (parent instanceof SqlInsertDmlInstruction) {
                return true;
            }
            if (!(parent instanceof SqlCreateViewStatement) || ((SqlCreateViewStatement)parent).getColumnAliases().length <= 0) break;
            return true;
        }
        return false;
    }

    @Nullable
    private static SqlExpression getSelectExpression(@NotNull SqlSelectClause selectClause, @NotNull PsiElement element) {
        if (selectClause == null) {
            SqlImplUtil.$$$reportNull$$$0(180);
        }
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(181);
        }
        for (SqlExpression expression : selectClause.getExpressions()) {
            if (!expression.getTextRange().contains(element.getTextRange().getStartOffset())) continue;
            return expression;
        }
        return null;
    }

    @Nullable
    private static SqlElement getResultSetExpressionList(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        SqlExpressionList list = SqlValuesParameterInfoUtils.findExpressions(element);
        if (list != null) {
            return list;
        }
        SqlSelectClause selectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)element, SqlSelectClause.class);
        if (selectClause != null) {
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)selectClause, SqlQueryExpression.class);
            return query != null && SqlImplUtil.inColumnProvidingContext(query) ? selectClause : null;
        }
        return null;
    }

    @Nullable
    public static IntRange getImmediateColumnSourceIndices(@Nullable PsiElement element, @Nullable SqlElement anExpressionList, boolean strict) {
        SqlElement expressionList;
        if (element == null) {
            return null;
        }
        SqlElement sqlElement = expressionList = anExpressionList != null ? anExpressionList : SqlImplUtil.getResultSetExpressionList(element);
        if (strict && element.getParent() != expressionList) {
            return null;
        }
        if (expressionList instanceof SqlExpressionList) {
            int index = SqlValuesParameterInfoUtils.getCurrentParameterIndex((SqlExpressionList)expressionList, element.getTextRange().getStartOffset());
            return index >= 0 ? new IntRange(index, index) : null;
        }
        if (expressionList instanceof SqlSelectClause) {
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)expressionList, SqlQueryExpression.class);
            if (query == null) {
                return null;
            }
            DasType type = query.getDasType();
            if (!(type instanceof SqlTableType)) {
                return null;
            }
            SqlTableType tableType2 = (SqlTableType)type;
            SqlExpression expression = SqlImplUtil.getSelectExpression((SqlSelectClause)expressionList, element);
            if (expression == null) {
                return null;
            }
            IntRange indices = SqlImplUtil.indicesOfImmediateSource(tableType2, (PsiElement)expression);
            return indices.getStart() >= 0 ? indices : null;
        }
        return null;
    }

    @NotNull
    public static JBIterable<? extends DasObject> unwrapFake(@Nullable DasObject obj2) {
        JBIterable<SqlDefinition> jBIterable = obj2 instanceof SqlFileImpl.GroupImpl ? ((SqlFileImpl.GroupImpl)obj2).delegates() : JBIterable.of((Object)obj2);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(182);
        }
        return jBIterable;
    }

    public static boolean isColumnQualifier(@NotNull PsiElement place) {
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(183);
        }
        return SqlImplUtil.isQualifier(place, SqlDbElementType.COLUMN);
    }

    public static boolean isQualifier(@NotNull PsiElement place, @NotNull ObjectKind qualifiedKind) {
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(184);
        }
        if (qualifiedKind == null) {
            SqlImplUtil.$$$reportNull$$$0(185);
        }
        if (!(place instanceof SqlReferenceExpression)) {
            return false;
        }
        PsiElement parent = place.getParent();
        if (!(parent instanceof SqlReferenceExpression)) {
            return false;
        }
        SqlReferenceExpression parentRef = (SqlReferenceExpression)parent;
        return parentRef.getQualifierExpression() == place && parentRef.getReferenceElementType().getTargetKind() == qualifiedKind;
    }

    public static boolean isColumnReference(@NotNull PsiElement place) {
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(186);
        }
        return place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getReferenceElementType().getTargetKind() == SqlDbElementType.COLUMN;
    }

    @NotNull
    public static JBIterable<? extends DasObject> getSiblingObjects(@NotNull SqlDefinition anchor, @NotNull Class<? extends SqlDefinition> targetClass) {
        if (anchor == null) {
            SqlImplUtil.$$$reportNull$$$0(187);
        }
        if (targetClass == null) {
            SqlImplUtil.$$$reportNull$$$0(188);
        }
        JBIterable jBIterable = SqlImplUtil.sqlChildren(SqlImplUtil.sqlParent((PsiElement)anchor)).filter(targetClass).filter(DbSqlUtilCore.byName((DasObject)anchor, null, DbImplUtilCore.getCasingProvider((DasObject)anchor)));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(189);
        }
        return jBIterable;
    }

    @NotNull
    public static DasType getObjectColumnDasType(@NotNull SqlLanguageDialectEx dialect, @NotNull DasColumn column2, JBIterable<DasColumn> children2) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(190);
        }
        if (column2 == null) {
            SqlImplUtil.$$$reportNull$$$0(191);
        }
        ProgressManager.checkCanceled();
        if (!children2.isEmpty()) {
            PsiElement resolved = DbSqlUtilCore.getPsiDelegate(column2);
            return SqlImplUtil.createTableTypeWithColumns(dialect, children2, resolved, (DasSymbol)((Object)column2));
        }
        DasType dasType = column2.getDasType();
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(192);
        }
        return dasType;
    }

    @NotNull
    public static SqlTableType createTableTypeWithColumns(@NotNull SqlLanguageDialectEx dialect, @NotNull JBIterable<DasColumn> dasColumns, @Nullable PsiElement resolved, @NotNull DasSymbol symbol) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(193);
        }
        if (dasColumns == null) {
            SqlImplUtil.$$$reportNull$$$0(194);
        }
        if (symbol == null) {
            SqlImplUtil.$$$reportNull$$$0(195);
        }
        ProgressManager.checkCanceled();
        String prefix = symbol.getKind() == SqlDbElementType.COLUMN ? symbol.getName() + "." : "";
        ArrayList<Column> columns = new ArrayList<Column>();
        List sortedColumns = dasColumns.sort(Comparator.comparing(DasNamed::getName)).toList();
        for (int i2 = 0; i2 < sortedColumns.size(); ++i2) {
            DasColumn current = (DasColumn)sortedColumns.get(i2);
            ArrayList<DasColumn> children2 = new ArrayList<DasColumn>();
            String currentName = current.getName();
            while (i2 + 1 < sortedColumns.size() && ((DasColumn)sortedColumns.get(i2 + 1)).getName().startsWith(currentName + ".")) {
                children2.add((DasColumn)sortedColumns.get(i2 + 1));
                ++i2;
            }
            DasType dasType = SqlImplUtil.getObjectColumnDasType(dialect, current, (JBIterable<DasColumn>)JBIterable.from(children2));
            columns.add(new Column(currentName.substring(prefix.length()), dasType, (DbColumn)current, (DbColumn)current));
        }
        return SqlImplUtil.createType(null, ":", columns, resolved);
    }

    @Nullable
    private static PsiElement getPossiblyInjectedElement(@NotNull PsiFile file, int offset) {
        PsiElement result2;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(196);
        }
        if ((result2 = InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, offset)) == null) {
            result2 = file.findElementAt(offset);
        }
        return result2;
    }

    @Nullable
    public static <T extends PsiElement> T getElementBySelection(@NotNull PsiFile file, int start2, int end, @NotNull Class<T> elementClass) {
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(197);
        }
        if (elementClass == null) {
            SqlImplUtil.$$$reportNull$$$0(198);
        }
        PsiElement element1 = SqlImplUtil.getPossiblyInjectedElement(file, start2);
        PsiElement element2 = SqlImplUtil.getPossiblyInjectedElement(file, end - 1);
        if (element1 instanceof PsiWhiteSpace) {
            element1 = file.findElementAt(element1.getTextRange().getEndOffset());
        }
        if (element2 instanceof PsiWhiteSpace) {
            element2 = file.findElementAt(element2.getTextRange().getStartOffset() - 1);
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)parent, elementClass, (boolean)false);
    }

    @NotNull
    public static String getEffectiveName(@NotNull String name2, boolean isQuoted, @NotNull Casing casing) {
        Case aCase;
        if (name2 == null) {
            SqlImplUtil.$$$reportNull$$$0(199);
        }
        if (casing == null) {
            SqlImplUtil.$$$reportNull$$$0(200);
        }
        if ((aCase = casing.choose(!isQuoted)) == Case.MIXED) {
            aCase = Case.LOWER;
        }
        String string = aCase.apply(name2);
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(201);
        }
        return string;
    }

    @NotNull
    public static DataType getNormalizedDataType(@NotNull SqlReferenceExpression expression) {
        SmartList refs;
        String typeName;
        Casing casing;
        block8: {
            if (expression == null) {
                SqlImplUtil.$$$reportNull$$$0(202);
            }
            casing = NamingServices.getNamingService(SqlImplUtil.getDbms((PsiElement)expression)).getDefaultCasing();
            typeName = SqlImplUtil.getEffectiveName(expression.getName(), expression.isQuoted(), casing);
            if (expression.getQualifierExpression() == null) {
                DataType dataType = DataTypeFactory.ofArgs(null, typeName, null, true);
                if (dataType == null) {
                    SqlImplUtil.$$$reportNull$$$0(203);
                }
                return dataType;
            }
            refs = new SmartList();
            SqlReferenceExpression ref2 = expression;
            while (true) {
                refs.add(ref2);
                SqlExpression qualifier = ref2.getQualifierExpression();
                if (qualifier == null) break block8;
                if (!(qualifier instanceof SqlReferenceExpression)) break;
                ref2 = (SqlReferenceExpression)qualifier;
            }
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(204);
            }
            return dataType;
        }
        if (refs.size() > 3) {
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(205);
            }
            return dataType;
        }
        SqlReferenceExpression leftmostRef = (SqlReferenceExpression)refs.get(refs.size() - 1);
        String schemaName = refs.size() > 1 ? SqlImplUtil.getEffectiveName(leftmostRef.getName(), leftmostRef.isQuoted(), casing) : null;
        String packageName = refs.size() == 3 ? SqlImplUtil.getEffectiveName(((SqlReferenceExpression)refs.get(1)).getName(), ((SqlReferenceExpression)refs.get(1)).isQuoted(), casing) : null;
        DataType dataType = DataTypeFactory.of(schemaName, packageName, typeName, -1, 0, null, null, false, true);
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(206);
        }
        return dataType;
    }

    public static boolean traverseDataSources(@NotNull List<DbDataSource> roots2, @Nullable SqlImportState importChecker, @NotNull Predicate<DbDataSource> consumer) {
        if (roots2 == null) {
            SqlImplUtil.$$$reportNull$$$0(207);
        }
        if (consumer == null) {
            SqlImplUtil.$$$reportNull$$$0(208);
        }
        HashSet<String> visited = new HashSet<String>();
        ArrayList<DbDataSource> queue = new ArrayList<DbDataSource>(roots2);
        while (!queue.isEmpty()) {
            DbDataSource dataSource = (DbDataSource)queue.remove(0);
            if (!visited.add(dataSource.getUniqueId()) || importChecker != null && !importChecker.isImported(dataSource.getDelegate(), null)) continue;
            if (!consumer.test(dataSource)) {
                return false;
            }
            RawDataSource d = dataSource.getDelegate();
            if (!(d instanceof SqlDataSource)) continue;
            ContainerUtil.addIfNotNull(queue, (Object)((SqlDataSource)d).getParentDataSource());
        }
        return true;
    }

    public static boolean processSqlDataSourceFiles(@NotNull SqlDataSource dataSource, @NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull PsiFile contextFile, @NotNull PsiElement place) {
        if (dataSource == null) {
            SqlImplUtil.$$$reportNull$$$0(209);
        }
        if (processor2 == null) {
            SqlImplUtil.$$$reportNull$$$0(210);
        }
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(211);
        }
        if (contextFile == null) {
            SqlImplUtil.$$$reportNull$$$0(212);
        }
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(213);
        }
        for (SqlFile file : dataSource.getSqlFiles()) {
            if (file.processDeclarations(processor2, state, (PsiElement)contextFile, place)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRefWithDblink(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(214);
        }
        PsiElement last = e.getLastChild();
        return e instanceof SqlReferenceExpression && last instanceof SqlReferenceExpression && ((SqlReferenceExpression)last).getReferenceElementType().getTargetKind() == ObjectKind.DB_LINK;
    }

    public static boolean processExcludedRefInInsertConflict(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2, @NotNull ReservedEntity targetEntity) {
        SyntaxTraverser.ApiEx api;
        PsiElement conflictAction;
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(215);
        }
        if (processor2 == null) {
            SqlImplUtil.$$$reportNull$$$0(216);
        }
        if (targetEntity == null) {
            SqlImplUtil.$$$reportNull$$$0(217);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, targetEntity.name, resolve2) && (conflictAction = (PsiElement)(api = SyntaxTraverser.psiApi()).parents((Object)place).filter(SqlImplUtil.isType((IElementType)SqlCompositeElementTypes.SQL_CONFLICT_ACTION_CLAUSE)).first()) != null && !api.children((Object)conflictAction).filter(SqlImplUtil.isType((IElementType)SqlCommonKeywords.SQL_UPDATE)).isEmpty()) {
            Object entityType;
            SqlDmlInstruction insert = (SqlDmlInstruction)api.parents((Object)place).filter(SqlDmlInstruction.class).first();
            DasBuiltinType<?> type = insert == null ? DasTypeSystemBase.UNKNOWN : insert.getTargetExpression().getDasType();
            Object object = entityType = type == DasTypeSystemBase.UNKNOWN ? SqlTableTypeBase.EMPTY_TABLE : type;
            if (!processor2.executeTarget((DasSymbol)targetEntity, (DasType)entityType, null, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    public static boolean isRecursive(@NotNull SqlTableDefinition table) {
        if (table == null) {
            SqlImplUtil.$$$reportNull$$$0(218);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)table, () -> CachedValueProvider.Result.create((Object)SqlImplUtil.calcIsRecursive(table), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static int findColumnByElement(@NotNull SqlTableType type, @Nullable PsiElement element) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(219);
        }
        if (element == null) {
            return -1;
        }
        int count = type.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            PsiElement columnElement = type.getColumnElement(i2);
            PsiElement sourceElement = type.getSourceColumnElement(i2);
            if (!columnElement.isEquivalentTo(element) && (sourceElement == null || !sourceElement.isEquivalentTo(element))) continue;
            return i2;
        }
        return -1;
    }

    public static boolean hasNonEditableFragment(@NotNull Document document, @NotNull PsiElement element) {
        if (document == null) {
            SqlImplUtil.$$$reportNull$$$0(220);
        }
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(221);
        }
        TextRange range = element.getTextRange();
        if (document instanceof DocumentWindow) {
            DocumentWindow window = (DocumentWindow)document;
            TextRange nonEditableRange = TextRangeUtil.getEnclosingTextRange((List)InjectedLanguageManager.getInstance((Project)element.getProject()).getNonEditableFragments(window));
            return nonEditableRange.intersects(range);
        }
        return document.getRangeGuard(range.getStartOffset(), range.getEndOffset()) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canBeQualifier(@NotNull ResolveResult resolveResult) {
        PsiElement element;
        if (resolveResult == null) {
            SqlImplUtil.$$$reportNull$$$0(222);
        }
        if (!((element = resolveResult.getElement()) instanceof DasObject)) return false;
        DasObject dasObject = (DasObject)element;
        if (!SqlImplUtil.getSqlDialectSafe(element).canBeQualifier(dasObject)) return false;
        return true;
    }

    private static boolean calcIsRecursive(@NotNull SqlTableDefinition table) {
        SqlExpression expression;
        if (table == null) {
            SqlImplUtil.$$$reportNull$$$0(223);
        }
        if (!((expression = table.getQueryExpression()) instanceof SqlQueryExpression)) {
            return false;
        }
        SqlTableExpression tableExpression = ((SqlQueryExpression)expression).getTableExpression();
        if (tableExpression == null) {
            return false;
        }
        SqlFromClause fromClause = tableExpression.getFromClause();
        if (fromClause == null) {
            return false;
        }
        SqlExpression fromExpression = fromClause.getFromExpression();
        if (fromExpression == null) {
            return false;
        }
        for (SqlReferenceExpression ref2 : SqlImplUtil.sqlTraverser((PsiElement)fromExpression).filter(SqlReferenceExpression.class)) {
            if (!ref2.getReference().isReferenceTo((PsiElement)table)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<SqlReferenceExpression> getNonAggregateColumnRefs(@NotNull SqlQueryExpression o) {
        SqlSelectClause selectClause;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(224);
        }
        if ((selectClause = o.getSelectClause()) == null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(225);
            }
            return list;
        }
        SqlTableExpression tableExpression = o.getTableExpression();
        if (tableExpression == null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(226);
            }
            return list;
        }
        final PsiElement table = SqlImplUtil.resolveTable(tableExpression);
        final List columns = table instanceof SqlAsExpression ? ((SqlAsExpression)table).getColumnAliasList() : (table instanceof DasObject ? DasUtil.getColumns((DasObject)table).filter(PsiElement.class).toList() : ContainerUtil.emptyList());
        final boolean checkAggregatesPresent = SqlImplUtil.getSqlDialectSafe((PsiElement)o).getDbms().isH2() || tableExpression.getGroupByClause() == null;
        final boolean[] hasAggregates = new boolean[]{false};
        final SmartList nonAggregatedRefs = new SmartList();
        selectClause.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                SqlReferenceExpression ref2;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (element instanceof SqlQueryExpression) {
                    return;
                }
                super.visitElement(element);
                if (checkAggregatesPresent && !hasAggregates[0] && element instanceof SqlFunctionCallExpression) {
                    hasAggregates[0] = SqlImplUtil.isAggregate((SqlFunctionCallExpression)element, false);
                }
                if (element instanceof SqlReferenceExpression && (ref2 = (SqlReferenceExpression)element).getNode().getElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE && !SqlImplUtil.inAggregateFunctionCall(ref2) && SqlImplUtil.isHighlightableForGroupBy(table, columns, ref2)) {
                    nonAggregatedRefs.add((Object)ref2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil$3", "visitElement"));
            }
        });
        Object object = checkAggregatesPresent && !hasAggregates[0] ? Collections.emptyList() : nonAggregatedRefs;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(227);
        }
        return object;
    }

    private static boolean isHighlightableForGroupBy(PsiElement table, List<? extends PsiElement> columns, SqlReferenceExpression e) {
        ObjectKind targetSymKind;
        SqlClause clause = (SqlClause)PsiTreeUtil.getContextOfType((PsiElement)e, SqlClause.class, (boolean)true, (Class[])new Class[]{SqlStatement.class});
        if (clause != null && !(clause instanceof SqlSelectClause)) {
            return false;
        }
        DasSymbol targetSym = e.resolveSymbol();
        ObjectKind objectKind = targetSymKind = targetSym != null ? targetSym.getKind() : null;
        if (targetSymKind != SqlDbElementType.COLUMN) {
            return false;
        }
        SqlResultSetExpression expression = SqlImplUtil.findResultSetExpression(e);
        if (expression == null) {
            return true;
        }
        if (SqlImplUtil.isCorrelatedQuery(expression, table)) {
            return columns.contains(e.resolve());
        }
        if (expression instanceof SqlQueryExpression) {
            SqlFromClause fromClause;
            SqlTableExpression tableExpression = ((SqlQueryExpression)expression).getTableExpression();
            SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
            if (fromClause != null && fromClause.getFromExpression() instanceof SqlAsExpression) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static SqlResultSetExpression findResultSetExpression(SqlReferenceExpression e) {
        SqlParenthesizedExpression parenthesized = (SqlParenthesizedExpression)PsiTreeUtil.getContextOfType((PsiElement)e, (Class[])new Class[]{SqlParenthesizedExpression.class});
        if (parenthesized == null) {
            return null;
        }
        for (SqlExpression expression : parenthesized.getExpressionList()) {
            if (!(expression instanceof SqlResultSetExpression) || !PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)e, (boolean)true)) continue;
            return (SqlResultSetExpression)expression;
        }
        return null;
    }

    private static boolean inAggregateFunctionCall(SqlReferenceExpression ref2) {
        SqlFunctionCallExpression call = SqlImplUtil.getFunctionCallParent((PsiElement)ref2);
        while (call != null) {
            if (SqlImplUtil.isAggregate(call, true)) {
                return true;
            }
            call = SqlImplUtil.getFunctionCallParent((PsiElement)call);
        }
        return false;
    }

    @Nullable
    private static SqlFunctionCallExpression getFunctionCallParent(@Nullable PsiElement o) {
        return (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlFunctionCallExpression.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class});
    }

    private static boolean isAggregate(@Nullable SqlFunctionCallExpression call, boolean allowAnalyticClause) {
        if (call == null) {
            return false;
        }
        BuiltinFunction definition = call.getFunctionDefinition();
        if (definition == null) {
            return false;
        }
        return !(!"true".equals(definition.getDialectAttribute("analytic")) && !"true".equals(definition.getDialectAttribute("aggregate")) || !allowAnalyticClause && PsiTreeUtil.findSiblingForward((PsiElement)call.getFirstChild(), (IElementType)SqlCompositeElementTypes.SQL_ANALYTIC_CLAUSE, (boolean)true, null) != null);
    }

    public static boolean isCorrelatedQuery(@NotNull SqlResultSetExpression expression, @Nullable PsiElement table) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(228);
        }
        if (!(expression instanceof SqlQueryExpression)) {
            return false;
        }
        SqlQueryExpression query = (SqlQueryExpression)expression;
        PsiElement queryTable = SqlImplUtil.resolveTable(query.getTableExpression());
        return queryTable == null || !table.equals(queryTable);
    }

    @Nullable
    public static PsiElement resolveTable(@Nullable SqlTableExpression tableExpression) {
        if (tableExpression == null) {
            return null;
        }
        SqlFromClause fromClause = tableExpression.getFromClause();
        if (fromClause == null) {
            return null;
        }
        SqlExpression fromExpression = fromClause.getFromExpression();
        if (fromExpression == null) {
            return null;
        }
        if (fromExpression instanceof SqlAsExpression) {
            SqlAsExpression alias = (SqlAsExpression)fromExpression;
            fromExpression = alias.getExpression();
        }
        if (!(fromExpression instanceof SqlReferenceExpression)) {
            return null;
        }
        SqlReferenceExpression ref2 = (SqlReferenceExpression)fromExpression;
        return ref2.resolve();
    }

    @NotNull
    private static JBIterable<PsiElement> getResolvesNotInGroupBy(@NotNull SqlReferenceExpression ref2, @Nullable SqlGroupByClause groupByClause) {
        if (ref2 == null) {
            SqlImplUtil.$$$reportNull$$$0(229);
        }
        JBIterable allColumns = JBIterable.from(DbSqlUtilCore.resolveToColumnList(ref2));
        for (PsiElement column2 : allColumns) {
            if (!(column2 instanceof SqlAsExpression) && column2 != ref2) continue;
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(230);
            }
            return jBIterable;
        }
        if (groupByClause == null) {
            JBIterable jBIterable = allColumns;
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(231);
            }
            return jBIterable;
        }
        LocalSearchScope scope2 = new LocalSearchScope((PsiElement)groupByClause);
        SmartHashSet posRefTargets = new SmartHashSet();
        for (SqlPositionalReference posRef : SqlImplUtil.sqlChildren((PsiElement)groupByClause).filter(SqlPositionalReference.class)) {
            PsiElement target2 = posRef.resolve();
            if (target2 instanceof SqlImplicitSymbol) {
                target2 = ((SqlImplicitSymbol)target2).getTargetDefinition();
            }
            if (target2 == null) continue;
            posRefTargets.add((Object)target2);
        }
        SqlExpression topExpression = SqlImplUtil.getTopExpression(ref2);
        if (topExpression != null && SqlImplUtil.hasUsages((PsiElement)topExpression, (SearchScope)scope2, (Set<PsiElement>)posRefTargets)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(232);
            }
            return jBIterable;
        }
        if ((allColumns = allColumns.filter(element -> !SqlImplUtil.hasUsages(element, (SearchScope)scope2, (Set<PsiElement>)posRefTargets))).isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(233);
            }
            return jBIterable;
        }
        JBIterable jBIterable = topExpression instanceof SqlAsExpression ? JBIterable.of((Object)topExpression) : allColumns;
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(234);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> getResolvesNotInGroupBy(@NotNull SqlReferenceExpression ref2, @Nullable SqlQueryExpression o) {
        if (ref2 == null) {
            SqlImplUtil.$$$reportNull$$$0(235);
        }
        return SqlImplUtil.getResolvesNotInGroupBy(ref2, o == null || o.getTableExpression() == null ? null : o.getTableExpression().getGroupByClause());
    }

    private static boolean hasUsages(@NotNull PsiElement element, @NotNull SearchScope scope2, @NotNull Set<PsiElement> extraTargets) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(236);
        }
        if (scope2 == null) {
            SqlImplUtil.$$$reportNull$$$0(237);
        }
        if (extraTargets == null) {
            SqlImplUtil.$$$reportNull$$$0(238);
        }
        return extraTargets.contains(element) || ReferencesSearch.search((PsiElement)element, (SearchScope)scope2).findFirst() != null;
    }

    private static SqlExpression getTopExpression(@NotNull SqlReferenceExpression ref2) {
        if (ref2 == null) {
            SqlImplUtil.$$$reportNull$$$0(239);
        }
        SqlReferenceExpression e = ref2;
        SqlReferenceExpression top = ref2;
        while (!(e instanceof SqlSelectClause || e instanceof SqlQueryExpression || e instanceof PsiFile)) {
            if (!((e = e.getParent()) instanceof SqlExpression)) continue;
            top = (SqlExpression)e;
        }
        return top;
    }

    @NotNull
    public static String getResolvedColumnName(@NotNull DatabaseDialectEx dialect, @NotNull SqlReferenceExpression ref2, @NotNull PsiElement resolved) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(240);
        }
        if (ref2 == null) {
            SqlImplUtil.$$$reportNull$$$0(241);
        }
        if (resolved == null) {
            SqlImplUtil.$$$reportNull$$$0(242);
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref2.getDasType(), SqlTableType.class);
        SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe((PsiElement)ref2);
        if (type == null || ref2.getReference().isReferenceTo(resolved)) {
            String string = ref2.getReference().getCanonicalText();
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(243);
            }
            return string;
        }
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            if (type.getColumnElement(i2) != resolved) continue;
            DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(ref2.getProject(), sqlDialect).withDialect(dialect);
            String name2 = StringUtil.notNullize((String)type.getColumnName(i2));
            String typeAlias = type.getColumnTypeAlias(i2);
            if (typeAlias == null) {
                String string = ref2.getReference().getCanonicalText();
                if (string == null) {
                    SqlImplUtil.$$$reportNull$$$0(244);
                }
                return string;
            }
            builder.columnRef(typeAlias).symbol(".").columnRef(name2);
            String string = builder.getStatement();
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(245);
            }
            return string;
        }
        String string = ref2.getReference().getCanonicalText();
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(246);
        }
        return string;
    }

    @NotNull
    public static Collection<DasObject> getAllUsingTargets(@NotNull SqlUsingClause usingClause) {
        SqlReferenceList refList;
        if (usingClause == null) {
            SqlImplUtil.$$$reportNull$$$0(247);
        }
        if ((refList = usingClause.getReferenceList()) == null) {
            Set<DasObject> set = Collections.emptySet();
            if (set == null) {
                SqlImplUtil.$$$reportNull$$$0(248);
            }
            return set;
        }
        List refs = refList.getReferenceList();
        List list = ContainerUtil.flatMap((Iterable)refs, ref2 -> ContainerUtil.mapNotNull((Object[])ref2.multiResolve(false), r -> {
            DasSymbol symbol = DasSymbolUtil.getSymbol(r);
            return symbol != null ? symbol.getDasObject() : null;
        }));
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(249);
        }
        return list;
    }

    @NotNull
    private static Condition<PsiElement> isType(IElementType type) {
        Condition condition = Conditions.compose((Function)SyntaxTraverser.psiApi().TO_TYPE, (Condition)Conditions.is((Object)type));
        if (condition == null) {
            SqlImplUtil.$$$reportNull$$$0(250);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 8, 9, 10, 12, 13, 14, 16, 18, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 36, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 51, 53, 54, 55, 56, 57, 58, 59, 60, 62, 63, 67, 71, 72, 73, 75, 76, 78, 79, 82, 83, 85, 90, 94, 95, 96, 97, 98, 99, 100, 103, 105, 107, 108, 109, 110, 111, 112, 113, 119, 120, 121, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 141, 148, 150, 152, 155, 156, 157, 160, 162, 163, 164, 165, 166, 168, 169, 170, 172, 177, 178, 179, 180, 181, 183, 184, 185, 186, 187, 188, 190, 191, 193, 194, 195, 196, 197, 198, 199, 200, 202, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 228, 229, 235, 236, 237, 238, 239, 240, 241, 242, 247 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 1: 
            case 2: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: 
            case 18: 
            case 25: 
            case 29: 
            case 32: 
            case 40: 
            case 43: 
            case 46: 
            case 190: 
            case 193: 
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 16: 
            case 39: 
            case 85: 
            case 98: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 108: 
            case 121: 
            case 123: 
            case 124: 
            case 141: 
            case 157: 
            case 160: 
            case 181: 
            case 221: 
            case 236: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 24: 
            case 107: 
            case 128: 
            case 170: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 30: 
            case 44: 
            case 72: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 34: 
            case 48: 
            case 51: 
            case 112: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 36: 
            case 38: 
            case 71: 
            case 148: 
            case 150: 
            case 177: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryExpression";
                break;
            }
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 75: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 76: 
            case 133: 
            case 202: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 94: 
            case 96: 
            case 109: 
            case 130: 
            case 210: 
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 95: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpFile";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeType";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
            case 134: 
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 135: 
            case 152: 
            case 166: 
            case 196: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colList";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgt";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectClause";
                break;
            }
            case 183: 
            case 184: 
            case 186: 
            case 213: 
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedKind";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasColumns";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEntity";
                break;
            }
            case 218: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 229: 
            case 235: 
            case 239: 
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraTargets";
                break;
            }
            case 242: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usingClause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceList";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 82: 
            case 83: 
            case 85: 
            case 90: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 103: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 119: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 141: 
            case 148: 
            case 150: 
            case 152: 
            case 155: 
            case 156: 
            case 157: 
            case 160: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 168: 
            case 169: 
            case 170: 
            case 172: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 202: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 228: 
            case 229: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 247: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 26: 
            case 27: 
            case 35: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElement";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildDasType";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRebuiltDasType";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingElements";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevTraverser";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevChildren";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlChildrenNoWS";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "byElementType";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlParents";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCompositeElements";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectType";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeLateralAware";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualified";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectSafe";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTraverser";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlChildren";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasedPart";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLong";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicateSpaces";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabels";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLabels";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindSynonymAware";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheableDasType";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "processColumnList";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "getTriggerEvents";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "getTupleType";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "getTupleDasType";
                break;
            }
            case 149: 
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "filterHiddenColumns";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbVersions";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierKind";
                break;
            }
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierDasType";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateStatementsBackward";
                break;
            }
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedElements";
                break;
            }
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRelatedElements";
                break;
            }
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFake";
                break;
            }
            case 189: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingObjects";
                break;
            }
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectColumnDasType";
                break;
            }
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveName";
                break;
            }
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedDataType";
                break;
            }
            case 225: 
            case 226: 
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonAggregateColumnRefs";
                break;
            }
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvesNotInGroupBy";
                break;
            }
            case 243: 
            case 244: 
            case 245: 
            case 246: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedColumnName";
                break;
            }
            case 248: 
            case 249: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUsingTargets";
                break;
            }
            case 250: {
                objectArray = objectArray2;
                objectArray2[1] = "isType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedElements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMirror";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModifiedState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setImmediateQualifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setImmediateTarget";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processQualifierImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCasingProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDasType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElement";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "rebuildDasType";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "computeRebuiltDasType";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateQualifier";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateTarget";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getLastQueryExpression";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setLastQueryExpression";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "revSiblings";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingElements";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "siblings";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "siblingsNoDummy";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "byElementType";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "convertToTableType";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getSelectType";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheLeftOfType";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getTypeLateralAware";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheRightOfType";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getBlockContentElement";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getMinDbmsVersion";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getCasedPart";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingOneOf";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingChildOf";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isAsteriskRef";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getAsterisk";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getLabels";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "calcLabels";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "calcPosition";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "ignoreKinds";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getAnyRoot";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "wrapObjectToPsi";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelSqlFile";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "isSameSqlFileDialect";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSystem";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getScopingType";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getScopingExpression";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getCacheableDasType";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "hasLocationOf";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "treeWalkUp";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "isMarkedUnresolved";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getTableTypeOfColumnList";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierKind";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "processColumnList";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "getTriggerEvents";
                break;
            }
            case 148: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "filterHiddenColumns";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "getDbVersions";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "canUnquote";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierKind";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierDasType";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "isAutoVal";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "isComputedVal";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "iterateStatementsBackward";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "mergeColumnListInto";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedElements";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "calcRelatedElements";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "indicesOfImmediateSource";
                break;
            }
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "inColumnProvidingContext";
                break;
            }
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "getSelectExpression";
                break;
            }
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "isColumnQualifier";
                break;
            }
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "isQualifier";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "isColumnReference";
                break;
            }
            case 187: 
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingObjects";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "getObjectColumnDasType";
                break;
            }
            case 193: 
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "createTableTypeWithColumns";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "getPossiblyInjectedElement";
                break;
            }
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "getElementBySelection";
                break;
            }
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveName";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedDataType";
                break;
            }
            case 207: 
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "traverseDataSources";
                break;
            }
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "processSqlDataSourceFiles";
                break;
            }
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "isRefWithDblink";
                break;
            }
            case 215: 
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "processExcludedRefInInsertConflict";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "isRecursive";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "findColumnByElement";
                break;
            }
            case 220: 
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "hasNonEditableFragment";
                break;
            }
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "canBeQualifier";
                break;
            }
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "calcIsRecursive";
                break;
            }
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "getNonAggregateColumnRefs";
                break;
            }
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "isCorrelatedQuery";
                break;
            }
            case 229: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "getResolvesNotInGroupBy";
                break;
            }
            case 236: 
            case 237: 
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "hasUsages";
                break;
            }
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "getTopExpression";
                break;
            }
            case 240: 
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedColumnName";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "getAllUsingTargets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 8, 9, 10, 12, 13, 14, 16, 18, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 36, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 51, 53, 54, 55, 56, 57, 58, 59, 60, 62, 63, 67, 71, 72, 73, 75, 76, 78, 79, 82, 83, 85, 90, 94, 95, 96, 97, 98, 99, 100, 103, 105, 107, 108, 109, 110, 111, 112, 113, 119, 120, 121, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 141, 148, 150, 152, 155, 156, 157, 160, 162, 163, 164, 165, 166, 168, 169, 170, 172, 177, 178, 179, 180, 181, 183, 184, 185, 186, 187, 188, 190, 191, 193, 194, 195, 196, 197, 198, 199, 200, 202, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 228, 229, 235, 236, 237, 238, 239, 240, 241, 242, 247 -> new IllegalArgumentException(string);
        };
    }

    public static class Column {
        public final String name;
        public final DasType dasType;
        public final PsiElement element;
        public final PsiElement sourceElement;

        public Column(String name2, DasType dasType, @NotNull PsiElement element, PsiElement sourceElement) {
            if (element == null) {
                Column.$$$reportNull$$$0(0);
            }
            this.name = name2;
            this.dasType = dasType;
            this.element = element;
            this.sourceElement = sourceElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil$Column", "<init>"));
        }
    }

    private static class MyColumnInfo
    extends RenameableFakePsiElement
    implements PsiColumn,
    SqlTypedDefinition,
    PsiColumnWithSymbol {
        final SqlTableDefinition myTableInfo;
        final int myIndex;
        final SqlTableType myTableType;
        final DasObject myInfo;

        MyColumnInfo(@NotNull SqlTableDefinition parent, int index, @NotNull SqlTableType tableType2) {
            if (parent == null) {
                MyColumnInfo.$$$reportNull$$$0(0);
            }
            if (tableType2 == null) {
                MyColumnInfo.$$$reportNull$$$0(1);
            }
            super((PsiElement)parent.getContainingFile());
            this.myTableInfo = parent;
            this.myIndex = index;
            this.myTableType = tableType2;
            PsiElement columnElement = tableType2.getSourceColumnElement(index);
            this.myInfo = (DasObject)ObjectUtils.tryCast((Object)columnElement, DasObject.class);
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)this.myTableInfo);
            if (dbms == null) {
                MyColumnInfo.$$$reportNull$$$0(2);
            }
            return dbms;
        }

        @Override
        @NotNull
        public PsiColumn getDasObject() {
            MyColumnInfo myColumnInfo = this;
            if (myColumnInfo == null) {
                MyColumnInfo.$$$reportNull$$$0(3);
            }
            return myColumnInfo;
        }

        public boolean isNameQuoted() {
            return this.myTableType.isColumnQuoted(this.myIndex);
        }

        @Override
        public DasTable getTable() {
            return this.myTableInfo;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.COLUMN;
            if (objectKind == null) {
                MyColumnInfo.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myTableType.getColumnName(this.myIndex), (String)DasUtil.NO_NAME);
            if (string == null) {
                MyColumnInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        public String getComment() {
            return this.myInfo == null ? null : this.myInfo.getComment();
        }

        @Override
        public DasObject getDasParent() {
            return this.getTable();
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        @Override
        @NotNull
        public DasType getDasType() {
            DasType dasType = this.myTableType.getColumnDasType(this.myIndex);
            if (dasType == null) {
                MyColumnInfo.$$$reportNull$$$0(6);
            }
            return dasType;
        }

        @Override
        public boolean isNotNull() {
            return this.myInfo instanceof DasTypedObject && ((DasTypedObject)this.myInfo).isNotNull();
        }

        @Override
        public String getDefault() {
            return this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDefault() : null;
        }

        public PsiElement getParent() {
            return this.myTableInfo;
        }

        public String getTypeName() {
            return DbPresentationCore.getPresentableName(this.getKind(), DbImplUtilCore.getDbms((DasObject)this.myTableInfo));
        }

        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myTableType.getColumnElement(this.myIndex);
            if (psiElement == null) {
                MyColumnInfo.$$$reportNull$$$0(7);
            }
            return psiElement;
        }

        @Override
        public short getPosition() {
            return (short)(this.myIndex + 1);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return null;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return null;
        }

        public void accept(SqlVisitor visitor2) {
            visitor2.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor2) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
        }

        public boolean isEquivalentTo(PsiElement another) {
            if (!(another instanceof MyColumnInfo)) {
                return false;
            }
            MyColumnInfo info2 = (MyColumnInfo)another;
            return this.myIndex == info2.myIndex && Objects.equals(this.myTableInfo, info2.myTableInfo) && Objects.equals(this.myInfo, info2.myInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasObject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ValuesTableType
    extends SqlTableTypeBase {
        private final SqlExpressionList myExpressionList;
        private final List<SqlColumnSymbol> myColumns = new ArrayList<SqlColumnSymbol>();

        public ValuesTableType(SqlExpressionList list) {
            this.myExpressionList = list;
            Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)list).getDbms();
            String prefix = ValuesTableType.getColumnNamePrefix(dbms);
            boolean needQuotes = prefix.isEmpty();
            List expressions = this.myExpressionList.getExpressionList();
            int size = expressions.size();
            for (int i2 = 0; i2 < size; ++i2) {
                final SqlExpression expression = (SqlExpression)expressions.get(i2);
                String name2 = this.calcColumnName(i2, prefix, dbms);
                SqlColumnSymbol symbol = new SqlColumnSymbol(name2, needQuotes, (PsiElement)expression, i2, null, null){

                    @Override
                    @NotNull
                    public DasType getType() {
                        DasType dasType = expression.getDasType();
                        if (dasType == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return dasType;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableType$1", "getType"));
                    }
                };
                this.myColumns.add(symbol);
            }
        }

        @NotNull
        private static String getColumnNamePrefix(@NotNull Dbms dbms) {
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(0);
            }
            if (dbms.isH2() || dbms.isHsqldb()) {
                return "C";
            }
            if (dbms.isSqlite() || dbms == Dbms.POSTGRES || dbms == Dbms.GREENPLUM || dbms == Dbms.COCKROACH) {
                return "column";
            }
            if (dbms.isSnowflake()) {
                return "COLUMN";
            }
            return "";
        }

        @NotNull
        private String calcColumnName(int i2, @NotNull String prefix, @NotNull Dbms dbms) {
            if (prefix == null) {
                ValuesTableType.$$$reportNull$$$0(1);
            }
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(2);
            }
            int num = i2 + 1;
            if (!prefix.isEmpty()) {
                String string = prefix + num;
                if (string == null) {
                    ValuesTableType.$$$reportNull$$$0(3);
                }
                return string;
            }
            PsiElement columnElement = this.getColumnElement(i2);
            if (dbms == Dbms.MARIA) {
                String string = columnElement instanceof SqlStringLiteralExpression ? StringUtil.notNullize((String)((SqlStringLiteralExpression)columnElement).getValue()) : columnElement.getText();
                if (string == null) {
                    ValuesTableType.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = columnElement instanceof SqlDefinition ? ((SqlDefinition)columnElement).getName() : String.valueOf(num);
            if (string == null) {
                ValuesTableType.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public DataType toDataType() {
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                ValuesTableType.$$$reportNull$$$0(6);
            }
            return dataType;
        }

        @NotNull
        public List<DasObject> getMethods() {
            List<DasObject> list = Collections.emptyList();
            if (list == null) {
                ValuesTableType.$$$reportNull$$$0(7);
            }
            return list;
        }

        public int getColumnCount() {
            return this.myExpressionList.getExpressionList().size();
        }

        public String getColumnName(int i2) {
            return this.myColumns.get(i2).getName();
        }

        public boolean isColumnQuoted(int i2) {
            return this.myColumns.get(i2).isQuoted();
        }

        public DasType getColumnDasType(int i2) {
            return ((SqlExpression)this.myExpressionList.getExpressionList().get(i2)).getDasType();
        }

        @Nullable
        public PsiElement getColumnQualifier(int i2) {
            return this.myExpressionList;
        }

        @NotNull
        public PsiElement getColumnElement(int i2) {
            PsiElement psiElement = (PsiElement)this.myExpressionList.getExpressionList().get(i2);
            if (psiElement == null) {
                ValuesTableType.$$$reportNull$$$0(8);
            }
            return psiElement;
        }

        @Nullable
        public PsiElement getSourceColumnElement(int i2) {
            return (PsiElement)this.myColumns.get(i2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcColumnName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toDataType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethods";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnNamePrefix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "calcColumnName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static class EmptyTable
    implements DasTable {
        private EmptyTable() {
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.TABLE;
            if (objectKind == null) {
                EmptyTable.$$$reportNull$$$0(0);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                EmptyTable.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isQuoted() {
            return true;
        }

        @Override
        public boolean isSystem() {
            return false;
        }

        @Override
        public boolean isTemporary() {
            return false;
        }

        @Override
        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c2) {
            if (c2 instanceof PsiElement && SqlImplUtil.getSqlDialectSafe((PsiElement)c2).isAutoIncrementColumn(c2)) {
                EnumSet<DasColumn.Attribute> enumSet = EnumSet.of(DasColumn.Attribute.AUTO_GENERATED);
                if (enumSet == null) {
                    EmptyTable.$$$reportNull$$$0(2);
                }
                return enumSet;
            }
            Set<DasColumn.Attribute> set = DasUtil.NO_ATTRS;
            if (set == null) {
                EmptyTable.$$$reportNull$$$0(3);
            }
            return set;
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$EmptyTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static final class TokenSets {
        public static final BracePair[] BRACE_PAIRS = new BracePair[]{new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_PAREN, (IElementType)SqlCommonTokens.SQL_RIGHT_PAREN, true), new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_BRACE, (IElementType)SqlCommonTokens.SQL_RIGHT_BRACE, false), new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_BRACKET, (IElementType)SqlCommonTokens.SQL_RIGHT_BRACKET, false), new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_ANGLES, (IElementType)SqlCommonTokens.SQL_RIGHT_ANGLES, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_RQUOTE, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_PARAM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_PARAM_RQUOTE, false)};
    }
}

