/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.instructions.SqlExitInstruction;
import com.intellij.sql.dataFlow.instructions.SqlFlowGraph;
import com.intellij.sql.dataFlow.instructions.SqlInstruction;
import com.intellij.sql.dataFlow.instructions.SqlJumpInstruction;
import com.intellij.sql.dataFlow.instructions.SqlNondeterministicJumpInstruction;
import com.intellij.sql.dataFlow.instructions.SqlReturnInstruction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlMissingReturnInspection;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlControlFlowHolder;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlMissingReturnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlMissingReturnInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!dialect.getDbms().isOracle()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2, onTheFly){
            final /* synthetic */ boolean $onTheFly;
            {
                this.$onTheFly = $onTheFly;
                super($manager, $dialect, (Collection<ProblemDescriptor>)$result);
            }

            /*
             * WARNING - void declaration
             */
            public void visitSqlCreateProcedureStatement(SqlCreateProcedureStatement o) {
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlCreateProcedureStatement(o);
                if (!(o instanceof SqlCreateFunctionStatementImpl) || ((SqlCreateFunctionStatementImpl)o).getBody().isEmpty()) {
                    return;
                }
                SqlFlowGraph flowGraph = FlowUtilKt.buildFlowGraph((SqlRoutineDefinition)o);
                Set<SqlInstruction> unreachableInstructions = FlowUtilKt.findUnreachableInstructions(flowGraph);
                JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser(arg_0 -> createAnnotationVisitor.1.visitSqlCreateProcedureStatement$lambda$1(createAnnotationVisitor.1::visitSqlCreateProcedureStatement$lambda$0, arg_0)).withRoot((Object)flowGraph.getExitPoint())).expandAndSkip(arg_0 -> createAnnotationVisitor.1.visitSqlCreateProcedureStatement$lambda$3(createAnnotationVisitor.1::visitSqlCreateProcedureStatement$lambda$2, arg_0))).postOrderDfsTraversal().filter(arg_0 -> createAnnotationVisitor.1.visitSqlCreateProcedureStatement$lambda$5(arg_0 -> createAnnotationVisitor.1.visitSqlCreateProcedureStatement$lambda$4(unreachableInstructions, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Object object = (Iterable)jBIterable;
                Collection destination$iv = new LinkedHashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    SqlInstruction sqlInstruction = (SqlInstruction)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getOwnerGraph().getSource());
                }
                LinkedHashSet badElements = (LinkedHashSet)destination$iv;
                Iterator<E> iterator = badElements.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                object = iterator;
                while (object.hasNext()) {
                    E e = object.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    SqlControlFlowHolder badElement = (SqlControlFlowHolder)e;
                    JBIterable jBIterable2 = badElement.getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"getBody(...)");
                    SqlElement sqlElement = (SqlElement)CollectionsKt.lastOrNull((Iterable)((Iterable)jBIterable2));
                    if (sqlElement == null || (sqlElement = this.getAnchor(sqlElement)) == null) continue;
                    this.reportProblem((PsiElement)sqlElement);
                }
            }

            private final PsiElement getAnchor(SqlElement $this$getAnchor) {
                PsiElement psiElement;
                if ($this$getAnchor instanceof SqlBlockStatement) {
                    psiElement = ((SqlBlockStatement)$this$getAnchor).getExceptionClause();
                    if (psiElement == null || (psiElement = psiElement.getFirstChild()) == null) {
                        psiElement = ((SqlBlockStatement)$this$getAnchor).getLastChild();
                    }
                } else {
                    psiElement = $this$getAnchor.getFirstChild();
                }
                return psiElement;
            }

            private final void reportProblem(PsiElement anchor) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor, SqlBundle.message((String)"inspection.message.missing.return.statement", (Object[])new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }

            private static final Iterable visitSqlCreateProcedureStatement$lambda$0(SqlInstruction it) {
                return it.getPredecessors();
            }

            private static final Iterable visitSqlCreateProcedureStatement$lambda$1(Function1 $tmp0, Object p0) {
                return (Iterable)$tmp0.invoke(p0);
            }

            private static final boolean visitSqlCreateProcedureStatement$lambda$2(SqlInstruction it) {
                return it instanceof SqlExitInstruction || it instanceof SqlJumpInstruction || it instanceof SqlNondeterministicJumpInstruction;
            }

            private static final boolean visitSqlCreateProcedureStatement$lambda$3(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final boolean visitSqlCreateProcedureStatement$lambda$4(Set $unreachableInstructions, SqlInstruction it) {
                return !(it instanceof SqlReturnInstruction) && !$unreachableInstructions.contains(it);
            }

            private static final boolean visitSqlCreateProcedureStatement$lambda$5(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }
}

