/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.base.psi.SqlFunctionBodyInjector;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgOptionalKeywords;
import com.intellij.sql.dialects.postgres.PgReservedKeywords;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionBodyInjector
extends SqlFunctionBodyInjector {
    @Override
    protected boolean canApply(PsiElement context) {
        return context instanceof SqlStringLiteralExpression && SqlImplUtil.getSqlDialectSafe(context) == this.getDialect();
    }

    @Override
    @Nullable
    protected Pair<Language, String> calcBodyLanguage(@NotNull PsiElement context) {
        if (context == null) {
            FunctionBodyInjector.$$$reportNull$$$0(0);
        }
        return this.getBodyLanguage(context);
    }

    @Override
    @Nullable
    protected Pair<String, String> getPrefixSuffix(Language language, @NotNull PsiElement context) {
        if (context == null) {
            FunctionBodyInjector.$$$reportNull$$$0(1);
        }
        if (!language.getID().equals("Python")) {
            return null;
        }
        SqlCreateProcedureStatement createProcedure = (SqlCreateProcedureStatement)PsiTreeUtil.getParentOfType((PsiElement)context, SqlCreateProcedureStatement.class, (boolean)false);
        if (createProcedure == null) {
            return null;
        }
        ArrayList arguments = ContainerUtil.newArrayList((Iterable)createProcedure.getArguments());
        String prefix = "import plpy\nSD = GD = TD = {}\ndef _f(" + StringUtil.join((Collection)arguments, NavigationItem::getName, (String)", ") + "):";
        return Pair.create((Object)prefix, null);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<SqlStringLiteralExpressionImpl>> list = Collections.singletonList(SqlStringLiteralExpressionImpl.class);
        if (list == null) {
            FunctionBodyInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private Pair<Language, String> getBodyLanguage(@NotNull PsiElement context) {
        Object lang;
        if (context == null) {
            FunctionBodyInjector.$$$reportNull$$$0(3);
        }
        ASTNode nodeParent = Objects.requireNonNull(context.getNode().getTreeParent());
        SqlStatement statement2 = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)context, SqlStatement.class, (boolean)false);
        if (!(statement2 instanceof SqlCreateProcedureStatement || statement2 != null && statement2.getFirstChild().getNode().getElementType() == PgTypes.PG_DO)) {
            return null;
        }
        ASTNode asNode = TreeUtil.findSiblingBackward((ASTNode)nodeParent, (IElementType)PgReservedKeywords.PG_AS);
        if (statement2 instanceof SqlCreateProcedureStatement && asNode == null) {
            return null;
        }
        ASTNode gp = nodeParent.getTreeParent();
        ASTNode langNode = gp == null ? null : gp.findChildByType((IElementType)SqlCompositeElementTypes.SQL_LANGUAGE_CLAUSE);
        langNode = langNode == null ? null : langNode.findChildByType(PgOptionalKeywords.PG_LANGUAGE);
        Object v0 = lang = langNode == null ? null : SqlImplUtil.getSiblingToTheRightOfType(langNode.getPsi(), true, PsiElement.class);
        if (lang == context) {
            return null;
        }
        String text = lang == null ? null : lang.getText();
        return this.getLangBySpec(text, context);
    }

    @Override
    protected Pair<Language, String> getLangBySpec(@Nullable String text, @NotNull PsiElement host) {
        if (host == null) {
            FunctionBodyInjector.$$$reportNull$$$0(4);
        }
        return FunctionBodyInjector.getBlockByLangSpec(text, host, this.getDialect());
    }

    @NotNull
    protected Language getDialect() {
        PgDialect pgDialect = PgDialect.INSTANCE;
        if (pgDialect == null) {
            FunctionBodyInjector.$$$reportNull$$$0(5);
        }
        return pgDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcBodyLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixSuffix";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBodyLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLangBySpec";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

