/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.ExpressionParser;
import com.intellij.sql.dialects.mongo.js.FunctionParser;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JSModifiersStructure;
import com.intellij.sql.dialects.mongo.js.JSParsingContextUtil;
import com.intellij.sql.dialects.mongo.js.JavaScriptParser;
import com.intellij.sql.dialects.mongo.js.StatementParser;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6Parser
extends JavaScriptParser {
    public ES6Parser(PsiBuilder builder) {
        super(builder);
        this.myStatementParser = new ES6StatementParser(this);
        this.myFunctionParser = new ES6FunctionParser(this);
        this.myExpressionParser = new ES6ExpressionParser(this);
    }

    static class ES6StatementParser
    extends StatementParser {
        private static final JSModifiersStructure CLASS_MEMBER_MODIFIERS_STRUCTURE_WITH_ES_PRIVATE = new JSModifiersStructure.JSOrderedModifiersStructure(new JSModifiersStructure.JSOneOfModifiersStructure(JSElementTypes.PRIVATE_KEYWORD, JSElementTypes.PUBLIC_KEYWORD), new JSModifiersStructure.JSOneOfModifiersStructure(JSElementTypes.STATIC_KEYWORD, JSElementTypes.ASYNC_KEYWORD), new JSModifiersStructure.JSOneOfModifiersStructure(JSElementTypes.ASYNC_KEYWORD, JSElementTypes.STATIC_KEYWORD), new JSModifiersStructure.JSOneOfModifiersStructure(JSElementTypes.GET_KEYWORD, JSElementTypes.SET_KEYWORD), new JSModifiersStructure.JSModifiersStructureLeaf(JSElementTypes.MULT), new JSModifiersStructure.JSModifiersStructureLeaf(JSElementTypes.SHARP));
        private static final Predicate<PsiBuilder> IS_MEMBER_NAME_START = builder -> {
            IElementType token = builder.getTokenType();
            return JSElementTypes.PROPERTY_NAMES.contains(token) || token == JSElementTypes.MULT || token == JSElementTypes.LBRACKET;
        };

        ES6StatementParser(JavaScriptParser parser2) {
            super(parser2);
        }

        @Override
        protected void parseClassMember() {
            PsiBuilder.Marker classMember = this.builder.mark();
            int classMemberOffset = this.builder.getCurrentOffset();
            if (this.builder.getTokenType() == JSElementTypes.SEMICOLON) {
                classMember.drop();
                this.parseEmptyStatement();
                return;
            }
            boolean wasGenerator = this.myJavaScriptParser.getFunctionParser().isGeneratorContext();
            boolean lexerAdvanced = this.parseClassMemberModifiers();
            this.parseStandardClassMember(classMember, lexerAdvanced);
            this.myJavaScriptParser.getFunctionParser().setIsGenerator(wasGenerator);
            assert (this.builder.getCurrentOffset() > classMemberOffset);
        }

        protected void parseStandardClassMember(PsiBuilder.Marker classMember, boolean lexerAdvanced) {
            if (this.isNamedClassMemberStart()) {
                this.parseNamedClassMember(classMember);
            } else {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.statement", new Object[0]));
                if (!lexerAdvanced) {
                    this.builder.advanceLexer();
                }
                classMember.drop();
            }
        }

        protected boolean parseClassMemberModifiers() {
            return this.myJavaScriptParser.parseModifiers(CLASS_MEMBER_MODIFIERS_STRUCTURE_WITH_ES_PRIVATE, false, IS_MEMBER_NAME_START);
        }

        protected boolean isNamedClassMemberStart() {
            return this.myJavaScriptParser.getExpressionParser().isPropertyNameStart(this.builder.getTokenType());
        }

        protected void parseNamedClassMember(@NotNull PsiBuilder.Marker classMember) {
            if (classMember == null) {
                ES6StatementParser.$$$reportNull$$$0(0);
            }
            IElementType lookahead = this.builder.lookAhead(1);
            PsiBuilder.Marker mark2 = this.builder.mark();
            boolean skipName = false;
            IElementType nextToken = this.builder.getTokenType();
            boolean shouldBeFunc = !(nextToken != JSElementTypes.LBRACKET && !this.isIdentifierToken(nextToken) && !JSElementTypes.PROPERTY_NAMES.contains(nextToken) && !JSElementTypes.LITERALS.contains(nextToken) || this.builder.getUserData(ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY) != Boolean.TRUE && this.myJavaScriptParser.getFunctionParser().isGeneratorContext() != Boolean.TRUE.booleanValue() && this.builder.getUserData(FunctionParser.HAD_GET_SET) != Boolean.TRUE);
            this.builder.putUserData(FunctionParser.HAD_GET_SET, null);
            if (nextToken == JSElementTypes.LBRACKET) {
                this.parseMemberPropertyWithBrackets();
                skipName = true;
                lookahead = this.builder.getTokenType();
            }
            if (this.isPossibleMemberFunctionStart(lookahead) || shouldBeFunc) {
                mark2.drop();
                boolean wasGenerator = this.myJavaScriptParser.getFunctionParser().isGeneratorContext();
                this.myJavaScriptParser.getFunctionParser().setIsGenerator(false);
                this.parseMemberFunction(classMember, skipName);
                this.myJavaScriptParser.getFunctionParser().setIsGenerator(wasGenerator);
            } else {
                this.parseMemberVariable(mark2, skipName);
                this.forceCheckForSemicolon();
                classMember.done(this.getFieldStatementElementType());
                classMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            }
        }

        protected IElementType getFieldStatementElementType() {
            return JSElementTypes.FIELD_STATEMENT;
        }

        protected void parseMemberPropertyWithBrackets() {
            this.myJavaScriptParser.getExpressionParser().parsePropertyName();
        }

        protected boolean isPossibleMemberFunctionStart(IElementType lookahead) {
            return JSElementTypes.LPAR == lookahead || JSElementTypes.LT == lookahead;
        }

        protected void parseMemberFunction(PsiBuilder.Marker classMember, boolean skipName) {
            if (!skipName) {
                this.parserMemberFunctionName();
            }
            FunctionParser functionParser = this.myJavaScriptParser.getFunctionParser();
            functionParser.parseParameterList(false);
            this.myJavaScriptParser.getTypeParser().tryParseType();
            if (this.builder.getTokenType() == JSElementTypes.LBRACE) {
                this.myJavaScriptParser.getStatementParser().parseFunctionBody();
            } else {
                this.checkMemberFunctionSuffix();
            }
            this.checkForSemicolon();
            classMember.done(functionParser.getFunctionDeclarationElementType());
            classMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }

        protected void parserMemberFunctionName() {
            boolean nameParsed = this.myJavaScriptParser.getFunctionParser().parseFunctionName(true, FunctionParser.Context.PROPERTY);
            if (!nameParsed) {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.function.name", new Object[0]));
            }
        }

        protected void checkMemberFunctionSuffix() {
            ES6StatementParser.checkMatches(this.builder, JSElementTypes.SEMICOLON, "MongoJS.parser.message.expected.lbrace.or.semicolon");
        }

        protected void parseMemberVariable(PsiBuilder.Marker var, boolean skipName) {
            if (!skipName) {
                this.parseMemberVariableName();
            }
            this.myJavaScriptParser.getTypeParser().tryParseType();
            if (this.builder.getTokenType() == JSElementTypes.EQ) {
                this.parseVariableInitializer(false);
            }
            var.done(this.getFieldElementType());
            var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }

        protected void parseMemberVariableName() {
            this.myJavaScriptParser.getExpressionParser().parsePropertyName();
        }

        @Override
        protected boolean parseReferenceListMember() {
            PsiBuilder.Marker refMember = this.builder.mark();
            ExpressionParser expressionParser = this.myJavaScriptParser.getExpressionParser();
            boolean result2 = expressionParser.parseLeftHandSideExpression(false);
            if (result2) {
                refMember.done((IElementType)JSElementTypes.EXTENDS_LIST_MEMBER);
            } else {
                refMember.drop();
            }
            return result2;
        }

        @Override
        public boolean parseForLoopHeader() {
            LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.FOR_KEYWORD);
            if (this.builder.lookAhead(1) == JSElementTypes.AWAIT_KEYWORD) {
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                return this.parseForLoopHeaderCondition();
            }
            return super.parseForLoopHeader();
        }

        @Override
        protected void parseES6DecoratorDeclaration(@NotNull PsiBuilder.Marker decoratorMark) {
            if (decoratorMark == null) {
                ES6StatementParser.$$$reportNull$$$0(1);
            }
            LOG.assertTrue(JSElementTypes.DECORATOR_KEYWORD == this.builder.getTokenType());
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSElementTypes.AT) {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.at", new Object[0]));
                decoratorMark.drop();
                return;
            }
            String methodsMustBeEmpty = (String)this.builder.getUserData(FunctionParser.methodsEmptinessKey);
            this.builder.advanceLexer();
            if (!this.myJavaScriptParser.getFunctionParser().parseFunctionName(false, FunctionParser.Context.SOURCE_ELEMENT)) {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.name", new Object[0]));
                IElementType type = this.builder.getTokenType();
                if (type != JSElementTypes.LBRACE && type != JSElementTypes.LPAR && (methodsMustBeEmpty == null || type != JSElementTypes.SEMICOLON)) {
                    decoratorMark.drop();
                    return;
                }
            }
            if (this.builder.getTokenType() == JSElementTypes.LPAR) {
                this.myJavaScriptParser.getFunctionParser().parseParameterList(false);
            }
            if (this.builder.getTokenType() != JSElementTypes.LBRACE) {
                if (methodsMustBeEmpty != null) {
                    if (this.builder.getTokenType() == JSElementTypes.SEMICOLON) {
                        this.builder.advanceLexer();
                    }
                    decoratorMark.done((IElementType)JSElementTypes.ES6_DECORATOR_DECLARATION);
                    return;
                }
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.lbrace", new Object[0]));
                decoratorMark.drop();
                return;
            }
            this.builder.advanceLexer();
            this.myJavaScriptParser.getFunctionParser().tryParseES7Decorators();
            if (this.builder.getTokenType() != JSElementTypes.RBRACE) {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.rbrace", new Object[0]));
            } else {
                this.builder.advanceLexer();
            }
            decoratorMark.done((IElementType)JSElementTypes.ES6_DECORATOR_DECLARATION);
        }

        @Override
        protected boolean isModifier(IElementType token) {
            if (token == JSElementTypes.ASYNC_KEYWORD) {
                return this.builder.lookAhead(1) == JSElementTypes.FUNCTION_KEYWORD;
            }
            return super.isModifier(token);
        }

        public IElementType getFieldElementType() {
            return JSElementTypes.FIELD;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classMember";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decoratorMark";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/mongo/js/ES6Parser$ES6StatementParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseNamedClassMember";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseES6DecoratorDeclaration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ES6FunctionParser
    extends FunctionParser {
        public static final Key<Boolean> HAD_ASYNC_MODIFIER_KEY = Key.create((String)"js.asyncModifier");
        private static final JSModifiersStructure ARROW_FUNCTION_MODIFIERS = new JSModifiersStructure.JSModifiersStructureLeaf(JSElementTypes.ASYNC_KEYWORD);

        ES6FunctionParser(JavaScriptParser parser2) {
            super(parser2);
        }

        @Override
        public boolean parseFunctionNoMarker(FunctionParser.Context context, @NotNull PsiBuilder.Marker functionMarker) {
            if (functionMarker == null) {
                ES6FunctionParser.$$$reportNull$$$0(0);
            }
            boolean wasAsync = this.checkModifierAndSaveAsync();
            boolean result2 = super.parseFunctionNoMarker(context, functionMarker);
            this.restoreAsync(wasAsync);
            return result2;
        }

        @Override
        public boolean hasSupportDecorators() {
            return true;
        }

        @Override
        public boolean isFunctionDeclarationStart() {
            IElementType tokenType = this.builder.getTokenType();
            return tokenType == JSElementTypes.FUNCTION_KEYWORD || tokenType == JSElementTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSElementTypes.FUNCTION_KEYWORD;
        }

        @Override
        public boolean parseAttributesList() {
            if (this.builder.getTokenType() == JSElementTypes.LBRACKET) {
                return false;
            }
            PsiBuilder.Marker modifierList = this.builder.mark();
            boolean hadAttributes = this.tryParseES7Decorators();
            if (hadAttributes && this.myJavaScriptParser.getStatementParser().isExportDefault()) {
                modifierList.done(this.getAttributeListElementType());
                return true;
            }
            boolean hadExport = false;
            if (this.builder.getTokenType() == JSElementTypes.EXPORT_KEYWORD) {
                hadExport = true;
                this.builder.advanceLexer();
            }
            if (!hadAttributes) {
                this.tryParseES7Decorators();
            }
            if (this.builder.getTokenType() == JSElementTypes.ASYNC_KEYWORD) {
                this.builder.advanceLexer();
                this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.TRUE);
            }
            if (!hadExport && JSElementTypes.GET_SET.contains(this.builder.getTokenType()) && this.myJavaScriptParser.getExpressionParser().isPropertyNameStart(this.builder.lookAhead(1))) {
                this.builder.advanceLexer();
            }
            modifierList.done(this.getAttributeListElementType());
            return true;
        }

        @Override
        public boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
            if (arrowFunction == null) {
                ES6FunctionParser.$$$reportNull$$$0(1);
            }
            boolean wasGenerator = this.isGeneratorContext();
            this.parseArrowFunctionAttributeList();
            boolean wasAsync = this.checkModifierAndSaveAsync();
            boolean result2 = super.parseArrowFunctionWithoutModifiers(arrowFunction);
            this.restoreAsync(wasAsync);
            this.setIsGenerator(wasGenerator);
            return result2;
        }

        @Override
        protected boolean isValidFirstParameterStart(IElementType next) {
            IElementType nextLookAhead;
            return super.isValidFirstParameterStart(next) && (next != JSElementTypes.ASYNC_KEYWORD || (nextLookAhead = this.builder.lookAhead(2)) != JSElementTypes.LPAR && nextLookAhead != JSElementTypes.MULT);
        }

        protected void parseArrowFunctionAttributeList() {
            this.myJavaScriptParser.parseModifiers(ARROW_FUNCTION_MODIFIERS, false, builder -> this.isAcceptableLambdaTokenAfterAsync(builder.getTokenType()));
        }

        protected boolean isAcceptableLambdaTokenAfterAsync(IElementType tokenType) {
            return tokenType == JSElementTypes.LPAR || this.myJavaScriptParser.isIdentifierName(tokenType);
        }

        @Override
        protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
            boolean wasAsync = this.checkModifierAndSaveAsync();
            boolean lexerAdvanced = super.parseParameterListAndBody(marker, elementType);
            this.restoreAsync(wasAsync);
            return lexerAdvanced;
        }

        @Override
        public boolean allowLastCommaInParameterAndArgumentList() {
            return true;
        }

        private boolean checkModifierAndSaveAsync() {
            boolean hadAsyncModifier = Boolean.TRUE.equals(this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY));
            this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
            boolean wasAsync = this.isAsyncContext();
            this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)hadAsyncModifier);
            return wasAsync;
        }

        private void restoreAsync(@Nullable Boolean wasAsync) {
            this.builder.putUserData(JSParsingContextUtil.ASYNC_METHOD_KEY, (Object)wasAsync);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionMarker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrowFunction";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/dialects/mongo/js/ES6Parser$ES6FunctionParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseFunctionNoMarker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseArrowFunctionWithoutModifiers";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ES6ExpressionParser
    extends ExpressionParser {
        ES6ExpressionParser(JavaScriptParser parser2) {
            super(parser2);
        }

        @Override
        protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
            if (this.myJavaScriptParser.getFunctionParser().tryParseES7Decorators() && this.builder.getTokenType() == JSElementTypes.RBRACE) {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.property.name", new Object[0]));
                property.done((IElementType)JSElementTypes.PROPERTY);
                return true;
            }
            return super.parsePropertyNoMarker(property);
        }

        @Override
        protected boolean isPropertyStart(IElementType elementType) {
            return super.isPropertyStart(elementType) || elementType == JSElementTypes.MULT || elementType == JSElementTypes.AT;
        }

        @Override
        protected void parseDestructuringProperty() {
            if (this.tryParseDestructuringRestElement(JSElementTypes.DESTRUCTURING_PROPERTY)) {
                return;
            }
            super.parseDestructuringProperty();
        }

        private boolean tryParseDestructuringRestElement(IElementType type) {
            if (this.builder.getTokenType() == JSElementTypes.DOT_DOT_DOT) {
                PsiBuilder.Marker property = this.builder.mark();
                this.parseDestructuringRestElementNoMarker();
                property.done(type);
                return true;
            }
            return false;
        }

        protected void parseDestructuringRestElementNoMarker() {
            assert (this.builder.getTokenType() == JSElementTypes.DOT_DOT_DOT);
            this.builder.advanceLexer();
            IElementType tokenType = this.builder.getTokenType();
            if (this.isIdentifierToken(tokenType)) {
                PsiBuilder.Marker var = this.builder.mark();
                this.builder.advanceLexer();
                IElementType varType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
                assert (varType != null);
                var.done(varType);
            } else if (tokenType == JSElementTypes.LBRACE || tokenType == JSElementTypes.LBRACKET) {
                PsiBuilder.Marker mark2 = this.builder.mark();
                mark2.done(this.parseDestructuringElementNoMarker(false, false));
            } else {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.identifier", new Object[0]));
            }
        }

        @Override
        protected void parseDestructuringArrayElement() {
            if (this.tryParseDestructuringRestElement(JSElementTypes.DESTRUCTURING_ARRAY_REST)) {
                return;
            }
            super.parseDestructuringArrayElement();
        }

        @Override
        protected boolean parseArrayElement(boolean first2, Ref<IElementType> elementTypeRef) {
            boolean parseMoreElements = true;
            if (first2 && this.builder.getTokenType() == JSElementTypes.FOR_KEYWORD) {
                elementTypeRef.set((Object)JSElementTypes.ARRAY_COMPREHENSION);
                this.myJavaScriptParser.getStatementParser().parseForLoopHeader();
                while (true) {
                    if (this.builder.getTokenType() == JSElementTypes.IF_KEYWORD) {
                        this.myJavaScriptParser.getStatementParser().parseIfStatementHeader();
                        continue;
                    }
                    if (this.builder.getTokenType() != JSElementTypes.FOR_KEYWORD) break;
                    this.myJavaScriptParser.getStatementParser().parseForLoopHeader();
                }
                parseMoreElements = false;
            }
            if (!this.parseSpreadExpression()) {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.expression", new Object[0]));
                parseMoreElements = false;
            }
            return parseMoreElements;
        }

        @Override
        protected void parseAdditionalReferenceSeparator(PsiBuilder.Marker mark2) {
            if (this.builder.getTokenType() == JSElementTypes.SHARP) {
                this.builder.advanceLexer();
                mark2.done(JSElementTypes.DOT_SHARP);
            } else {
                mark2.drop();
            }
        }

        @Override
        @Nullable
        protected IElementType getSafeAccessOperator() {
            return JSElementTypes.ELVIS;
        }

        @Override
        protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
            return super.isReferenceQualifierSeparator(tokenType) || tokenType == this.getSafeAccessOperator();
        }

        @Override
        protected boolean parseArgument() {
            if (this.builder.getTokenType() == JSElementTypes.DOT_DOT_DOT) {
                return this.parseSpreadExpression();
            }
            return super.parseArgument();
        }

        private boolean parseSpreadExpression() {
            if (this.builder.getTokenType() == JSElementTypes.DOT_DOT_DOT) {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                if (!this.parseAssignmentExpression(true)) {
                    this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.expression", new Object[0]));
                    marker.drop();
                    return false;
                }
                marker.done((IElementType)JSElementTypes.SPREAD_EXPRESSION);
            } else if (!this.parseAssignmentExpression(true)) {
                this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.expression", new Object[0]));
                return false;
            }
            return true;
        }

        @Override
        protected boolean parseUnaryExpression() {
            IElementType type = this.builder.getTokenType();
            if (type == JSElementTypes.AWAIT_KEYWORD) {
                if (this.myJavaScriptParser.getFunctionParser().isAsyncContext() || !ES6ExpressionParser.hasSemanticLinefeedAfter(this.builder) && this.myJavaScriptParser.isIdentifierName(this.builder.lookAhead(1))) {
                    PsiBuilder.Marker expr = this.builder.mark();
                    this.builder.advanceLexer();
                    if (this.builder.getTokenType() == JSElementTypes.MULT) {
                        this.builder.advanceLexer();
                    }
                    if (!this.parseUnaryExpression()) {
                        this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.expression", new Object[0]));
                    }
                    expr.done(JSElementTypes.PREFIX_EXPRESSION);
                    return true;
                }
                return this.parsePostfixExpression();
            }
            if (type == JSElementTypes.THROW_KEYWORD) {
                PsiBuilder.Marker mark2 = this.builder.mark();
                this.builder.advanceLexer();
                if (!this.parseUnaryExpression()) {
                    mark2.rollbackTo();
                    return false;
                }
                mark2.done(JSElementTypes.THROW_EXPRESSION);
                return true;
            }
            return super.parseUnaryExpression();
        }

        @Override
        public boolean parsePrimaryExpression() {
            if (this.builder.getTokenType() == JSElementTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSElementTypes.FUNCTION_KEYWORD) {
                PsiBuilder.Marker asyncStart = this.builder.mark();
                if (this.myJavaScriptParser.getFunctionParser().parseFunctionExpression()) {
                    asyncStart.drop();
                    return true;
                }
                asyncStart.rollbackTo();
            }
            if (this.builder.getTokenType() == JSElementTypes.DO_KEYWORD) {
                PsiBuilder.Marker doMarker = this.builder.mark();
                this.builder.advanceLexer();
                this.myJavaScriptParser.getStatementParser().parseBlock();
                doMarker.done(JSElementTypes.DO_EXPRESSION);
                return true;
            }
            if (this.builder.getTokenType() == JSElementTypes.SHARP && (this.builder.getUserData(ALLOW_PIPE_TOPICS) != Boolean.TRUE || this.canBePrivateName(this.builder.lookAhead(1)))) {
                PsiBuilder.Marker start2 = this.builder.mark();
                PsiBuilder.Marker startThis = this.builder.mark();
                this.builder.advanceLexer();
                startThis.done((IElementType)JSElementTypes.SHARP_THIS_SHORTHAND_EXPRESSION);
                IElementType tokenType = this.builder.getTokenType();
                if (this.canBePrivateName(tokenType)) {
                    if (tokenType != JSElementTypes.IDENTIFIER) {
                        this.builder.remapCurrentToken(JSElementTypes.IDENTIFIER);
                    }
                    this.builder.advanceLexer();
                } else {
                    this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.identifier", new Object[0]));
                }
                start2.done((IElementType)JSElementTypes.SHARP_THIS_ACCESS_EXPRESSION);
                return true;
            }
            return super.parsePrimaryExpression();
        }

        private boolean canBePrivateName(IElementType tokenType) {
            return this.isIdentifierToken(tokenType) || JSElementTypes.PROPERTY_NAMES.contains(tokenType);
        }

        @Override
        protected boolean parseNewExpression() {
            LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.NEW_KEYWORD);
            if (this.builder.lookAhead(1) == JSElementTypes.DOT) {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSElementTypes.IDENTIFIER) {
                    if (!"target".equals(this.builder.getTokenText())) {
                        this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.target", new Object[0]));
                    }
                    this.builder.advanceLexer();
                } else {
                    this.builder.error(DatabaseBundle.message("MongoJS.parser.message.expected.identifier", new Object[0]));
                }
                marker.done(JSElementTypes.META_PROPERTY);
                return false;
            }
            return super.parseNewExpression();
        }

        @Override
        public boolean parseAssignmentExpression(boolean allowIn) {
            if ((this.builder.getTokenType() == JSElementTypes.LPAR || this.isIdentifierToken(this.builder.getTokenType())) && this.myJavaScriptParser.getFunctionParser().parseArrowFunction()) {
                return true;
            }
            return super.parseAssignmentExpression(allowIn);
        }
    }
}

