/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.exasol.refactoring;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.exasol.ExaDialect;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/dialects/exasol/refactoring/ExaExtractVariableHelper;", "Lcom/intellij/sql/refactoring/SqlExtractVariableHelper;", "<init>", "()V", "isTypeStrict", "", "createDeclaration", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "type", "Lcom/intellij/database/model/DataType;", "expressionText", "createInitializerDeclaration", "text", "addDeclaration", "declaration", "block", "anchor", "intellij.database.dialects.exasol"})
public final class ExaExtractVariableHelper
extends SqlExtractVariableHelper {
    @NotNull
    public static final ExaExtractVariableHelper INSTANCE = new ExaExtractVariableHelper();

    private ExaExtractVariableHelper() {
        super(ExaDialect.INSTANCE);
    }

    @Override
    public boolean isTypeStrict() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement createDeclaration(@NotNull Project project, @NotNull String name2, @NotNull DataType type, @NotNull String expressionText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)expressionText, (String)"expressionText");
        String string = this.createBuilder(project).identifier(name2, ObjectKind.VARIABLE).space().type(type).getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String varText = string;
        String statementText = "create function foo() as " + varText + "; begin end";
        SqlStatement dummyFunction = SqlPsiElementFactory.createStatementFromText(statementText, this.getDialect(), project, null);
        return PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)dummyFunction), SqlVariableDefinition.class);
    }

    @Override
    @Nullable
    public PsiElement createInitializerDeclaration(@NotNull Project project, @NotNull String name2, @NotNull String text) {
        SqlStatement dummyFunction;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = this.createBuilder(project).identifier(name2, ObjectKind.VARIABLE).space().symbol(":=").space().plain(text).getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String initText = string;
        String statementText = "create function foo() as begin " + initText + "; end";
        SqlStatement sqlStatement = dummyFunction = SqlPsiElementFactory.createStatementFromText(statementText, this.getDialect(), project, null);
        return PsiTreeUtil.getChildOfType((PsiElement)(sqlStatement != null ? sqlStatement.getLastChild() : null), SqlStatement.class);
    }

    @Override
    @Nullable
    public PsiElement addDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement block, @NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        PsiElement parent = block.getParent();
        PsiElement addedVar = parent.addBefore(declaration, block);
        PsiElement psiElement = SqlPsiElementFactory.createLeafFromText(declaration.getProject(), this.getDialect(), ";");
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createLeafFromText(...)");
        PsiElement semi = psiElement;
        parent.addAfter(semi, addedVar);
        parent.addBefore(SqlPsiElementFactory.newLine(block.getProject()), addedVar);
        return addedVar;
    }
}

