/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.LevelFun;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.common.CalendarFun;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.model.Pointer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationContent;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 02\u00020\u0001:\u0003012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0010\u001a\u00100\u0011j\u0007`\u0013\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0012H\u0002J&\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u0010\u001a\u00100\u0011j\u0007`\u0013\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0012H\u0002J$\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010\u0010\u001a\u00100\u0011j\u0007`\u0013\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0012J\u001c\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0013H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0014\u0010\u0010\u001a\u00100\u0011j\u0007`\u0013\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0012H\u0002J\u001d\u0010!\u001a\n \"*\u0004\u0018\u00010\u00110\u0011*\u00060\u0011j\u0002`\u0013H\u0002\u00a2\u0006\u0002\u0010#J%\u0010$\u001a\n \"*\u0004\u0018\u00010\u00110\u0011*\u00060\u0011j\u0002`\u00132\u0006\u0010%\u001a\u00020&H\u0002\u00a2\u0006\u0002\u0010'J%\u0010(\u001a\n \"*\u0004\u0018\u00010\u00110\u0011*\u00060\u0011j\u0002`\u00132\u0006\u0010%\u001a\u00020&H\u0002\u00a2\u0006\u0002\u0010'J=\u0010)\u001a\u00020\t\"\b\b\u0000\u0010**\u00020\u000b2\u0006\u0010\n\u001a\u0002H*2\u001c\u0010+\u001a\u0018\u0012\u0004\u0012\u0002H*\u0012\b\u0012\u00060\u0011j\u0002`\u0013\u0012\u0004\u0012\u00020\r0,H\u0002\u00a2\u0006\u0002\u0010-J[\u0010)\u001a\u00020\t\"\b\b\u0000\u0010**\u00020\u000b2\u0006\u0010\n\u001a\u0002H*2\u001c\u0010+\u001a\u0018\u0012\u0004\u0012\u0002H*\u0012\b\u0012\u00060\u0011j\u0002`\u0013\u0012\u0004\u0012\u00020\r0,2\u001c\u0010.\u001a\u0018\u0012\u0004\u0012\u0002H*\u0012\b\u0012\u00060\u0011j\u0002`\u0013\u0012\u0004\u0012\u00020\r0,H\u0002\u00a2\u0006\u0002\u0010/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00063"}, d2={"Lcom/intellij/database/view/DatabaseDocumentationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "prepareQuickDoc", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "produceForGroupFast", "", "group", "Lcom/intellij/database/view/structure/DvDsGroup;", "b", "Ljava/lang/StringBuilder;", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/text/StringBuilder;", "produceForDataSourceFast", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "ds", "Lcom/intellij/database/model/RawDataSource;", "produceForDataSourceSlow", "gatherDataSourceStatistics", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "produceForSchemaFast", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "br", "kotlin.jvm.PlatformType", "(Ljava/lang/StringBuilder;)Ljava/lang/StringBuilder;", "appendText", "text", "", "(Ljava/lang/StringBuilder;Ljava/lang/String;)Ljava/lang/StringBuilder;", "appendNoBreak", "prepare", "N", "fastProducer", "Lkotlin/Function2;", "(Lcom/intellij/database/model/basic/BasicNode;Lkotlin/jvm/functions/Function2;)Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "slowProducer", "(Lcom/intellij/database/model/basic/BasicNode;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "Companion", "DatabaseNodeDocumentationTarget1", "DatabaseNodeDocumentationTarget2", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseDocumentationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseDocumentationService.kt\ncom/intellij/database/view/DatabaseDocumentationService\n+ 2 DatabaseDocumentationService.kt\ncom/intellij/database/view/DatabaseDocumentationService$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n142#2:192\n1863#3,2:193\n1053#3:195\n*S KotlinDebug\n*F\n+ 1 DatabaseDocumentationService.kt\ncom/intellij/database/view/DatabaseDocumentationService\n*L\n79#1:192\n89#1:193,2\n95#1:195\n*E\n"})
public final class DatabaseDocumentationService {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Regex textNLPattern = new Regex("\r?\n");

    public DatabaseDocumentationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final DocumentationTarget prepareQuickDoc(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DvDsGroup ? this.prepare(node, (Function2)new Function2<DvDsGroup, StringBuilder, Unit>((Object)this){

            public final void invoke(DvDsGroup p0, StringBuilder p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DatabaseDocumentationService.access$produceForGroupFast((DatabaseDocumentationService)this.receiver, p0, p1);
            }
        }) : (basicNode instanceof DataSourceNode ? this.prepare(node, (Function2)new Function2<DataSourceNode, StringBuilder, Unit>((Object)this){

            public final void invoke(DataSourceNode p0, StringBuilder p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DatabaseDocumentationService.access$produceForDataSourceFast((DatabaseDocumentationService)this.receiver, p0, p1);
            }
        }, (Function2)new Function2<DataSourceNode, StringBuilder, Unit>((Object)this){

            public final void invoke(DataSourceNode p0, StringBuilder p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DatabaseDocumentationService.access$produceForDataSourceSlow((DatabaseDocumentationService)this.receiver, p0, p1);
            }
        }) : (basicNode instanceof BasicSchema ? this.prepare(node, (Function2)new Function2<BasicSchema, StringBuilder, Unit>((Object)this){

            public final void invoke(BasicSchema p0, StringBuilder p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                DatabaseDocumentationService.access$produceForSchemaFast((DatabaseDocumentationService)this.receiver, p0, p1);
            }
        }) : null));
    }

    private final void produceForGroupFast(DvDsGroup group, StringBuilder b) {
        b.append("<b>Group</b>: ").append(group.getDisplayName()).append("<br/>");
    }

    private final void produceForDataSourceFast(DataSourceNode dsn, StringBuilder b) {
        this.produceForDataSourceFast(dsn.rawDataSource, b);
    }

    public final void produceForDataSourceFast(@NotNull RawDataSource ds, @NotNull StringBuilder b) {
        String dbVersionName;
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(ds);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        Object[] objectArray = new Object[]{dialect.getDisplayName()};
        String string = DatabaseBundle.message("dataSource.quickInfo.dialectPhrase", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String s1 = string;
        StringBuilder stringBuilder = b.append(s1);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        this.br(stringBuilder);
        if (ds instanceof LocalDataSource && (dbVersionName = ((LocalDataSource)ds).getDatabaseVersion().name) != null) {
            this.br(b);
            String string2 = DataSourceUtil.formatDataSourceInfoString((LocalDataSource)ds);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatDataSourceInfoString(...)");
            CharSequence charSequence = string2;
            Regex regex = new Regex("^(.+?):", RegexOption.MULTILINE);
            String string3 = "<b>$1</b>:";
            String info2 = regex.replace(charSequence, string3);
            this.appendText(b, info2);
            this.br(b);
        }
    }

    private final void produceForDataSourceSlow(DataSourceNode dsn, StringBuilder b) {
        BasicModel basicModel = dsn.getModel();
        if (basicModel == null) {
            return;
        }
        BasicModel model = basicModel;
        Companion companion = Companion;
        Function0 f$iv = () -> DatabaseDocumentationService.produceForDataSourceSlow$lambda$0(this, model);
        boolean $i$f$computeInReadAction = false;
        CharSequence text = (CharSequence)ReadAction.nonBlocking((Callable)new Callable(f$iv, null){
            private final /* synthetic */ Function0 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object call() {
                return this.function.invoke();
            }
            {
                this(function);
            }
        }).executeSynchronously();
        StringFun.appendIfNotNull(b, text);
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence gatherDataSourceStatistics(BasicModel model) {
        void $this$forEach$iv;
        Dbms dbms = model.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        Object2IntOpenHashMap map2 = new Object2IntOpenHashMap();
        Object object = ((JBTreeTraverser)model.traverser().expand(arg_0 -> DatabaseDocumentationService.gatherDataSourceStatistics$lambda$2(DatabaseDocumentationService::gatherDataSourceStatistics$lambda$1, arg_0))).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"traverse(...)");
        object = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DasObject it = (DasObject)element$iv;
            boolean bl = false;
            map2.addTo((Object)it.getKind(), 1);
        }
        if (map2.isEmpty()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        StringBuilder stringBuilder = this.br(b).append("<b>Contents:</b>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        this.br(stringBuilder);
        b.append("<ul>");
        Object2IntMap.FastEntrySet fastEntrySet = map2.object2IntEntrySet();
        Intrinsics.checkNotNullExpressionValue((Object)fastEntrySet, (String)"object2IntEntrySet(...)");
        Iterable $this$sortedBy$iv = (Iterable)fastEntrySet;
        boolean $i$f$sortedBy = false;
        for (Object2IntMap.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Object2IntMap.Entry it = (Object2IntMap.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((ObjectKind)it.getKey()).getOrder());
                it = (Object2IntMap.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((ObjectKind)it.getKey()).getOrder()));
            }
        })) {
            String presentableName;
            Intrinsics.checkNotNull((Object)entry);
            ObjectKind kind = (ObjectKind)((Map.Entry)entry).getKey();
            Integer count = (Integer)((Map.Entry)entry).getValue();
            Intrinsics.checkNotNull((Object)count);
            Intrinsics.checkNotNullExpressionValue((Object)DbPresentationCore.getPresentableName(kind, dbms2, count), (String)"getPresentableName(...)");
            b.append("<li>").append(count).append(" ").append(presentableName).append("</li>\n");
        }
        b.append("</ul>");
        return b;
    }

    private final void produceForSchemaFast(BasicSchema schema, StringBuilder b) {
        Instant instant = schema.getLastIntrospectionLocalTimestamp();
        ZonedDateTime lastIntrospectionTime = instant != null ? instant.atZone(ZoneId.systemDefault()) : null;
        BasicMultiLevelSchema basicMultiLevelSchema = schema instanceof BasicMultiLevelSchema ? (BasicMultiLevelSchema)schema : null;
        Level lastIntrospectionLevel = basicMultiLevelSchema != null ? basicMultiLevelSchema.getLastIntrospectionLevel() : null;
        String schemaNameH = "<b>" + schema.getName() + "</b>";
        Object[] objectArray = new Object[]{schemaNameH};
        String string = DatabaseBundle.message("quickDoc.schema.header", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.appendText(b, string);
        if (lastIntrospectionTime != null || lastIntrospectionLevel != null) {
            b.append("<p>");
            String string2 = DatabaseBundle.message("quickDoc.schema.lastIntrospection.begin", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.appendNoBreak(b, string2).append(' ');
            if (lastIntrospectionTime != null) {
                objectArray = new Object[]{CalendarFun.getLocaleDataTimeFormatterMediumStyle().format(lastIntrospectionTime)};
                String string3 = DatabaseBundle.message("quickDoc.schema.lastIntrospection.atTime", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                this.appendNoBreak(b, string3).append(' ');
            }
            if (lastIntrospectionLevel != null) {
                objectArray = new Object[]{lastIntrospectionLevel, StringsKt.replace$default((String)LevelFun.getMiniBrief(lastIntrospectionLevel), (String)" ", (String)"&nbsp;", (boolean)false, (int)4, null)};
                String string4 = DatabaseBundle.message("quickDoc.schema.lastIntrospection.atLevel", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                this.appendNoBreak(b, string4);
            }
            b.append("<p/>\n");
        }
    }

    private final StringBuilder br(StringBuilder $this$br) {
        return $this$br.append("<br/>\n");
    }

    private final StringBuilder appendText(StringBuilder $this$appendText, String text) {
        CharSequence charSequence = text;
        Regex regex = textNLPattern;
        String string = "<br/>\n";
        return $this$appendText.append(regex.replace(charSequence, string));
    }

    private final StringBuilder appendNoBreak(StringBuilder $this$appendNoBreak, String text) {
        return $this$appendNoBreak.append(StringsKt.replace$default((String)text, (String)" ", (String)"&nbsp;", (boolean)false, (int)4, null));
    }

    private final <N extends BasicNode> DocumentationTarget prepare(N node, Function2<? super N, ? super StringBuilder, Unit> fastProducer) {
        StringBuilder b = new StringBuilder();
        fastProducer.invoke(node, (Object)b);
        return new DatabaseNodeDocumentationTarget1<N>(node, b);
    }

    private final <N extends BasicNode> DocumentationTarget prepare(N node, Function2<? super N, ? super StringBuilder, Unit> fastProducer, Function2<? super N, ? super StringBuilder, Unit> slowProducer) {
        StringBuilder b = new StringBuilder();
        fastProducer.invoke(node, (Object)b);
        return new DatabaseNodeDocumentationTarget2<N>(node, b, slowProducer);
    }

    private static final CharSequence produceForDataSourceSlow$lambda$0(DatabaseDocumentationService this$0, BasicModel $model) {
        return this$0.gatherDataSourceStatistics($model);
    }

    private static final boolean gatherDataSourceStatistics$lambda$1(DasObject it) {
        return it instanceof DasNamespace;
    }

    private static final boolean gatherDataSourceStatistics$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$produceForGroupFast(DatabaseDocumentationService $this, DvDsGroup group, StringBuilder b) {
        $this.produceForGroupFast(group, b);
    }

    public static final /* synthetic */ void access$produceForDataSourceFast(DatabaseDocumentationService $this, DataSourceNode dsn, StringBuilder b) {
        $this.produceForDataSourceFast(dsn, b);
    }

    public static final /* synthetic */ void access$produceForDataSourceSlow(DatabaseDocumentationService $this, DataSourceNode dsn, StringBuilder b) {
        $this.produceForDataSourceSlow(dsn, b);
    }

    public static final /* synthetic */ void access$produceForSchemaFast(DatabaseDocumentationService $this, BasicSchema schema, StringBuilder b) {
        $this.produceForSchemaFast(schema, b);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u000e\b\b\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\r"}, d2={"Lcom/intellij/database/view/DatabaseDocumentationService$Companion;", "", "<init>", "()V", "textNLPattern", "Lkotlin/text/Regex;", "getTextNLPattern", "()Lkotlin/text/Regex;", "computeInReadAction", "X", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getTextNLPattern() {
            return textNLPattern;
        }

        public final <X> X computeInReadAction(@NotNull Function0<? extends X> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            boolean $i$f$computeInReadAction = false;
            return (X)ReadAction.nonBlocking((Callable)new /* invalid duplicate definition of identical inner class */).executeSynchronously();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0012\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/view/DatabaseDocumentationService$DatabaseNodeDocumentationTarget1;", "N", "Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "node", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<init>", "(Lcom/intellij/database/model/basic/BasicNode;Ljava/lang/StringBuilder;)V", "getNode", "()Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/database/model/basic/BasicNode;", "getB", "()Ljava/lang/StringBuilder;", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "intellij.database.impl"})
    private static class DatabaseNodeDocumentationTarget1<N extends BasicNode>
    implements DocumentationTarget {
        @NotNull
        private final N node;
        @NotNull
        private final StringBuilder b;

        public DatabaseNodeDocumentationTarget1(@NotNull N node, @NotNull StringBuilder b) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.node = node;
            this.b = b;
        }

        @NotNull
        public final N getNode() {
            return this.node;
        }

        @NotNull
        protected final StringBuilder getB() {
            return this.b;
        }

        @NotNull
        public Pointer<? extends DocumentationTarget> createPointer() {
            Pointer pointer = Pointer.hardPointer((Object)this);
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
            return pointer;
        }

        @NotNull
        public TargetPresentation computePresentation() {
            TargetPresentation targetPresentation = TargetPresentation.Companion.builder(StringFun.wrapWithHtmlTag(this.b)).presentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
            return targetPresentation;
        }

        @NotNull
        public DocumentationResult computeDocumentation() {
            return (DocumentationResult)DocumentationResult.Companion.documentation(StringFun.wrapWithHtmlTag(this.b));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B9\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u001c\u0010\b\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R'\u0010\b\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/view/DatabaseDocumentationService$DatabaseNodeDocumentationTarget2;", "N", "Lcom/intellij/database/model/basic/BasicNode;", "Lcom/intellij/database/view/DatabaseDocumentationService$DatabaseNodeDocumentationTarget1;", "node", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "slowProducer", "Lkotlin/Function2;", "", "<init>", "(Lcom/intellij/database/model/basic/BasicNode;Ljava/lang/StringBuilder;Lkotlin/jvm/functions/Function2;)V", "getSlowProducer", "()Lkotlin/jvm/functions/Function2;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "intellij.database.impl"})
    private static final class DatabaseNodeDocumentationTarget2<N extends BasicNode>
    extends DatabaseNodeDocumentationTarget1<N> {
        @NotNull
        private final Function2<N, StringBuilder, Unit> slowProducer;

        public DatabaseNodeDocumentationTarget2(@NotNull N node, @NotNull StringBuilder b, @NotNull Function2<? super N, ? super StringBuilder, Unit> slowProducer) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter(slowProducer, (String)"slowProducer");
            super(node, b);
            this.slowProducer = slowProducer;
        }

        @NotNull
        public final Function2<N, StringBuilder, Unit> getSlowProducer() {
            return this.slowProducer;
        }

        @Override
        @NotNull
        public DocumentationResult computeDocumentation() {
            String text1 = StringFun.wrapWithHtmlTag(this.getB());
            DocumentationResult.Documentation documentation = DocumentationResult.Companion.documentation(text1);
            return (DocumentationResult)documentation.updates(FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super DocumentationContent>, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ DatabaseNodeDocumentationTarget2<N> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$flow = (FlowCollector)this.L$0;
                            this.L$0 = $this$flow;
                            this.label = 1;
                            v0 = DelayKt.delay((long)1L, (Continuation)((Continuation)this));
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $this$flow = (FlowCollector)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            this.this$0.getSlowProducer().invoke(this.this$0.getNode(), (Object)this.this$0.getB());
                            text2 = StringFun.wrapWithHtmlTag(this.this$0.getB());
                            var4_5 = DocumentationContent.content((String)text2);
                            Intrinsics.checkNotNullExpressionValue((Object)var4_5, (String)"content(...)");
                            this.L$0 = null;
                            this.label = 2;
                            v1 = $this$flow.emit((Object)var4_5, (Continuation)this);
                            if (v1 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl30
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl30:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(FlowCollector<? super DocumentationContent> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })));
        }
    }
}

