/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DbSingleValueModelMultiApplier<E extends BasicElement, T, S extends DbSingleValueModelState<T>>
extends DbEditorModelBase.MultiApplierBase<E, S> {
    @Override
    protected void applyImpl(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @NotNull List<DbEditorModel<E, S>> models2) {
        DbSingleValueModelState state;
        if (model == null) {
            DbSingleValueModelMultiApplier.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DbSingleValueModelMultiApplier.$$$reportNull$$$0(1);
        }
        if (models2 == null) {
            DbSingleValueModelMultiApplier.$$$reportNull$$$0(2);
        }
        if ((state = (DbSingleValueModelState)model.getState()).isInconsistent()) {
            return;
        }
        for (DbEditorModel<E, S> mm : models2) {
            this.applySingle(state, (DbSingleValueModelState)mm.getState());
        }
    }

    protected void applySingle(@NotNull S state, @NotNull S to) {
        if (state == null) {
            DbSingleValueModelMultiApplier.$$$reportNull$$$0(3);
        }
        if (to == null) {
            DbSingleValueModelMultiApplier.$$$reportNull$$$0(4);
        }
        ((DbSingleValueModelState)to).setValue(((DbSingleValueModelState)state).getValue());
    }

    @Override
    protected void resetImpl(@NotNull DbEditorModel<E, S> model, @NotNull ElementOwner owner, @NotNull List<DbEditorModel<E, S>> models2) {
        if (model == null) {
            DbSingleValueModelMultiApplier.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            DbSingleValueModelMultiApplier.$$$reportNull$$$0(6);
        }
        if (models2 == null) {
            DbSingleValueModelMultiApplier.$$$reportNull$$$0(7);
        }
        Set values = ContainerUtil.map2Set(models2, m -> ((DbSingleValueModelState)m.getState()).getValue());
        DbSingleValueModelState state = (DbSingleValueModelState)model.getState();
        boolean inconsistent = values.size() > 1;
        state.setValue(inconsistent ? this.getInconsistentValue(model) : ContainerUtil.getFirstItem((Collection)values));
        state.setInconsistent(inconsistent);
        state.setEnabled(ContainerUtil.and(models2, m -> ((DbSingleValueModelState)m.getState()).isEnabled()));
    }

    public T getInconsistentValue(@NotNull DbEditorModel<E, S> model) {
        if (model == null) {
            DbSingleValueModelMultiApplier.$$$reportNull$$$0(8);
        }
        return DbSingleValueModelState.getDefaultValue(model.getApplier());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbSingleValueModelMultiApplier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applySingle";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "resetImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getInconsistentValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

