/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.SqlValuesExtractor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.Out;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlInsertValuesExtractor
extends SqlValuesExtractor {
    private final Dbms myDbms;

    public SqlInsertValuesExtractor(@NotNull ObjectFormatter converter, @Nullable DasObject databaseTable, @NotNull Dbms dbms) {
        if (converter == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(0);
        }
        if (dbms == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(1);
        }
        super(converter, databaseTable);
        this.myDbms = dbms;
    }

    @Override
    public SqlInsertExtraction startExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int ... selectedColumns) {
        if (out == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(2);
        }
        if (allColumns == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(3);
        }
        if (query == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(4);
        }
        if (config == null) {
            SqlInsertValuesExtractor.$$$reportNull$$$0(5);
        }
        return new SqlInsertExtraction(out, this.myDbms, config, allColumns, selectedColumns);
    }

    private static void removeComputedAndAutoVal(int[] selectedColumns, Int2ObjectMap<? extends GridColumn> columnsMap, DasObject databaseTable, boolean addComputedColumns, boolean addGeneratedColumns) {
        for (int selectedColumn : selectedColumns) {
            DasColumn dasColumn;
            GridColumn column2 = (GridColumn)columnsMap.get(selectedColumn);
            if (column2 == null) continue;
            if (GridUtilCore.isRowId((GridColumn)column2)) {
                columnsMap.remove(selectedColumn);
                continue;
            }
            if (databaseTable == null || (dasColumn = DasUtil.findChild(databaseTable, DasColumn.class, ObjectKind.COLUMN, column2.getName())) == null || (addGeneratedColumns || !DasUtil.isAutoGenerated(dasColumn)) && (addComputedColumns || !DasUtil.isComputed(dasColumn))) continue;
            columnsMap.remove(selectedColumn);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/SqlInsertValuesExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startExtraction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SqlInsertExtraction
    extends SqlValuesExtractor.SqlExtractionBase {
        SqlInsertExtraction(Out output, Dbms dbms, ExtractionConfig config, List<? extends GridColumn> allColumns, int[] selectedColumnIndices) {
            super(output, dbms, config, allColumns, selectedColumnIndices);
        }

        protected void appendHeader(boolean appendNewLine) {
            Project project;
            if (!this.myConfig.getAddTableDdl()) {
                return;
            }
            DasObject dasObject = SqlInsertValuesExtractor.this.myDatabaseTable;
            if (dasObject instanceof DbElement) {
                DbElement dbTable = (DbElement)dasObject;
                DetailsSyncHelper syncHelper = DetailsSyncHelper.of(dbTable);
                syncHelper.notifyIfSyncRequired(DatabaseBundle.message("extract", new Object[0]));
                this.myDdlBuilder.plain(DatabaseDefinitionHelper.generateDefinition(dbTable, new StringBuilder()).toString());
                return;
            }
            if (SqlInsertValuesExtractor.this.myDatabaseTable instanceof BasicElement && (project = DbImplUtilCore.getAnyProject()) != null) {
                this.myDdlBuilder.plain(DatabaseDefinitionHelper.generateDefinitionUsingScriptingService(project, (BasicElement)SqlInsertValuesExtractor.this.myDatabaseTable, null).toString());
                return;
            }
            this.myDdlBuilder.keyword("CREATE").space().keyword("TABLE").space();
            if (SqlInsertValuesExtractor.this.myDatabaseTable == null) {
                this.myDdlBuilder.identifier("MY_TABLE");
            } else {
                this.myDdlBuilder.ref(SqlInsertValuesExtractor.this.myDatabaseTable, SqlInsertValuesExtractor.this.myDatabaseTable.getName());
            }
            this.myDdlBuilder.space().symbol("(").newLine();
            boolean first2 = true;
            for (GridColumn column2 : this.myAllColumns) {
                if (GridUtilCore.isRowId((GridColumn)column2)) continue;
                if (first2) {
                    first2 = false;
                } else {
                    this.myDdlBuilder.symbol(",").newLine();
                }
                String typeName = StringUtil.isEmpty((String)column2.getTypeName()) ? "unknown" : column2.getTypeName();
                this.myDdlBuilder.space(2).columnRef(column2.getName()).space().type(typeName);
            }
            this.myDdlBuilder.newLine().symbol(")").symbol(";").newLine();
        }

        protected void appendData(List<? extends GridRow> rows) {
            int[] selectedColumns = GridExtractorsUtilCore.getNonEmptySelection((List)this.myAllColumns, (int[])this.mySelectedColumnIndices);
            Int2ObjectMap columnsMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping((List)this.myAllColumns);
            SqlInsertValuesExtractor.removeComputedAndAutoVal(selectedColumns, (Int2ObjectMap<? extends GridColumn>)columnsMap, SqlInsertValuesExtractor.this.myDatabaseTable, this.myConfig.getAddComputedColumns(), this.myConfig.getAddGeneratedColumns());
            for (GridRow gridRow : rows) {
                this.myDdlBuilder.keyword("INSERT").space().keyword("INTO").space();
                if (SqlInsertValuesExtractor.this.myDatabaseTable != null) {
                    this.myDdlBuilder.qualifiedRef(SqlInsertValuesExtractor.this.myDatabaseTable).space();
                } else {
                    this.myDdlBuilder.identifier("MY_TABLE");
                }
                boolean first2 = true;
                this.myDdlBuilder.symbol("(");
                for (int selectedColumn : selectedColumns) {
                    GridColumn column2 = (GridColumn)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    if (first2) {
                        first2 = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.columnRef(column2.getName());
                }
                this.myDdlBuilder.symbol(")").space();
                first2 = true;
                this.myDdlBuilder.keyword("VALUES").space().symbol("(");
                for (int selectedColumn : selectedColumns) {
                    GridColumn column2 = (GridColumn)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    if (first2) {
                        first2 = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.literal(SqlInsertValuesExtractor.this.getValueLiteral(gridRow, column2, ObjectFormatterMode.SQL_SCRIPT));
                }
                this.myDdlBuilder.symbol(")").symbol(";").newLine();
            }
        }
    }
}

