/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.WarningInfo;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.session.DatabaseConsoleHistoryController;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionManagerListener;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseOutdatedCheckBuffer;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.editor.ExecuteRoutineFromFileAction;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.run.actions.DebugRoutineAction;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DatabaseElementSourceVirtualFileImpl;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.TwoSideComponent;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DatabaseEditorHelper
extends DatabaseEditorHelperCore {
    private static final Logger LOG = Logger.getInstance(DatabaseEditorHelper.class);
    @NlsSafe
    private static final String DDL_EDITOR_DISPLAY_NAME = "DDL";
    private static final Key<Object> DB_EDITOR_LISTENER_INSTALLED = Key.create((String)"DB_EDITOR_LISTENER_INSTALLED");
    private static final Key<Boolean> FILE_CONTENT_LOADED = Key.create((String)"DBE_CONTENT_LOADED");

    public static void installEditorFactoryListener(final @NotNull Project project) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(0);
        }
        if (project.getUserData(DB_EDITOR_LISTENER_INSTALLED) != null) {
            return;
        }
        project.putUserData(DB_EDITOR_LISTENER_INSTALLED, (Object)Boolean.TRUE);
        project.getMessageBus().connect().subscribe(PsiDocumentListener.TOPIC, (document, psiFile, project1) -> {
            VirtualFile patt5595$temp;
            if (psiFile != null && (patt5595$temp = psiFile.getVirtualFile()) instanceof DatabaseElementSourceVirtualFileImpl) {
                DatabaseElementSourceVirtualFileImpl vFile = (DatabaseElementSourceVirtualFileImpl)patt5595$temp;
                DatabaseEditorHelper.reloadIfNeeded(project1, vFile);
            }
        });
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditorManagerListener listener2 = new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (DbImplUtil.isDatabaseVirtualFile(file)) {
                    DatabaseEditorHelper.configureToolbar(file, source);
                    DatabaseEditorHelper.setDdlEditorsDisplayName(file, source);
                    if (!DatabaseEditorHelper.isDataFile(file)) {
                        DatabaseEditorHelper.scheduleOutdatedCheck(project, file);
                    }
                } else {
                    DatabaseEditorHelper.restoreAttachedConsole(source.getProject(), file);
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                DatabaseElementSourceVirtualFileImpl vf;
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((vf = (DatabaseElementSourceVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)event.getNewFile(), DatabaseElementSourceVirtualFileImpl.class))) != null && DatabaseEditorHelper.needsRefresh(vf, project)) {
                    DatabaseEditorHelper.scheduleReload(project, vf, true);
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (source.isFileOpen(file)) {
                    return;
                }
                JdbcConsole console = JdbcConsoleProvider.getConsole(source.getProject(), file);
                if (console != null) {
                    console.detached(DatabaseSessionClient.DetachTrigger.FILE_CLOSED);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        project.getMessageBus().connect().subscribe(DbPsiFacade.TOPIC, ds -> {
            for (VirtualFile file : fileEditorManager.getSelectedFiles()) {
                DatabaseElementSourceVirtualFileImpl vf = (DatabaseElementSourceVirtualFileImpl)((Object)((Object)ObjectUtils.tryCast((Object)file, DatabaseElementSourceVirtualFileImpl.class)));
                if (vf == null || !DatabaseEditorHelper.needsRefresh(vf, project)) continue;
                DatabaseEditorHelper.scheduleReload(project, vf, true);
            }
        });
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                JdbcConsole console;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                Editor editor2 = event.getEditor();
                Document document = editor2.getDocument();
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                JdbcConsole jdbcConsole = console = file == null ? null : JdbcConsoleProvider.getConsole(project, file);
                if (console != null) {
                    console.getProgressHelper().applyState(editor2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/editor/DatabaseEditorHelper$2", "editorCreated"));
            }
        }, (Disposable)project.getMessageBus());
        MessageBusConnection connection2 = project.getMessageBus().connect();
        connection2.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener2);
        connection2.subscribe(DatabaseSessionManager.getTopic(), (Object)new DatabaseSessionManagerListener(){
            private boolean myShowToolbar;
            {
                this.myShowToolbar = DatabaseEditorHelper.showConsoleToolbar(project);
            }

            @Override
            public void sessionOpened(@NotNull DatabaseSession session) {
                if (session == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.updateConsoleToolbarIfNeeded();
            }

            @Override
            public void sessionClosed(@NotNull DatabaseSession session) {
                if (session == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.updateConsoleToolbarIfNeeded();
            }

            private void updateConsoleToolbarIfNeeded() {
                boolean newShowToolbar = DatabaseEditorHelper.showConsoleToolbar(project);
                if (this.myShowToolbar == newShowToolbar) {
                    return;
                }
                this.myShowToolbar = newShowToolbar;
                DatabaseEditorHelper.getAllOpenedEditors(project).filter(e -> {
                    VirtualFile file = e.getVirtualFile();
                    return DbImplUtil.isSqlScriptFile(project, file) && JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file) && !DbImplUtil.isDatabaseVirtualFile(file) && JdbcConsoleProvider.getValidConsole(project, file) == null;
                }).forEach(e -> {
                    if (this.myShowToolbar) {
                        DatabaseEditorHelper.configureConsoleToolbar(project, null, e.getVirtualFile());
                        return;
                    }
                    DatabaseEditorHelper.removeConsoleToolbar(project, e.getVirtualFile());
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "session";
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sessionOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sessionClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            listener2.fileOpened(fileEditorManager, virtualFile);
        }
        DataBus.addRootAuditor(project, new DataAuditor(){
            final ConcurrentMap<GridDataRequest.Context, String> myReportedQueries = ContainerUtil.createConcurrentWeakMap();

            @Override
            public void jobSubmitted(@NotNull DataRequest request2, @NotNull DataProducer producer) {
                if (request2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (producer == null) {
                    4.$$$reportNull$$$0(1);
                }
                this.updateToolbars(request2);
            }

            @Override
            public void jobFinished(@NotNull DataRequest request2, @NotNull DataProducer producer) {
                if (request2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (producer == null) {
                    4.$$$reportNull$$$0(3);
                }
                this.updateToolbars(request2);
            }

            void updateToolbars(@NotNull DataRequest request2) {
                if (request2 == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (request2.owner instanceof DataGrid || request2.owner instanceof AbstractQueryLanguageConsole) {
                    ActivityTracker.getInstance().inc();
                }
            }

            @Override
            public void print(@NotNull DataRequest.Context context, @NlsContexts.NotificationContent @Nullable String message) {
                if (context == null) {
                    4.$$$reportNull$$$0(5);
                }
                if (!4.needLog(context)) {
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)message)) {
                    return;
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, MessageType.INFO).setDisplayId("DatabaseEditorHelper.Auditor.print").notify(project);
            }

            @Override
            public void warn(@NotNull DataRequest.Context context, @NotNull WarningInfo warningInfo) {
                if (context == null) {
                    4.$$$reportNull$$$0(6);
                }
                if (warningInfo == null) {
                    4.$$$reportNull$$$0(7);
                }
                if (!4.needLog(context)) {
                    return;
                }
                String message = warningInfo.getMessage();
                if (StringUtil.isEmptyOrSpaces((String)message)) {
                    return;
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, MessageType.WARNING).setDisplayId("DatabaseEditorHelper.Auditor.warn").notify(project);
            }

            @Override
            public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
                Object content;
                if (context == null) {
                    4.$$$reportNull$$$0(8);
                }
                if (errorInfo == null) {
                    4.$$$reportNull$$$0(9);
                }
                if (!4.needLog(context)) {
                    return;
                }
                String query = StringUtil.nullize((String)StringUtil.trim((String)context.getQuery()));
                if (query != null && Objects.equals(query, this.myReportedQueries.put((GridDataRequest.Context)context, query))) {
                    query = null;
                }
                if (StringUtil.isEmptyOrSpaces((String)(content = (String)(query == null ? "" : query + "\n") + errorInfo.getMessage()))) {
                    content = DatabaseBundle.message("notification.content.missing.error.message", new Object[0]);
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification((String)content, MessageType.ERROR).setDisplayId("DatabaseEditorHelper.Auditor.error").notify(project);
            }

            private static boolean needLog(@NotNull DataRequest.Context context) {
                if (context == null) {
                    4.$$$reportNull$$$0(10);
                }
                DatabaseSession session = (DatabaseSession)ObjectUtils.tryCast((Object)context.request.owner, DatabaseSession.class);
                return SessionsUtil.isInternalOwner(context.request.owner) || session != null && session.isInternal();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "producer";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "warningInfo";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorInfo";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobSubmitted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobFinished";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateToolbars";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "warn";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "needLog";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project.getMessageBus());
    }

    public static boolean isDataFile(@NotNull VirtualFile file) {
        DatabaseElementVirtualFileImpl dbFile;
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(1);
        }
        return (dbFile = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)file, DatabaseElementVirtualFileImpl.class))) != null && dbFile.getFamily() == null && !dbFile.isSource();
    }

    public static boolean needsRefresh(DatabaseElementSourceVirtualFileImpl vf, @NotNull Project project) {
        DbElement element;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(2);
        }
        if ((element = vf.findElement(project)) == null) {
            return false;
        }
        return DatabaseEditorHelper.computeObjectHashCode(element) != vf.getObjectHash();
    }

    private static int computeObjectHashCode(DbElement element) {
        int h = DatabaseEditorHelper.computeObjectHashInner(element);
        BasicElement e = DbImplUtilCore.getMaybeBasicElement(element);
        if (e != null) {
            for (BasicElement basicElement : e.getPredecessors()) {
                DbElement pdb = element.getDataSource().findElement(basicElement);
                if (pdb == null) continue;
                h = Objects.hash(h, DatabaseEditorHelper.computeObjectHashInner(pdb));
            }
        }
        return h;
    }

    private static int computeObjectHashInner(DbElement element) {
        int h = DatabaseEditorHelper.hashCode(element);
        for (DbElement child : element.getDasChildren(null)) {
            if (DbTargetUtil.adjustForNavigation(child) != element) continue;
            h = Objects.hash(h, DatabaseEditorHelper.hashCode(child));
        }
        return h;
    }

    private static int hashCode(DbElement element) {
        BasicElement e = DbImplUtilCore.getMaybeBasicElement(element);
        return e == null ? 0 : ModelLightCopier.hashCode(e);
    }

    public static void scheduleOutdatedCheck(@NotNull Project project, @NotNull VirtualFile file) {
        LocalDataSource ds;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(4);
        }
        DbElement element = DbImplUtilCore.findElement(project, file);
        BasicElement basic = DbImplUtilCore.getMaybeBasicElement(element);
        LocalDataSource localDataSource = ds = element == null ? null : DbImplUtilCore.getMaybeLocalDataSource(element.getDataSource());
        if (ds != null && basic != null) {
            DatabaseOutdatedCheckBuffer.getInstance(project).scheduleOutdatedCheck(ds, basic);
        }
    }

    @NotNull
    public static JBIterable<EditorEx> getAllOpenedEditors(@NotNull Project project) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getAllEditors()).filter(TextEditor.class).map(TextEditor::getEditor).filter(EditorEx.class).filter(e -> e.getVirtualFile() != null);
        if (jBIterable == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    private static void restoreAttachedConsole(@NotNull Project project, @NotNull VirtualFile file) {
        boolean coarse;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(8);
        }
        if (!JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file)) {
            return;
        }
        JdbcConsole existing2 = JdbcConsoleProvider.getValidConsole(project, file);
        if (existing2 != null) {
            DatabaseEditorHelper.configureConsoleToolbar(project, existing2, file);
            return;
        }
        DatabaseSession attached = JdbcConsoleProvider.findOrCreateSession(project, file);
        if (attached != null) {
            JdbcConsoleProvider.attachConsole(project, attached, file);
            return;
        }
        try (AccessToken ignore = SlowOperations.knownIssue((String)"DBE-21818");){
            coarse = DbSqlUtil.isSqlFileCoarse(file);
        }
        if (coarse) {
            DatabaseEditorHelper.configureConsoleToolbar(project, null, file);
        }
    }

    private static boolean showConsoleToolbar(@NotNull Project project) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(9);
        }
        return PlatformUtils.isDataGrip() || !DatabaseSessionManager.getSessions(project).isEmpty();
    }

    public static void removeConsoleToolbar(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(10);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(11);
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            EditorEx editor2 = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor2 == null) continue;
            if (DatabaseEditorHelper.showConsoleToolbar(project) && DbImplUtil.isSqlScriptFile(project, file)) {
                JComponent headerComponent = editor2.getPermanentHeaderComponent();
                headerComponent.setBackground(null);
                for (Component c3 : (JBTreeTraverser)UIUtil.uiTraverser((Component)headerComponent).filter(c2 -> c2 instanceof ActionToolbar)) {
                    c3.setBackground(null);
                }
            } else {
                editor2.setPermanentHeaderComponent(null);
                editor2.setHeaderComponent(null);
            }
            editor2.setBackgroundColor(null);
            editor2.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, AbstractColorsScheme.INHERITED_COLOR_MARKER);
        }
    }

    public static void configureConsoleToolbar(@NotNull Project project, @Nullable JdbcConsole console, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(12);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(13);
        }
        if (console == null && !DatabaseEditorHelper.showConsoleToolbar(project)) {
            return;
        }
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : manager.getAllEditors(file)) {
            EditorEx editor2 = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor2 == null) continue;
            JdbcConsole.buildHeaderComponent((Editor)editor2, console);
        }
    }

    private static void configureToolbar(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(14);
        }
        if (source == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(15);
        }
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor2 = ((TextEditor)fileEditor).getEditor();
            DatabaseEditorHelper.configureToolbar(source.getProject(), file, editor2);
            if (!(file instanceof DatabaseElementSourceVirtualFileImpl)) continue;
            DatabaseEditorHelper.processLoading(source.getProject(), fileEditor, (DatabaseElementSourceVirtualFileImpl)file);
        }
    }

    private static void processLoading(final Project project, FileEditor fileEditor, final DatabaseElementSourceVirtualFileImpl vf) {
        JComponent editorComponent = fileEditor.getComponent();
        if (editorComponent instanceof JBLoadingPanel && vf.isBusy()) {
            ((JBLoadingPanel)editorComponent).startLoading();
        }
        if (DatabaseEditorHelper.needsReload(vf)) {
            UiNotifyConnector.Once.installOn((Component)editorComponent, (Activatable)new Activatable(){

                public void showNotify() {
                    DatabaseEditorHelper.reloadIfNeeded(project, vf);
                }
            });
        }
    }

    @NotNull
    public static Promise<Void> reloadIfNeeded(@NotNull Project project, DatabaseElementSourceVirtualFileImpl vf) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(16);
        }
        if (DatabaseEditorHelper.needsReload(vf)) {
            FILE_CONTENT_LOADED.set((UserDataHolder)vf, (Object)Boolean.TRUE);
            return DatabaseEditorHelper.scheduleReload(project, vf);
        }
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(17);
        }
        return promise;
    }

    public static boolean needsReload(DatabaseElementSourceVirtualFileImpl vf) {
        return !vf.isBusy() && vf.isSource() && !Boolean.TRUE.equals(FILE_CONTENT_LOADED.get((UserDataHolder)vf));
    }

    private static void setDdlEditorsDisplayName(@NotNull VirtualFile file, @NotNull FileEditorManager fem) {
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(18);
        }
        if (fem == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(19);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        for (EditorComposite composite : ((FileEditorManagerEx)fem).getSplitters().getAllComposites(file)) {
            for (FileEditor editor2 : composite.getAllEditors()) {
                if (!(editor2 instanceof TextEditor)) continue;
                composite.setDisplayName(editor2, DDL_EDITOR_DISPLAY_NAME);
            }
        }
    }

    public static boolean isTableDataAvailable(@Nullable DbElement element) {
        LocalDataSource dataSource = DbImplUtilCore.getLocalDataSource(element);
        DatabaseDriver driver = dataSource == null ? null : dataSource.getDatabaseDriver();
        return element != null && DbImplUtilCore.isDataTable(element.getKind()) && dataSource != null && (driver == null || !Boolean.FALSE.equals(driver.getUserData(DatabaseDriver.CAN_LOAD_TABLES)));
    }

    @NotNull
    public static StringBuilder loadOrGenerateDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) {
        DdlBuilder builder;
        block7: {
            if (element == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(20);
            }
            if (sb == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(21);
            }
            int length = sb.length();
            DatabaseDefinitionHelper.loadDefinition(element, sb);
            if (length == sb.length()) break block7;
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(22);
            }
            return stringBuilder;
        }
        try {
            builder = new DdlBuilder(sb).configureFor(element).comment("definition is not available or empty\n");
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            builder = new DdlBuilder(sb).configureFor(element).comment("Failed to load definition\n").comment(ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"") + "\n\n");
        }
        builder.comment("auto-generated definition\n\n");
        StringBuilder stringBuilder = DatabaseDefinitionHelper.generateDefinition(element, sb);
        if (stringBuilder == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(23);
        }
        return stringBuilder;
    }

    public static void setCurrentSchemaSafe(@NotNull DatabaseDialectEx dialect, @Nullable ObjectPath path, @NotNull DatabaseConnection connection2) {
        SearchPath searchPath;
        String statement2;
        if (dialect == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(24);
        }
        if (connection2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(25);
        }
        String string = statement2 = (searchPath = SearchPath.of(path)) == null ? null : dialect.sqlSetSearchPath(searchPath);
        if (statement2 == null) {
            return;
        }
        try {
            SmartStatements.poweredBy(connection2).simple().barren().execute(statement2);
        }
        catch (Exception e) {
            LOG.warn(statement2, (Throwable)e);
        }
    }

    @NotNull
    public static Promise<Void> scheduleReload(@NotNull Project project, @NotNull DatabaseElementSourceVirtualFileImpl virtualFile) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(26);
        }
        if (virtualFile == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(27);
        }
        return DatabaseEditorHelper.scheduleReload(project, virtualFile, false);
    }

    @NotNull
    private static Promise<Void> scheduleReload(final @NotNull Project project, final @NotNull DatabaseElementSourceVirtualFileImpl virtualFile, final boolean keepUserModifications) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(28);
        }
        if (virtualFile == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(29);
        }
        if (!virtualFile.isSource()) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(30);
            }
            return promise;
        }
        Promise<Void> promise = new Computable<Promise<Void>>(){

            public Promise<Void> compute() {
                virtualFile.setBusy(true);
                return AsyncUtil.runAsync(() -> this.onReady(), DataSourceStorage.getProjectStorage(project)::doWhenInitialized);
            }

            public Promise<Void> onReady() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (!project.isDisposed()) {
                        DatabaseEditorHelper.setVisualProgress(project, virtualFile, true);
                    }
                });
                return AsyncUtil.runAsync(() -> this.loadContent(), arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0)).thenAsync(ignored -> AsyncUtil.runAsync(() -> this.finish(), arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0)));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Promise<Void> loadContent() {
                if (project.isDisposed()) {
                    return Promises.cancelledPromise();
                }
                StringBuilder sb = new StringBuilder();
                int objectHash = 0;
                try {
                    DbElement element = virtualFile.findElement(project);
                    if (element == null) {
                        sb.append("-- invalid target");
                    } else {
                        objectHash = DatabaseEditorHelper.computeObjectHashCode(element);
                        Dbms dbms = DbImplUtilCore.getDbms(element);
                        if (!DBIntrospectorFactory.hasNativeIntrospector(dbms) && DatabaseDefinitionHelper.isRawDefinitionAvailable(element)) {
                            DatabaseEditorHelper.loadOrGenerateDefinition(element, sb);
                        } else {
                            sb.append("-- auto-generated definition\n");
                            DatabaseDefinitionHelper.generateDefinition(element, sb);
                        }
                        if (sb.length() == 0) {
                            sb.append("-- definition is not available or empty");
                        }
                    }
                }
                catch (Exception e) {
                    String trace = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)LOG);
                    for (String s : trace.split("\n")) {
                        sb.append("-- ").append(s).append("\n");
                    }
                }
                finally {
                    String content = StringUtil.convertLineSeparators((String)sb.toString());
                    if (!virtualFile.isModifiedByUser() || !keepUserModifications || content.equals(virtualFile.getContent())) {
                        virtualFile.setContent(content, objectHash);
                    }
                    virtualFile.setBusy(false);
                }
                return Promises.resolvedPromise();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Promise<Void> finish() {
                if (project.isDisposed() || !virtualFile.isValid()) {
                    return Promises.cancelledPromise();
                }
                DatabaseEditorHelper.setVisualProgress(project, virtualFile, false);
                Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
                if (document == null) {
                    return Promises.cancelledPromise();
                }
                Runnable docUpdateRunnable = () -> {
                    PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                    DbElement element = virtualFile.findElement(project);
                    DasNamespace object = element == null ? null : DbImplUtilCore.getSearchPathObject(element);
                    DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)file, (Object)ObjectPaths.searchPathOf(object));
                    FileDocumentManager.getInstance().reloadFromDisk(document, project);
                    boolean reformatOnPaste = CodeInsightSettings.getInstance().REFORMAT_ON_PASTE == 4;
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    if (file != null && reformatOnPaste) {
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
                    }
                };
                boolean writable = virtualFile.isWritable();
                try {
                    virtualFile.setWritableInner(true);
                    document.setReadOnly(false);
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                        if (document.getTextLength() == 0) {
                            DocumentReference reference = DocumentReferenceManager.getInstance().create(document);
                            UndoManager.getInstance((Project)project).nonundoableActionPerformed(reference, false);
                        }
                        docUpdateRunnable.run();
                    });
                }
                catch (Throwable throwable) {
                    virtualFile.setWritableInner(writable);
                    document.setReadOnly(!writable);
                    throw throwable;
                }
                virtualFile.setWritableInner(writable);
                document.setReadOnly(!writable);
                return Promises.resolvedPromise();
            }
        }.compute();
        if (promise == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(31);
        }
        return promise;
    }

    private static void setVisualProgress(@NotNull Project project, @NotNull VirtualFile file, boolean flag) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(32);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(33);
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            JComponent editorComponent;
            if (!(fileEditor instanceof TextEditor) || !((editorComponent = fileEditor.getComponent()) instanceof JBLoadingPanel)) continue;
            JBLoadingPanel component = (JBLoadingPanel)editorComponent;
            if (flag) {
                component.startLoading();
                continue;
            }
            component.stopLoading();
        }
    }

    private static void configureToolbar(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Editor editor2) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(34);
        }
        if (virtualFile == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(35);
        }
        if (editor2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(36);
        }
        if (((EditorEx)editor2).getPermanentHeaderComponent() != null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        boolean isDbSrc = DbSrcUtilsCore.isDbSrcFile(virtualFile);
        if (isDbSrc) {
            group.add((AnAction)new ExecuteRoutineFromFileAction());
            PsiFile psiFile = PsiUtilCore.getPsiFile((Project)project, (VirtualFile)virtualFile);
            if (psiFile instanceof SqlFile && ((SqlFile)psiFile).getSqlLanguage().getDbms().isOracle()) {
                group.add((AnAction)new DebugRoutineAction());
            }
        }
        DumbAwareAction dataAction = new DumbAwareAction(){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    7.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                VirtualFile file;
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                ObjectKind kind = DbSrcUtilsCore.isDbSrcFile(file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) || file instanceof DatabaseElementVirtualFileImpl && ((DatabaseElementVirtualFileImpl)file).isSource() ? DbImplUtil.getKind(file) : null;
                boolean enabled = DbImplUtilCore.isDataTable(kind);
                e.getPresentation().setEnabledAndVisible(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    7.$$$reportNull$$$0(2);
                }
                if ((project = e.getProject()) == null) {
                    return;
                }
                VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
                DbElement element = DbImplUtilCore.findElement(project, file);
                if (element == null || !element.isValid()) {
                    return;
                }
                DbNavigationUtils.navigateToData(element, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/editor/DatabaseEditorHelper$7";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        ActionUtil.copyFrom((AnAction)dataAction, (String)"Jdbc.OpenEditor.Data");
        dataAction.registerCustomShortcutSet(editor2.getComponent(), null);
        ActionManager actionManager = ActionManager.getInstance();
        if (virtualFile instanceof DatabaseElementVirtualFileImpl || isDbSrc) {
            group.add(actionManager.getAction("DDL.Editor.Specific.StorageFile"));
        }
        group.add((AnAction)dataAction);
        ActionToolbar leftToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)group, true);
        leftToolbar.setTargetComponent(editor2.getContentComponent());
        JComponent component = leftToolbar.getComponent();
        EditorHeaderComponent headerComponent = new EditorHeaderComponent();
        headerComponent.add((Component)component, "West");
        ((EditorEx)editor2).setPermanentHeaderComponent((JComponent)headerComponent);
        editor2.setHeaderComponent((JComponent)headerComponent);
        DatabaseEditorHelper.configureEditorHeader(project, virtualFile, (JComponent)headerComponent);
    }

    public static void openConsoleFile(@Nullable DbElement element) {
        DatabaseEditorHelper.openConsoleFile(element, false);
    }

    public static void openConsoleFile(@Nullable DbElement element, boolean newInstance) {
        LocalDataSource dataSource;
        LocalDataSource localDataSource = dataSource = element == null ? null : DbImplUtil.getMaybeLocalDataSource(element.getDataSource());
        if (dataSource == null) {
            return;
        }
        DasNamespace context = element instanceof DbDataSource ? ((DbDataSource)element).getModel().getCurrentRootNamespace() : DasUtil.getParentOfClass(element, DasNamespace.class, false);
        DatabaseEditorHelper.openConsoleFile(element.getProject(), dataSource, context, newInstance);
    }

    public static void openConsoleFile(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable DasNamespace schema, boolean newInstance) {
        VirtualFile file;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(37);
        }
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(38);
        }
        VirtualFile virtualFile = file = newInstance ? DatabaseEditorHelper.createNewConsoleVirtualFile(dataSource) : DatabaseEditorHelper.getConsoleVirtualFile(dataSource);
        if (file != null) {
            DatabaseEditorHelper.openConsoleForFile(project, dataSource, schema, file);
        }
    }

    public static void openConsoleForFile(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable DasNamespace schema, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(39);
        }
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(40);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(41);
        }
        FileEditorManager.getInstance((Project)project).openFile(file, true);
        if (schema == null) {
            return;
        }
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(dataSource.getDbms());
        DasNamespace spObject = DbImplUtilCore.getSearchPathObject(dialect, schema);
        List<DasNamespace> namespaces2 = Collections.singletonList(spObject);
        SearchPath searchPath = DbImplUtil.getAutoSwitchPath(DbImplUtil.getMaybeLocalDataSource(dataSource), ObjectPaths.of(namespaces2));
        if (searchPath != null) {
            if (console != null) {
                console.switchSchema(searchPath, false);
            } else {
                ChooseSchemaAction.setSelectedSearchPath(project, file, searchPath);
            }
        }
        DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)PsiManager.getInstance((Project)project).findFile(file), (Object)searchPath);
    }

    @Nullable
    public static VirtualFile getConsoleRootDir(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(42);
        }
        String rootPath = DbConsoleRootType.getInstance().getContentRootPath(dataSource.getUniqueId());
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(rootPath);
    }

    @Nullable
    public static VirtualFile getConsoleVirtualFile(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(43);
        }
        return DatabaseConsoleHistoryController.Companion.getContentFile(dataSource, ScratchFileService.Option.create_if_missing);
    }

    @Nullable
    public static VirtualFile findExistingConsoleVirtualFile(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(44);
        }
        return DatabaseConsoleHistoryController.Companion.getContentFile(dataSource, ScratchFileService.Option.existing_only);
    }

    @Nullable
    public static VirtualFile createNewConsoleVirtualFile(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(45);
        }
        return DatabaseConsoleHistoryController.Companion.getContentFile(dataSource, ScratchFileService.Option.create_new_always);
    }

    public static void migrateConsolesIfNeeded(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(46);
        }
        DatabaseConsoleHistoryController.Companion.migrateConsolesIfNeeded(dataSource);
    }

    public static void configureEditorHeader(@Nullable Project project, @Nullable VirtualFile virtualFile, @Nullable JComponent headerComponent) {
        VirtualFile file;
        if (headerComponent == null) {
            return;
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(DataManager.getInstance().getDataContext((Component)headerComponent));
        DatabaseGridDataHookUp hookup = DbVFSUtils.isConsoleFile(virtualFile) ? DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)dataGrid) : null;
        DasObject table = hookup == null ? null : hookup.getDatabaseTable();
        VirtualFile adjustedFile = table instanceof DbElement ? ((DbElement)table).getVirtualFile() : virtualFile;
        DatabaseColorManager.LocalColors state = project == null ? null : (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(project).getState();
        Color color = state != null && state.useColors ? DatabaseColorManager.getColor(project, adjustedFile, true) : null;
        Color toolbarColor = state != null && state.useInToolbars ? color : null;
        headerComponent.setBackground(toolbarColor);
        for (Component c3 : (JBTreeTraverser)UIUtil.uiTraverser((Component)headerComponent).filter(c2 -> c2 instanceof ActionToolbar)) {
            c3.setBackground(toolbarColor);
            if (!(c3.getParent() instanceof TwoSideComponent)) continue;
            c3.getParent().setBackground(toolbarColor);
            if (toolbarColor == null) continue;
            ((TwoSideComponent)c3.getParent()).setOpaque(true);
        }
        Color editorColor = state != null && state.useInEditor ? color : null;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)headerComponent));
        if (editor2 instanceof EditorEx && (file = editor2.getVirtualFile()) != null && DbSqlUtil.isSqlFileCoarse(file)) {
            ((EditorEx)editor2).setBackgroundColor(editorColor);
            editor2.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, (Color)ObjectUtils.notNull((Object)editorColor, (Object)AbstractColorsScheme.INHERITED_COLOR_MARKER));
        }
        if (dataGrid != null) {
            dataGrid.getColorsScheme().setDefaultBackground(editorColor);
            dataGrid.getEditorColorsScheme().setDefaultBackground(editorColor);
            dataGrid.getResultView().defaultBackgroundChanged();
        }
    }

    @Nullable
    private static BasicNamedElement getNamed(@Nullable BasicElement element, @NotNull ObjectKind kind, @NotNull String name2) {
        if (kind == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(47);
        }
        if (name2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(48);
        }
        NamingFamily family = element == null ? null : (NamingFamily)element.familyOf(kind);
        return family == null ? null : (BasicNamedElement)family.get(name2);
    }

    @Nullable
    public static DasNamespace findNamespace(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable ObjectPath objectPath) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(49);
        }
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(50);
        }
        if (objectPath == null) {
            return null;
        }
        dataSource = dataSource instanceof DbDataSource ? ((DbDataSource)dataSource).getDelegate() : dataSource;
        BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
        ObjectKind k = objectPath.kind;
        if (model == null || k != ObjectKind.SCHEMA && k != ObjectKind.DATABASE) {
            return null;
        }
        BasicRoot root = model.getRoot();
        if (root instanceof BasicModMultiDatabaseRoot) {
            if (k == ObjectKind.DATABASE) {
                return (DasNamespace)((Object)DatabaseEditorHelper.getNamed(root, ObjectKind.DATABASE, objectPath.getName()));
            }
            ObjectPath parent = objectPath.parent;
            if (parent != null) {
                return (DasNamespace)((Object)DatabaseEditorHelper.getNamed(DatabaseEditorHelper.getNamed(root, ObjectKind.DATABASE, parent.getName()), ObjectKind.SCHEMA, objectPath.getName()));
            }
        }
        if (k != ObjectKind.SCHEMA) {
            return null;
        }
        for (BasicSchema basicSchema : root.getAllSchemas()) {
            if (!basicSchema.getName().equals(objectPath.getName())) continue;
            return basicSchema;
        }
        return null;
    }

    @Nullable
    public static List<DasNamespace> findNamespaces(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable SearchPath searchPath) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(51);
        }
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(52);
        }
        if (searchPath == null) {
            return null;
        }
        List sp = JBIterable.from(searchPath.elements).transform(p2 -> DatabaseEditorHelper.findNamespace(project, dataSource, p2)).toList();
        return sp.isEmpty() ? null : sp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 17, 22, 23, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 17: 
            case 22: 
            case 23: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/DatabaseEditorHelper";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fem";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 27: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOpenedEditors";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadIfNeeded";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "loadOrGenerateDefinition";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleReload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installEditorFactoryListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDataFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "needsRefresh";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleOutdatedCheck";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllOpenedEditors";
                break;
            }
            case 6: 
            case 17: 
            case 22: 
            case 23: 
            case 30: 
            case 31: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreAttachedConsole";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showConsoleToolbar";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeConsoleToolbar";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configureConsoleToolbar";
                break;
            }
            case 14: 
            case 15: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "configureToolbar";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reloadIfNeeded";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setDdlEditorsDisplayName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadOrGenerateDefinition";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentSchemaSafe";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReload";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setVisualProgress";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "openConsoleFile";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "openConsoleForFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleRootDir";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleVirtualFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findExistingConsoleVirtualFile";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createNewConsoleVirtualFile";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "migrateConsolesIfNeeded";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getNamed";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaces";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 17, 22, 23, 30, 31 -> new IllegalStateException(string);
        };
    }

    public static class Regenerate
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                Regenerate.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                Regenerate.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            DatabaseElementSourceVirtualFileImpl vf = (DatabaseElementSourceVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.VIRTUAL_FILE), DatabaseElementSourceVirtualFileImpl.class));
            if (project != null && vf != null) {
                DatabaseEditorHelper.scheduleReload(project, vf);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                Regenerate.$$$reportNull$$$0(2);
            }
            DatabaseElementSourceVirtualFileImpl vf = (DatabaseElementSourceVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)e.getData(CommonDataKeys.VIRTUAL_FILE), DatabaseElementSourceVirtualFileImpl.class));
            e.getPresentation().setEnabledAndVisible(vf != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/DatabaseEditorHelper$Regenerate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$Regenerate";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

