/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.ui.CompletionParamEditor;
import com.intellij.database.dialects.mssql.ssrp.SsrpConstants;
import com.intellij.database.dialects.mssql.ssrp.SsrpInfo;
import com.intellij.database.dialects.mssql.ssrp.SsrpInfoCache;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpHostParamEditor
extends CompletionParamEditor<SsrpInfo.SsrpServer> {
    private static final Logger LOG = Logger.getInstance(SsrpHostParamEditor.class);
    public static final Key<SsrpInfo> SSRP_INFO = Key.create((String)"SSRP_INFO");
    public static final String SQLSERVER_DISCOVERY = "SQLSERVER_DISCOVERY";
    public static final Condition<SsrpInfo.SsrpServer> NO_ERROR = server -> server.getError() == null;
    public final Ref<String> myHost;

    public SsrpHostParamEditor(@NlsContexts.Label @NotNull String label, final @NotNull DataInterchange interchange) {
        if (label == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(1);
        }
        super(label, interchange);
        this.myHost = SsrpInfoCache.addHost();
        this.setUpdateTitle(DatabaseBundle.message("SsrpHostParamEditor.progress.title.discovering.reachable.servers", new Object[0]));
        this.setForceRefresh(DatabaseBundle.message("SsrpHostParamEditor.progress.title.rediscover.instances", new Object[0]));
        this.setReportErrorOnAutoPopup(true);
        this.addUpdateOnShow();
        interchange.addUserDataListener(new DataInterchange.UserDataListener(){

            public void userDataChanged(@NotNull Key changed) {
                if (changed == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (changed != SSRP_INFO) {
                    return;
                }
                SsrpInfo info2 = (SsrpInfo)SSRP_INFO.get((UserDataHolder)interchange);
                SsrpHostParamEditor.this.setVariantsAndCompletionVariants(info2 == null ? Collections.emptyList() : new ArrayList<SsrpInfo.SsrpServer>(info2.getServers()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dialects/mssql/ui/SsrpHostParamEditor$1", "userDataChanged"));
            }
        }, this);
        SSRP_INFO.set((UserDataHolder)interchange, (Object)SsrpInfoCache.get());
        SsrpInfoCache.addListener(new SsrpInfoCache.Listener(){

            public void consume(SsrpConstants.SsrpException e) {
                if (e == null) {
                    SsrpInfo info2 = SsrpInfoCache.get();
                    ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> SSRP_INFO.set((UserDataHolder)interchange, (Object)info2));
                } else {
                    LOG.warn((Throwable)e);
                    ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> interchange.showError(e.getMessage(), SsrpHostParamEditor.SQLSERVER_DISCOVERY));
                }
            }
        }, this);
        ((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider(editor2 -> {
            this.updateHighlighting((Editor)editor2);
            editor2.addFocusListener(new FocusChangeListener(){

                public void focusLost(@NotNull Editor editor2) {
                    if (editor2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    SsrpHostParamEditor.this.updateServerIfNotPresented();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dialects/mssql/ui/SsrpHostParamEditor$3", "focusLost"));
                }
            });
        });
    }

    protected void updateHighlighting(@Nullable Editor editor2) {
        String error;
        if (editor2 == null) {
            return;
        }
        EditorMouseHoverPopupControl.disablePopups((Editor)editor2);
        boolean unsupportedBrowsing = DataSourceSshTunnelConfiguration.hasTunnel(this.getInterchange().getDataSource());
        editor2.getMarkupModel().removeAllHighlighters();
        SsrpInfo.SsrpServer item = this.getItemByText(this.getText());
        String string = error = item == null ? null : item.getError();
        if (unsupportedBrowsing || !"UnknownHost".equals(error)) {
            editor2.getContentComponent().setToolTipText("");
            return;
        }
        TextAttributesKey key2 = CodeInsightColors.ERRORS_ATTRIBUTES;
        editor2.getContentComponent().setToolTipText(DatabaseBundle.message("SsrpHostParamEditor.error.unknown.host", new Object[0]));
        editor2.getMarkupModel().addRangeHighlighter(key2, 0, editor2.getDocument().getTextLength(), 4000, HighlighterTargetArea.EXACT_RANGE);
    }

    @Override
    protected void updateModelAtShow() {
        if (!SSRP_INFO.isIn((UserDataHolder)this.getInterchange())) {
            this.updateModelAsync();
        }
    }

    @Override
    @NotNull
    protected String getText(@NotNull SsrpInfo.SsrpServer item) {
        if (item == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(2);
        }
        String string = item.getName();
        if (string == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public SsrpInfo.SsrpServer getItemByText(@NotNull String text) {
        SsrpInfo info2;
        if (text == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(4);
        }
        return (info2 = SsrpInfoCache.get()) == null ? null : info2.getServer(text);
    }

    @Override
    protected void fireChanged() {
        this.myHost.set((Object)this.getText());
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
        super.fireChanged();
    }

    @Override
    @NotNull
    protected List<SsrpInfo.SsrpServer> getVariantsSync(@NotNull Map<Key<?>, ?> options, @NotNull ErrorHandler handler2) {
        if (options == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(5);
        }
        if (handler2 == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(6);
        }
        SsrpInfoCache.update(false);
        SsrpInfo info2 = SsrpInfoCache.get();
        return info2 == null ? Collections.emptyList() : new ArrayList<SsrpInfo.SsrpServer>(info2.getServers());
    }

    protected void updateServerIfNotPresented() {
        SsrpInfo.SsrpServer server = this.getItemByText(this.getText());
        if (server == null) {
            SsrpInfoCache.updateHost(true, this.getText());
        }
    }

    @Override
    protected void setVariants(@NotNull List<SsrpInfo.SsrpServer> variants) {
        if (variants == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(7);
        }
        super.setVariants(variants);
        this.updateHighlighting(((CompletionParamEditor.ProgressFieldWithCompletion)this.getEditorComponent()).getField().getEditor());
    }

    @Override
    protected void setCompletionVariants(@NotNull List<SsrpInfo.SsrpServer> variants) {
        if (variants == null) {
            SsrpHostParamEditor.$$$reportNull$$$0(8);
        }
        super.setCompletionVariants(JBIterable.from(variants).filter(NO_ERROR).toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/ui/SsrpHostParamEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/ui/SsrpHostParamEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemByText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariantsSync";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setVariants";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

