/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.localdb;

import com.intellij.database.dialects.mssql.localdb.LocalDbConstants;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalDb {
    @NotNull
    private static Collection<String> getInstancesList(@NotNull String executable, @NotNull ProgressIndicator progress) throws ExecutionException {
        if (executable == null) {
            LocalDb.$$$reportNull$$$0(0);
        }
        if (progress == null) {
            LocalDb.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)executable)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                LocalDb.$$$reportNull$$$0(2);
            }
            return list;
        }
        CapturingProcessHandler handler2 = new CapturingProcessHandler(new GeneralCommandLine(new String[]{executable, "info"}));
        ProcessOutput output = handler2.runProcessWithProgressIndicator(progress);
        List list = ContainerUtil.notNullize((List)(output.getExitCode() != 0 ? null : output.getStdoutLines()));
        if (list == null) {
            LocalDb.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static LocalDbInstance getInstance(@NotNull String executable, @NotNull String instanceName, @NotNull ProgressIndicator progress) throws ExecutionException {
        CapturingProcessHandler handler2;
        ProcessOutput output;
        Matcher matcher;
        boolean matched;
        if (executable == null) {
            LocalDb.$$$reportNull$$$0(4);
        }
        if (instanceName == null) {
            LocalDb.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            LocalDb.$$$reportNull$$$0(6);
        }
        return new LocalDbInstance(instanceName, (matched = (matcher = LocalDbConstants.PIPE_PATTERN.matcher((output = (handler2 = new CapturingProcessHandler(new GeneralCommandLine(new String[]{executable, "info", instanceName}))).runProcessWithProgressIndicator(progress)).getStdout())).find()) ? matcher.group(1) : "<pipe name>", matched);
    }

    public static void startInstance(@NotNull String executable, @NotNull String instanceName, @NotNull ProgressIndicator progress) throws ExecutionException {
        if (executable == null) {
            LocalDb.$$$reportNull$$$0(7);
        }
        if (instanceName == null) {
            LocalDb.$$$reportNull$$$0(8);
        }
        if (progress == null) {
            LocalDb.$$$reportNull$$$0(9);
        }
        CapturingProcessHandler handler2 = new CapturingProcessHandler(new GeneralCommandLine(new String[]{executable, "start", instanceName}));
        handler2.runProcessWithProgressIndicator(progress);
    }

    public static Collection<LocalDbInstance> getInstances(@NotNull String executable, @NotNull ProgressIndicator progress) throws ExecutionException {
        if (executable == null) {
            LocalDb.$$$reportNull$$$0(10);
        }
        if (progress == null) {
            LocalDb.$$$reportNull$$$0(11);
        }
        Ref ex = Ref.create();
        ArrayList instances = ContainerUtil.newArrayList((Iterable)JBIterable.from(LocalDb.getInstancesList(executable, progress)).filterMap(s -> {
            try {
                return LocalDb.getInstance(executable, s, progress);
            }
            catch (ExecutionException e) {
                ex.set((Object)e);
                return null;
            }
        }));
        if (ex.get() != null) {
            throw (ExecutionException)((Object)ex.get());
        }
        return instances;
    }

    @Nullable
    public static String getPipeForInstance(@NotNull String instance, @NotNull String executable, @NotNull ProgressIndicator progress) throws ExecutionException {
        if (instance == null) {
            LocalDb.$$$reportNull$$$0(12);
        }
        if (executable == null) {
            LocalDb.$$$reportNull$$$0(13);
        }
        if (progress == null) {
            LocalDb.$$$reportNull$$$0(14);
        }
        LocalDb.startInstance(executable, instance, progress);
        LocalDbInstance inst = (LocalDbInstance)ContainerUtil.find(LocalDb.getInstances(executable, progress), LocalDb.byInstance(instance));
        return inst == null ? null : inst.pipe;
    }

    @NotNull
    public static Condition<LocalDbInstance> byInstance(@Nullable String instance) {
        Condition condition = inst -> inst.instance.equals(instance);
        if (condition == null) {
            LocalDb.$$$reportNull$$$0(15);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: 
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/localdb/LocalDb";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/localdb/LocalDb";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstancesList";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "byInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstancesList";
                break;
            }
            case 2: 
            case 3: 
            case 15: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startInstance";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInstances";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPipeForInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 15 -> new IllegalStateException(string);
        };
    }

    public static final class LocalDbInstance {
        public final String instance;
        public final String pipe;
        public final boolean running;

        private LocalDbInstance(String instance, String pipe2, boolean running) {
            this.instance = instance;
            this.pipe = pipe2;
            this.running = running;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalDbInstance instance1 = (LocalDbInstance)o;
            if (this.running != instance1.running) {
                return false;
            }
            if (!this.instance.equals(instance1.instance)) {
                return false;
            }
            return this.pipe.equals(instance1.pipe);
        }

        public int hashCode() {
            int result2 = this.instance.hashCode();
            result2 = 31 * result2 + this.pipe.hashCode();
            result2 = 31 * result2 + (this.running ? 1 : 0);
            return result2;
        }
    }
}

